/*
 * $Header: /u1/src/rfmail/RCS/funpack.c,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: funpack.c,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.3  1991/06/15  09:33:39  pgd
 * *** empty log message ***
 *
 * Rfmail did not understand its own MSGID lines.
 *
 * Revision 0.4.1.2  1991/06/05  09:13:58  pgd
 * Various Bugfixes:
 *
 * Patches suggested by Marc Boucher (marc):
 * Changed path to: config.receive_path!msg->orig!username
 *
 * Added #! rnews <SIZE> lines between messages in news batches for CNews
 *
 * Added the Lines: <#oflinesinmessagebody> header in news.
 *
 * All blank lines at end of messages are deleted
 *
 * X-FSC-FOO: translation was buggy and made things like
 *
 * 	X-FSC-EID:3f84383
 *
 * (which is illegal, there must be a space between the : and the value of the
 * header)
 *
 * A good enveloppe from (From site!user <date> remote from
 * config.receive_path) is now added to the front of messages for
 * mail. (necessary so that modern sendmails and smail3 can have good
 * enveloppe return path -- buggy smail2.5's must be fixed)
 *
 * The Received: header is only added for mail, not news (uncommon if
 * not illegal in news)
 *
 *
 * Added Comment-To: field
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 *
 */

/* Unpaketize fido-mail packets and send mail to reciver or send it to
   news-server.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/*
 * Authors:
 *
 * Teemu Torma who wrote the original code (?)
 *
 * Heikki Suonsivu (hsu@hutcs.hut.fi) who made a lot of enhancements
 * 
 * Per Lindqvist (pgd@compuram.bbt.se) who continued to enhance rfmail.
 */


#include "fnet.h"

#ifndef HAVE_BCOPY
#include <memory.h>
#endif

#include "nodelist.h"
#include "configs.h"
#include "fnews.h"
#include "packet.h"
#include "routing-hash.h"
#include "rfmail.h"

#define	MAXHEADERLINES	50
#define	CHUNKSIZE	16


/*
 * Prototypes for local routines
 */
LDECLARE(int, savebadarticle, (FILE *));
LDECLARE(void, process_packet, (char *));
LDECLARE(char *, find_unix_delivery, (Node));
LDECLARE(void, savebadfile, (char *));
LDECLARE(void, process_arcmail, (char *));
LDECLARE(Newsgroup *, get_newsgroup, (char *));
LDECLARE(void, close_sender, (void));
LDECLARE(void, create_rfc822_header, (struct message *));
LDECLARE(void, process_news, (FILE *, struct message *, struct packet *));
LDECLARE(void, process_mail, (FILE *, struct message *, struct packet *));
/* LDECLARE(void, create_fidonet_kludges, (struct message *)); */
LDECLARE(void, send_message, (FILE *, struct message *, boolean));
LDECLARE(boolean, unpack_packet, (FILE *, struct packet *));
/* LDECLARE(void, process_headers, (struct message *)); */
LDECLARE(void, parse_seenbys, (struct message *, Node));
LDECLARE(void, digest_via, (Message *, char *));
LDECLARE(boolean, parse_origin_line, (char *, Node *));

static boolean needanotherpass;
static char packetname[PATH_LEN];
static FILE *sender = NULL;
static char badname[PATH_LEN];
static FILE *badtemp = NULL;
static int sender_pid;

int
echocmp(ng1, ng2)
     Newsgroup *ng1, *ng2;
{
	return strcmp(ng1->echo, ng2->echo);
}

#if 0
void
tprintf(fp, fmt VA_ALIST)
	FILE *fp;
	char *fmt;
	VA_DCL
{
	char buffer[BUFSIZ];
	va_list pvar;
  
	VA_START(pvar, fmt);
	vsprintf(buffer, fmt, pvar);
	if (fputs(buffer, fp) == -1)
		log("$Cannot write message file.");
	if (badtemp) {
		if (fputs(buffer, badtemp) == -1)
			log("$Cannot write bad message file.");
	}
	va_end(pvar);
}
#endif

void
tputs(buffer, fp)
	char *buffer;
	FILE *fp;
{
	if (fputs(buffer, fp) == -1)
		log("$Cannot write message file.");
	if (badtemp)
		if (fputs(buffer, badtemp) == -1)
			log("$Cannot write bad message file.");
}

static void
tputc(c, fp)
	int c;
	FILE *fp;
{
	if (putc(c, fp) == -1)				
		log("$Cannot write message file.");
	if (badtemp) {							
		if (putc(c, badtemp) == -1)			
			log("$Cannot write bad message file.");	
	}							
}


/* Execute sender of fido-message. Argument will be program name, argument
   for that and pid to return. If command is not empty, use it instead
   of given program and build parameter table. */

static char command[64];

FILE *
open_sender(program, args, pid)
	char *program, **args;
	int *pid;
{
	FILE *fp;
	int fd[2], count = 0;
	char *p, *realargs[MAXARGS];
	char *cmd, *realprogram, **ap;

	mallocname("open_sender:cmd");
	cmd = strsave(command);
	
	if (*cmd) {
		for (p = strtok(cmd, SEPARATORS); p;
		     p = strtok(NULL, SEPARATORS))
			realargs[count++] = p;

		realargs[count++] = NULL;
		realprogram = *realargs;

		if (realprogram) {
			program = realprogram;
			/* append user arguments */
			count--;
			for (ap = args; *ap; ap++)
				realargs[count++] = *ap;
			realargs[count++] = NULL;
			args = realargs;
		}
	}

	if (pipe(fd) == -1) {
		perror("funpack: pipe");
		fp = NULL;
		goto out;
	}
  
	switch (*pid = fork()) {
	case -1:
		perror("funpack: fork failed");
		fp = NULL;
		goto out;
		
	case 0:
		close(0);
		if (dup(fd[0]) == 0) {
			close(fd[0]);
			close(fd[1]);
			if (args)
				execvp(program, args);
			else
				execlp(program, basename(program), (char *) 0);
			fatal(EX_OSERR, "$Cannot execute: %s", program);
		} else
			fatal(EX_OSERR, "$Cannot dup file descriptor");
		
	default:
		close(fd[0]);
		if ((fp = fdopen(fd[1], "w")) == NULL) {
			perror("funpack: fdopen");
			fp = NULL;
			goto out;
		}
	}

 out:
	free(cmd);
	return fp;
}

static Newsgroup *
get_newsgroup(echo)
     char *echo;
{
	Newsgroup ng, *ngp;
	static Newsgroup junkgroup = {
		"JUNK", 	"junk",		"",
		TRUE, 	TRUE,	0};
	
	/*  debug(2, "Checking echolist '%s'", echo); */
	strcpy(ng.echo, echo);
	if (ngp = (Newsgroup *) bsearch( (char *) &ng, (char *) config.ng,
					(Uint) config.newsgroups,
					sizeof(Newsgroup), echocmp))
		return ngp;
	log("No newsgroup for '%s' found, return junk, distribution local",
	    echo);
	return &junkgroup;
}

/*
 * Check if message is news-message (currenlty: if first line begins
 * with AREA:). If area is found, we'll return name for that area,
 * otherwise NULL.
 */


/*
 * Remove userids from names, like "James Smith (SMITH)" will become
 * "James Smith". Simple algorithm now, but its enough. Scandinvian
 * chars are translated to a and o, and other special chars are
 * removed.
 */
void
remove_id(name)
	char *name;
{
	char *p, *cp;
  
	if (p = strchr(name, '(')) {
		while (*p != ')' && *p)
			for (cp = p; *cp = *(cp + 1); cp++)
				;	/* Remove one char */
		if (*p == ')')
			for (cp = p; *cp = *(cp + 1); cp++)
				; 	/* Remove last ) */
	}
	stripbad_name(name);
	name_to_fidonet_format(name);

	/*
	 * Fixup to a valid internet address, by replacing every occurance of
	 * '@' with '%'.
	 */
	for (cp = name; *cp; cp++)
		if (*cp == '@')
			*cp = '%';
	stripbad(name);
  
	/* Remove blanks from the end */
	while (strlen(name) && isspace(name[strlen(name) - 1]))
		name[strlen(name) - 1] = 0;
}

/* 
 * Search alias name which matches with fidonet name, return NULL
 * if no alias specified.
 */
char *
get_alias(name)
	char *name;
{
	char buffer[BUFSIZ];
	char *cp;
	FILE *fp;
	static char unixname[BUFSIZ], fidoname[BUFSIZ];
  
	if (fp = fopen(config.alias, "r")) {
		while (fgets(buffer, BUFSIZ, fp)) {
			buffer[strlen(buffer) - 1] = 0;
			if (*buffer != '#') {
				if (cp = strpbrk(buffer, " \t")) {
					*cp = 0; /* Break unixname out */
					strcpy(unixname, buffer); /* And save it */
					debug(8, "Unix name %s", unixname);
				} else {
					/* No space or tab found, probably bad line */
					debug(1, "Bad alias line %s", buffer);
					continue;
				}
				
				/* Search for name start, there may be space between */
				cp++;
				while (*cp && isspace(*cp))
					cp++;
				if (!*cp) {
					debug(1, "Bad alias line %s", buffer);
					continue;
				}
				
				strcpy(fidoname, cp); /* Save fidonet name */
				debug(8, "Fidoname %s", fidoname);
	      
				if (!stricmp(fidoname, name)) {
					fclose(fp);

					/* There may be node specs after name, null them out */
					if (cp = strchr(unixname, ','))
						*cp = 0;

					debug(8, "Fidoname %s matched with %s, return %s",
					      fidoname, name, unixname);
					return unixname;
				}
			}
		}
	}
	
	fclose(fp);
	return NULL;
}

/* Save bad article from file given to bad directory */

static int
savebadarticle(fp)
     FILE *fp;
{
	char *fname, buffer[BUFSIZ];
	FILE *badfile;
	
	log("Saving bad article/mail to %s",
	    fname = sprintfs("%s/bad.%ld", config.badarticles,
			     sequencer(config.badsequence)));
	if (badfile = myfopen(fname, "w+")) {
		rewind(fp);
		while (fgets(buffer, BUFSIZ, fp))
			fputs(buffer, badfile);
	} else {
		log("$Could not open bad article file");
		return -1;
	}
	fclose(badfile);
	return 0;
}

/* Unpack packet and all files in it. Packet's header will be stripped
   off. For each message check if it is news-msg (First line begins
   with AREA:). If it is, send it to news-sender sfnews, otherwise
   send it to rmail. Address is given in to-field, or if it wont
   fit to it, in the first line of message. In later case to-field
   must be "Usenet". */

static boolean
unpack_packet(packet, pkt)
	FILE *packet;
	struct packet *pkt;
{
	long point;
	int c, ptype;
	struct nodelist packetfromentry;
	struct message msg;
  
	/* get node-entry for packet-sender */
	if (search_node(pkt->orig, &packetfromentry) == NULL)
		log("Unknown packet sender: %s", ascnode(pkt->orig));

	/*
	 * Process all messages in packet.
	 */
	for (;;) {
		/*
		 * Look for packet type byte
		 */
		if ((ptype = getc(packet)) == EOF) break;
		if ((c = getc(packet)) == EOF) break;
		if (ptype == 0 && c) {
			ptype = c;
			if ((c = getc(packet)) == EOF)
				break;
		}
		if (ptype == 0 && c == 0) {
			/*
			 * Some versions of rfmail, give
			 * an extra null byte in the packets.
			 */
			ptype = getc(packet);
			if (ptype != 2)
				break;
			if ((c = getc(packet)) == EOF)
				break;
		}
		if (ptype == 2) {
			if (!read_type2_message(packet, &msg, pkt))
				break;
		} else {
			log("Cannot process packet type %d", ptype);
			break;
		}

/*		process_headers(&msg); */
		if (msg.area)
			process_news(packet, &msg, pkt);
		else {
			if (sender)
				close_sender();
			process_mail(packet, &msg, pkt);
		}
		freemsg(&msg);
	}

	do {
		c = getc(packet);
	} while (c != EOF && c == 0);

	point = ftell(packet);
	if (fseek(packet, 0L, SEEK_END) < 0)
		log("$Could not seek in packet file");

	/* If packet end and current point difference is bigger than 127,
	   something is wrong. Fidonet protocol uses xmodem, thus < 128
	   characters of trash is ok. Typically this happens when unpack
	   gets out of sync somewhere, junking rest of the file. */
  
	if (ftell(packet) - point > 127) {
		sendadmin("Corrupted Packet",
			  "Packet %s short %ld - %ld = %ld bytes", packetname,
			  ftell(packet), point, ftell(packet) - point);
		return FALSE;
	}
	
	debug(1, "Done with packet");
	return TRUE;
}


int
funpack(argc, argv)
     int argc;
     char **argv;
{
	char *fname;
	Node node;


	/* Sort newsgroups according to echo name for easier searching */
	
#ifdef USG
	qsort( (char *) config.ng, (Uint) config.newsgroups,
	      sizeof(Newsgroup), echocmp);
#endif
#ifdef BSD
	qsort( (char *) config.ng, config.newsgroups,
	      sizeof(Newsgroup), echocmp);
#endif
  
	node.zone = -1;

  
	if (fflag)
		debug(2, "Unpacking packets beginning to node %s",
		      ascnode(node));
	else
		debug(2, "Unpacking all packets");

	get_nodelist();		/* Update nodelist-index */


	/* 
	 * We want to inhibit sigpipe, so mailer going bananas
	 * won't crash us.
	 */
	signal(SIGPIPE, SIG_IGN);
	signal(SIGHUP, SIG_IGN);
	
	/*
	 * Look for arcmail to unpack
	 */
	if (config.packers > 0
	    && myopendir(fflag ? nodepath(config.infiles, node)
			       : config.infiles, TRUE)) {
		while (fname = myreaddir(NULL))
			if (is_arcmail(fname))
				process_arcmail(fname);
		myclosedir();
	}

	/*
	 * Go through the input directory for files to unpack
	 * We have to redo the if a packet is re-routed.
	 */
	mychdir(fflag ? nodepath(config.indir, node) : config.indir);
	for (needanotherpass = TRUE; needanotherpass; ) {
		needanotherpass = FALSE;
		if (myopendir(NULL, TRUE)) {
			while (fname = myreaddir(NULL))
				process_packet(fname);
			myclosedir();
		} else {
			log("$Unable to open spool directory");
			return EX_OSERR;
		}
		if (needanotherpass)
			debug(1, "Some packet routed, rescanning input directory");
	}
	close_sender();

	return EX_OK;
}

/*
 * Find out where to deliver mail for a node
 */
static char *
find_unix_delivery(node)
	Node node;
{
	register int target, mask;
  
	for (target = 0; target < config.targets; target++) {
		if (config.routing[target].rtype != ROUTING_UNIXMAIL)
			continue;
		for (mask = 0; mask < config.routing[target].masks; mask++) {
			if (node_match(config.routing[target].mask[mask], node))
				return config.routing[target].unixaddr;
		}
	}

	/* If no matches found, send it with default delivery agent. */
	return NULL;
}

/*
 * Process a packet
 */
static void
process_packet(pname)
	char *pname;
{
	FILE *packet;
	char *p;
	boolean saved = FALSE;
	struct packet pkt;

	log("Processing %s", pname);
		  
	if (!is_mailpkt(pname)) {
		log("Packet %s is not a mail packet", spoolname(pname));
		savebadfile(pname);
		return;
	}
	/* open packet */
	packet = fopen(pname, "r");
	if (packet == NULL) {
		log("$Unable to open packet %s", spoolname(pname));
		savebadfile(pname);
		return;
	}
	if (!read_packet_header(packet, &pkt)) {
		savebadfile(pname);
		return;
	}

	debug(1, "Packet from %s to %s", ascnode(pkt.orig), ascnode(pkt.dest));
	debug(1, "Time %02d:%02d:%02d %d.%d.%d",
	      pkt.hour, pkt.minute, pkt.second,
	      pkt.day, pkt.month, pkt.year);
	debug(1, "Max baud rate %d, Product: %s, ver %d, serial %d",
	      pkt.rate, productname(pkt.prodcode), pkt.ver, pkt.serialno);
	debug(1, "Pwd \"%s\"", pkt.passwd);

	/*
	 * Here we unpack all packets, even those not intended for us.
	 * The reasons for this are twofold:
	 * If we directly re-route the packet, file-attaches
	 * will not follow. We also want to put in the "via-"
	 * kludges into the routed messages.
	 *
	 * I don't otherwise know what to do with packets
	 * routed to us, but not to us.
	 */
/*	if (is_our_node(pkt.dest)) { */
		if (!unpack_packet(packet, &pkt)) {
			savebadfile(pname);
			saved = TRUE;
		}
#if 0
	} else {
		/*
		 * This packet should be routed
		 * to another machine. This is actually very
		 * simple. We just rename it to the correct
		 * directory.
		 */
		log("Routing packet to %s", ascnode(pkt.dest));
		p = sprintfs("%s/%s",
			     nodepath(config.outfiles, pkt.dest),
			     basename(pname));
		if (myrename(pname, p) == -1) {
			log("$Cannot move packet %s to %s",
			    spoolname(pname),
			    spoolname(p));
			savebadfile(p);
		}
		saved = TRUE;

		/*
		 * We have to rescan the input tree
		 * unless we are only scanning one node.
		 */
		needanotherpass = !fflag;
	}
#endif
	
	fclose(packet);
	
	/*
	 * Move packet to unpacked directory.
	 *
	 */
	if (!saved) {
		if (config.save_unpacked_packets
		    && (p = basename(pname),
		     !(p > pname+9 && strnequ(p-9, "/arcmail/", 9)))
		     ) {
			p = sprintfs("%s/%s", config.unpacked, pname);
			if (myrename(pname, p)) {
				log("$Could not save packet %s as %s",
				    spoolname(pname), spoolname(p));
				if (unlink(pname))
					log("$Could not unlink packet %s",
					    spoolname(pname));
			}
		} else if (unlink(pname))
			log("$Could not unlink packet %s", spoolname(pname));
	}
}

/*
 * Save a bad file/packet into the badfiles directory.
 */
static void
savebadfile(fname)
	char *fname;
{
	char badfname[PATH_LEN];

	sprintf(badfname, "%s/%s", config.badarticles, basename(fname));
	unique_name(badfname);
	log("Saving bad file %s as %s", spoolname(fname), spoolname(badfname));
	if (myrename(fname, badfname)) {
		log("$Could not save bad file %s", spoolname(fname));
		if (unlink(fname))
			log("$Could not unlink file %s", spoolname(fname));
	}
}

/*
 * Find the unarc command for the arcmail bundle.
 * The pathanme of the compressed file is the parameter
 */
static char *
get_unarc_command(fname)
	char *fname;
{
	int packer;
	char magic[ID_LEN];
	FILE *arc;
	int bytes_read;

	/* open arcmail bundle */

	arc = fopen(fname, "rb");
	if (arc == NULL)
		{
		log("Can not open arcmail bundle %s", spoolname(fname));	
		return NULL;
		}
	for (packer = 0; packer < config.packers; packer++)
		{
		/* seek to start of magic */

		if (fseek(arc, (long) config.packerinfo[packer].id_start, SEEK_SET) != 0 )
			{
			log("Can not seek to start of magic (offset %d) in arcmail bundle %s for packer %s",
				 config.packerinfo[packer].id_start, spoolname(fname), 
				 config.packerinfo[packer].name);
			fclose(arc);
			return NULL;
			}

		bytes_read = fread(magic, (size_t) 1, (size_t) config.packerinfo[packer].id_len,  arc);
		if (bytes_read != config.packerinfo[packer].id_len)
			{
			log("Can not read magic from arcmail bundle %s, read %d instead of %d bytes", 
				spoolname(fname), bytes_read, config.packerinfo[packer].id_len);
			fclose(arc);
			return NULL;
			}
		if (memcmp(magic, config.packerinfo[packer].id, config.packerinfo[packer].id_len) == 0)
			{
			return config.packerinfo[packer].extract_cmd;	
			}
		}
	/* no appropriate packer found */

	log("Arcmail bundle %s compressed with unknown type of packer", spoolname(fname));
	fclose(arc);
	return NULL;
}

/*
 * Process an arcmail library.
 * The path-name of the arc-file is parameter
 */
static void
process_arcmail(fname)
	char *fname;
{
	Node node;
	char *cp;
	char *unarc_command;
	char scratch[PATH_LEN];

	if (access(fname, 4) == -1) {
		log("Read access to %s denied", spoolname(fname));
		return;
	}
	strcpy(scratch, fname);
	cp = basename(scratch); 
	if (cp[-1] != '/')
		goto error;
	cp[-1] = 0;
#ifdef BINKLEY
	sscanf(cp, "%04x%04x", &node.net, &node.node);
	node.zone = config.mynode.zone;
	node.zone = 0;
#else
	if (!parsenode(scratch, &node, NULL, NULL))
		goto error;
#endif
	log("UnArcing arcmail from node %s (%s)",
	    ascnode(node), spoolname(fname));
	
	/*
	 * Move to work directory
	 */
	sprintf(scratch, "%s/arcmail/", nodepath(config.indir, node));
	if (chdir(scratch) == -1) {
		if (errno == ENOENT
		    && (!makepath(scratch) || chdir(scratch) == -1)) {
			log("$Cannot create directory %s - archive not unpacked",
			    scratch);
			return;
		}
	}
	unarc_command = get_unarc_command(fname);
	if (unarc_command == NULL)
		return;

	/*MARCFIXME: arc -xi exit with return code 2 when a packet is
	  corrupted. this can cause messages to be extracted over and over
	  if some good packets were in the archive, because it is not
	  moved away*/
	
	if (exec_command(unarc_command, fname, NULL)) {
		log("Can not execute %s", unarc_command);
		return;
	}
	debug(1, "UnArcing successfully completed");

	if (config.save_arcmail) {
		sprintf(scratch, "%s/%s", config.unpacked, basename(fname));
		unique_name(scratch);
		if (myrename(fname, scratch)) {
			log("$Could not save %s as %s",
			    spoolname(fname), spoolname(scratch));
			if (unlink(fname))
				log("$Could not unlink %s", spoolname(fname));
		}
	}
	else if (unlink(fname))
			log("$Could not unlink %s", spoolname(fname));
	return;
 error:
	log("Impossible error in process arcmail");
}

static void
close_sender()
{
	int s;

	if (sender == NULL)
		return;
	fclose(sender);
	sender = NULL;

	s = mywait(sender_pid);
	debug(2, "Wait status: %o", s);
	if (s && config.save_bad_messages) 
		if (savebadarticle(badtemp))
			log("Could not save bad article %s", badname);
	fclose(badtemp);
	badtemp = NULL;
	unlink(badname);
}

/*
 * Process a news message
 */
static void
process_news(packet, msg, pkt)
	FILE *packet;
	struct message *msg;
	struct packet *pkt;
{
	char *args[MAXARGS];
	int n, c;
	Node tmpnode;
	struct line *lp;
	Newsgroup *ngp;
	boolean ex_ufgate;

	/* News expects some kind of subject and ignores the message
	   without one? */
	if (*msg->subject == 0) {
		debug(2, "No subject given");
		strcpy(msg->subject, "No subject");
	}

	ngp = msg->ngp = get_newsgroup(msg->area);
	if (ngp && (msg->attr & ATTR_PRIVATE)
	    && !ngp->acceptprivate) {
		log("Newsgroup %s does not accept private messages",
		    ngp->ng);
		if (!ngp->trashprivate) {
			process_mail(packet, msg, pkt);
			msg->ngp = NULL;
		}
		return;
	}

	/*
	 * Parse all SEEN-BY lines
	 * create a list of nodes we should send this message to.
	 */
	parse_seenbys(msg, pkt->orig);

	/* This is a news-article. Open sendfidonews and give area name as
	   argument to it. Input of sfnews will be just like input
	   of mail. */
	  
	log("News-article: %s -> %s",
	    msg->area, ngp->ng);
	log("\tFrom: %s, To: %s, Subj: %s", msg->from, msg->to, msg->subject);
	  
	/* create args for sender */
	mallocname("save for rnews");
	*args = strsave(config.rnews);
#ifdef NEEDED
	args[1] = strsave(ngp->ng);
	args[2] = NULL;
#else
	args[1] = NULL;
#endif

	if (!bflag || sender == NULL) {
		if ((sender = open_sender(*args, args, &sender_pid)) == NULL) {
			log("Can not execute %s", *args);
			goto error;
		}
		strcpy(badname, "/tmp/funpXXXXXX");
		mktemp(badname);
		badtemp = fopen(badname, "w+");
		if (badtemp == NULL)
			log("$Cannot open tmp file %s", badname);
	}

	/*
	 * Try to pick up sender address by looking for a
	 * " * Origin" line
	 * Also, if this has come from UFGATE, try to find
	 * the original Internet address of the sender, and
	 * the original message-ID of the posting.  These
	 * can be used to let news items that have travelled
	 * Usenet->Fido->Usenet come out with the correct
	 * From: and Message-ID: lines. 
	 * I suppose that one could also grab the original 
	 * newsgroups in the same way, but that screws up
	 * the Echo-Newsgroup mapping in rfmail.cf!
	 * I also strip the UFGATE mini-header, to keep
	 * things neat.
	 */
	ex_ufgate = FALSE;
	msg->internet = NULL;
	msg->ufgroup = NULL;
	msg->ufgid = NULL;
 	debug(9, "Looking for UFGATE signature");
	if (lp = msg->headers) {
		do {
			debug(9, "Header: %s\n", lp->txt);
			if (strnequ( lp->txt, "RFMAIL", 6)) {
				debug(8, "Message originated with rfmail: %s",
				      lp->txt);
				ex_ufgate = TRUE;
				break;
			}
			if (strnequ(lp->txt, "UFGATE", 6)) {
				debug(8, "Message originated with ufgate: %s",
				      lp->txt);
				ex_ufgate = TRUE;
				break;
			}
			lp = lp->next;
		} while (lp != msg->headers);
	}

	if (lp = msg->body) {
		do {
			if (ex_ufgate) {
				if (strnequ(lp->txt, "From:", 5)) {
					debug(8, "UFGATE from [%s]", lp->txt);
					if (msg->internet)
						free(msg->internet);
					msg->internet = strsave(lp->txt + 6);
					debug(9,"new from [%s]",msg->internet);
				} else if (strnequ(lp->txt,"Message-ID:",11)) {
					debug(8, "UFGATE msg-id [%s]",lp->txt);
					if(msg->ufgid)
						free(msg->ufgid);
					msg->ufgid = strsave(lp->txt + 12);
					debug(9, "new ufgid [%s]", msg->ufgid);
				} else if (strnequ(lp->txt, "Newsgroups:",11)){
					debug(8, "UFGATE newsgroup [%s]", lp->txt);
					if(msg->ufgroup)
						free(msg->ufgroup);
					msg->ufgroup = strsave(lp->txt + 12);
					debug(9, "new ufgroup [%s]", msg->ufgroup);
				} else if (strnequ(lp->txt, "From:", 5)
					|| strnequ(lp->txt, "Date:", 5)
					|| strnequ(lp->txt, "Message-ID:", 11)
					|| strnequ(lp->txt, "Newsgroups:", 11)) {
					debug(9, "removing UFGATE [%s]", lp->txt);
					free(lp->txt);
					lp->txt = NULL;
				} else {
					debug(9, "keeping UFGATE [%s]", lp->txt);
					if (lp->txt[0] == '\0') {
						ex_ufgate = FALSE;
						debug(9, "end of UFGATE headers");
					}
				}
			}
			   
			if (strnequ(lp->txt, " * Origin:", 10)
			    && parse_origin_line(lp->txt+10, &tmpnode)) {
				if (tmpnode.zone == NOZONE)
					tmpnode.zone=pkt->orig.zone;
				msg->orig = tmpnode;
			}
			lp = lp->next;
		} while (lp != msg->body);
	}

#if 0
	/*
	 * Cnews does not like this line, so I removed it - pgd
	 */
	tprintf(sender, "From %d!%d!%s %s\n",
		orignode.net, orignode.node,
		from, date("%a %h %d %T 19%y", NULL));
#endif

	/*       remote from %d not understood by smail 2.5. */

	/* Now generate valid RFC 822 header for mail. Some fields may
	   be different, in all places there may be comments between (
	   and )-characters. */
      
	/* This is imporant for news articles, as without this inews
	   tries to post it back. */
	msg->rfchdr = addline(NULL,
		      sprintfs("Path: %s!%s!%s", config.receive_path,
			       internode(msg->orig), msg->from),0);
      
	(void)addline(msg->rfchdr, sprintfs("Newsgroups: %s", ngp->ng),0);
	if (*ngp->distribution)
		(void)addline(msg->rfchdr,
			 sprintfs("Distribution: %s", ngp->distribution), 0);
	
	if (msg->ufgroup)
		(void)addline(msg->rfchdr, 
			 sprintfs("X-Fido-Newsgroups: %s", msg->ufgroup), 0);

	/*
	 * Create rfc822 header
	 */
	create_rfc822_header(msg);

/*	create_fidonet_kludges(msg); */

	/* done with header, now send message text */

	send_message(sender, msg, TRUE);

	/* done with this msg, wait process to finish */
	if (sender && !bflag)
		close_sender();

	sendnews(msg, ngp);

	debug(2, "Done with message");
	
	/* free argument-list */
	for (n = 0; args[n]; n++)
		free(args[n]);
	return;
      
      /* in the case of error skip text of message */
 error:
	while ((c = getc(packet)) && c != EOF);
      
	/* free argument-list */
	for (n = 0; args[n]; n++)
		free(args[n]);
}

/*
 * This routine processes an echomail message
 */
static void
process_mail(packet, msg, pkt)
	FILE *packet;
	struct message *msg;
	struct packet *pkt;
{
	char *args[MAXARGS];
	char buffer[BUFSIZ];
	char *p, *cp;
	int n, c;
	char *deliver;

	debug(1, "Message is for mail");

	/*
	 * Check if this is a message to be gatewayed to
	 * internet.
	 * 
	 * We will gateway if we can pick up an internet address.
	 * We look for such an address in the "to" field, in a "To:"
	 * kludge, or in the first line of the message, if the "to"
	 * field contains "uucp", "usenet", "eunet" or "internet".
	 */
	if (config.internet_gateway) {
		if (rfc822(msg->to))
			deliver = msg->to;
		else if ((   struequ(msg->to, "uucp")
			  || struequ(msg->to, "usenet")
			  || struequ(msg->to, "eunet")
			  || struequ(msg->to, "internet"))
			 && msg->toto && rfc822(msg->toto)) {
			deliver = msg->toto;
		} else
			 deliver = find_unix_delivery(msg->dest);
	} else
		deliver = find_unix_delivery(msg->dest);

	if (deliver)
		log("Message From: %s @ %s To: %s Subj: %s",
		    msg->from, ascnode(msg->orig),
		    deliver, msg->subject);
	else
		log("Message From: %s @ %s To: %s @ %s Subj: %s",
		    msg->from, ascnode(msg->orig),
		    msg->to, ascnode(msg->dest), msg->subject);
		
	/*
	 * Check that message is to us,
	 * if not, route it to the correct node.
	 */
	if (deliver == NULL && !is_our_node(msg->dest)) {
		log("Routing Message from %s @ %s to %s @ %s",
		    msg->from, ascnode(msg->orig),
		    msg->to, ascnode(msg->dest));
		msg->attr |= ATTR_INTRANSIT;
		write_msg(msg, config.mynode, msg->dest);
		return;
	}

	if (deliver) {
		cp = deliver-1;
		while (cp = strchr(cp+1, '%'))
			if (cp[1] == 's')
				break;
		if (cp)
			sprintf(buffer, deliver, msg->to);
		else
			sprintf(buffer, "%s@%s", msg->to, deliver);
	} else
		strcpy(buffer, msg->to);
	debug(8, "Searching alias for %s", buffer);
	if (p = get_alias(buffer)) {
		strcpy(buffer, p);
		debug(8, "Got alias %s", buffer);
	} else {
		debug(8, "No alias, using %s", buffer);
	}
	
/*		for (n = 0; buffer[n]; n++)
			buffer[n] = tolower(buffer[n]); */
	
	mallocname("save for rmail");
	*args = strsave(basename(config.rmail));
	for (n = 1, cp = strtok(buffer, ", \t"); cp && n < MAXARGS;
	     cp = strtok((char *) 0, ", \t"), n++) {
		mallocname(sprintfs("save for argument %d", n));
		args[n] = strsave(cp);
	}
	args[n] = NULL;
          
	for (n = 1; args[n]; n++)
		log("Sending mail from %s @ %s to %s",
		    msg->from, ascnode(msg->orig), args[n]);
          
	msg->rfchdr = addline(NULL, sprintfs("From %s!%s  %s remote from %s",
		internode(msg->orig), msg->from,
		date("%a %h %d %T 19%y", NULL), config.receive_path), 0);


	/* print Received: field */
	addline(msg->rfchdr,
		sprintfs( "Received: by %s (rfmail %s/%s)",
			 internode(config.mynode), version,
			 config.system_name),0);
	addline(msg->rfchdr,
		sprintfs("  id AA%05d; %s", getpid(),
			 date("%a, %d %h %y %T %o (%z)", NULL)), 0);

	/* 
	 * Now generate valid RFC 822 header for mail. Some fields may
	 * be different, in all places there may be comments between (
	 * and )-characters.
	 */
	msg->internet = NULL;
	msg->ufgid = NULL;
	create_rfc822_header(msg);

	/* print To: field */
	p = cp = sprintfs("To: ");
	cp = strend(cp);
	for (n = 1; args[n]; n++) {
		sprintf(cp, "%s", args[n]);
		cp = strend(cp);
		if (args[n + 1]) {
			sprintf(cp, ", ");
			cp = strend(cp);
		}
	}
	*cp++ = 0;
	(void)addline(msg->rfchdr, p, 0);

/*	create_fidonet_kludges(msg); */

	/* done with header, now send message text */

	/* open rmail for sending message */
	if ((sender = open_sender(config.rmail, args, &sender_pid)) == NULL) {
		log("Can not execute %s", config.rmail);
		goto error;
	}

	send_message(sender, msg, FALSE);

	/* done with this msg, wait process to finish */
	if (sender)
		close_sender();
	debug(1, "Done with message");
      
	/* free argument-list */
	for (n = 0; args[n]; n++)
		free(args[n]);
	return;
      
	/* in the case of error skip text of message */
 error:
	while ((c = getc(packet)) && c != EOF);
      
	/* free argument-list */
	for (n = 0; args[n]; n++)
		free(args[n]);
}


/*
 * Create rfc822 header lines, based on the IFNA header
 * data in the message structure.
 */
static void
create_rfc822_header(msg)
	struct message *msg;
{
	char *cp, *cp1;
	struct line *lp;
	char scratch[PATH_LEN];
	Node tmpnode;
	int attr, bit;

	/* print Date: field */
	(void)addline(msg->rfchdr,
		      sprintfs("Date: %s",
			       date("%a, %d %h %y %T %o", &msg->date)),0);
      
	/* print From: and Reply-To: field */
	if (msg->internet == NULL) {
		(void)addline(msg->rfchdr,
			      sprintfs("From: %s@%s",
				       msg->from, internode(msg->orig)),0);
#ifdef REPLY_TO_WANTED
		(void)addline(msg->rfchdr,
			      sprintfs("Reply-To: %s@%s",
				       msg->from, internode(msg->orig)),0);
#endif
	} else {
		(void)addline(msg->rfchdr,
			      sprintfs("X-Fido-From: %s@%s",
				       msg->from, internode(msg->orig)),0);
		(void)addline(msg->rfchdr,
			      sprintfs("From: %s", msg->internet),0);
#ifdef REPLY_TO_WANTED
		(void)addline(msg->rfchdr, 
			      sprintfs("Reply-To: %s", msg->internet),0);
#endif
	}
  	
	
	/* print Subject: field */
	(void)addline(msg->rfchdr, sprintfs("Subject: %s", msg->subject),0);
      
#ifdef COMMENT_TO_WANTED
	/*
	 * print Comment-to: field
	 */
	(void) addline(msg->rfchdr,
		       sprintfs("Comment-To: %s@%s",
				msg->to, internode(msg->orig)), 0);
#endif

	/*
	 * Convert fidonet "Via" kludges to rfc822 "Received:" headers
	 * Note that the "Received" header lines are backwards
	 * in respect to the vias.
	 */
	if (lp = msg->headers) {
		do {
			lp = lp->prev;
			if (strnequ(lp->txt, "Via ", 4))
				digest_via(msg, lp->txt+4);
		} while (lp != msg->headers);
	}
				

	/*
	 * Try to pick up Message-ID from the fidonet MSGID: line.
	 * Or generate a new message id.
	 */
	if (msg->ufgid == NULL) {
		if (msg->msgid && (cp=strchr(msg->msgid, ' ')) && cp[1]) {
			strcpy(scratch, msg->msgid);
			cp = strchr(scratch, ' ');
			*cp++ = 0;
			while (isspace(*cp))
				cp++;
			if (parsenode(scratch, &tmpnode, NULL, NULL)
			    && tmpnode.net != NONET
			    && tmpnode.node != NONODE) {
				if (tmpnode.zone == NOZONE)
					tmpnode.zone = msg->orig.zone;
			} else
				tmpnode = msg->orig;
			(void)addline(msg->rfchdr,
				      sprintfs("Message-ID: <%s@%s>",
					       cp, internode(tmpnode)),0);
		} else
			(void)addline(msg->rfchdr,
				      sprintfs("Message-ID: <%s.AA%ld@%s>",
					       date("%y%m%q%H%M", NULL),
					       sequencer(config.idsequence),
					       internode(config.mynode)),0);
	} else {
		(void)addline(msg->rfchdr,
			      sprintfs("Message-ID: %s", msg->ufgid ), 0 );
	}

	/* 
	 * Print attributes only if there is something to print
	 */
	if (attr = (msg->attr & ~ATTR_KILLSENT)) {
		cp = NULL;
		bit = 1;
		for (;;) {
			if (bit & attr && (cp1 = ascii_attribute(bit))) {
				if (cp == NULL) {
					strcpy(scratch, "X-Flags:");
					cp = strend(scratch);
				}
				*cp++ = ' ';
				strcpy(cp, cp1);
				cp = strend(cp);
				attr &= ~bit;
			}
			if (bit == 0100000)
				break;
			bit <<= 1;
		}
		if (cp)
			(void)addline(msg->rfchdr, scratch, 0);
	}

	/* print X-Fidonet-Comment-To: field */
	(void)addline(msg->rfchdr,
		      sprintfs("X-Fidonet-Comment-To: %s@%s",
			       msg->from, internode(msg->orig)),0);
	if (msg->path)
		(void)addline(msg->rfchdr,
			      sprintfs("X-FSC-PATH: %s", msg->path),0);

	/*
	 * Convert a fidonet "REPLY:" header into a
	 * RFC822 "In-Reply-To:" header.
	 */
	if (msg->reply) {
		cp = msg->reply;
		while (isspace(*cp)) cp++;
		if (cp = strchr(cp, ' '))
			cp = sprintfs("In-Reply-To: <%s@%s>",
				      cp+1, internode(tmpnode));
		else
			buglog("Malformed REPLY: line: %s", msg->reply);
	}
		

	/*
	 * Generate rfc822 headers out of the rest of the
	 * fidonet headers.
	 * Via's are already processed.
	 */
	if (lp = msg->headers) {
		do {
			cp = lp->txt; 
			if (strnequ(cp, "Via", 3)
			    && (cp[3]==':' || cp[3] == ' '))
				goto next;
			/*
			 * We have to add a colon to the keyword
			 */
			cp1 = scratch;
			while (*cp && *cp != ':' && *cp != ' ')
				*cp1++ = *cp++;
			*cp1++ = 0;
			if (*cp == ':' || *cp == ' ') cp++;
			(void)addline(msg->rfchdr,
				     sprintfs("X-FSC-%s: %s", scratch, cp), 0);
		next:
			lp = lp->next;
		} while (lp != msg->headers);
	}
}


static void
send_message(fp, msg, fornews)
	register FILE *fp;
	struct message *msg;
	boolean fornews;
{
	register struct line *lp;

	/* get rid of all trailing blank lines at end of message */
	if(msg->body) {
		lp = msg->body->prev;
		while(lp && lp->txt && lp->txt[0] == 0)
			lp = delline(lp, &msg->body);
	}

	/*
	 * If we are doing news batching, calculate the size of the message,
	 * and add the "#! rnews 999" to the file.
	 */
	if(fornews && bflag) {
		int Lines, Size;

		Lines = Size = 0;

		lp = msg->body;
		if(lp) do {
			if (lp->txt) {
				Lines++;
				Size += (strlen(lp->txt)+1);
			}
			lp = lp->next;
		} while(lp != msg->body);

		(void)addline(msg->rfchdr, sprintfs("Lines: %d", Lines),0);

		Size++; /* '\n' between header and body */

		lp = msg->rfchdr;
		if(lp) do {
			Size += (strlen(lp->txt)+1);
			lp = lp->next;
		} while(lp != msg->rfchdr);

		fprintf(fp, "#! rnews %d\n", Size);
	}


	/*
	 * Emit all rfc822 header lines
	 */
	lp = msg->rfchdr;
	do {
		tputs(lp->txt, fp);
		tputc('\n', fp);
		lp = lp->next;
	} while (lp != msg->rfchdr);
	tputc('\n', fp);

	/*
	 * Emit all body lines
	 */
	lp = msg->body;
	if (lp) do {
		if (lp->txt) {
			tputs(lp->txt, fp);
			tputc('\n', fp);
		}
		lp = lp->next;
	} while (lp != msg->body);
}


#if 0
void
process_headers(msg)
	struct message *msg;
{
	struct line *lp;
	int i;
	char *cp;

	for (i = 0; i < sizeof(header_fields)/sizeof(header_fields[0]); i++)
		*header_fields[i].ptr = NULL;
	for (lp = msg->headers; lp;
	     lp = (lp->next==msg->headers ? NULL : lp->next)) {
		cp = lp->txt;
		for (i = 0; i < sizeof(header_fields)/sizeof(header_fields[0]); i++) {
			if (*header_fields[i].ptr == NULL
			    && strnequ(header_fields[i].field, cp,
					       header_fields[i].len)) {
				cp += header_fields[i].len;
				while (isspace(*cp))
					cp++;
				*header_fields[i].ptr = cp;
				break;
			}
		}
	}
}
#endif


/*
 * Parse and remove all "SEEN-BY" lines from message.
 */
static void
parse_seenbys(msg, pktsender)
	struct message *msg;
	Node pktsender;
{
	struct line *lp;
	char *cp;
	boolean hastearline;
	Node node, tmpnode;
	char scratch[128];

	msg->seenby = NULL;
	msg->seenbys = msg->maxseenbys = 0;
	if ((lp = msg->body) == NULL)
		return;
	/*
	 * If we have a tear line, start scanning after SEEN-BY's after
	 * the tear line, otherwise scan whole message
	 */
	hastearline = FALSE;
	do {
		if (strnequ(lp->txt, "---", 3)) {
			hastearline = TRUE;
			break;
		}
		lp = lp->next;
	} while (lp != msg->body);
	if (!hastearline)
		lp = msg->body;
	while ((lp = lp->next) != msg->body) {
		if (strnequ(lp->txt, "SEEN-BY: ", 9)) {
			strcpy(scratch, lp->txt+9);
			cp = strtok(scratch, " ");
			if (cp == NULL || !parsenode(cp, &node, NULL, NULL)
			    || node.node == NONODE) {
				buglog("Strange %s", lp->txt);
				goto next;
			}
			if (node.zone == NOZONE)
				node.zone = pktsender.zone;
			add_seenby(msg, node);
			while (cp = strtok(NULL, " ")) {
				if (!parsenode(cp, &tmpnode, NULL, NULL)
				    || tmpnode.node == NONODE) {
					buglog("Strange %s", lp->txt);
					goto next;
				}
				if (tmpnode.zone == NOZONE)
					tmpnode.zone = node.zone;
				if (tmpnode.net == NONET)
					tmpnode.net = node.net;
				add_seenby(msg, tmpnode);
				node = tmpnode;
			}
			lp = delline(lp, &msg->headers);
		}
	next: ;
	}
}

/*
 * Digest a fidonet "Via: " kludge
 */
static void
digest_via(msg, via)
	Message *msg;
	char *via;
{
	char *cp, *cp1, *cp2, *cp3;
	Node tmpnode;
	char scratch[128], progname[64];
	char buf[128];
	char *junkid, *datep, *nodep;

	strcpy(buf, via);
	/*
	 * First strip off an optional initial junk-id
	 */
	if (cp = strchr(buf, ' ')) {
		*cp = 0;
		if (parsenode(buf, &tmpnode, NULL, NULL)
		    && tmpnode.net != NONET) {
			*cp = ' ';
			junkid = NULL;
		} else {
			junkid = buf;
			cp++;
			while (isspace(*cp)) cp++;
		}
	}

	/*
	 * Strip off program name, if we have one.
	 */
	if ((cp2 = strchr(cp, '(')) && (cp3 = strchr(cp2, ')'))) {
		strncopy(progname, cp2+1, cp3-cp2-1);
		while (cp2 > cp && isspace(cp2[-1]))
			--cp2;
		for (cp3++; isspace(*cp3); cp3++);
		if (*cp3) {
			*cp2++ = ' ';
			while (*cp2++ = *cp3++) ;
		} else
			*cp2 = 0;
	} else
		*progname = 0;

	/*
	 * Now, what we have left is: <node> <date>
	 * or: <node>, <date>
	 */
	if ((cp2 = strchr(cp, ',')) || (cp2 = strchr(cp, ' '))) {
		for (cp3 = cp2; cp3 > cp1 && isspace(cp3[-1]); cp3--) ;
		*cp3 = 0;
		cp2++;
		while (isspace(*cp2))
			cp2++;
		nodep = cp;
		datep = cp2;
	} else {
		nodep = cp;
		datep = NULL;
	}
	if (cp = strchr(nodep, '@')) {
		*cp = 0;
		if (parsenode(nodep, &tmpnode, NULL, NULL))
			sprintf(scratch, "Received: by %s %s",
				internode(tmpnode), cp+1);
		else
			sprintf(scratch, "Received: by %s", nodep);
	} else {
		if (parsenode(nodep, &tmpnode, NULL, NULL))
			sprintf(scratch, "Received: by %s %s",
				internode(tmpnode), nodep);
		else
			sprintf(scratch, "Received: by %s", nodep);
	}
	cp = strend(scratch);
	if (junkid && !strequ(junkid, "Node")) {
		sprintf(cp, " with %s", junkid);
		cp = strend(cp);
	}
	if (*progname) {
		sprintf(cp, " (%s)", progname);
		cp = strend(cp);
	}
	if (datep) {
		sprintf(cp, "; %s", datep);
		cp = strend(cp);
	}
	newrfchdrline(msg, scratch, 0);
}

			
/*
 * Parse origin line
 *
 * The origin node should be in the last parenthezes of the
 * origin line. There are a few variations:
 *	(2:201/300)
 *	(2:201/300@fidonet)
 *	(2:201/300@fidonet.org)
 *	(IDENT 2:201/300)
 */
static boolean
parse_origin_line(lp, node)
	char *lp;
	Node *node;
{
	char *cp, *p;
	Node tmpnode;
	char buffer[128];

	if ((cp = strrchr(lp, '('))
	    && (p = strchr(cp, ')'))) {
		strncopy(buffer, cp+1, p-cp-1);
		/*
		 * Buffer now holds the parenthezed part
		 */
		if (cp = strchr(buffer, '@')) {
			if (struequ(cp, "@fidonet")
			    || struequ(cp, "@fidonet.org"))
				*cp = 0;
		}
		/*
		 * Strip off an initial identifier
		 */
		cp = buffer;
		if (isalpha(*cp)) {
			do cp++; while (isalnum(*cp) || *cp == '-');
			while (isspace(*cp))
				cp++;
		}
		if (parsenode(cp, &tmpnode, NULL, NULL)
		    && tmpnode.net != NONET
		    && tmpnode.node != NONET) {
			*node = tmpnode;
			debug(3, "Origin node picked up from Origin line: %s",
			      ascnode(tmpnode));
			return TRUE;
		} else
			buglog("Illegal origin line: %s", lp);
	}
	return FALSE;
}

