/*
 * $Header: /u1/src/rfmail/RCS/funcs.c,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: funcs.c,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.5  1991/09/07  10:37:46  pgd
 * not finished revision check-in
 *
 * Revision 0.4.1.3  1991/06/15  09:33:39  pgd
 * *** empty log message ***
 *
 * Revision 0.4.1.2  1991/06/05  09:13:58  pgd
 * Various Bugfixes:
 *
 *
 * Changed the binary revision extracting code to give correct result.
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 *
 */

/* Miscancelleus functions, logging, sequence numberic etc.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/*
 * Authors:
 *
 * Teemu Torma who wrote the original code (?)
 *
 * Heikki Suonsivu (hsu@hutcs.hut.fi) who made a lot of enhancements
 * 
 * Per Lindqvist (pgd@compuram.bbt.se) who continued to enhance rfmail.
 */

/* LINTLIBRARY */

#include "fnet.h"

#include <pwd.h>
#include <grp.h>
#include <sys/stat.h>
#include <sys/ioctl.h>

#ifdef FCNTL
#include <fcntl.h>
#endif

#ifdef HAVE_WAIT_H
#include <sys/wait.h>
#endif

#ifdef TERMIO
#include <termio.h>
#else
#include <sgtty.h>
#endif

#ifndef FTIMER
#ifdef HAVE_TIMEB_H
#include <sys/timeb.h>
#else
#include "timeb.h"
#endif
#include <time.h>
#endif

#include "nodelist.h"
#include "shuffle.h"
#include "configs.h"
#include "directory.h"
#include "packet.h"
#include "prodcode.h"
#include "routing-hash.h"

#ifdef XENIX
DECLARE(int, stat, (char *, struct stat *));
#endif

#define my_labs(n) (((n) < 0l) ? (-(n)) : (n))

/* extern long atol(); */
extern time_t time();
extern int errno;
extern char *sys_errlist[];

static FILE *logfp = NULL;
static int buglogfd;
static int msglogfd;

FILE *errorfp = stderr;
char newline_string[3] = "\n";
UIDTYPE file_uid;			/* UID for created files */
GIDTYPE file_gid;			/* GID for created files */
char version[20];
int version_major, version_minor, version_revision, version_patchlev;
char schedule;			/* Routing schedule in effect */


LDECLARE(int, openlogfile, (char *));


/* 
 * Lock file descriptor up to the end. If yur system doesn't have lockf()
 * (also known as locking()), or other region or file locking function
 * or system call, this should be done with lock-files.
 */
int
lock(fd)
     int fd;
{
#ifdef LOCK_LOCKF
  return lockf(fd, F_LOCK, 0l);
#else
#ifdef LOCK_LOCKING
  return locking(fd, F_LOCK, 0l);
#else
#ifdef NEEDED
  fatal(EX_SOFTWARE, "Lock called when lock files should be used, fd %d !", fd);
  /*NOTREACHED*/
#endif /* NEEDED */
#endif /* LOCK_LOCKING */
#endif /* LOCK_LOCKF */
}

/* 
 * Unlock file descriptor up to the end. Routine which calls this should
 * first seek to original position.
 */
int
unlock(fd)
     int fd;
{
#ifdef LOCK_LOCKF
	return lockf(fd, F_ULOCK, 0l);
#else
#ifdef LOCK_LOCKING  
	return locking(fd, F_ULOCK, 0l);
#else
#ifdef NEEDED /* Forget about locks. Use of lock files needs rewrite. */  
	fatal(EX_SOFTWARE,
	      "Unlock called when lock files should be used, fd %d !", fd);
  /*NOTREACHED*/
#endif /* NEEDED */
#endif /* LOCK_LOCKING */
#endif /* LOCK_LOCKF */
}

/*
 * Return ascii-date in specified format. If format string is null, return
 * date as date(1) returns it. Format is same than date(1) has, in addition
 * %z, which means timezone name. Clock is the time to convert, if NULL,
 *   we'll use current time.
 *
 * Key to the data format string:
 *	%D	date in format YY/MM/DD
 *	%H	Hour of day, 00-23
 *	%M	Minutes, 00-59
 *	%S	Seconds, 00-59
 *	%T	Time in format hh:mm:ss
 *	%a	Name of weekday, Mon, Tue, ... , Sun
 *	%d	Day of month, 1-31
 *	%h	Name of month, Jan, Feb, ..., Dec
 *	%j	Day of year, 001-356
 *	%l	Military time zone, Z = UT, A = -1, M = -12, (J not used)
 *		N = +1, Y = +12..
 *	%m	Month 1-12
 *	%n	newline (\n)
 *	%o	Timezone, numeric, e.g. +0200
 *	%q	Day of month, 01-31
 *	%t	tab (\t)
 *	%w	Weekday, 0-6
 *	%y	Year, 00-99
 *	%z	Timezone name, e.g. EST
 *
 * Default if no format string given: "%a %h %d %T %z 19%y";
 *
 */
char *
date(fmt, clocktime)
	char *fmt;
	time_t *clocktime;
{
	/* names for weekdays */
	static char *weekdays[] = {
		"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat",
	};
  
	/* names for months */
	static char *months[] = {
		"Jan", "Feb", "Mar", "Apr", "May", "Jun",
		"Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
	};
	static char buffer[80];
	char *bp = buffer;
	time_t _clock;
	struct tm *tm_s;
#ifdef BSD
	struct timeval t;
	struct timezone tz;
	extern char *timezone();
#endif
  
	if (!clocktime)
		_clock = time((long *) 0);
	tm_s = localtime(clocktime ? clocktime : &_clock);
#ifdef BSD
	gettimeofday(&t, &tz);
#endif
  
	/* if no format string, this is default */
	if (!fmt)
		fmt = "%a %h %d %T %z 19%y";
	for (*bp = 0; *fmt; fmt++)
		switch (*fmt) {
		case '%':
			switch (*++fmt) {

			case 'n': 	/* newline */
				*bp++ = '\n';
				break;
				
			case 't':	/* tabulator */
				*bp++ = '\t';
				break;
				
			case 'm':	/* month number 1-12 */
				sprintf(bp, "%02d", tm_s->tm_mon + 1);
				while (*bp)
					bp++;
				break;
				
			case 'd':	/* day of month 1-31 */
				sprintf(bp, "%2d", tm_s->tm_mday);
				while (*bp)
					bp++;
				break;

			case 'q':
				sprintf(bp, "%02d", tm_s->tm_mday);
				while (*bp)
					bp++;
				break;
				
			case 'y':	/* year 00-99 */
				sprintf(bp, "%02d", tm_s->tm_year);
				while (*bp)
					bp++;
				break;
				
			case 'D':	/* date in format YY/MM/DD */
				sprintf(bp, "%02d/%02d/%02d", tm_s->tm_year,
					tm_s->tm_mon + 1, tm_s->tm_mday);
				while (*bp)
					bp++;
				break;
				
			case 'H':	/* hour 0-23 */
				sprintf(bp, "%02d", tm_s->tm_hour);
				while (*bp)
					bp++;
				break;
				
			case 'M':	/* minutes 0-59 */
				sprintf(bp, "%02d", tm_s->tm_min);
				while (*bp)
					bp++;
				break;
				
			case 'S':	/* seconds 0-59 */
				sprintf(bp, "%02d", tm_s->tm_sec);
				while (*bp)
					bp++;
				break;
				
			case 'T':	/* time in format HH:MM:SS */
				sprintf(bp, "%02d:%02d:%02d",
					tm_s->tm_hour, tm_s->tm_min,
					tm_s->tm_sec);
				while (*bp)
					bp++;
				break;
				
			case 'j':	/* day of year 1-356 */
				sprintf(bp, "%03d", tm_s->tm_yday + 1);
				while (*bp)
					bp++;
				break;
				
			case 'w':	/* weekday 0-6 */
				sprintf(bp, "%d", tm_s->tm_wday);
				while (*bp)
					bp++;
				break;
				
			case 'a':	/* name of weekday 'Mon', 'Tue', ... , 'Sun' */
				strcpy(bp, weekdays[tm_s->tm_wday]);
				while (*bp)
					bp++;
				break;
				
			case 'h':			/* name of month 'Jan', 'Feb', ... , 'Dec' */
				strcpy(bp, months[tm_s->tm_mon]);
				while (*bp)
					bp++;
				break;
				
			case 'z':	/* name of timezone, e.g. EST */
#ifdef USG
				strcpy(bp, *tzname);
#endif
#ifdef BSD
				strcpy(bp, timezone(tz.tz_minuteswest, tm_s->tm_isdst));
#endif
				while (*bp)
					bp++;
				break;
				
			case 'o':	/* numeric time zone, e.g. +0200 */
#ifdef USG
				sprintf(bp, "%c%02ld%02ld",
					(timezone <= 0l) ? '+' : '-',
					(my_labs(timezone) / (60l * 60l)),
					(my_labs(timezone) % (60l * 60l)));
#endif
#ifdef BSD
				sprintf(bp, "%c%02ld%02ld",
					(tz.tz_minuteswest <= 0l) ? '+' : '-',
					(my_labs(tz.tz_minuteswest) / 60l),
					(my_labs(tz.tz_minuteswest) % 60l));
#endif
				while (*bp)
					bp++;
				break;

			case 'l':/* military time zone, Z = UT, A = -1, M = -12, (J not used),
				    N = +1, Y = +12.. */
#ifdef USG
				*bp = (timezone == 0l) ? 'Z' : ((int) (my_labs(timezone) /
								       (60l * 60l)) +
								((timezone < 0l) ? 'M' : '@'));
				if (timezone > 0l && *bp >= 'J')
					(*bp)++;
#endif
#ifdef BSD
				*bp = (tz.tz_minuteswest == 0l) ? 'Z' :
					((int) (my_labs(tz.tz_minuteswest) / 60l) +
					 ((tz.tz_minuteswest < 0l) ? 'M' : '@'));
				if (tz.tz_minuteswest > 0l && *bp >= 'J')
					(*bp)++;
#endif
				*++bp = 0;
				break;
				
			default:
				*bp++ = *fmt;
				break;
			}
			break;
		default:
			*bp++ = *fmt;
			break;
		}
	*bp = 0;
	return buffer;
}


/*
 * Put a string to kitchen-sink logfile
 */
void
putlog(str)
	char *str;
{
	static boolean junked = FALSE;
	static boolean trying = FALSE;
	char path[PATH_LEN], *cp;
	int e;
	FILE *lfp;

	if (trying)
		return;
	if (junked)
		return;

	if (logfp)
		lfp = logfp;
	else if (!hasconfig || *config.logdir == 0)
		lfp = stderr;
	else {
		trying = TRUE;
		sprintf(path, "%s/%s", config.logdir, "log");
		if ((logfp = myfopen(path, "a")) == NULL) {
			trying = FALSE;
			e = errno;
			cp = sprintfs("Cannot open log file '%s': ", logfp);
			errno = e;
			perror(cp);
			junked = TRUE;
			return;
		}
		trying = FALSE;
		lfp = logfp;
	}
	fputs(str, lfp);
	putc('\n', lfp);
	fflush(lfp);
}


/*
 * Put a string to bug-log file
 */
void
putbuglog(str)
	char *str;
{
	char scratch[BUFSIZ];

	if (buglogfd == -1)
		return;

	if (buglogfd == 0) {
		sprintf(scratch, "%s/%s", config.logdir, "buglog");
		if ((buglogfd = openlogfile(scratch)) == -1) {
			log("Cannot open bug log file %s", scratch);
			return;
		}
	}
	strncopy(scratch, str, sizeof(scratch)-1);
	strcat(scratch, "\n");
	write(buglogfd, scratch, strlen(scratch));
}


/*
 * Put a string to bug-log file
 */
void
putmsglog(str)
	char *str;
{
	char scratch[BUFSIZ];

	if (msglogfd == -1)
		return;

	if (msglogfd == 0) {
		sprintf(scratch, "%s/%s", config.logdir, "msglog");
		if ((msglogfd = openlogfile(scratch)) == -1) {
			log("Cannot open bug log file %s", scratch);
			return;
		}
	}
	strncopy(scratch, str, sizeof(scratch)-1);
	strcat(scratch, "\n");
	write(msglogfd, scratch, strlen(scratch));
}


void
puterrlog(str)
	char *str;
{
	fputs(str, errorfp); putc('\n', errorfp);
	fflush(errorfp);
}


/* 
 * Log to logfile. If logfile is not open, open it.
 *  
 * If first character in format string is '$', print also errno. If external
 * variable verbose is set, logging will be done also to errorfp.
 */
void
log(fmt VA_ALIST)
	char *fmt;
	VA_DCL
{
	char log_buffer[BUFSIZ];
	va_list args;
	int eno = errno;
	register char *cp;
  
	VA_START(args, fmt);
  
	sprintf(log_buffer, "%s: ", date("%q-%h-%y %H:%M:%S", NULL));
	cp = strend(log_buffer);
	vsprintf(cp, fmt + (*fmt == '$'), args);
	cp = strend(cp);
	if (*fmt == '$')
		sprintf(cp, " errno = %d (%s)", errno, syserr(eno));
	putlog(log_buffer);
	/* if verbose is set, print also to errorfp */
	if (verbose)
		puterrlog(log_buffer);
	va_end(args);
}

void
buglog(fmt VA_ALIST)
	char *fmt;
	VA_DCL
{
	char log_buffer[BUFSIZ];
	va_list args;
	int eno = errno;
	register char *cp;
  
	VA_START(args, fmt);
  
	sprintf(log_buffer, "%s: ", date("%q-%h-%y %H:%M:%S", NULL));
	cp = strend(log_buffer);
	vsprintf(cp, fmt + (*fmt == '$'), args);
	cp = strend(cp);
	if (*fmt == '$')
		sprintf(cp, " errno = %d (%s)", errno, syserr(eno));
	putbuglog(log_buffer);
	putlog(log_buffer);
  
	/* if verbose is set, print also to errorfp */
	if (verbose)
		puterrlog(log_buffer);
	va_end(args);
}

void
msglog(fmt VA_ALIST)
	char *fmt;
	VA_DCL
{
	char log_buffer[BUFSIZ];
	va_list args;
	int eno = errno;
	register char *cp;
  
	VA_START(args, fmt);
  
	sprintf(log_buffer, "%s: ", date("%q-%h-%y %H:%M:%S", NULL));
	cp = strend(log_buffer);
	vsprintf(cp, fmt + (*fmt == '$'), args);
	cp = strend(cp);
	if (*fmt == '$')
		sprintf(cp, " errno = %d (%s)", errno, syserr(eno));
	putmsglog(log_buffer);
	putlog(log_buffer);
  
	/* if verbose is set, print also to errorfp */
	if (verbose)
		puterrlog(log_buffer);
	va_end(args);
}



/*
 * Fatal error
 */
void
fatal(errcode, fmt VA_ALIST)
	int errcode;
	char *fmt;
	VA_DCL
{
	va_list args;
  	char log_buffer[BUFSIZ];
	int eno = errno;
	register char *cp;
  
	VA_START(args, fmt);
	sprintf(log_buffer, "%s: ", date("%q-%h-%y %H:%M:%S", NULL));
	cp = strend(log_buffer);
	vsprintf(cp, fmt + (*fmt == '$'), args);
	cp = strend(cp);
	if (*fmt == '$')
		sprintf(cp, " errno = %d (%s)", errno, syserr(eno));
	putlog("***** Fatal Error *****");
	putlog(log_buffer);
	if (logfp) {
		puterrlog("***** Fatal Error *****");
		puterrlog(log_buffer);
	}
	va_end(args);
	exit(errcode ? errcode : -1);
}


/* 
 * Debug output. First argument should be number, rest are used arguments
 * for vfprintf(3S). If external variable verbose has equal or greater
 * value than first number, vfprintf(3S) will be used to print other
 * arguments to errorfp.
 */
void
debug(debug_level, fmt VA_ALIST)
	int debug_level;
	char *fmt;
	VA_DCL
{
	va_list args;
  
	VA_START(args, fmt);
	if (debug_level <= verbose) {
		fflush(stdout); /* We get cleaner display this way */
		fflush(errorfp);
		if (*fmt != '>' && *fmt != '<') {
			fprintf(errorfp, "%s: ",
				date("%q-%h-%y %H:%M:%S", NULL));
			vfprintf(errorfp, fmt, args);
			fputs(newline_string, errorfp);
		} else
			vfprintf(errorfp, fmt, args);
		fflush(errorfp);
	}
	va_end(args);
}

/* General sequencer */

long
sequencer(filename)
	char *filename;
{
	char seqfile[128], buffer[14];
	FILE *fp;
	long seqn = 0;

#ifdef LOCK_LOCKFILES
	if (!createlock("rfmailseq", config.lock_timeout))
		fatal(EX_TEMPFAIL, "Cannot create lock file");
#else
	lock(fileno(fp));
#endif
  
	sprintf(seqfile, "%s", filename);
	if ((fp = fopen(seqfile, "r+")) == NULL) {
		if (errno == ENOENT) {
			if ((fp = myfopen(seqfile, "w+")) == NULL)
				fatal(EX_OSFILE, "$Can not create seq-file %s",
				      seqfile);
			fputs("1", fp);
			fclose(fp);
			if ((fp = fopen(seqfile, "r+")) == NULL)
				fatal(EX_OSFILE,
				      "$Can not open new seq-file %s",
				      seqfile);
		} else {
			fatal(EX_OSFILE, "$Can not open seq-file %s", seqfile);
		}
	}

	if (fgets(buffer, 14, fp))
		seqn = atol(buffer);
	else
		seqn = 0; /* This can theoretically fail */
	seqn++;
	rewind(fp);
	fprintf(fp, "%ld\n", seqn);
	fclose(fp);
#ifdef LOCK_LOCKFILES
	removelock("rfmailseq");
#else
	unlock(fileno(fp));
#endif
	return seqn;
}

/* Get full pathname for spoolfile with new job number. File is in
   spool directory and contains prefix followed by four digit
   job number. */

char *
spoolfile(prefix)
     char *prefix;
{
	static char file[PATH_LEN];
  
	sprintf(file, "%s/%s%08ld",
		config.msgdir, prefix,
		sequencer(config.sequence));
	return file;
}

/*
 * Return basename of s
 * This routine works for both unix paths and
 * msdos paths.
 */
char *
basename(s)
	register char *s;
{
	register char *p = s;
  
	for (; *s; s++)
		if (*s == '/' || *s == '\\')
			p = s+1;
	return p;
}

/*
 * Returns the path of the specified filename
 * excluding the trailing slash.
 */
char *
basepath(s)
	register char *s;
{
	register char *np;
	static char path[128];

	np = basename(s);
	while (np > s && (np[-1] == '/' || np[-1] == '\\'))
		np--;
	strncopy(path, s, np-s);
	return path;
}

/*
 * Return the file type of the supplied filename
 */
char *
basetype(s)
	register char *s;
{
	register char *p = "";

	for (; *s; s++) 
		if (*s == '/')
			p = "";
		else if (*s == '.')
			p = s+1;
	return p;
}

/*
 * Return a pointer to the path of a file
 * relative to fnet spool directory.
 * This is used in printouts to reduce the length of
 * the filenames
 */
char *
spoolname(s)
	register char *s;
{
	if (strnequ(s, config.spooldir, strlen(config.spooldir))) {
		s += strlen(config.spooldir);
		if (*s == '/')
			s++;
	}
	return s;
}


/*
 * Return the directory path for a node, given the nodenumber
 */
char *
nodepath(s, node)
	char *s;
	Node node;
{
	register char *p;

	if (s)
		p = sprintfs("%s/%s", s, ascnode(node));
	else
		p = sprintfs("%s", ascnode(node));
	return p;
}


/*
 * Create packet name for inbound.
 * Subpath is based on nodenumber. 
 * If packet name is supplied, the path is prepended, otherwise
 * an unique packet name is created.
 */
void
sprintipacketname(s, node)
     char *s;
     Node node;
{
	char buffer[128];

	sprintf(buffer, "%s/%s", nodepath(NULL, node),
				 *s ? basename(s)
				    : sprintfs("%08x.in",
					  sequencer(config.ipacketsequence)));
	strcpy(s, buffer);
}

void
mychdir(s)
	char *s;
{
	if (chdir(s) == -1) {
		if (errno == ENOENT) {
			if (mymkdir(s) == -1)
				fatal(EX_OSERR, "$Cannot create missing directory %s", s);
		} else
			fatal(EX_OSERR, "$Cannot chdir to %s", s);
	}
}

void *
mymalloc(size)
	Uint size;
{
	register char *p;

	p = malloc(size+10);
	if (p == NULL) {
		log("Run out of memory");
		abort();	/* Coredump. Maybe malloc corruption or like */
	}
	return (void *)p;
}

void *
myrealloc(original_pointer, size)
	register void *original_pointer;
	Uint size;
{
	register char *p;

	if (original_pointer == NULL)
		return mymalloc(size);
	p = realloc(original_pointer, size);
	if (p == NULL) {
		log("Run out of memory");
		abort();
	}
	return (void *)p;
}

/* 
 * Like sendback, but no mail file is required and receiver will be picked up
 * from config.admin. This is used to announce important matters to system
 * administrator.
 */
void
sendadmin(subject, fmt VA_ALIST)
	char *subject, *fmt;
	VA_DCL
{
	va_list args;
	FILE *mailer;
	char buffer[BUFSIZ];

	VA_START(args, fmt);
	
	if (*config.admin) {
		log("Sending message to %s", config.admin);
  
		/* generate shell command and open it */
		sprintf(buffer, "exec %s %s", config.rmail, config.admin);
		if (mailer = popen(buffer, "w")) {
			/* print correct header for mailer */
			fprintf(mailer, "From MAILER-DAEMON %s\n",
				date("%a %h %d %T 19%y", NULL));
			fprintf(mailer, "Date: %s\n",
				date("%a, %d %h %y %T %o", NULL));
			fprintf(mailer, "From: FidoNet Mail <%s@%s>\n",
				"MAILER-DAEMON", internode(config.mynode));
			fprintf(mailer, "Subject: Announcemente Importante: %s\n",
				subject);
			fprintf(mailer, "Message-ID: <%s.AA%05d@%s>\n",
				date("%y%m%q%H%M", NULL), getpid(),
				internode(config.mynode));
			fprintf(mailer, "To: %s\n", config.admin);
			fprintf(mailer, "\n");
			fprintf(mailer,
				"  ----- Diagnostics follow -----\n");
			vfprintf(mailer, fmt, args);
			fprintf(mailer, "\n\n");
			
			/* mail is now sent, close mailer */
			pclose(mailer);
		} else
			log("$Unable to invoke mailer for returned mail");
	} else {
		/* No admin defined, log message */
		vsprintf(buffer, fmt, args);
		log("Important: %s", buffer);
	}
	va_end(args);
}


#ifndef HAVE_RENAME
int
rename(oldfile, newfile)
	char *oldfile, *newfile;
{
	if (link(oldfile, newfile) == -1)
		return -1;
	if (unlink(oldfile) == -1) {
		/* Try to remove new created link, but ignore result */
		unlink(newfile);
		return -1;
	}
	return 0; /* Everything went ok */
}
#endif

void
check_unlink(path)
	char *path;
{
	if (unlink(path) < 0)
		log("$Cannot unlink %s", path);
}

#ifdef USG
void
check_ioctl(fd, mode, address)
	int fd, mode;
	char *address;
{
	if (ioctl(fd, mode, address) < 0)
		log("$Ioctl failed, fd %d, mode %lu, address %ld",
		    fd, mode, (long) address);
}
#endif /* USG */

#ifdef BSD
void
check_ioctl(fd, mode, address)
	int fd;
	Ulong mode;
	char *address;
{
	if (ioctl(fd, mode, address) < 0)
		log("$Ioctl failed, fd %d, mode %d, address %ld",
		    fd, mode, (long)address);
}
#endif /* BSD */

/*
 * Directory creator for packet paths.
 * 
 * If a file creation fails for a file creation, this routine
 * is called, to create the neccessary subdirectories.
 */
boolean
makepath(apath)
	char *apath;
{
	char path[128];
	register char *cp;
	
	strcpy(path, apath);
	cp = strrchr(path, '/');
	if (cp == NULL)
		return FALSE;
	*cp = '\0';
	if (access(path, 0) == -1) {
		/*
		 * Create path from root
		 */
		cp = path;
		while (cp = strchr(cp+1, '/')) {
			*cp = 0;
			if (access(path, 0) == -1) {
				if (mymkdir(path) == -1)
					return FALSE;
			}
			*cp = '/';
		}
		if (access(path, 0) == -1) {
			if (mymkdir(path) == -1)
				return FALSE;
		}
	}
	return TRUE;
}


int
mymkdir(path)
	char *path;
{
	int s;

#ifdef USG
#define MODES (S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH)
#else
#define MODES 0
#endif
	s = mkdir(path, S_IREAD | S_IWRITE | S_IEXEC | MODES);
	if (s == -1) {
		log("$mkdir(%s) failed\n", path);
		return -1;
	}
	if (chmod(path, 0770) == -1)
		log("$cannot change mode of directory %s", path);
	else if (chown(path, file_uid, file_gid) == -1)
		log("$Cannot change owner/group of file %s", path);

	return 0;
}

/*
 * Special rename that creates the destination path
 * if not existing
 */
int
myrename(src, dst)
	char *src, *dst;
{
	if (rename(src, dst) == -1)
		if (errno != ENOENT || !makepath(dst)
		    || rename(src, dst) == -1)
			return -1;
	return 0;
}

FILE *
myfopen(fname, opts)
	char *fname, *opts;
{
	register FILE *fp;
	boolean newfile;

	newfile = (boolean)(access(fname, 0) == -1);
	fp = fopen(fname, opts);
	if (fp == NULL && (opts[0] == 'w' || opts[0] == 'a') && errno == ENOENT
	    && makepath(fname)) {
		fp = fopen(fname, opts);
		newfile = TRUE;
	}
	if (newfile) {
		/* set correct permissions for spoolfile and lock it */
		if (chmod(fname, config.file_mode) == -1)
			log("$Cannot change mode of file %s", fname);
		else if (chown(fname, file_uid, file_gid) == -1)
			log("$Cannot change owner/group of file %s", fname);
	}
	return fp;
}
	
/*
 * Like fseek, but checks for seek error
 */
void
myfseek(stream, offset, ptrname)
	FILE *stream;
	long offset;
	int ptrname;
{
	if (fseek(stream, offset, ptrname) != 0)
		fatal(EX_OSERR, "$Seek error");
}


/*
 * special version of the of the readdir() package that
 * returns full paths and optionally decends subdirectory trees.
 */
#define	DIRSTACKMAX	5
static DIR *dirstack[DIRSTACKMAX];
static char *dirpath[DIRSTACKMAX];
static int dirstkp = -1;
static int nesting;

int
myopendir(path, nest)
	char *path;
	int nest;
{
	if (path == NULL)
		path = ".";
	nesting = nest;
	if (dirstack[0] = opendir(path)) {
		if (strequ(path, "."))
			dirpath[0] = NULL;
		else
			dirpath[0] = strdup(path);
		dirstkp = 0;
		return 1;
	} else {
		dirstkp = -1;
		return 0;
	}
}


/*
 * Read next filename from the directory opened with
 * "myopendir", optionally matching the wild-card filename
 * in "mask"
 */
char *
myreaddir(mask)
	char *mask;
{
	struct dirent *dp;
	struct stat sbuf;
	static char path[128];

	while (dirstkp != -1) {
		if (dp = readdir(dirstack[dirstkp])) {
			if (dirpath[dirstkp])
				sprintf(path, "%s/%s", dirpath[dirstkp],
					dp->d_name);
			else 
				strcpy(path, dp->d_name);
			if (stat(path, &sbuf) == -1) {
				debug(2, "cannot stat file %s", path);
				continue;
			}
			switch (sbuf.st_mode & S_IFMT) {
			case S_IFREG:
				if (mask && !match(path, mask))
					continue;
				return path;
			case S_IFDIR:
				if (strequ(dp->d_name, ".")
				    || strequ(dp->d_name, "..")
				    || !nesting)
				    continue;
				if (dirstkp == DIRSTACKMAX-1) {
					log("Too deep directory nesting, path %s ignored", path);
					continue;
				}
				if ((dirstack[dirstkp+1] = opendir(path)) == NULL) {
					debug(2, "Cannot access path %s", path);
					continue;
				}
				dirstkp++;
				dirpath[dirstkp] = strdup(path);
				break;
			default:
				debug(2, "illegal file type for file %s", path);
			}
		} else {
			if (dirpath[dirstkp])
				free(dirpath[dirstkp]);
			closedir(dirstack[dirstkp]);
			dirstkp--;
		}
	}
	return NULL;
}

void
myclosedir()
{
	while (dirstkp != -1) {
		closedir(dirstack[dirstkp]);
		free(dirpath[dirstkp]);
		dirstkp--;
	}
}


/*
 * Convert product code into product name
 */
char *
productname(code)
	int code;
{
	static char scratch[20];

	if (code >= 0 && code < sizeof(prodcode)/sizeof(prodcode[0])
	    && prodcode[code])
		return prodcode[code];
	else if (code == PRODUCTCODE)
		return "rfmail";
	else {
		sprintf(scratch, "%d", code);
		return scratch;
	}
}

/*
 * Check if a filename is arcmail
 */
boolean
is_arcmail(fname)
	char *fname;
{
	register char *p;
	register int c;

	p = strrchr(fname, '.');
	if (p && p[1] && p[2] && isdigit(p[3]) && p[4] == 0) {
		c = tolower(p[1]) | (tolower(p[2]) << 8);
		if (   c == ('m' | ('o'<<8))
		    || c == ('t' | ('u'<<8))
		    || c == ('w' | ('e'<<8))
		    || c == ('t' | ('h'<<8))
		    || c == ('f' | ('r'<<8))
		    || c == ('s' | ('a'<<8))
		    || c == ('s' | ('u'<<8)))
			return TRUE;
	}
	return FALSE;
}


/*
 * Check if file is an incoming mail packet.
 */
boolean
is_mailpkt(fname)
	char *fname;
{
	register char *p;

	p = strrchr(fname, '.');
	if (p && tolower(p[1]) == 'p'
	      && tolower(p[2]) == 'k'
	      && tolower(p[3]) == 't'
	      && p[4] == 0)
		return TRUE;
	return FALSE;
}

/*
 * Check if file is an incoming file request file
 */
boolean
is_req(fname)
	char *fname;
{
	register char *p;

	p = strrchr(fname, '.');
	if (p && tolower(p[1]) == 'r'
	      && tolower(p[2]) == 'e'
	      && tolower(p[3]) == 'q'
	      && p[4] == 0)
		return TRUE;
	return FALSE;
}

/*
 * Check if it is a filed status name,
 * and return the number of times the transfer
 * has failed for this node.
 *
 * Failed files have file type .x99, where 99 is the number of
 * times a connection has failed.
 * It can also have type .occ, which indicates that the number
 * was occupied at last call. Occupied files always return a
 * fail count of 1.
 * If a fail count of 0 is returned, it is guaranteed that
 * the file is not a fail file.
 */
int
is_failed(fname)
	char *fname;
{
	register char *p;
	int n;

	p = basetype(fname);
	if (p != NULL) {
		if (p[0] == 'x' && isdigit(p[1]) && isdigit(p[2]) && p[3] == 0) {
			n = atoi(p+1);
			if (n == 0)
				n = 1;
			return n;
		}
		if (p[0] == 'o' && p[1] == 'c' && p[2] == 'c' && p[3] == 0)
			return 1;
	}
	return 0;
}

/*
 * Check if file is an outgoing packet
 */
boolean
is_out(fname)
	char *fname;
{
	register char *p;

	if (p = basetype(fname)) {
		if (p[0] && ((p[1] == 'e' && p[2]=='q') ||
			     (p[1] == 'u' && p[2]=='t')))
			return TRUE;
	}
	return FALSE;
}
			     

/*
 * Wildcard matching routine
 * The match routine tries to match a string with a wildcard
 * pattern.
 * Special pattern characters are:
 *	?	 - Any character
 *	*	 - Any string
 *	[...]	 - Any character within brackets
 */
static boolean umatch();

boolean
match(s, p)
	register char *s, *p;
{
	register scc;
	int c, cc, ok, lc;

	scc = *s++;
	switch (c = *p++) {
	case '[':
		ok = 0;
		lc = 077777;
		while (cc = *p++) {
			if (cc==']') {
				if (ok)
					return match(s, p);
				else
					return FALSE;
			} else if (cc=='-') {
				if (lc<=scc && scc<=(c = *p++))
					ok++;
			} else
				if (scc == (lc=cc))
					ok++;
		}
		return FALSE;

	default:
		if (c!=scc)
			return FALSE;

	case '?':
		if (scc)
			return match(s, p);
		return FALSE;

	case '*':
		return umatch(--s, p);

	case '\0':
		return (boolean)(scc == 0);
	}
}

static boolean
umatch(s, p)
	char *s, *p;
{
	if(*p==0)
		return TRUE;
	while(*s)
		if (match(s++,p))
			return TRUE;
	return FALSE;
}

/*
 * Generate an unique filename
 */
void
unique_name(fname)
	char *fname;
{
	char *bname;
	register char *cp;

	while (access(fname, 0) == 0) {
		bname = basename(fname);
		cp = strrchr(fname, '.');
		if (cp && isdigit(cp[1]) && isdigit(cp[2])
		    && cp[3] == 0) {
			sprintf(cp, ".%02d", atoi(cp+1)+1);
		} else if (strlen(bname) <= 11)
			strcat(bname, ".00");
		else
			strcpy(bname+11, ".00");
	}
}

char *
syserr(eno)
	int eno;
{
	register char *cp;

	if (eno >= 0 && eno < sys_nerr)
		cp = sys_errlist[eno];
	else
		cp = NULL;
	if (cp == NULL || *cp == '\0')
		cp = sprintfs("Error code %d", eno);
	return cp;
}


/*
 * Translate symbolic owner and group to numeric.
 */
void
get_ownerdata()
{
	struct passwd *pwd;
	struct group *grp;
	void endpwent(), endgrent();

	/*
	 * We have to translate symbolic owner to
	 * numeric.
	 */
	pwd = getpwnam(config.file_owner);
	if (pwd == NULL)
		buglog("Cannot locate owner %s", config.file_owner);
	else
		file_uid = pwd->pw_uid;
	endpwent();

	/*
	 * Do the same for symbolic group
	 */
	grp = getgrnam(config.file_group);
	if (grp == NULL)
		buglog("Cannot locate group %s", config.file_group);
	else
		file_gid = grp->gr_gid;
	endgrent();
}


/*
 * Fixup version number from RCS revision information
 * Put the binary version number in version_major and version_minor,
 * put the ascii digits in version[]. Only keep the major and minor
 * part of the revision number.
 */
void
fixversion(revid)
	char *revid;
{
	register char *cp;
	char *cp1;
	register int n;

	cp1 = cp = strchr(revid, ' ');
	while (isspace(*cp))
		cp++;
	n = 0;
	cp1 = version;
	while (isdigit(*cp)) {
		n = n * 10 + *cp - '0';
		*cp1++ = *cp++;
	}
	version_major = n;
	if (*cp == '.') {
		*cp1++ = *cp++;
		n = 0;
		while (isdigit(*cp)) {
			n = n * 10 + *cp - '0';
			*cp1++ = *cp++;
		}
		version_minor = n;
	} else
		version_minor = 0;
	if (*cp == '.') {
		*cp1++ = *cp++;
		n = 0;
		while (isdigit(*cp)) {
			n = n * 10 + *cp - '0';
			*cp1++ = *cp++;
		}
		version_revision = n;
	} else
		version_revision = 0;
	if (*cp == '.') {
		*cp1++ = *cp++;
		n = 0;
		while (isdigit(*cp)) {
			n = n * 10 + *cp - '0';
			*cp1++ = *cp++;
		}
		version_patchlev = n;
	} else
		version_patchlev = 0;
	*cp1++ = '\0';
}


static int
openlogfile(fname)
	char *fname;
{
	int fd;

	fd = open(fname, O_WRONLY|O_APPEND);
	if (fd == -1 && errno == ENOENT) {
		fd = open(fname, O_WRONLY|O_APPEND|O_CREAT, 0600);
		if (fd == -1 && errno == ENOENT && makepath(fname))
			fd = open(fname, O_WRONLY|O_APPEND|O_CREAT, 0600);
		if (fd == -1)
			return -1;
		/* set correct permissions for file */
		if (chmod(fname, config.file_mode) == -1)
			log("$Cannot change mode of file %s", fname);
		else if (chown(fname, file_uid, file_gid) == -1)
			log("$Cannot change owner/group of file %s", fname);
	}
	return fd;
}
	

/* 
 * Find out which node to route mail for node to
 * Returns:
 *	result = TRUE if routing found for this schedule
 *	&tletter = The routing type (c, h, o, d)
 *	&gnode = The node to schedule to
 * if gnode == NULL, route_node will return FALSE if
 * the packets is to be scheduled to another node than given.
 */
boolean
route_node(node, rtype, gnode)
	Node node, *gnode;
	routing_type *rtype;
{
	register int target, mask;
  
	for (target = 0; target < config.targets; target++) {
		*rtype = config.routing[target].rtype;

		if (schedule != config.routing[target].tag)
			continue;

		for (mask = 0; mask < config.routing[target].masks; mask++) {
			if (node_match(config.routing[target].mask[mask], node)) {
				
				if (*rtype == ROUTING_DIRECT
				    || *rtype == ROUTING_ARC_DIRECT) {
					if (gnode)
						*gnode = node;
				} else {
					if (gnode)
						*gnode = config.routing[target].dest;
					else
						continue;
				}
				return TRUE;
			}
		}
	}
	return FALSE;
}

void 
rtypetoletter(rtype, tletter)
	routing_type rtype;
	char *tletter;
{
	switch (rtype) {
	case ROUTING_CRASH:
	case ROUTING_ARC_CRASH:
		*tletter = 'c';
		return;
	case ROUTING_HOLD:
	case ROUTING_ARC_HOLD:
		*tletter = 'h';
		return;
	case ROUTING_ROUTE_TO:
	case ROUTING_ARC_TO:
		*tletter = 'o';
		return;
	case ROUTING_DIRECT:
	case ROUTING_ARC_DIRECT:
		*tletter = 'd';
		return;
	default:
		*tletter = '?';
	}
}

/*
 * Find information to be used for the given node
 * Used for packet type, password and origin address
 *
 */

struct dest_info
get_destinfo(node)
	Node node;
{
	int i,j;
	struct dest_info default_info = { {config.mynode}, 1, config.mynode, "", FTS0001,  -1};
	
	for (i = 0; i < MAX_KEYS ; i++)
		{
		for (j = 0; j < config.destinfo[i].no_masks; j++)
			if (node_match(config.destinfo[i].masks[j], node))
				return config.destinfo[i];
		}
	return default_info;
}

/* Check if mask node expression matches node */

boolean
node_match(mask, node)
	Node mask, node;
{
	if (node.zone == NODE_WILDCARD && mask.zone != node.zone)
		return FALSE;
	if (mask.zone != NODE_WILDCARD && mask.zone != node.zone)
		return FALSE;
	if (node.net == NODE_WILDCARD && mask.net != node.net)
		return FALSE;
	if (mask.net != NODE_WILDCARD && mask.net != node.net)
		return FALSE;
	if (node.node == NODE_WILDCARD && mask.node != node.node)
		return FALSE;
	if (mask.node != NODE_WILDCARD && mask.node != node.node)
		return FALSE;
	if (node.point == NODE_WILDCARD && mask.point != node.point)
		return FALSE;
	if (mask.point != NODE_WILDCARD && mask.point != node.point)
		return FALSE;
	return TRUE;
}


/*
 * Check if the node number is one of ours.
 */
boolean
is_our_node(node)
	Node node;
{
	register int i;

	if (NODEEQU(node, config.mynode))
		return TRUE;
	for (i = 0; i < config.akas; i++)
		if (NODEEQU(config.aka[i], node))
			return TRUE;
	return FALSE;
}

#ifndef HAVE_MKDIR

/*
 *				NMKDIR.C
 *
 * Written by Robert Rother, Mariah Corporation, August 1985. 
 *
 * I wrote this out of shear disgust with myself because I couldn't
 * figure out how to do this in /bin/sh.
 *
 * If you want it, it's yours.  All I ask in return is that if you
 * figure out how to do this in a Bourne Shell script you send me
 * a copy.
 *					sdcsvax!rmr or rmr@uscd
*
* Severely hacked over by John Gilmore to make a 4.2BSD compatible
* subroutine.	11Mar86; hoptoad!gnu
*
* Modified by rmtodd@uokmax 6-28-87 -- when making an already existing dir,
* subroutine didn't return EEXIST.  It does now.
*/

/*
 * Make a directory.  Compatible with the mkdir() system call on 4.2BSD.
 */
int
mkdir(dpath, dmode)
	char *dpath;
	int dmode;
{
	int cpid, status;
	struct stat statbuf;
	extern int errno;

	if (stat(dpath,&statbuf) == 0) {
		errno = EEXIST;		/* Stat worked, so it already exists */
		return -1;
	}

	/* If stat fails for a reason other than non-existence, return error */
	if (errno != ENOENT) return -1; 

	switch (cpid = fork()) {

	case -1:			/* Error in fork() */
		return(-1);		/* Errno is set already */

	case 0:				/* Child process */
		/*
		 * Cheap hack to set mode of new directory.  Since this
		 * child process is going away anyway, we zap its umask.
		 * FIXME, this won't suffice to set SUID, SGID, etc. on this
		 * directory.  Does anybody care?
		 */
		status = umask(0);	/* Get current umask */
		status = umask(status | (0777 & ~dmode)); /* Set for mkdir */
		execl("/bin/mkdir", "mkdir", dpath, (char *)0);
		_exit(-1);		/* Can't exec /bin/mkdir */
	
	default:			/* Parent process */
		status = mywait(cpid);
	}

	if (status != 0) {
		errno = EIO;		/* We don't know why, but */
		return -1;		/* /bin/mkdir failed */
	}

	return 0;
}

#endif

/*
 * Read a 8-bit int from file.
 */
boolean
read_char(fp, c)
	FILE *fp;
	Uchar *c;
{
	register int c1;

	c1 = getc(fp);
	if (c1 == -1)
		return FALSE;
	*c = c1;
/*	debug(8, "< %02x(%ld)", *c, ftell(fp)-2); */
	return TRUE;
}

/*
 * Read a 16-bit int from file.
 */
boolean
read_int16(fp, c)
	FILE *fp;
	Ushort *c;
{
	register int c1, c2;

	c1 = getc(fp);
	if (c1 == -1)
		return FALSE;
	c2 = getc(fp);
	if (c2 == -1)
		return FALSE;
	*c = c1 | (c2 << 8);
/*	debug(8, "< %02x(%ld)", *c, ftell(fp)-2); */
	return TRUE;
}

/*
 * Read a 32-bit long from file.
 */
boolean
read_long(fp, c)
	FILE *fp;
	Ulong *c;
{
	int c1, c2, c3, c4;

	if ((c1 = getc(fp)) == -1) return FALSE;
	if ((c2 = getc(fp)) == -1) return FALSE;
	if ((c3 = getc(fp)) == -1) return FALSE;
	if ((c4 = getc(fp)) == -1) return FALSE;
	*c = c1 | (c2 << 8) | (c3 << 16) | (c4 << 24);
	return TRUE;
}

/*
 * Read a 24-bit long from file.
 */
boolean
read_int24(fp, c)
	register FILE *fp;
	Ulong *c;
{
	int c1, c2, c3;

	if ((c1 = getc(fp)) == -1) return FALSE;
	if ((c2 = getc(fp)) == -1) return FALSE;
	if ((c3 = getc(fp)) == -1) return FALSE;
	*c = c1 | (c2 << 8) | (c3 << 16);
	return TRUE;
}

/* Read null-terminated string from file. Ensure that buffer is also
   null-terminated. Remove possible blanks from beginning and blanks+newlines
   from end, they are generated by some buggy mailers. */


boolean
read_string(fp, buffer, nbytes)
	char *buffer;
	FILE *fp;
	int nbytes;
{
	register int n, c;
	int b;
	char *cp;

	for (n = 0, b = 1; n < nbytes; n++) {
		c = getc(fp);
		if (c == EOF)
			return FALSE;
		if (b) {
			if (isspace(c)) {
				n--;
				continue;
			} else
				b = 0;
		}
		buffer[n] = c;
/*		debug(8, "<%d %c>", c, c); */
		if (c == 0)
			break;
	}
	buffer[nbytes-1] = 0;

	/* Remove \n and spacing from end if its there, its a bug */
	cp = strend(buffer);
	while (cp > buffer && isspace(cp[-1]))
		*--cp = 0;
	return TRUE;
}

/* 
 * Write a char to file in msdos integer format
 * Return TRUE if operation succeeded, 
 * FALSE if it failed
 */
boolean
write_char(fp, value)
	FILE *fp;
	Uint value;
{
	if (putc(value & 0xff, fp) == EOF)
		return FALSE;
	return TRUE;
}

/* 
 * Write int to file in msdos integer format
 * Return TRUE if operation succeeded, 
 * FALSE if it failed
 */
boolean
write_int16(fp, value)
	register FILE *fp;
	register Uint value;
{
	if (putc(value & 0xff, fp) == EOF)
		return FALSE;
	if (putc(value >> 8, fp) == EOF)
		return FALSE;
	return TRUE;
}

/* 
 * Write long to file in msdos integer format
 * Return TRUE if operation succeeded, 
 * FALSE if it failed
 */
boolean
write_long(fp, value)
	register FILE *fp;
	register Ulong value;
{
	if (putc(value & 0xff, fp) == EOF)
		return FALSE;
	if (putc((value >> 8) & 0xff, fp) == EOF)
		return FALSE;
	if (putc((value >> 16) & 0xff, fp) == EOF)
		return FALSE;
	if (putc((value >> 24) & 0xff, fp) == EOF)
		return FALSE;
	return TRUE;
}

/* 
 * Write a 24-bit word (long) to file in msdos integer format
 * Return TRUE if operation succeeded, 
 * FALSE if it failed
 */
boolean
write_int24(fp, value)
	register FILE *fp;
	register Ulong value;
{
	if (putc(value & 0xff, fp) == EOF)
		return FALSE;
	if (putc((value >> 8) & 0xff, fp) == EOF)
		return FALSE;
	if (putc((value >> 16) & 0xff, fp) == EOF)
		return FALSE;
	return TRUE;
}

/*
 * Put string to file in null-terminated format.
 */
boolean
write_string(fp, s)
	register FILE *fp;
	register char *s;
{
	while (*s) {
		if (putc(*s, fp) == EOF)
			goto err;
		s++;
	}
	if (putc(0, fp) == EOF)
		goto err;
	return TRUE;
 err:
	return FALSE;
}

/*
 * wait-function that should work on all systems (hopefully)
 * returns exit-status of process
 */
int
mywait(pid)
	int pid;
{
/*
 * This might have to change to BSD, if any system has sys/wait.h
 * but not union-based wait.
 */
#ifdef BSD 
	union wait *status;
#else
	int status;
#endif
	int p;
	

	while ((p = wait(&status)) != pid) {
		if (p == -1) {
			if (errno == EINTR)
				log("Wait interrupted");
			else {
				log("$wait fails");
				return -1;
			}
		}
	}
#ifdef BSD
	if (status.w_status & 0xff)
		return -1;
	return (status.w_status >> 8) & 0xff;
#else
	if (status & 0xff)
		return -1;
	return (status >> 8) & 0xff;
#endif
}


int
baud_to_bsdbaud(baud)
     int baud;
{
	switch (baud) {
	case 50: return B50;
	case 75: return B75;
	case 110: return B110;
	case 134: return B134;
	case 200: return B200;
	case 300: return B300;
	case 600: return B600;
	case 1200: return B1200;
	case 1800: return B1800;
	case 2400: return B2400;
	case 4800: return B4800;
	case 9600: return B9600;
	case 19200:
#ifdef B19200
		return B19200;
#else
		return EXTA; /* Guess. This may blow up something! */
#endif
	case 38400:
#ifdef B38400
		return B38400;
#else
		return EXTB; /* Guess, again. */
#endif
	case 0:
		log("0 baud rate requested, returning B9600");
		return B9600;
	default:
		log("Unknown baud rate %d requested, returning B9600", baud);
		return B9600;
	}
}

int
bsdbaud_to_baud(bsdbaud)
	int bsdbaud;
{
	switch (bsdbaud) {
	case B50: return 50;
	case B75: return 75;
	case B110: return 110;
	case B134: return 134;
	case B200: return 200;
	case B300: return 300;
	case B600: return 600;
	case B1200: return 1200;
	case B1800: return 1800;
	case B2400: return 2400;
	case B4800: return 4800;
	case B9600: return 9600;
#ifdef B19200
	case B19200:
#else
	case EXTA: /* Guess. This may blow up something! */
#endif
		return 19200;
#ifdef B38400
	case B38400:
#else
	case EXTB: /* Guess, again. */
#endif
		return 38400;
	case B0:
		log("B0 = 0 baud rate, returning 0");
		return 0;
	default:
		log("Unknown baud flag %o requested, returning 9600", bsdbaud);
		return 9600;
	}
}

#ifndef FTIMER
extern long timezone;
extern int  daylight;

void
ftime(tp)
struct timeb *tp;
{
	long t;

	(void) time(&t);
	tp->time = t;
	tp->millitm = 0;
	tp->timezone = timezone/60;
	tp->dstflag = daylight;
}
#endif

/*
 * Execute a command, capturing output to log file
 */
int
exec_command(program VA_ALIST)
	char *program;
	VA_DCL
{
	va_list vargs;
	FILE *fp;
	int fd[2];
	int pid;
	char buf[128];
	char *args[MAXARGS];
	int nargs;
	char *cp;
	int status;

	VA_START(vargs, program);
  
	nargs = 0;

	strcpy(buf, program);
	for (cp = strtok(buf, " "); cp; cp = strtok(NULL, " "))
		args[nargs++] = cp;
	while (cp = va_arg(vargs, char *))
		args[nargs++] = cp;

	args[nargs] = NULL;

	if (pipe(fd) == -1) {
		perror("funpack: pipe");
		return -1;
	}
  
	switch (pid = fork()) {
	case -1:
		perror("funpack: fork failed");
		return -1;
      
	case 0:			/* Child */
		/* redirect stdout into pipe */

		if (dup2(fd[1], 1) != -1) {
			close(fd[0]);
			close(fd[1]);
			execvp(args[0], args);
			perror(program);
		} else
			perror("funpack: dup");
		exit(EX_OSERR);
      
	default:		/* Parent */
		close(fd[1]);
		if ((fp = fdopen(fd[0], "r")) == NULL) {
			perror("funpack: fdopen");
			return -1;
		}
	}
	while (fgets(buf, sizeof buf-1, fp))
		{
		if (buf[strlen(buf) -1] == '\n')
			buf[strlen(buf) - 1] = '\0';
		log(buf);
		}
	fclose(fp);
	
	status = mywait(pid);
	debug(2, "Wait status: %o", status);
	return status;
}
