/*
 * $Header: /u1/src/rfmail/RCS/fpack.c,v 0.5 1992/05/18 04:27:24 pgd Exp pgd $
 *
 * $Log: fpack.c,v $
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.5  1991/09/07  10:37:46  pgd
 * not finished revision check-in
 *
 * Revision 0.4.1.3  1991/06/15  09:33:39  pgd
 * *** empty log message ***
 *
 * Revision 0.4.1.2  1991/06/05  09:13:58  pgd
 * Various Bugfixes:
 *
 * Patches suggested by Jari Nopanen:
 * open_packet did not correctly handle already open packet.
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 *
 */

/* Create and update fidomail packets. Read mail messages from
   spool directory and append them to packet. If packet doesn't
   exist already, it will be created. Packet name in P.point.node.net.zone.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/*
 * Authors:
 *
 * Teemu Torma who wrote the original code (?)
 *
 * Heikki Suonsivu (hsu@hutcs.hut.fi) who made a lot of enhancements
 * 
 * Per Lindqvist (pgd@compuram.bbt.se) who continued to enhance rfmail.
 */

#include "fnet.h"

#include <ctype.h>

#ifdef FCNTL
#include <fcntl.h>
#endif

#include <sys/stat.h>

#include "nodelist.h"
#include "configs.h"
#include "packet.h"
#include "routing-hash.h"
#include "rfmail.h"
#ifdef BINKLEY
#include "binkley.h"
#endif     

#ifdef XENIX
DECLARE(int, fstat, (int, struct stat *));
#endif

/*
 * local defines and typedefs 
 */

#define MAX_CACHE MAX_TARGETS + 1 /* allow for 1 target on command line */

/*
 * Prototypes for local routines
 */
LDECLARE(boolean, open_packet, (Node, char));
LDECLARE(void, close_packets, (void));
LDECLARE(boolean, process_message, (char *));
#ifndef BINKLEY
LDECLARE(void, normalize_packet, (char *));
#endif
LDECLARE(void, savebadmsg, (char *));


#ifndef min
#define	min(A,B)	((A)<(B)?(A):(B))
#endif


static struct mailbundle_cache {
	Node dest;			/* destination of packet */
	routing_type rtype;		/* type of routing  (hash) */
	FILE *fptr;			/* pointer to open packet */
	char packet_name[PATH_LEN];	/* full path to packet */
} mail_cache[MAX_CACHE];

static no_cache = 0;
static FILE *packet;

/*
 * Store a mail packet in the cache
 */

static void
cache(node, rtype, packetname, fptr)
	Node node;			/* destination node */
	char rtype;			/* type of mail */
	char * packetname;		/* packetname */
	FILE *fptr;			/* pointer to open packetfile */
{
	mail_cache[no_cache].dest = node; 
	mail_cache[no_cache].rtype = rtype;
	mail_cache[no_cache].fptr = fptr;
	if (packetname != NULL)
		strcpy(mail_cache[no_cache].packet_name, packetname);
	else 
		mail_cache[no_cache].packet_name[0] = '\0';
	no_cache++;
}

/*
 * Get the filepointer of a mailpacket from the cache
 */

static FILE *
get_packet_ptr(node, type)
	Node node;
	char type;
{
	int i;

	for(i = 0; i < no_cache; i++)
		{
		if (NODEEQU(mail_cache[i].dest, node) && mail_cache[i].rtype == type)
			return mail_cache[i].fptr;
		}
	return NULL;
}

/* Close all open packets and create/update Binkley style flowfiles 
   called when fpack terminates. */

void
close_packets()
{
	int i;

	for (i = 0; i < no_cache; i++)
		{
		if (mail_cache[i].fptr != NULL)
			{
			/* Packet file open, close this one */
			/* msg type 0 indicates end of packet. Notice, */
			/* if file is reopened for appending new messages, */
			/* one must seek to point before this. */

			if (!write_int16(mail_cache[i].fptr, 0))
				log("$fpack (close_packet): write failure");
			if (fclose(mail_cache[i].fptr) != 0)
				log("$fpack (close_packet): close error");
			}

#ifdef BINKLEY
			arc_mail(mail_cache[i].dest, mail_cache[i].rtype, mail_cache[i].packet_name);
#endif	/* BINKLEY */
	}
}

/* Open packet for writing. This should be called always when there is the
   slightest possibility of target node being changed. For every message with
   current implementation. */ 

static boolean
open_packet(node, type)
	Node node;
	char type;
{
	Packet pkt;
	char *outpacket;
#ifdef BINKLEY
	int opacketseq;
#else
	char tletter;
	int l, i;
#endif
 
	/*
	 * Check if we have any existing packet for this node.
	 * If we have, append to that packet, otherwise create
	 * new packet with the requested name.
	 */
	if ((packet = get_packet_ptr(node,type)) == NULL)
		{
		/* no packet exists, create a new packet */
#ifdef BINKLEY
		opacketseq = sequencer(config.opacketsequence);
		if (node.zone != config.mynode.zone)
			outpacket = sprintfs("%s.%03x/%08d.PKT", config.outdir, node.zone, opacketseq);
		else
			outpacket = sprintfs("%s/%08d.PKT", config.outdir, opacketseq);

		/* open packet */

		if ((packet = myfopen(outpacket, "w")) == NULL) {
			log("$Can not open packet %s for writing",
			    spoolname(outpacket));
			return FALSE;
			}

		/* store packet in cache */

		cache(node, type, outpacket, packet);      

		/* prepare and write packet header */

		create_packet_header(&pkt, node);
		if (!write_packet_header(&pkt, packet)) {
			log("$Error writing packet header to file %s",
			    spoolname(outpacket));
			return FALSE;
		}
#else
		sprintf(packet_name, "%s.out", nodepath(NULL, node));
		outpacket = sprintfs("%s/%s", config.outdir, packet_name);
		l = strlen(outpacket);
		for (i = 0; i < 4; i++) {
			outpacket[l-3] = "odch"[i];
			if (access(outpacket, 0) == 0)
				break;
		}
		if (i == 4) {
			rtypetoletter(type, &tletter);
			outpacket[l-3] = tletter;
			debug(1, "New packet %s", outpacket);
			if ((packet = myfopen(outpacket, "w")) == NULL) {
				log("$Can not open packet %s for writing",
				    spoolname(outpacket));
				return FALSE;
			}
	      
			create_packet_header(&pkt, node);
			/* write packet-header, if it fails, exit */
			if (!write_packet_header(&pkt, packet)) {
				log("$Error writing packet header to file %s",
				    spoolname(outpacket));
				return FALSE;
			}
	} else {
		debug(1, "Packet %s exists, append to it", 
		      spoolname(outpacket));
		if ((packet = fopen(outpacket, "r+")) == NULL) {
			log("$Can not open %s for update",
			    spoolname(outpacket));
			return FALSE;
		}
		/*
		 * Position before the eof mark
		 */
		if (fseek(packet, -2l, 2) == -1)
			log("$fpack: fseek error");
#endif
	}
	return TRUE;

}


int
fpack(argc, argv)
     int argc;
     char **argv;
{
	char *fname, *bname;
	int target, i;
	Node node;

  
	get_nodelist();		/* try to update nodelist-index */

	/* lock packets, wait if it's alredy locked */

#ifdef LOCK_LOCKFILES
	if (!createlock("opacket", config.lock_timeout))
		fatal(EX_TEMPFAIL, "Could not create lock file");
#else
	while (lock(fileno(packet)) == -1 && errno == EAGAIN)
		sleep(1);
#endif
  
	if (fflag)
		log("Packing messages to node %s", ascnode(fnode));
	else if (Pflag)
		log("Packing messages / polling node %s", ascnode(Pnode));
	else
		log("Packing all messages");
 
#ifndef BINKLEY 
	/*
	 * First normalize all current packets in the out directory
	 */
	if (myopendir(fflag ? nodepath(config.indir, fnode) : config.indir, TRUE)) {
		while (fname = myreaddir(NULL)) {
			normalize_packet(fname);
			myclosedir();
		}
	}
#endif

	/*
	 * Process all new messages.
	 */
	if (myopendir(config.msgdir, TRUE)) {
		while (fname = myreaddir(NULL)) {
			/* Check out that this is a message file */
			bname = basename(fname);
			if (bname[0] == 'M' && bname[1] == '.') {
				if (process_message(fname)) {
					log("Processed message %s",
					    spoolname(fname));
					check_unlink(fname);
				} else if (config.save_bad_messages)
					savebadmsg(fname);
				else
					check_unlink(fname);
			}
		}
		myclosedir();
	}
	  
	/*
	 * Create empty packets/flowfiles for nodes that need polling
	 */
	for (target = 0; target < config.targets; target++) {
		if (schedule == config.routing[target].tag
		    && config.routing[target].rtype == ROUTING_POLL) {
			for (i = 0; i < config.routing[target].masks; i++) {
				node.zone = config.routing[target].mask[i].zone;
				node.net = config.routing[target].mask[i].net;
				node.node = config.routing[target].mask[i].node;
				node.point = config.routing[target].mask[i].point;
				log("polling node %s", ascnode(node));
#ifdef BINKLEY
				cache(node, ROUTING_CRASH, NULL, NULL);
#else
				open_packet(node, ROUTING_CRASH);
#endif
			}
		}
	}
	
	if (Pflag)
#ifdef BINKLEY
		cache(Pnode, ROUTING_CRASH, NULL, NULL);
#else
		open_packet(Pnode, ROUTING_CRASH);
#endif

	close_packets();		/* Packet files should be open at this point */

#ifdef LOCK_LOCKFILES
	removelock("opacket");
#else
	unlock(fileno(packet));
#endif
  
	return EX_OK;
}




/*
 * Process a message. Dispose of packet according to routing
 * instructions.
 */
static boolean
process_message(fname)
	char *fname;
{
	FILE *msgfp;
	register int c;
	char rtype;
	Node tonode;
	Message msg;

	if ((msgfp = fopen(fname, "r")) == NULL)
		goto bad;

	debug(1, "Processing message %s", spoolname(fname));
		
	/*
	 * Read the message into the 'msg' structure
	 */
	if (!read_msg_hdr(&msg, msgfp))
		goto bad;

	/* 
	 * Find out which packet this message should go into
	 * route_node returns FALSE if we should not route
	 * to this node under this schedule.
	 *
	 * If crash specified, always set routing to crash
	 * Is this correct?
	 */
	if (msg.attr & ATTR_CRASH) {
		rtype = ROUTING_CRASH;
		tonode = msg.dest;
	} else if (!route_node(msg.dest, &rtype, &tonode))
		goto skip;
  
	if (fflag && cmpnode(&tonode, &fnode) != 0)
		goto skip;

	/*
	 * Output the correct packet for output
	 */
	if (!open_packet(tonode, rtype))
		goto bad;
  
	/*
	 * Write message header to packet
	 */
	if (!write_type2_hdr(&msg, packet))
		goto bad;

	/*
	 * Copy message body to packet.
	 */
	while ((c = getc(msgfp)) && c != 0 && c != -1) {
		if (c == '\r') c = '\n';
		else if (c == '\n') c = '\r';
		putc(c, packet);
	}
	putc(0, packet);	/* Write message end-of-file marker */
	putc(0, packet);	/* Write packet end-of-file marker */
	putc(0, packet);
	fflush(packet);		/* Flush output buffers for safety */
 skip:
	if (msgfp)
		fclose(msgfp);
	return TRUE;

 bad:
	if (msgfp)
		fclose(msgfp);
	return FALSE;
}


#ifndef BINKLEY
/*
 * normalize packet.
 */
static void
normalize_packet(fname)
	char *fname;
{
	char *cp, *np, *tp;
	Node node;
	int target, mask, rtype;
	char scratch[PATH_LEN];

	strcpy(scratch, fname);
	/*
	 * Figure out which node this packet is to
	 */
	cp = spoolname(scratch);
	if (cp == fname)
		return;
	np = basename(cp);
	if (np[-1] != '/')
		return;
	np[-1] = 0;
	tp = basetype(np);
	/*
	 * Process only .?ut and .?eq packets
	 */
	if (!is_out(np))
		return;
	if (!parsenode(cp, &node, NULL, NULL))
		return;

	/* 
	 * Find routing command for this node
	 */
	for (target = 0; target < config.targets; target++) {
		rtype = config.routing[target].rtype;
		if (schedule != config.routing[target].tag)
			continue;
		if (rtype != ROUTING_LEAVE && rtype != ROUTING_SEND
		    && rtype != ROUTING_DOCRASH)
			continue;
		for (mask = 0; mask < config.routing[target].masks; mask++)
		       if (node_match(config.routing[target].mask[mask], node))
				break;
		if (mask == config.routing[target].masks)
			continue;
		switch (rtype) {
		case ROUTING_LEAVE:
			/*
			 * Leave command. Rename .out -> .Out
			 */
			strcpy(scratch, fname);
			cp = basetype(scratch);
			if (islower(*cp)) {
				*cp = toupper(*cp);
				if (myrename(fname, scratch))
					log("$Cannot put packet %s on leave",
					    spoolname(fname));
				else
					log("Putting packet %s on leave",
					    spoolname(fname));
			}
			return;

		case ROUTING_SEND:
			/*
			 * Send command. Rename .Out -> .out
			 */
			if (isupper(*tp)) {
				strcpy(scratch, fname);
				cp = basetype(scratch);
				*cp = tolower(*cp);
				if (myrename(fname, scratch))
					log("$Cannot send packet %s",
					    spoolname(fname));
				else
					log("Putting packet %s on send",
					    spoolname(fname));
			}
			return;

		case ROUTING_DOCRASH:
			/*
			 * Crash command.
			 * Rename .Cut -> .cut
			 */
			if (strequ(tp, "Cut")) {
				strcpy(scratch, fname);
				cp = basetype(scratch);
				*cp = tolower(*cp);
				if (myrename(fname, scratch))
					log("$Cannot crash packet %s",
					    spoolname(fname));
				else
					log("Crashing packet %s",
					    spoolname(fname));
			}
			return;
		}
	}
	return;
}
#endif

static void
savebadmsg(fname)
	char *fname;
{
	char path[PATH_LEN];

	sprintf(path, "%s/%s", config.badarticles, basename(fname));
	unique_name(path);
	if (myrename(fname, path) == -1) {
		log("$Cannot move bad message %s to %s",
		    spoolname(fname), spoolname(path));
		if (unlink(path) == -1)
			log("$Unable to unlink %s", spoolname(path));
	}
}
