/*
 * $Header: /u1/src/rfmail/RCS/fnet.h,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: fnet.h,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.2  1991/06/05  09:13:58  pgd
 * Various Bugfixes:
 *
 * Revision 0.4.1.1  1991/05/21  11:13:48  pgd
 * *** empty log message ***
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

/* General definitions for fidonet software
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/*
 * Authors:
 *
 * Teemu Torma who wrote the original code (?)
 *
 * Heikki Suonsivu (hsu@hutcs.hut.fi) who made a lot of enhancements
 * 
 * Per Lindqvist (pgd@compuram.bbt.se) who continued to enhance rfmail.
 */

/*
 * Includes needed by all rfmail modules
 */


#include <stdio.h>
#include <sys/types.h>

#include "conf.h"

#include "declare.h"

#ifdef TMINSYS
#include <sys/time.h>
#else
#include <time.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#include <errno.h>
#include <stdlib.h>

#ifdef HAVE_TIMEB_H
#include <sys/timeb.h>
#else
#include "timeb.h"
#endif

#include <signal.h>

#define Timeout(t)      (time(NULL) - s_time > (t))
#define Timeleft(t)	((t) - (time(NULL) - s_time))
#define SetStart()      (s_time = time(NULL))

/* Msc doesn't define SIG_ERR */

#ifndef SIG_TYPE
#ifdef VOIDSIG
#define SIG_TYPE void (*)()
#define SIG_FTYPE void
typedef void (*sig_t)(void);
#else
#define SIG_TYPE int (*)()
#define SIG_FTYPE int
typedef int (*sig_t)();
#endif
#endif /* SIG_TYPE undefined */

#ifndef SIG_ERR
#define SIG_ERR ((SIG_FTYPE (*)())-1)
#endif /* SIG_ERR undefined */

#ifdef MALLOC_DEBUGGER
extern char _mallocdebug_name[20];
extern int _name_repeat;
#define mallocname(s) strncpy(_mallocdebug_name, s, 19); \
  _mallocdebug_name[19] = 0;
#define mallocnames(s) strncpy(_mallocdebug_name, s, 19); \
  _mallocdebug_name[19] = 0; _name_repeat = 1;
#define mallocendnames() _name_repeat = 0; *_mallocdebug_name = 0
#else
#define mallocname(s) /* Ignore */
#define mallocnames(s) /* Ignore */
#define mallocendnames() /* Ignore */
#endif

/* General stuff I like */

#if (!defined(TRUE) && !defined(FALSE))

#ifdef __GNUC__
typedef enum { FALSE = 0, TRUE = 1 } boolean;
#else
typedef	unsigned int boolean;
#define	FALSE	0
#define	TRUE	1
#endif

#else

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
typedef unsigned int boolean;

#endif


#define LINEBUF 256
#define ERRBUF 512

#define FLOATCHARS "0123456789.-eE+"
#define INTCHARS "0123456789-"
#define UNSIGNEDCHARS "0123456789"
#define SEPARATORS " ,;\r\n\t"
#define WHITESPACE " \r\n\t"

/* make < 0 -1, > 0 1, = 0 0 */

#define REDUCE(X) (((X) < 0) ? -1 : ((X) ? 1 : 0))

#define	BIT(X)	(Uint)(1 << (X))
/* Functions. */

#ifdef lint
extern char *strsave();
#else
#define strsave(s) (strcpy(mymalloc((Uint) (strlen(s) + 1)), (s)))
#endif

#define strequ(X,Y) ((boolean)(strcmp(X,Y) == 0))
#define strnequ(X,Y,N) ((boolean)(strncmp(X, Y, N) == 0))
#define strnotnull(X) (*X != '\0')
#define strnull(X) (*X == '\0');
/* Point to end of string */
#define strend(X) ((X) + strlen(X))

/* Increment counter, looping back to 0 if wrap-over */

#define loop_increment(X,Y) (X = (++X >= (Y)) ? 0 : X)
#define loop_decrement(X,Y) (X = (--X < 0) ? (Y)-1 : X)

/* Some procedures */

#ifdef lint
#ifdef clearerr
#undef clearerr
#endif
DECLARE(void, clearerr, (FILE *));
#endif

#include "config.h"

DECLARE(char *, sstrcat, (char *, char *));
DECLARE(char *, mktemp, (char *));
DECLARE(char *, strclean, (char *));
DECLARE(char *, strsclean, (char *));
DECLARE(char *, strnsave, (char *, int));
DECLARE(int, strempty, (char *));
#ifdef SVR3
DECLARE(void, exit, (int));
DECLARE(void, qsort, (char *, Uint, Uint, int (*)()));
DECLARE(void, free, (char *));
DECLARE(void, perror, (char *));
#endif
#ifdef BSD
DECLARE(int, qsort, (char *, Uint, Uint, int (*)()));
DECLARE(int, free, (char *));
#endif
#ifdef XENIX
DECLARE(int, mkdir, (char *, int));
DECLARE(Ushort, getuid, (void));
DECLARE(Ushort, geteuid, (void));
DECLARE(Ushort, getgid, (void));
DECLARE(Ushort, getegid, (void));
#endif
#ifdef USG
DECLARE(Uint, alarm, (Uint));
DECLARE(Uint, sleep, (Uint));
#endif
#ifdef BSD
DECLARE(int, alarm, (int));
DECLARE(int, sleep, (int));
#endif


#ifdef XENIX
/*
 * declarations to quiet gcc
 * You can pick declarations from here if you want to quiet down
 * gcc for another system than xenix.
 */
DECLARE(int, chdir, ( const char * ));
DECLARE(int, lockf, ( int, int, long ));
DECLARE(int, getpid, (void));
DECLARE(int, link, ( const char *, const char * ));
DECLARE(int, unlink, ( const char * ));
DECLARE(int, access, ( const char *, int ));
DECLARE(int, chmod, ( const char *, int ));
DECLARE(void, strlwr, (char *));
DECLARE(int, open, (const char *, int, ...));
DECLARE(int, close, (int));
DECLARE(void *, mymalloc, (Uint));
DECLARE(int, read, ( int, char *, Uint ));
DECLARE(int, write, ( int, char *, Uint ));
DECLARE(int, fork, (void));
DECLARE(int, wait, ( int * ));
DECLARE(int, kill, ( int, int ));
DECLARE(void, mssleep, (Uint)); 
DECLARE(void *, myrealloc, ( void *, Uint ));
DECLARE(long, nap, (long));
DECLARE(int, fcntl, (int, int, ...));
DECLARE(int, ioctl, (int, int, ...));
DECLARE(int, creat, ( const char *, int ));
DECLARE(long, lseek, (int, long, int));
DECLARE(int, chown, (const char *, int, int));
DECLARE(int, setutent, (void));
DECLARE(int, endutent, (void));
DECLARE(int, execl, (const char *, ...));
DECLARE(int, execlp, (const char *, ...));
DECLARE(int, execvp, (const char *, char **));
DECLARE(int, execv, (const char *, ...));
DECLARE(int, rdchk, (int));
DECLARE(int, pipe, ( int * ));
DECLARE(int, dup, (int));
DECLARE(char *, strstr, (const char *, const char *));
DECLARE(int, exec_command, (char *, ...));
#endif

#ifdef linux
/*
 * declarations to quiet gcc
 * You can pick declarations from here if you want to quiet down
 * gcc for another system than xenix.
 */
/* DECLARE(int, chdir, ( const char * ));
DECLARE(int, lockf, ( int, int, long ));
DECLARE(int, getpid, (void));
DECLARE(int, link, ( const char *, const char * ));
DECLARE(int, unlink, ( const char * ));
DECLARE(int, access, ( const char *, int ));
DECLARE(int, chmod, ( const char *, int )); */
DECLARE(void, strlwr, (char *));
DECLARE(void, strupr, (char *));
/* DECLARE(int, open, (const char *, int, ...));
DECLARE(int, close, (int)); */
DECLARE(void *, mymalloc, (Uint));
/* DECLARE(int, read, ( int, char *, Uint ));
DECLARE(int, write, ( int, char *, Uint ));
DECLARE(int, fork, (void));
DECLARE(int, wait, ( int * ));
DECLARE(int, kill, ( int, int )); */
DECLARE(void, mssleep, (Uint));
DECLARE(void *, myrealloc, ( void *, Uint ));
/* DECLARE(long, nap, (long));
DECLARE(int, fcntl, (int, int, ...));
DECLARE(int, ioctl, (int, int, ...));
DECLARE(int, creat, ( const char *, int ));
DECLARE(long, lseek, (int, long, int));
DECLARE(int, chown, (const char *, int, int));
DECLARE(int, setutent, (void));
DECLARE(int, endutent, (void));
DECLARE(int, execl, (const char *, ...));
DECLARE(int, execlp, (const char *, ...));
DECLARE(int, execvp, (const char *, char **));
DECLARE(int, execv, (const char *, ...));
DECLARE(int, rdchk, (int));
DECLARE(int, pipe, ( int * ));
DECLARE(int, dup, (int));
DECLARE(char *, strstr, (const char *, const char *)); */
DECLARE(int, exec_command, (char *, ...));
#endif

/* Defines which are not in std headers (why!?) */

extern int optind, opterr;

/* Global variables. */

extern int verbose;
extern boolean receiving_data;
extern FILE *errorfp;
extern char version[];
extern int version_major, version_minor;
extern boolean hasconfig;

/* Function declarations. */

DECLARE(char *, bfind, (char *, char *, Uint, Uint, int (*)(void *, void *)) );
DECLARE(char *, baseit, (long));
DECLARE(void, name_to_fidonet_format, (char *));
DECLARE(char *, expand_char, (int));
DECLARE(char *, asciify, (char *, int)); /* Remove ibm 'ascii' */
DECLARE(char *, stripbad_name, (char *)); /* []{} etc are bad in addresses */
DECLARE(char *, strip_newline, (char *)); /* Remove possible newline. */     
DECLARE(int, stricmp, (char *, char *));
DECLARE(int, strnicmp, (char *, char *, int));
DECLARE(char *, clean_filename, (char *));
DECLARE(void, log, (char *, ...));
DECLARE(void, buglog, (char *, ...));
DECLARE(void, msglog, (char *, ...));
DECLARE(void, fatal, (int, char *, ...));
DECLARE(void, debug, (int, char *, ...));
DECLARE(void, sendadmin, (char *, char *, ...));
DECLARE(void, check_ioctl, (int, int, char *));
DECLARE(char *, sprintfs, (char *, ...));
DECLARE(char *, sstrdup, (char *));
DECLARE(char *, spoolfile, (char *));
DECLARE(SIG_FTYPE, quit, (int));
DECLARE(char *, basename, (char *));
DECLARE(char *, basepath, (char *));
DECLARE(char *, spoolname, (char *));
DECLARE(FILE *, pfopen, (char *, char *, char *));
DECLARE(char *, date, (char *, long *));
DECLARE(long, sequencer, (char *));
DECLARE(char *, mheader, (FILE *, char *));
DECLARE(int, write_file, (char *, char *, int));
DECLARE(void, wait_input_to_drain, (int));
#ifndef HAVE_RENAME
DECLARE(int, rename, (char *, char *));
#endif
DECLARE(int, read_header, (FILE *));     
DECLARE(void, check_unlink, (char *));
#ifdef USG
/* System V.3 seems to declare sprintf in stdio.h. Gcc complains if prototype
   is given later? */
/* DECLARE(int, sprintf, (char *, char *, ...)); */
#endif /* USG */
#ifdef BSD
DECLARE(char *, sprintf, (char *, char *, ...));
#endif /* BSD */

DECLARE(int, myopendir, (char *, int));
DECLARE(void, myclosedir, (void));
DECLARE(char *, myreaddir, (char *));
DECLARE(void, get_configuration, (int *, char **, char *));
DECLARE(void, configprintusage, (FILE *));
DECLARE(int, mymkdir, (char *));
DECLARE(void, mychdir, (char *));
DECLARE(void, nstrcpy, (char *, char *));
DECLARE(void, savefile, (char *));
DECLARE(int, baud_to_bsdbaud, (int));
DECLARE(void, remove_reqs, (void));
DECLARE(boolean, createlock, (char *, time_t));
DECLARE(char *, lockname, (char *));
DECLARE(boolean, checklock, (char *));
DECLARE(time_t, parsedate, (char *, struct timeb *));
DECLARE(int, do_script, (char *));
DECLARE(int, yoohoo_receiver, (void));
DECLARE(int, myrename, (char *, char *));
DECLARE(void, savebad, (char *));
DECLARE(void, removelock, (char *));
DECLARE(int, build_header, (Uchar *));
DECLARE(void, silent_remove_superlock, (void));
DECLARE(boolean, makepath, (char *));
DECLARE(FILE *, myfopen, (char *, char *));
DECLARE(void, myfseek, (FILE *, long, int));
DECLARE(void, unique_name, (char *));
DECLARE(boolean, is_arcmail, (char *));
DECLARE(boolean, is_mailpkt, (char *));
DECLARE(boolean, is_req, (char *));
DECLARE(boolean, is_out, (char *));
DECLARE(int, is_failed, (char *));
DECLARE(char *, basetype, (char *));
DECLARE(boolean, match, (char *, char *));
DECLARE(int, struequ, (char *, char *));
DECLARE(void, stripbad, (char *));
DECLARE(long, dateconv, (int, int, int, int, int, int, int, int, int));
DECLARE(char *, syserr, (int));
DECLARE(void, strncopy, (char *, char *, int));
DECLARE(void, get_ownerdata, (void));
DECLARE(int, lock, (int));
#ifndef GETHOSTNAME
DECLARE(int, gethostname, (char *, int));
#endif
DECLARE(void, fixversion, (char *));

DECLARE(boolean, write_string, (FILE *, char *));
DECLARE(boolean, read_string, (FILE *, char *, int));
DECLARE(boolean, read_char, (FILE *, Uchar *));
DECLARE(boolean, read_int16, (FILE *, Ushort *));
DECLARE(boolean, read_long, (FILE *, Ulong *));
DECLARE(boolean, read_int24, (FILE *, Ulong *));
DECLARE(boolean, write_char, (FILE *, Uint));
DECLARE(boolean, write_int16, (FILE *, Uint));
DECLARE(boolean, write_long, (FILE *, Ulong));
DECLARE(boolean, write_int24, (FILE *, Ulong));


/* Memory allocation related defines. */

#ifdef lint
extern char *strsave();
#else
#define strsave(s) (strcpy(mymalloc((Uint) (strlen(s) + 1)), (s)))
#endif

DECLARE(int, mywait, (int));
DECLARE(int, bsdbaud_to_baud, (int));

#ifndef linux
DECLARE(int, getopt, (int, char **, const char *));
#endif
char *optarg;

