/*
 * $Header: /u1/src/rfmail/RCS/fio.c,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: fio.c,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.3  1991/06/15  09:33:39  pgd
 * *** empty log message ***
 *
 * Revision 0.4.1.2  1991/06/05  09:13:58  pgd
 * Various Bugfixes:
 *
 * Patches suggested by Marc Boucher (marc):
 * A #endif was misplaced (relative to a close bracket } )
 * Added call to flush() before hangup
 *
 * Revision 0.4.1.1  1991/05/21  11:13:48  pgd
 * *** empty log message ***
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 *
 */

/* Routines for io for fidonet software.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/*
 * Authors:
 *
 * Teemu Torma who wrote the original code (?)
 *
 * Heikki Suonsivu (hsu@hutcs.hut.fi) who made a lot of enhancements
 * 
 * Per Lindqvist (pgd@compuram.bbt.se) who continued to enhance rfmail.
 */

#include "fnet.h"

#include <sys/param.h>

#ifdef FCNTL
#include <fcntl.h>
#endif

#ifdef HAVE_SELECT
#ifdef XENIX
#include <sys/select.h>
#endif
#endif

#include "fcall.h"

/* number of characters in input buffer */
int nchars = 0;

char devname[40];

#ifdef DEBUG
/* This is for protocol debugging logs */
#define DEBUG_STATE_READ 1
#define DEBUG_STATE_WRITE 2
#endif

TTYSTATE current_terminal_state;

LDECLARE(void, set_terminal_timeout, (int, int));

static char *ctable[256] = {
  "[NUL]", /* 000 nul */
  "[SOH]", /* 001 soh */
  "[STX]", /* 002 stx */
  "[ETX]", /* 003 etx */
  "[EOT]", /* 004 eot */
  "[ENQ]", /* 005 enq */
  "[ACK]", /* 006 ack */
  "[BEL]", /* 007 bel */
  "[BS]", /* 010 bs  */
  "[HT]", /* 011 ht  */
  "[NL]", /* 012 nl  */
  "[VT]", /* 013 vt  */
  "[NP]", /* 014 np  */
  "[CR]", /* 015 cr  */
  "[SO]", /* 016 so  */
  "[SI]", /* 017 si  */
  "[DLE]", /* 020 dle */
  "[DC1]", /* 021 dc1 */
  "[DC2]", /* 022 dc2 */
  "[DC3]", /* 023 dc3 */
  "[DC4]", /* 024 dc4 */
  "[NAK]", /* 025 nak */
  "[SYN]", /* 026 syn */
  "[ETB]", /* 027 etb */
  "[CAN]", /* 030 can */
  "[EM]", /* 031 em  */
  "[SUB]", /* 032 sub */
  "[ESC]", /* 033 esc */
  "[FS]", /* 034 fs  */
  "[GS]", /* 035 gs  */
  "[RS]", /* 036 rs  */
  "[US]", /* 037 us  */
  " ", /* 040 sp  */
  "!", /* 041  !  */
  "\"", /* 042  "  */
  "#", /* 043  #  */
  "$", /* 044  $  */
  "%", /* 045  %  */
  "&", /* 046  &  */
  "'", /* 047  '  */
  "(", /* 050  (  */
  ")", /* 051  )  */
  "*", /* 052  *  */
  "+", /* 053  +  */
  ",", /* 054  ,  */
  "-", /* 055  -  */
  ".", /* 056  .  */
  "/", /* 057  /  */
  "0", /* 060  0  */
  "1", /* 061  1  */
  "2", /* 062  2  */
  "3", /* 063  3  */
  "4", /* 064  4  */
  "5", /* 065  5  */
  "6", /* 066  6  */
  "7", /* 067  7  */
  "8", /* 070  8  */
  "9", /* 071  9  */
  ":", /* 072  :  */
  ";", /* 073  ;  */
  "<", /* 074  <  */
  "=", /* 075  =  */
  ">", /* 076  >  */
  "?", /* 077  ?  */
  "@", /* 100  @  */
  "A", /* 101  A  */
  "B", /* 102  B  */
  "C", /* 103  C  */
  "D", /* 104  D  */
  "E", /* 105  E  */
  "F", /* 106  F  */
  "G", /* 107  G  */
  "H", /* 110  H  */
  "I", /* 111  I  */
  "J", /* 112  J  */
  "K", /* 113  K  */
  "L", /* 114  L  */
  "M", /* 115  M  */
  "N", /* 116  N  */
  "O", /* 117  O  */
  "P", /* 120  P  */
  "Q", /* 121  Q  */
  "R", /* 122  R  */
  "S", /* 123  S  */
  "T", /* 124  T  */
  "U", /* 125  U  */
  "V", /* 126  V  */
  "W", /* 127  W  */
  "X", /* 130  X  */
  "Y", /* 131  Y  */
  "Z", /* 132  Z  */
  "[", /* 133  [  */
  "\\", /* 134  \  */
  "]", /* 135  ]  */
  "^", /* 136  ^  */
  "_", /* 137  _  */
  "`", /* 140  `  */
  "a", /* 141  a  */
  "b", /* 142  b  */
  "c", /* 143  c  */
  "d", /* 144  d  */
  "e", /* 145  e  */
  "f", /* 146  f  */
  "g", /* 147  g  */
  "h", /* 150  h  */
  "i", /* 151  i  */
  "j", /* 152  j  */
  "k", /* 153  k  */
  "l", /* 154  l  */
  "m", /* 155  m  */
  "n", /* 156  n  */
  "o", /* 157  o  */
  "p", /* 160  p  */
  "q", /* 161  q  */
  "r", /* 162  r  */
  "s", /* 163  s  */
  "t", /* 164  t  */
  "u", /* 165  u  */
  "v", /* 166  v  */
  "w", /* 167  w  */
  "x", /* 170  x  */
  "y", /* 171  y  */
  "z", /* 172  z  */
  "{", /* 173  {  */
  "|", /* 174  |  */
  "}", /* 175  }  */
  "~", /* 176  ~  */
  "[DEL]",  /* 177 del   Translated to ^? */
  "[80]", /* 80 nul */
  "[81]", /* 81 soh */
  "[82]", /* 82 stx */
  "[83]", /* 83 etx */
  "[84]", /* 84 eot  scandinavian a with dots */
  "[85]", /* 85 enq */
  "[86]", /* 86 ack  scandinavian a with dot */
  "[87]", /* 87 bel */
  "[88]", /* 88 bs  */
  "[89]", /* 89 ht  */
  "[8a]", /* 8a nl  */
  "[8b]", /* 8b vt  */
  "[8c]", /* 8c np  */
  "[8d]", /* 8d cr  */
  "[8e]", /* 8e so   scandinavian A with dots */
  "[8f]", /* 8f si   scandinavian A with dot */
  "[90]", /* 90 dle */
  "[91]", /* 91 dc1  scandinavian a with dots */
  "[92]", /* 92 dc2 */
  "[93]", /* 93 dc3 */
  "[94]", /* 94 dc4  scandinavian o with dots */
  "[95]", /* 95 nak */
  "[96]", /* 96 syn */
  "[97]", /* 97 etb */
  "[98]", /* 98 can */
  "[99]", /* 99 em   scandinavian O with dots */
  "[9a]", /* 9a sub */
  "[9b]", /* 9b esc */
  "[9c]", /* 9c fs   pound */
  "[9d]", /* 9d gs  */
  "[9e]", /* 9e rs  */
  "[9f]", /* 9f us  */
  "[a0]", /* a0 sp  */
  "[a1]", /* a1  !  */
  "[a2]", /* a2  "  */
  "[a3]", /* a3  #  */
  "[a4]", /* a4  $  */
  "[a5]", /* a5  %  */
  "[a6]", /* a6  &  */
  "[a7]", /* a7  '  */
  "[a8]", /* a8  (  */
  "[a9]", /* a9  )  */
  "[aa]", /* aa  *  */
  "[ab]", /* ab  +  */
  "[ac]", /* ac  ,  */
  "[ad]", /* ad  -  */
  "[ae]", /* ae  .  */
  "[af]", /* af  /  */
  "[b0]", /* b0  0   Colouring chars from light to ... */
  "[b1]", /* b1  1  */
  "[b2]", /* b2  2   ... dark */
  "[b3]", /* b3  3  */
  "[b4]", /* b4  4  */
  "[b5]", /* b5  5  */
  "[b6]", /* b6  6  */
  "[b7]", /* b7  7  */
  "[b8]", /* b8  8  */
  "[b9]", /* b9  9  */
  "[ba]", /* ba  :  */
  "[bb]", /* bb  ;  */
  "[bc]", /* bc  <  */
  "[bd]", /* bd  =  */
  "[be]", /* be  >  */
  "[bf]", /* bf  ?  */
  "[c0]", /* c0  @  */
  "[c1]", /* c1  A  */
  "[c2]", /* c2  B  */
  "[c3]", /* c3  C  */
  "[c4]", /* c4  D  */
  "[c5]", /* c5  E  */
  "[c6]", /* c6  F  */
  "[c7]", /* c7  G  */
  "[c8]", /* c8  H  */
  "[c9]", /* c9  I  */
  "[ca]", /* ca  J  */
  "[cb]", /* cb  K  */
  "[cc]", /* cc  L  */
  "[cd]", /* cd  M  */
  "[ce]", /* ce  N  */
  "[cf]", /* cf  O  */
  "[d0]", /* d0  P  */
  "[d1]", /* d1  Q  */
  "[d2]", /* d2  R  */
  "[d3]", /* d3  S  */
  "[d4]", /* d4  T  */
  "[d5]", /* d5  U  */
  "[d6]", /* d6  V  */
  "[d7]", /* d7  W  */
  "[d8]", /* d8  X  */
  "[d9]", /* d9  Y  */
  "[da]", /* da  Z  */
  "[db]", /* db  [  */
  "[dc]", /* dc  \  */
  "[dd]", /* dd  ]  */
  "[de]", /* de  ^  */
  "[df]", /* df  _  */
  "[e0]", /* e0  `  */
  "[e1]", /* e1  a  */
  "[e2]", /* e2  b  */
  "[e3]", /* e3  c  */
  "[e4]", /* e4  d  */
  "[e5]", /* e5  e  */
  "[e6]", /* e6  f  */
  "[e7]", /* e7  g  */
  "[e8]", /* e8  h  */
  "[e9]", /* e9  i  */
  "[ea]", /* ea  j  */
  "[eb]", /* eb  k  */
  "[ec]", /* ec  l  */
  "[ed]", /* ed  m  */
  "[ee]", /* ee  n  */
  "[ef]", /* ef  o  */
  "[f0]", /* f0  p  */
  "[f1]", /* f1  q  */
  "[f2]", /* f2  r  */
  "[f3]", /* f3  s  */
  "[f4]", /* f4  t  */
  "[f5]", /* f5  u  */
  "[f6]", /* f6  v  */
  "[f7]", /* f7  w  */
  "[f8]", /* f8  x  */
  "[f9]", /* f9  y  */
  "[fa]", /* fa  z  */
  "[fb]", /* fb  {  */
  "[fc]", /* fc  |  */
  "[fd]", /* fd  }  */
  "[fe]", /* fe  ~  */
  "[ff]"  /* ff del */
};

/* Read one character from line. We will do buffering up to BUFBIZ
   characters. TIMEOUT will be returned it readline timeouts */

static Uchar buffer[INPUT_BUFFER_SIZE];
static int pos = 1;
static Uchar txbuffer[BUFSIZ];
static int txchc;
boolean carrier;

/*
 * Read a byte from the serial line.
 * Supply the number of milliseconds to wait
 * if no character is there.
 * Time = 0 means no wait.
 */
int
readline(timeout)
	int timeout;
{
	int c;
  
 redo:
	if (pos <= nchars)
		/* there are characters in buffer */
		c = buffer[pos++];
	else {
#ifdef TERMIO
		if (timeout < 0)
			timeout = 0;
		set_terminal_timeout(line, timeout/100);
		nchars = read(line, (char *)buffer+1, sizeof(buffer)-1);
		if (nchars < 0) {
			if (errno == EINTR)
				goto redo;
			log("$Line read error");
		}
#else
#ifdef HAVE_SELECT
		/*
		 * Wait using the select system call
		 */
		fd_set readfds;
		struct timeval tmo;

		FD_ZERO((char *)&readfds);
		FD_SET(line, &readfds);
		tmo.tv_sec = timeout/1000;
		tmo.tv_usec = (timeout % 1000) * 1000;
		nchars = select(line+1, &readfds, NULL, NULL, &tmo);
		if (nchars > 0)
			nchars = read(line, (char *) buffer + 1, sizeof(buffer)-1);
		
		/* If error is something else than EINTR, report it */
		if (nchars == -1) {
			if (errno == EINTR)
				goto redo;
			log("$Read error");
		}
#else
		/*
		 * We cannot timeout on read, and we
		 * don't have select. Must be some very old
		 * unix version.
		 * We could use itimer, at this point, but since
		 * I don't have that one, I cannot debug such code.
		 * For delays > 1s we otherwise could use alarm.
		 */
		for (;;) {
			nchars = read(line, (char *) buffer + 1, sizeof(buffer)-1);
#ifdef USG
			if (nchars == 0) {
				if (timeout == 0 || Timeout(timeout/1000 + 1))
					break;
				mssleep(100); 	/* 1/10th of a second. */
			} else {
				if (nchars < 0)
					log("$Line read error");
				break;
			}
#endif /* USG */
#ifdef BSD	  
			if (nchars <= 0 && errno == EWOULDBLOCK && timeout) {
				if (timeout == 0 || Timeout(timeout/1000 + 1))
					break;
				mssleep(100);	/* 1/10th of a second. */
			} else {
				if (nchars < 0)
					log("$Line read error");
				break;
			}
#endif /* BSD */
#endif /* HAVE_SELECT */
#endif	/* TERMIO */
      
		/*
		 * if we got characters return the first of them,
		 * otherwise return TIMEOUT
		 */
		if (nchars <= 0)
			c = TIMEOUT;
/*		else if (nchars == 0)
			c = EOF; */
		else {
			c = buffer[pos = 1];
			pos++;
		}
	}
  
	/*
	 * read data logging
	 */
	if (!receiving_data) {
		if (verbose > 8) {
			if (c >= 0 && c < 256)
				debug(8, "<%s", ctable[c]);
			else if (c == TIMEOUT)
				debug(8, "< [Timeout]");
			else if (c == EOF)
				debug(8, "< [EOF]");
			else
				debug(8, "< <Bug, c=%d>", c);
		}
	}
	
	return c;
}

/*
 * Put back a character.
 * Only one char of putback is guaranteed.
 */
int
putback(c)
	int c;
{
	buffer[--pos] = c;
	return c;
}


/*
 * Emulation of missing rdchk() function call.
 */
#ifndef HAVE_RDCHK
int
rdchk(fd)
	int fd;
{
#ifdef FIONREAD
	int iocount;

	return (ioctl(fd, FIONREAD, &iocount) < 0 || iocount <= 0) ? 0 : 1;
}
#else

#ifdef HAVE_SELECT
	fd_set readfds;
	struct timeval tmo;

	FD_ZERO((char *)&readfds);
	FD_SET(fd, &readfds);
	tmo.tv_sec = 0;		/* Setting times to zero makes the */
	tmo.tv_usec = 0;	/* select just poll the file descriptor */
	return select(fd+1, &readfds, NULL, NULL, &tmo) > 0;
#else

/*
 * Emulation of missing rdchk() with readline function call.
 * This assumes that fd == line
 */
	int c;

	c = readline(0);
	if (c < 0)
		return 0;
	putback(c);
	return 1;
#endif /* HAVE_SELECT */
}
#endif /* FIONREAD */

#endif /* HAVE_RDCHK */


/*
 * Check for character available
 */
int
readcheck()
{
	if (pos <= nchars)
		return 1;
	return rdchk(line);
}

/* Flush line. Both terminal buffers and input buffer of readline will
   be flushed */
void
flush()
{
#ifdef USG
	check_ioctl(line, TCFLSH, NULL);
#endif
#ifdef BSD
	check_ioctl(line, TIOCFLUSH, NULL);
#endif
	nchars = 0;
}

/*
 * Eat noice on incoming line
 */
void
eatnoice()
{
	do {
/*		flush() */;
	} while (readline(1000) != TIMEOUT);
}

/* 
 * Hang up line 
 * The trick here is to lower DTR, wait a while, and raise it again.
 * 
 * Much of this code is taken from KERMIT, but this is a 
 * simplification that you cannot expect to work on 
 * HPUX, AIX, AEGIS and ATT7300
 * If you want it to work on those machines also, check out
 * the code in kermit, and add some with conditional compilation.
 */
#define	HUPTIME	500		/* Milliseconds for hangup */

void
hangup(fd)
	int fd;
{
	TTYSTATE tio;
	int flags;
#ifdef TERMIO
	int savespeed;
	int z;
#else
	int ispeed, ospeed;
#endif

#ifdef TIOCSDTR
	/*
	 * Code for BSD, if we have TIOCSDTR
	 */
	if (ioctl(fd, TIOCCDTR, 0) < 0) { /* Clear DTR */
		log(1, "$tthang: Drop DTR with TIOCCCDTR failed");
	}
	mssleep(HUPTIME);
	if (ioctl(fd, TIOCSDTR, 0) == -1) /* Raise DTR */
		log(1, "$hangup: Raise DTR with TIOCCCDTR failed");
#else	/* TIOCSDTR */
#if defined(TIOCMBIS) && defined(TIOCMBIC) && defined(TIOCM_DTR)
	/*
	 * This code for some SVR3 systems. 
	 */
	z = TIOCM_DTR;		/* Code for DTR and RTS*/
#ifdef TIOCM_RTS
	z |= TIOCM_RTS;
#endif
	if (ioctl(fd, TIOCMBIC, &z) != -1) { /* Lower DTR */
		mssleep(HUPTIME); /* Leave it down for half a second */
		if (ioctl(fd, TIOCMBIS, &z) != -1)
			return;
	}
	log("$hangup: TIOCMBIC/TIOCMBIS failed");
#endif /* SVR3 */

	/*
	 * Generic unix case. Set speed to zero, and restore it again.
	 */
  
	get_terminal_state(fd, &tio);
#ifdef TERMIO
	flags = fcntl(fd, F_GETFL, 0);
	if ((flags & O_NDELAY) == 0)
		fcntl(fd, F_SETFL, flags | O_NDELAY);
	savespeed = tio.c_cflag;
	tio.c_cflag = B0 | HUPCL|CLOCAL; /* Lower DTR */
#ifdef TCXONC
	check_ioctl(fd, TCXONC, (char *)1);
#endif
#ifdef TIOCSTART
	check_ioctl(fd, TIOCSTART, 0);
#endif
	(void)set_terminal_state(fd, &tio);
#else /* TERMIO */
	ispeed = tio.sg_ispeed;
	ospeed = tio.sg_ospeed;
	tio.sg_ispeed = B0;	/* Lower DTR */
	tio.sg_ospeed = B0;
	(void)set_terminal_state(fd, &tio);
#endif
	mssleep(HUPTIME);	/* Sleep for 500ms */

	/*
	 * close(open()) magic
	 */
/*	close(open(.......)); */

	/*
	 * Restore the speed
	 */
#ifdef TERMIO
	tio.c_cflag = savespeed;
	fcntl(fd, F_SETFL, flags); /* Restore flags */
	(void)set_terminal_state(fd, &tio);
#else
	tio.sg_ispeed = ispeed;
	tio.sg_ospeed = ospeed;
	(void)set_terminal_state(fd, &tio);
#endif
#endif
}


/* 
 * Send character c to line. This also clears readline's input buffer
 * but not terminal buffers because it might take too much time.
 *  Tue Nov  8 13:49:27 1988
 *  No more clearing buffer, as I try to make it sealink compatible.
 */
void
sendline(c)
	register int c;
{
	Uchar cc = c;
	register int tries = 0;
	int bc;
  
	if (txchc)
		drainline(0);
	if (verbose >= 20)
		debug(20, ">%s", ctable[cc]);

	while ((bc = write(line, (char *) &cc, 1)) != 1) {
if (bc == 0)
	debug(1, "sendline returned 0!");
#ifdef EWOULDBLOCK
		/* Maybe... */
		if (errno == EWOULDBLOCK) {
			/* Sleep a bit, retry it, buffers full? */
			mssleep(10); /* 10 milliseconds. */
			continue;
		}
#endif /* EWOULDBLOCK */
		if (bc == 0 && (!carrier || tries++) > MAX_WRITE_ERROR_TRIES) {
			carrier = FALSE;
			break;
		} else if (bc == -1) {
			log("$Modem line write error");
			carrier = FALSE;
			break;
		} 
	}
  
	/* We should flush input after this. Not correctly doing this now. 
	   It would be better for user application to call flush() instead,
	   when it is really needed. */
	/* if (!sealink) nchars = 0; */
}

/*
 * Buffer a character to the output buffer
 */
void
xsendline(c)
	int c;
{
	if (txchc == sizeof(txbuffer)) {
		senddata((char *)txbuffer, txchc);
		txchc = 0;
	}
	txbuffer[txchc++] = c;
	
	if (verbose >= 20) {
		if (c <= 255)
			debug(20, ">%s", ctable[c]);
		else
			debug(20, "> <Bug, c=%u>", c);
	}
}

/*
 * Drain all output buffers
 */
void
drainline(flag)
	int flag;
{
	register int i;
	int count;

	if (txchc) {
		if (verbose < 20) {
			senddata((char *)txbuffer, txchc);
			txchc = 0;
		} else {
			count = txchc;
			txchc = 0;
			for (i = 0; i < count; i++)
				sendline(txbuffer[i]);
		}
	}
	if (flag) {
#ifdef USG
		check_ioctl(line, TCSBRK, (char *)1);
#endif
#ifdef BSD
		??? How to drain output buffers on BSD ???
#endif
	}
}

/*
 * Flush all buffered characters for output, and
 * the output queue
 */
void
flushline()
{
	txchc = 0;
#ifdef USG
	check_ioctl(line, TCFLSH, (char *)1);
#endif
#ifdef BSD
	???? How to flush the output queue on BSD? ?????
	check_ioctl(line, TIOCFLUSH, (char *) 0);
#endif
}

/*
 * Send break 
 */
void
sendbrk()
{
#ifdef USG
	check_ioctl(line, TCSBRK, 0);
#endif
#ifdef BSD
	???? How to send break on BSD ????
#endif
}


/* This should really be a write. Same problem everywhere, fio uses unbuffered
   output. */
void
sendstring(s)
     char *s;
{
	register char *p;

	for (p = s; *p; p++)
		xsendline(*p);
	drainline(0);
}

void
senddata(buf, bc)
	register char *buf;
	register Uint bc;
{
	int bytes_sent = 0;
	int tries = 0;
	int cnt;

	while (bc > 0) {
		cnt = write(line, buf + bytes_sent, bc);
		if (cnt > 0) {
			tries = 0;
			bc -= cnt;
			bytes_sent += cnt;
		} else {
#ifdef EWOULDBLOCK
			if (cnt == -1 && errno == EWOULDBLOCK)
				cnt = 0;
#endif
			if (cnt == -1) {
				/*
				 * Error condition
				 */
				cnt = 0; /* Nothing went through */
				if (tries == 0)
					log("$Modem line write error");
			}
			if (tries++ > MAX_WRITE_ERROR_TRIES)
				break;
			/* Sleep a bit, retry it, buffers full? */
			mssleep(10); 	/* 10 milliseconds. */
		}
	}
}

/* Tty ioctls handled through these routines for compatibility reasons. */

/* Get terminal line state */
boolean
get_terminal_state(fd, ttystatep)
	int fd;
	TTYSTATE *ttystatep;
{
	debug(7, "Getting terminal state");
#ifdef TERMIO
	if (ioctl(fd, TCGETA, (char *) ttystatep) < 0) {
		log("$Cannot get tty state");
		return FALSE;
	}
#else
	if (ioctl(fd, TIOCGETP, (char *) ttystatep) < 0) {
		log("$Cannot get tty state");
		return FALSE;
	}
#endif

	return TRUE;
}

/* Set terminal line state */
boolean
set_terminal_state(fd, ttystatep)
	int fd;
	TTYSTATE *ttystatep;
{
	debug(7, "Setting terminal state");
#ifdef TERMIO
	if (ioctl(fd, TCSETA, (char *) ttystatep) < 0) {
		log("$Cannot set tty state");
		return FALSE;
	}
	if (&current_terminal_state != ttystatep)
		current_terminal_state = *ttystatep;
#else
	if (ioctl(fd, TIOCSETP, (char *) ttystatep) < 0) {
		log("$Cannot set tty state");
		return FALSE;
	}
#endif

#ifdef BSD
	/* Kludge: No option for setting non-bloking mode with ioctl
	   (or I don't know about it? Puff. */
	if (ttystatep->sg_flags == RAW) {
		int status;
      
		if ((status = fcntl(fd, F_GETFL, 0)) < 0) {
			log("$Cannot get tty modes, fcntl failed");
			return -1;
		}
		if (fcntl(fd, F_SETFL, status | FNDELAY) < 0) {
			log("$Cannot set tty modes, fcntl failed");
			return -1;
		}
	}
#endif /* BSD */
	return TRUE;
}




#ifdef TERMIO
static void
set_terminal_timeout(fd, dlytime)
	int fd, dlytime;
{
	if (current_terminal_state.c_cc[VTIME] != dlytime) {
		current_terminal_state.c_cc[VTIME] = dlytime;
		current_terminal_state.c_cc[VMIN] = 0;
		if (ioctl(fd, TCSETA, (char *) &current_terminal_state) < 0)
			log("$Cannot set tty state");
	}
}
#endif
	

void
xon_disable()
{
#ifdef TERMIO
	current_terminal_state.c_iflag &= ~(IXON|IXOFF);
	set_terminal_state(line, &current_terminal_state);
#else
	????? To be written by someone who knows bsd
#endif
}

void
xon_enable()
{
#ifdef TERMIO
	current_terminal_state.c_iflag |= IXON|IXOFF;
	current_terminal_state.c_iflag &= ~IXANY;
	set_terminal_state(line, &current_terminal_state);
#else
	????? To be written by someone who knows bsd
#endif
}

/*
 * restart output suspended by XOFF from remote
 */
void
xon_flush()
{
#ifdef USG
	check_ioctl(line, TCXONC, (char *)1);
#endif
#ifdef BSD
		?????
#endif
}

#if 0
/*
 * Open communication serial device
 * Return file descriptor, or -1 if error.
 */
int
opendev(device)
	char *device;
{
	int fd, fd1, flags;
	TTYSTATE ttsb;

	debug(1, "opendev(%s)", device);
	*devname = 0;
	/*
	 * Open device. We have to specify the O_NDELAY
	 * parameter, since we have no carrier, and
	 * still have to talk with the modem.
	 */
	fd = open(device, O_RDWR | O_NDELAY);
	if (fd < 0)
		return -1;
	
	get_terminal_state(fd, &ttsb);
#ifdef TERMIO
	ttsb.c_cflag = ttsb.c_cflag & ~(CBAUD|HUPCL|baud_to_bsdbaud(speed))
		                    | (CLOCAL|CTSFLOW|RTSFLOW);
	ttsb.c_lflag &= ~ECHO;
	ttsb.c_cc[VMIN] = 1;
	ttsb.c_cc[VTIME] = 0;
#else
	ttsb.sg_ospeed = ttsb.sg_ispeed = baud_to_bsdbaud(speed);
#endif

	/*
	 * Now, we have to reopen the line
	 * to get rid of O_NDELAY
	 */
	fd1 = open(device, O_RDWR);
	if (fd1 == -1)
		fatal("$opendev: Reopen of device %s failed", device);
	close(fd);
	strncopy(devname, device, sizeof(devname)-1);
	return fd1;
}
#endif
		

/*
 * Sleep a number of milliseconds
 */
void
mssleep(msec)
	register Uint msec;
{
#ifdef HAVE_NAP
	nap(msec);
#else
#ifdef HAVE_USLEEP
	usleep(msec * 1000);
#else
#ifdef SELECT
	{
		struct timeval tv;	/* For getting time, from sys/time.h */
		struct timezone tz;
		int t1;

		gettimeofday(&tv, &tz);
		t1 = tv.tv_sec;
		tv.tv_sec = 0;
		tv.tv_usec = msec * 1000L;
		select(0, 0, 0, 0, &tv);
	}
#else
	/*
	 * Simulate with sleep.
	 * We have to sleep at least one second.
	 */
	if (msec < 1000)
		msec = 1000;
	sleep(msec / 1000);
#endif /* SELECT */
#endif /* HAVE_USLEEP */
#endif /* HAVE_NAP */
}

/*
 * Return current time in milliseconds
 */
long
mtime()
{
	long t;

#ifdef HAVE_TIMES
	struct tms *tp;
	static long firsttime = 0;

	t = times(&tp);
	if (firsttime == 0)
		firsttime = t;
	return (t - firsttime) * 1000 / HZ;
#else
#ifdef HAVE_GETTIMEOFDAY
	struct timeval tv;
	struct timezone tz;
	static long firstsec;
	static int firstusec;

	gettimeofday(&tv, &tz);
	if (firsttime == 0) {
		firstsec = tv.tv_sec;
		firstusec = tv.tv_usec;
	}
	t = (tv.tv_sec - firstsec) * 1000 + (tv.tv_usec - firstusec) / 1000;
#else
	static long firsttime;

	t = time(NULL);
	if (firsttime == 0)
		firsttime = t;
	t = (t - firsttime) * 1000;
#endif /* HAVE_GETTIMEOFDAY */
#endif /* HAVE_TIMES */
	return t;
}

