/*
 * Include file for fcall
 */

#ifdef TERMIO
#include <termio.h>
#define	TTYSTATE	struct termio
#else
#include <sgtty.h>
#define	TTYSTATE	struct sgttyb
#endif

#define True TRUE
#define False FALSE
#define BUFLEN 256
#define OK (0)
#define ERROR (-1)
#define	FAILED	(1)
#define	REJECTED (2)
#define	FINISH (3)


/* Number of bytes for empty packet file containing no messages. */
#define EMPTY_PACKET_SIZE 60L

typedef struct {
	boolean dopickup;
	boolean allowpickup;
	boolean reverse_handshake;
	boolean file_requests;	/* Allow inbound file requests */
} fidonet_options_t;

/* Telink/xmodem special characters. */

#define SOH (0x01) /* first character of xmodem block */
#define STX (0x02) /* send 1 k blocks */
#define EOT (0x04) /* end of stransmission */
#define ENQ (0x05) /* Request init. 'nothing to pickup' */
#define ACK (0x06) /* ok to send */
#define	LF  (0x0a)
#define	CR  (0x0d)
#define NAK (0x15) /* fail, resend */
#define SYN (0x16) /* first character of telink block */
#define CAN (0x18)
#define SUB (0x1a) /* end of filename in MODEM7 */
#define CTRLZ (0x1a) /* char to fill partial packet */
#define ESC (0x1b) /* Spawn a login when Waiting TSYNCH */

/* Definitions for xmodem. */

#define BlockSize (128) /* small xmodem sector size */
#define KBlockSize (1024) /* one k-byte xmodem sector size */

/* Misc. definitions. */

#define TSYNCH (0xae) /* sync character for fido */
#define TIMEOUT (-2) /* timeout on readline() */
#define YOOHOO (0xf1)

/* Output retry count. This should be something like 10 at maximum.
   EWOULDBLOCK is checked out separately. */

#define MAX_WRITE_ERROR_TRIES 10

/*
 * Dial return codes
 */
#define INTRPT (-1)		/* interrupt occurred */
#define D_HUNG (-2)		/* dialer hung */
#define NO_ANS (-3)		/* no answer */
#define ILL_BD (-4)		/* ilegal baud-rate */
#define A_PROB (-5)		/* acu problem */
#define L_PROB (-6)		/* line problem */
#define NO_Ldv (-7)		/* can't open Devices file */
#define DV_NT_A (-8)		/* requested device not available */
#define DV_NT_K (-9)		/* requested device not known */
#define NO_BD_A (-10)		/* no device available at requested baud */
#define NO_BD_K (-11)		/* no device known at requested baud */
#define DV_NT_E (-12)		/* requested speed does not match */
#define DIAL_INTERNAL_ERROR (-13)
#define	NO_OCC	(-14)		/* Number is occupied */
#define	DIAL_BAD_SPEED -15		/* Bad speed on called system */
#define	DIAL_NO_CARRIER -16		/* No carrier on called system */
#define	DIAL_RING -17
#define	DIAL_MODEM_ERROR -18
#define	DIAL_NO_DIALTONE -19


extern int line;
extern boolean allow_address_wildcards;
extern long total_bytes;
extern char binarytelinkblock[128];
extern char binaryfirstblock[128];

DECLARE(void, internal_undial, (int));
DECLARE(void, undial, (int));
DECLARE(int, yoohoo_sender, (void));
DECLARE(void, eatnoice, (void));
DECLARE(void, savepacket, (char *));
DECLARE(boolean, sendreq, (boolean));
DECLARE(boolean, zzreceiver, (void));
DECLARE(boolean, zzsender, (void));
#ifdef XENIX
DECLARE(void, resetdialer, (char *));
#endif
DECLARE(void, uploadpath, (char *, char *));
DECLARE(char *, productname, (int));
DECLARE(boolean, sendfiles, (boolean ));
DECLARE(boolean, recfiles, (boolean ));
DECLARE(boolean, filerequests, (boolean));
DECLARE(boolean, get_terminal_state, (int, TTYSTATE *));
DECLARE(boolean, set_terminal_state, (int, TTYSTATE *));

DECLARE(int, new_dial, (char *, TTYSTATE *, struct nodelist *));
DECLARE(void, new_undial, (int));


DECLARE(int, readline, (int ));
DECLARE(int, readcheck, ());
DECLARE(void, sendline, (int ));
DECLARE(void, xsendline, (int));
DECLARE(int, putback, (int));
DECLARE(void, hangup, (int));
DECLARE(void, flush, (void));
DECLARE(void, sendstring, (char *));
DECLARE(void, senddata, (char *, Uint ));
DECLARE(void, senddata, (char *, Uint));
DECLARE(void, drainline, (int));
DECLARE(void, xon_enable, (void));
DECLARE(void, xon_disable, (void));
DECLARE(void, xon_flush, (void));
DECLARE(void, sendbrk, (void));
DECLARE(void, flushline, (void));

