/*
 * $Header: /u1/src/rfmail/RCS/fcall.c,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: fcall.c,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.5  1991/09/07  10:37:46  pgd
 * not finished revision check-in
 *
 * Made some changes to the terminal settings. They might initialize wrong
 * on some systems.
 * Changed retry-sleep logic. Made command option -r set retry sleep time
 * initsession() has to be declared static
 *
 * Revision 0.4.1.3  1991/06/15  09:33:39  pgd
 * *** empty log message ***
 *
 * fcall did not recognize packets held for pickup.
 *
 * Revision 0.4.1.2  1991/06/05  09:13:58  pgd
 * Various Bugfixes:
 *
 * Patches suggested by Marc Boucher (marc):
 * Added call to initsession() when reverse_handshake but not daemon.
 * (important) 
 * changes to make inbaud = maxbaud = minbaud = 0 behave like "Any" in
 * speed field of HDB Systems file entries.
 * (baudrate and call.attr->c_flags&CBAUD are set according to the line's
 * speed after dial(3))
 *
 * Patches suggested by Jari Nopanen (JN):
 * Has to convert filenames to msdos when sending with zmodem.
 * terminal should not be open with CLOCAL, to get a signal when
 * carrier is lost.
 * no unlink of tty device
 * fixed some problems in reverse_handshake mode, "allright" has to be
 * defined together with handshake mode.
 * Has to look for outgoing packet and files to enable calling node
 * to pick up mail.
 * Some minor fixes.
 *
 * Revision 0.4.1.1  1991/05/21  11:13:48  pgd
 * *** empty log message ***
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 *
 */

/* Dial to host-fido for mail.
   
   @(#)Copyright (c) 1987 by Teemu Torma
   
   Permission is given to distribute this program and alter this code as
   needed to adapt it to foreign systems provided that this header is
   included and that the original author's name is preserved. */

/*
 * Authors:
 *
 * Teemu Torma who wrote the original code (?)
 *
 * Heikki Suonsivu (hsu@hutcs.hut.fi) who made a lot of enhancements
 * 
 * Per Lindqvist (pgd@compuram.bbt.se) who continued to enhance rfmail.
 */

#include "fnet.h"

#ifndef HAVE_BCOPY
#include <memory.h>
#endif

#ifdef FCNTL
#include <fcntl.h>
#endif

#include <sys/stat.h>

#include "nodelist.h"
#include "fcall.h"
#include "configs.h"
#include "packet.h"
#include "xmodem.h"
#include "zmodem.h"
#include "directory.h"

#ifdef XENIX
DECLARE(int, stat, (char *, struct stat *));
#endif

LDECLARE(void, initsession, ());
LDECLARE(boolean, fcall, (Node *, int));
LDECLARE(int, dial_modem, (Node));
LDECLARE(void, usermessage, (VOID));
LDECLARE(boolean, usersession, (int));
DECLARE(int, bsdbaud_to_baud, (int));

extern int getopt();
extern int optind;
extern int remote_capabilities;		/* YOOHOO capabilities bits */
extern boolean have_verbose;
extern int our_capabilities;	/* What we can do */
extern boolean carrier;

/*
 * Options
 */
int retry_time;			/* Number of seconds to wait before 
				   dialing again */
int retry_count;		/* Number of times to retry the dial of	
				   the same number. */
int wait_line;			/* How many seconds to wait for dialer */

fidonet_options_t fidonet_options; /* Fidonet FTSC-001 transfer options */
xmodem_options_t xmodem_options; /* X-modem options */
boolean exit_after_session;	/* Set TRUE if exit after one session */
boolean direct_line;		/* Set TRUE if directly connected line
				   (No dialing) */
boolean fflag, nflag, pflag;	/* Command-line options */

Node	fnode;			/* Argument given by -f flag */
boolean reverse_handshake;	/* -i Reverse handshake flag */
time_t sleeptime;		/* -z time to sleep */
time_t sleep_start_time;	/* Schedule start time */
time_t start_time;		/* Session start time */
time_t s_time;
boolean try_yoohoo;		/* -Y option, use YooHoo protocol */
int line = -1;
int speed = 1200;
boolean daemon;
boolean wazoo;			/* Set TRUE if we are using WaZoo protocol */
long total_bytes;		/* Total bytes transmitted, way or another */
struct packet firstblock;
Node packet_fromnode, packet_tonode;
TTYSTATE orgtblk;		/* Original tty state */
Node remote_node;		/* Node communicating with */
struct nodelist remote_nodeentry; /* Full node entry for remote node */
char packetname[15];		/* Official name (alias) of packet sent */
char ipacketname[PATH_LEN];
char *outpacket;		/* Name of outgoing mail packet */
int opacketseq;			/* Sequence number for output packets */

int baudrate;			/* Baudrate of the current connection */
int receive_retrys;
boolean b_option_seen;		/* Indicates that -b option is seen */
boolean calling;			/* Indicates that we did the call */


char *inpacket;
char *telno;			/* Telephone number */

TTYSTATE call_attr;		/* Line parameters for current call */
char *call_line;



/* version of rfmail, maintained by RCS */
static char *Revision = "$Revision: 0.5.0.1 $";

/* States for session sender. */

#define SendInit        (0)
#define WaitCxD         (1)
#define WhackCRs        (2)
#define WaitClear       (3)
#define	TSyncChk	(18)
#define SendMail        (4)
#define CheckMail       (5)
#define SendFiles       (6)
#define CheckFile      (7)
#define TryPickup       (8)

/* States for session receiver. */

#define WaitTsync       (9)
#define RecMail         (10)
#define XRecEnd         (11)
#define RecFiles        (12)
#define ChkFiles        (13)
#define AllowPickup     (14)
#define WaitBaud	(15)
#define Done		(16)

/* Other states */

#define DaemonInit	(17)
#define	YOOHOO_Receiver	(19)
#define	YOOHOO_Sender	(20)
#define	FTSC_Receiver	(21)
#define	ZedZap_Receiver	(22)
#define	ZedZap_Sender	(23)

/* Special case */

#define Error           (24)

/* State to exit main loop */

#define Exit		(25)

/* States to break up the loops */

#ifdef NEEDED
#define Done            (-2)
#endif

/* For debugging */

char *states[] = {
	"SendInit",			/* (0) */
	"WaitCxD",			/* (1) */
	"WhackCRs",			/* (2) */
	"WaitClear",			/* (3) */
	"SendMail",			/* (4) */
	"CheckMail",			/* (5) */
	"SendFiles",			/* (6) */
	"CheckFile",			/* (7) */
	"TryPickup",			/* (8) */
	"WaitTsync",			/* (9) */
	"RecMail",			/* (10) */
	"XRecEnd",			/* (11) */
	"RecFiles",			/* (12) */
	"ChkFiles",			/* (13) */
	"AllowPickup",			/* (14) */
	"WaitBaud",			/* (15) */
	"Done",				/* (16) */
	"DaemonInit",			/* (17) */
	"TSyncChk",			/* (18) */
	"YOOHOO_Receiver",		/* (19) */
	"YOOHOO_Sender",		/* (20) */
	"FTSC_Receiver",		/* (21) */
	"ZedZap_Receiver",		/* (22) */
	"ZedZap_Sender",		/* (23) */
	"Error",			/* (24) */
	"Exit",				/* (25) */
};


/* Translate telink and first block to structures for easier handling. */

#define MKINT16(cp) ((cp) += 2, cp[-2] | (cp[-1] << 8))

void
check_out_received_data()
{
	register Uchar *cp;
	register int i;

	check_out_telinkblock();
  
	cp = (Uchar *)binaryfirstblock;
	firstblock.orig.node = MKINT16(cp);
	firstblock.dest.node = MKINT16(cp);
	firstblock.year = MKINT16(cp);
	firstblock.month = MKINT16(cp);
	firstblock.day = MKINT16(cp);
	firstblock.hour = MKINT16(cp);
	firstblock.minute = MKINT16(cp);
	firstblock.second = MKINT16(cp);
	firstblock.rate = MKINT16(cp);
	firstblock.ver = MKINT16(cp);
	firstblock.orig.net = MKINT16(cp);
	firstblock.dest.net = MKINT16(cp);
	firstblock.prodcode = *cp++;
	firstblock.serialno = *cp++;
	for (i = 0; i < 8; i++)
		firstblock.passwd[i] = *cp++;
	firstblock.orig.zone = MKINT16(cp);
	if (firstblock.orig.zone == 0)
		firstblock.orig.zone = config.mynode.zone;
	firstblock.dest.zone = MKINT16(cp);
	if (firstblock.dest.zone == 0)
		firstblock.dest.zone = config.mynode.zone;
	packet_fromnode.zone = firstblock.orig.zone;
	packet_fromnode.net = firstblock.orig.net;
	packet_fromnode.node = firstblock.orig.node;
	packet_fromnode.point = 0;
	packet_tonode.zone = firstblock.dest.zone;
	packet_tonode.net = firstblock.dest.net;
	packet_tonode.node = firstblock.dest.node;
	packet_tonode.point = 0;
}

/* Show dialer's error code as message */

void
log_dialerr(code)
	int code;
{
	switch (code) {
	case INTRPT:
		log("Interrupt occured during dialing");
		break;
	case D_HUNG:
		log("Dialer hung (no return from write)");
		break;
	case NO_ANS:
		log("No answer");
		break;
	case ILL_BD:
		log("Illegal baud-rate");
		break;
	case A_PROB:
		log("$Acu problem (open() failure)");
		break;
	case L_PROB:
		log("$Line problem");
		break;
	case NO_Ldv:
		log("Can't open LDEVS file");
		break;
	case DV_NT_A:
		log("Requested device not available");
		break;
	case DV_NT_K:
		log("Requested line %s telno %s not known",  call_line, telno);
		break;
	case NO_BD_A:
		log("No device available at requested baud");
		break;
	case NO_BD_K:
		log("No device known at requested baud");
		break;
#ifdef DV_NT_E
	case DV_NT_E:
		log("Requested speed does not match");
		break;
#endif
	case NO_OCC:
		log("Number occupied");
		break;
	case DIAL_BAD_SPEED:
		log("Connection at bad speed");
		break;
	case DIAL_NO_CARRIER:
		log("No carrier");
		break;
	case DIAL_RING:
		log("Someone is calling on telephone line while dialing");
		break;
	case DIAL_MODEM_ERROR:
		log("Modem command error");
		break;
	case DIAL_NO_DIALTONE:
		log("No dial tone -- cannot dial");
		break;
	default:
		log("Dial error %d", code);
	}
}

/* Trapper for signals to quit gracefully. Be must do undial to get lock-
   file removed */

SIG_FTYPE
quit(sig)
	int sig;
{
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGTERM, SIG_IGN);
	signal(SIGHUP, SIG_IGN);
  
	debug(1, "quit, line = %d", line);
	if (line) {
		if (line != -1) {
			new_undial(line);
			carrier = FALSE;
			line = -1;
		}
	} else if (line == 0) {
		/* Reset line back to its original state after incoming call. */
		(void)set_terminal_state(line, &orgtblk);
	}
	
	if (sig >= 0)
		log("Caught signal %d", sig);
	
/*	removelock(SUPERLOCK); */
/* or	silent_remove_superlock(); */
	
	exit(EX_OSERR);
	/* NOTREACHED */
}

/* Send files in batch protocol */

boolean
sendfiles(zedzap)
	boolean zedzap;
{
	char *fname;
	int s;
	extern int sentfilerequests;


	sentfilerequests = 0;

	/*
	 * Send all files in the output file directory
	 * for this node
	 */
	if (myopendir(nodepath(config.outfiles, remote_node), FALSE)) {
		while (fname = myreaddir(NULL)) {
			if (zedzap)
				s = sendzmodem(fname, conver_to_msdos_name(fname),0,0,0);
			else
				s = batchsend(fname, conver_to_msdos_name(fname));
			switch (s) {
			case OK:
				savefile(fname);
				if (is_req(fname))
					sentfilerequests++;
				break;
			case REJECTED:
				savebad(fname);
				break;
			case FAILED:
			case ERROR:
				log("Transfer aborted to error");
				break;
			}
		}
	}
	/*
	 * Indicate we have no more files to send
	 */
	if (!zedzap)
		return batchsend(NULL, NULL);
	return TRUE;
}

boolean
recfiles(zedzap)
	boolean zedzap;
{
	boolean ok;

	if (zedzap)
		ok = getzmodem();
	else
		ok = batchrec();
	return ok;
}

void
printusage(fp)
     FILE *fp;
{
	fputs("\
fcall: Do a fidonet protocol session\n\
Possible options are:\n", fp);
	fputs(fidonet_options.allowpickup ? "\
-a  Don't allow system calling us to pick up his mail.\n" : "\
-a  Allow system calling us to pick up mail to him.\n", fp);
	fputs("\
-b  <baud rate> Bps to use during call.\n\
-c  Force crc mode. No checksum fallback is allowed.\n", fp);
	fputs(fidonet_options.dopickup ? "\
-d  Disable pickup, don't pick our mail when calling out\n" : "\
-d  Pick up our mail when calling out.\n", fp);
	fputs("\
-f  <fidonet address> Fidonet node to call.\n\
-h  Print usage.\n\
-i  Reverse handshake. Act in slave mode, used for incoming call. This will\n\
    be the default if command starts with a '-' (login shell).\n\
    In this situation, -i will force normal handshake.\n", fp);
	fputs(xmodem_options.sealink ? "\
-k  Do not do Sealink receive. This may be necessary on 386 systems\n" : "\
-k  Do Sealink receive. This may be troublesome for 386 systems\n", fp);
	fputs("\
    with fast modems and buggy serial line driver/hardware.\n\
-l  <tty device> tty line override\n\
-n  <Times to retry> How many times to retry if no connection.\n\
-p  <Telephone number> to call.\n", fp);
	fputs(xmodem_options.quicknak ? "\
-q  Disable immediate nak mode. Don't Nak until expected\n" : "\
-q  Enable immediate nak mode. Will nak as soon\n", fp);
	fputs("\
    as error happens, then wait until expected\n\
    input seen. Quick nak may not work with slow hardware\n", fp);
	fputs("\
-r  <retry time> How many seconds to wait until redial.\n", fp);
	fputs(xmodem_options.transfer_ack_numbered ? "\
-t  Make transfer-ok ack numbered.\n" : "\
-t  Make transfer-ok ack unnumbered.\n", fp);
	fputs("\
-v  <level> Set verbosity to <level>.\n\
-w  <wait time> How many seconds to wait if dialer is reserved.\n\
-z  <time> Wait for incoming call. Sleep until someone 'knocks on the door',\n\
    then enter slave mode. Terminate after <time> seconds have passed.\n\
    Special time 'config' adds time specified in configuration file.\n\
    Any number and mix of these can be specified to add value.\n\
    Value of 0 results configuration value to be used.\n\
-C  <number> Number of tries to give until fall back to checksum mode.\n\
    Use force crc (-c) to completely disable checksum mode.\n\
-D  The line specified by -l is a direct line without dialing.\n", fp);
	fputs(fidonet_options.file_requests ? "\
-F  Disallow inbound file requests.\n" : "\
-F  Allow inbound file requests.\n", fp);
	fputs("\n\
-N  <fidonet address> Set my node-number to the fidonet address.\n", fp);
	fputs("\
-O  <filename> to send debugging output to <filename>.\n", fp);
	fputs(xmodem_options.dotelink ? "\
-T  Disable telink block for mail.\n" : "\
-T  Enable telink block for mail.\n", fp);
	fprintf(fp, "\
-X <filename> Use this configuration file instead of %s\n", CONFIGFILE);
	fputs("\
-Y  Try a YooHoo protocol conversation.\n\
-Z  Enter demon mode for outgoing call.\n", fp);
	
  fflush(fp);
}

static SIG_FTYPE
trap(sig)
	int sig;
{
	signal(sig, trap);
}

static SIG_FTYPE
time_up_alarm(sig)
	int sig;
{
	/*
	 * this will terminate main lupe
	 */
	sleeptime = 0;
}


/* ARGSUSED */
int
main(argc, argv)
	int argc;
	char **argv;
{
	int c, i;
	int init_state;
	Node *call_node;
	boolean s, allright;
	static char *options = "ab:cdef:ikl:n:p:qr:s:w:z:C:DFN:S:TW:YZ:";
	allright = FALSE;
  
/* for (i = 0; i < argc; i++) printf("ARG(%d) = '%s'\n", i, argv[i]); */
	/*
	 * If we are called by login, first character of argv[0]
	 * is starting with '-'.
	 * If we are called with yoohoo handshake, first parameter
	 * should be "-YOOHOO"
	 */
	reverse_handshake = (*argv[0] == '-');
	if (reverse_handshake) {
		allright = TRUE; /* JN */
		try_yoohoo = strequ(argv[0], "-YOOHOO");
	} else
		try_yoohoo = FALSE;

	/*
	 * Setup our version string, and initialize configuration
	 */
	fixversion(Revision);

	/*
	 * Load configuration file.
	 */
	get_configuration(&argc, argv, options);

	/*
	 * If we are called from login, we should not output
	 * any debug or logging information to screen.
	 */
	if (reverse_handshake && !have_verbose)
		verbose = 0;
	daemon = FALSE;
	total_bytes = 0;
	receive_retrys = config.max_send_retries;
  
	/*
	 * Read nodelist into memory. Update it
	 * if neccessary
	 */
	get_nodelist();


	mychdir(config.spooldir);

	bzero((char *)&call_attr, sizeof(call_attr));
	xmodem_options.speed = baudrate = config.maxbaud;
	telno = NULL;

	xmodem_options.sealink = config.sealink;
	xmodem_options.forcecrc = config.forcecrc;
	fidonet_options.dopickup = config.dopickup;
	fidonet_options.allowpickup = config.allowpickup;
	fidonet_options.file_requests = config.file_request_mode != NONE_REQ;
	xmodem_options.checksum_fallback = config.checksum_fallback;
	xmodem_options.quicknak = config.quicknak;
	xmodem_options.transfer_ack_numbered = config.transfer_ack_numbered;
	xmodem_options.dotelink = config.telinkmail;
	xmodem_options.windows_at_2400 = config.windows_at_2400;
	xmodem_options.max_send_ahead = config.max_send_ahead;
  
	exit_after_session = FALSE;
	retry_time = config.retry_sleeptime;
	sleeptime = 0;
  
	while ((c = getopt(argc, argv, options)) != EOF) {
		switch (c) {
/*		case 'S':
			xmodem_options.max_send_ahead = atoi(optarg);
			break; */
		case 'W':
			xmodem_options.windows_at_2400 = atoi(optarg);
			break;
		case 'F':		/* Allow/Disallow file requests */
			fidonet_options.file_requests =
				!fidonet_options.file_requests;
			break;
		case 'd':		/* Disable pickup */
			fidonet_options.dopickup = !fidonet_options.dopickup;
			break;
		case 'e':
			exit_after_session = !exit_after_session;
			break;
		case 'p':		/*-p <number to call> */
			telno = optarg;
			allright = TRUE;
			pflag = TRUE;
			break;

		case 'l':		/* -l <tty line to use> */
			call_line = optarg;
			break;
		case 'D':		/* -D ... Use direct line (no dial) */
			direct_line = TRUE;
			allright = TRUE;
			break;
		case 'b':		/* -b <baud rate> */
		case 's':		/* -s accepted for compatibility */
			b_option_seen = TRUE;
			xmodem_options.speed = baudrate = atoi(optarg);
			break;
		case 'r':		/* -r <retry delay time> */
			retry_time = atoi(optarg);
			break;
		case 'n':		/* -n <retry count> */
			retry_count = atoi(optarg);
			nflag = TRUE;
			break;
		case 'w':		/* -w <wait line> */
			wait_line = atoi(optarg);
			break;
		case 'f':		/* -f <fidonet address to call> */
			if (!parsenode(optarg, &fnode, NULL, &config.mynode)) {
				fprintf(errorfp, "Cannot parse node given to -f option\n");
				goto error;
			}
			if (fnode.node == NONODE || fnode.point == NOPOINT) {
				fprintf(errorfp, "Incomplete node specification: %s\n", optarg);
				goto error;
			}
			if (fnode.zone == NOZONE)
				fnode.zone = config.mynode.zone;
			if (fnode.net == NONET)
				fnode.net = config.mynode.net;
			if (fnode.node == NONODE)
				fnode.node = config.mynode.node;
			fflag = TRUE;
			exit_after_session = TRUE;
			allright = TRUE;
			break;
		case 'k':		/* -k ... Toggle sealink option */
			xmodem_options.sealink = !xmodem_options.sealink;
			break;
		case 'i':		/* -i ... Reverse handshake */
			reverse_handshake = !reverse_handshake;
			if (reverse_handshake)
				allright = TRUE;
			break;
		case 'z':		/* -z <sleep time> */
			daemon = TRUE;
			if (strequ(optarg, "config"))
				sleeptime = config.sleeptime;
			else
				sleeptime = atol(optarg);
			/* Incoming connects may use different baud rate. */
			if (!b_option_seen)
				xmodem_options.speed = baudrate = config.inbaud;
			allright = TRUE;
			break;
		case 'Z':		/* -z <sleep time> */
			if (strequ(optarg, "config"))
				sleeptime = config.sleeptime;
			else
				sleeptime = atol(optarg);
			allright = TRUE;
			break;
		case 'a':		/* -a ... Toggle "allow pickup" */
			fidonet_options.allowpickup = !fidonet_options.allowpickup;
			break;
		case 'c':		/* -c ... Toggle "force crc" */
			xmodem_options.forcecrc = !xmodem_options.forcecrc;
			break;

		case 'C':		/* -C <checksum fallback option> */
			xmodem_options.checksum_fallback = atoi(optarg);
			break;
		case 'q':		/* -q ... Toggle quickNAK  */
			xmodem_options.quicknak = !xmodem_options.quicknak;
			break;
		case 't':		/* -t ... Toggle "ack numbered" */
			xmodem_options.transfer_ack_numbered
				= !xmodem_options.transfer_ack_numbered;
			break;

		case 'T':
			xmodem_options.transfer_ack_numbered
				= !xmodem_options.transfer_ack_numbered;
			break;


		case 'Y':		/* -Y ... Enable YooHoo protocol */
			try_yoohoo = 1;
			break;

		case 'N':		/* -N <node number> ... set my node */
			if (parsenode(optarg, &config.mynode, NULL, &config.mynode) == NULL)
				goto error;
			break;

		default:
		error:
			printusage(errorfp);
			fatal(EX_USAGE, "Illegal option '%c' for fcall", c);
		}
	}
	if (!allright)
		fatal(EX_USAGE, "Illegal usage, You have to specify either -f, -p, -z or -Z");

	debug(2, "Max Line Speed %d", xmodem_options.speed);
  
	signal(SIGINT, quit);
	signal(SIGTERM, quit);
	signal(SIGQUIT, quit);
	signal(SIGHUP, quit);

	/*
	 * Setup initial line terminal settings
	 */
#ifdef TERMIO
	call_attr.c_iflag = /*IGNPAR | */ IGNBRK;
	call_attr.c_oflag = 0;
	call_attr.c_cflag = CS8 | CREAD | HUPCL;
#ifdef RTSFLOW
	call_attr.c_cflag |= RTSFLOW;
#endif
	call_attr.c_lflag = NOFLSH;
	call_attr.c_line = 0;
	call_attr.c_cc[VMIN] = 0;		/* No delay! */
	call_attr.c_cc[VTIME] = 0;
#else
	call_attr.sg_flags = RAW;
#endif
    
	/* If daemon, always reverse handshake. */
	if (daemon)
		reverse_handshake = TRUE;
	else if (reverse_handshake) {
		/* Reverse handshake, but not daemon.
		   Getty/login saw TSYNCH, and
		   started up rfmail? */
		debug(1, "Login received %s",
		      try_yoohoo ? "YOOHOO" : "TSYNCH");
		line = 0;			/* Use stdin */

		/* Store original line state */
		get_terminal_state(line, &orgtblk);

		/*
		 * Set new state more suitable for us; pick up the
		 * original baud rate, do not use our own.  Keep some
		 * other parameters unchanged.
		 */
#ifdef TERMIO
		call_attr.c_cflag = (call_attr.c_cflag & ~CBAUD)
				  | (orgtblk.c_cflag & CBAUD);
		call_attr.c_line = orgtblk.c_line;
		baudrate = bsdbaud_to_baud(orgtblk.c_cflag & CBAUD);
		for (i = 0; i < sizeof(call_attr.c_cc); i++)
			if (i != VMIN && i != VTIME)
				call_attr.c_cc[i] = orgtblk.c_cc[i];
#else
		call_attr.sg_ispeed = orgtblk.sg_ispeed;
		call_attr.sg_ospeed = orgtblk.sg_ospeed;
		baudrate = bsdbaud_to_baud(call_attr.sg_ospeed);
#endif
		(void)set_terminal_state(line, &call_attr);
		
		init_state = try_yoohoo ? YOOHOO_Receiver : FTSC_Receiver;
		sleeptime = 0;
		initsession();
	} else
		init_state = SendInit;
  
	/*
	 * Setup a trap for end of this schedule
	 */
	sleep_start_time = time(NULL);
	if (sleeptime) {
		signal(SIGALRM, time_up_alarm);
		alarm(sleeptime);
	}

	if (daemon || sleeptime != 0) {
		if (!nflag)
			retry_count = config.retry_count;
	}

	/*
	 * Now do our business, while we should
	 */
	do {
		if (daemon)
			s = fcall(NULL, DaemonInit);
		else {
			if (fflag)
				call_node = &fnode;
			else
				call_node = node_to_call();
			if (call_node == NULL && !reverse_handshake) { /* JN */
				debug(1, "No node to call");
				/*
				 * There is nothing we can call right now,
				 * sleep a while, and try again.
				 */
				sleep(retry_time);
				continue;
			}
			s = fcall(call_node, init_state);
		}
		if (s && exit_after_session)
			break;
	} while (sleeptime && (sleep_start_time + sleeptime >= time(NULL)));

	if (sleeptime)
		signal(SIGALRM, SIG_IGN);

	/*
	 * Do final cleanup
	 */
	if (line >= 0) {
		(void)set_terminal_state(line, &orgtblk);
		if (daemon && line != 0) {
			/* Naive assumption: if line is stdin, we don't need to
			   close it nor remove any locks */
			close(line);
			line = -1;
			{
				/* JN */
				/* I hope this code doesn't any more
				   unlink tty-device if it is started
				   with -l -option */
				char *tmp;

				if (!(tmp = strrchr(call_line, '/')))
					fatal(EX_SOFTWARE, "Cannot remove lock, invalid device name: %s", call_line);
				removelock(++tmp);
			}
		}
	}
  
	exit(EX_OK);
	/* NOTREACHED */
	return EX_OK;			/* Just to make gcc happy */
}


/*
 * Main state machine for fcall
 * 
 * Return TRUE if we made a call, FALSE if call failed
 *
 * Comments in boxes directly from FTS-0001
 * Deviations noted below boxes.
 */
static boolean
fcall(call_node, init_state)
	Node *call_node;
	int init_state;
{
	int wasopen;
	sig_t alrm;
	int state = init_state;
	int c;
	boolean ok;
	char *p;
	time_t total_time;
	int delaytime;

	if (call_node && !reverse_handshake) /* JN */
		if (!set_node_lock(*call_node))
			return FALSE;

	start_time = time(NULL);

	while (state >= SendInit && state < Exit) {
	 debug(2, "Current state: %s", states[state]);
	 switch(state) {

/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | S0  | SendInit |                         | dial modem              | S1  |
 * |-----+----------+-------------------------+-------------------------+-----|
 *
 * Validates node number, and get information about it.
 * Remove old remote file requests.
 * Setup modem speed to call out on
 * Translate telephone number
 * Call dial() for modem connection.
 * When we get back control, we either have
 * a connection with remote, or connection failed.
 * Sets:
 *	remote_node -- node of remote
 *	ipacketname -- Unique incoming packet filename
 *	opacketseq -- unique number for outgoing packet
 *	packetname[] -- <opacketseq>.PKT name
 */

	 case SendInit:
		 line = dial_modem(*call_node);
		 if (line < 0) {
			 set_call_status(*call_node, line == NO_OCC);
			 debug(1, "Dial failed");
			 state = Error;
		 } else {
  			 state = WaitCxD;
		 }
		 break;
		 
	 case DaemonInit:
		 if (!daemon)
			 fatal(EX_SOFTWARE, "Internal error: State = DaemonInit, daemon = %d", daemon);
		 
		 log("DaemonInit");
		 
		 if (call_line == NULL || *call_line == 0)
			 fatal(EX_USAGE, "Call device undefined");
		 if (line > 0) {		/* Not yet opened? */
			 wasopen = TRUE;
			 close(line);
			 line = -1;
		 }
		 
		 if (!wasopen) {
			 if (strchr(call_line, '/') == NULL)
				 fatal(EX_SOFTWARE, "Invalid device name: %s", call_line);
			 if (!createlock(call_line, config.lock_timeout))
				 fatal(EX_OSFILE, "Device already occupied: %s", call_line);
		 }
	
		 /*
		  * Need to break open after zmh has passed.
		  * Could also invoke termination routine..?
		  * This may fail on BSD if open gets
		  * restarted? Manual states O_NDELAY is not
		  * implemented?
		  */
		 alarm(sleeptime);
		 if ((line = open(*call_line == '/' ? call_line :
				  sprintfs("/dev/%s", call_line), O_RDWR, 0)) == -1)
			 fatal(EX_OSFILE, "$Cannot open tty line given (%s)",
			       call_line);
	    
		 /* Not more alrm needed after this (?) */
		 alarm(0);
		 signal(SIGALRM, alrm);
		 
		 if (!wasopen)
			 if (!get_terminal_state(line, &orgtblk))
				 fatal(EX_OSFILE, "Cannot get terminal state");
		 if (!set_terminal_state(line, &call_attr))
			 fatal(EX_OSFILE, "Cannot set terminal state");
		 
		 debug(2, "Entered Sleep mode, switching to WaitBaud");
		 state = WaitBaud;
		 break;

/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | S1  | WaitCxD  | 1 carrier detected      | delay 1-5 seconds       | S2  |
 * |     |          | 2 busy, etc.            | report no connection    | exit|
 * |     |          | 3 voice                 | report no carrier       | exit|
 * |     |          | 4 carrier not detected  | report no connection    | exit|
 * |     |          |   within 60 seconds     |                         |     |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
	 case WaitCxD:
		 if (line >= 0) {
			 log("Call succeeded to %s on %d baud",
			     ascnode(*call_node), baudrate);
			 if (config.prewait) {
				 debug(1, "Wait %d seconds before start", config.prewait);
				 sleep(config.prewait);
			 } 
			 state = WhackCRs;
		 }
		 break;


/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | S2  | WhackCRs | 1 over 30 seconds       | report no response <cr> | exit|
 * |     |          | 2 ?? <cr>s received     | delay 1 sec             | S3  |
 * |     |          | 3 <cr>s not received    | send <cr> <sp> <cr> <sp>| S2  |
 * |     |          |                         |   delay ??? secs        |     |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
	 case WhackCRs:
		 if (config.quick_whack) { /* Nonstandard */
			 while (readline(1*1000) != TIMEOUT)
				 ;
			 
			 debug(2, "Sending <cr><sp><cr><sp>");
			 xsendline('\r');
			 xsendline(' ');
			 xsendline('\r');
			 sendline(' ');
			 mssleep(1000);
		 }
		 SetStart();
		 while (state == WhackCRs)
			 if (Timeout(30)) {
				 log("No response");
				 state = Error;
			 } else if ((c = readline(1*1000)) == '\r') {
				 debug(1, "Got CR, wait 1 second");
				 mssleep(1000);
				 state = WaitClear;
			 } else if (c < 0) {
				 debug(1, "Sending <cr><sp><cr><sp>");
				 xsendline('\r');
				 xsendline(' ');
				 xsendline('\r');
				 sendline(' ');
				 mssleep(1000);
			 }
		 /* else junk it */
		 
		 break;


/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | R0  | WaitCxD  | 1 carrier detected      |                         | R1  |
 * |     |          | 2 external timer expires| report no calls         | exit|
 * |-----+----------+-------------------------+-------------------------+-----|
 *
 * No real baud rate detection now. Make your modem constant speed, fix this or
 * find a getty which can spawn fidonet received when TSYNCH seen.
 */
	 case WaitBaud:
		 SetStart();
		 calling = FALSE;
		 delaytime = 2;
		 while (state == WaitBaud) {
			 if (time(NULL) > sleep_start_time + sleeptime) {
				 log("Sleep compeleted");
				 state = Exit;
			 }
			 if ((c = readline(delaytime*1000)) == ' ' || c == '\r') {
				 debug(1, "Someone knocking on the door, got %d", c);
				 usermessage();
				 state = WaitTsync;
				 start_time = time(NULL);
			 } else if (c < 0) {
				 delaytime += delaytime;
				 if (delaytime > 30) delaytime = 30;
			 } else  {
				 /* Some character received, but it wasn't
				    something we know about. Go back waiting
				    more. Here we should try to do something
				    intelligent by switching baud rates to
				    direction or another depending on character
				    received. */
				 delaytime = 2;
			 }
		 }
		 break;
	
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | R2  | WaitTsync| 1 TSYNCH received       | ignore input not TSYNCH | R3  |
 * |     |          | 2 60 seconds timeout    | hang up, report not Fido| exit|
 * |-----+----------+-------------------------+-------------------------+-----|
 *
 * Deviation:
 *	Look for both TSYNCH and YOOHOO. If Yoohoo, try Yoohoo protocol,
 * 	if FTSC use DietIFNA protocol.
 *
 * 	Look for  "L" or "l". If login defined, it looks like a human user
 *	session, try that out before starting mail protocol.
 */
	 case WaitTsync:
		 SetStart();
		 while (state == WaitTsync)
			 if (Timeout(60)) {
				 log("Garbage, no Tsync, Call ok (?)");
				 if (daemon)
					 state = AllowPickup;
				 else
					 state = Done;
			 } else if ((c = readline(Timeleft(60)*1000)) == TSYNCH) {
				 debug(1, "Received TSYNCH");
				 state = RecMail;
			 } else if (c == YOOHOO) {
				 debug(1, "Received YOOHOO");
				 state = YOOHOO_Receiver;
			 } else if (daemon && *config.login_path &&
				    (c == 'l' || c == 'L' || c == ESC)) {
				 if (usersession(c))
					 state = Done;
				 else
					 state = Error;
				 if (exit_after_session)
					 state = DaemonInit;
				 log("Wait returned, session finished?");
				 break;
			 } else if (reverse_handshake && (c == ' ' || c == '\r')) { 
				 /* Someone might have missed */
				 /* our welcome, retry it */ 
				 sendstring("Waiting for Fidonet handshake\r\n");
			 } else if (c == ENQ) {
				 if (reverse_handshake) {
					 if (!daemon) {
						 log("Internal error: illegal state WaitTsync when processing an incoming call");
						 state = Error;
						 break;
					 }
					 
					 /* When processing someone calling us */
					 debug(1, "Got ENQ, reverse handshake, presume garpage");
				 } else { /* Not reverse handshake, doing outgoing call */
					 /*
					  * ENQ is allow-file-request signal.
					  * We don't support bark file requests
					  * yet, so we can go on.
					  */
					 debug(1, "Got ENQ, assume nothing to pick up");
					 state = Done;
				 }
			 }
		 break;
	
	 case YOOHOO_Receiver:
		 ok = yoohoo_receiver();
		 if (ok == -1) {
			 log("Yoohoo Receive failed");
			 state = Error;
		 } else {
			 sprintipacketname(ipacketname, remote_node);
			 if (ok == 1 && (remote_capabilities & our_capabilities & ZED_ZAPPER)) {
				 log("WaZoo method: ZedZap");
				 state = ZedZap_Receiver;
				 try_yoohoo = TRUE;
			 } else {
				 log("WaZoo method: DietIfna");
				 state = RecMail;
				 try_yoohoo = FALSE;
			 }
		 }
		 break;
		 
	 case FTSC_Receiver:
		 /*
		  * We got a TSYNCH. See if we get anything within 2
		  * seconds.  If we get another TSYNCH it means FTSC,
		  * but if we get a WAZOO it means we missed the first
		  * waazoo, and we do a YooHoo
		  */
		 c = readline(2*1000);
		 if (c == YOOHOO)
			 state = YOOHOO_Receiver;
		 else {
			 if (c != TSYNCH)
				 putback(c);
			 state = RecMail;
		 }
		 break;

/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | R3* | RecMail  |                         | (XMODEM rec packet XR0) | R4  |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
	 case RecMail:
		 ok = xtrec(inpacket =
			    sprintfs("%s/%s", config.indir, ipacketname),
			    MAILTRANSFER);
		 state = XRecEnd;
		 break;
		 
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | R4  | XRecEnd  | 1 XMODEM successful     | delay 1 second          | R5  |
 * |     |          |                         |   flush input           |     |
 * |     |          | 2 XMODEM failed         | hang up, rept mail fail | exit|
 * |-----+----------+-------------------------+-------------------------+-----|
 */
	 case XRecEnd:
		 if (ok) {
			 log("Mail received successfully");
			 check_out_received_data();
			 if (!wazoo) {
				 remote_node = packet_fromnode;
				 if (strlen(telinkblock.sendingProg))
					 log("Other end was using %s", telinkblock.sendingProg);
				 remove_reqs();
			 }
			 if (strlen(telinkblock.filename)) {
				 log("Original packet file name was <%s>",
				     telinkblock.filename);
				 log("Renaming received packet %s to %s",
				     spoolname(inpacket),
				     spoolname(p = sprintfs("%s/%s", nodepath(config.indir, remote_node), telinkblock.filename)));
				 if (myrename(inpacket, p))
					 log("$Could not rename input packet %s to %s",
					     spoolname(inpacket), spoolname(p));
			 }
			 /* Flush input */
			 
			 mssleep(1000);
			 
			 SetStart();
			 while (state == XRecEnd)
				 if (Timeout(60)) {
					 log("Garbage on line");
					 state = Error;
					 break;
				 } else if (readline(1*1000) < 0) {
					 debug(1, "Line is clear, rec files");
					 state = RecFiles;
				 }
		 } else {
			 log("Receiving mail failed or nothing to receive");
			 if (config.save_bad_packets)
				 savebad(inpacket);
			 else
				 if (unlink(inpacket))
					 log("$Could not unlink packet %s", spoolname(inpacket));
			 state = Error;
		 }
		 break;
		 
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | R5* | RecFiles |                         | (BATCH rec files BR0)   | R6  |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
	 case RecFiles:
		 ok = recfiles(0);
		 state = ChkFiles;
		 break;

/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | R6  | ChkFiles | 1 BATCH recv successful | delay 2 secs            | R7  |
 * |     |          | 2 BATCH recv failed     | hang up, report bad file| exit|
 * |-----+----------+-------------------------+-------------------------+-----|
 */
	 case ChkFiles:
		 if (ok) {
			 log("Files received successfully");
			 mssleep(2000);
			 if (reverse_handshake
			     && fidonet_options.allowpickup) {
				 struct stat st;
				 char *cp;
				 /*
				  * Check if we have some packet waiting
				  * for this node.
				  */
				 cp = outgoing_mailpacket(remote_node);
				 if (cp && stat(cp, &st) != -1) {
					 if (st.st_size != EMPTY_PACKET_SIZE) {
						 /* The system we are talking
						    to */ 
						 remote_node = packet_fromnode;
						 state = WaitClear;
					 } else
						 state = Done; /* Packet, but empty */
				 } else {
					 boolean havefiles = False;
					 /*
					  * No mail packet, maybe there are
					  * files going out.
					  */
					 if (myopendir(nodepath(config.outfiles, remote_node), FALSE))
						 if (myreaddir(NULL))
							 havefiles = TRUE;
					 myclosedir();
					 if (havefiles)
						 state = WaitClear; /* We must go through SendMail */
					 else
						 state = Done; /* No packet at all */
				 }
				 if (cp)
					 free(cp);
				 if (state == Done)
					 sendline(ENQ);
			 } else
				 state = Done; /* We were calling */
		 } else {
			 log("Files not received ok");
			 state = Error;
		 }
		 break;

/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | R7  | AllowPkup| 1 have pickup for sender| receiver becomes sender | S3* |
 * |     |          | 2 nothing to pickup     | hang up, rept recv ok   | exit|
 * `-----+----------+-------------------------+-------------------------+-----'
 *
 *
 * No incoming call pickup in this version, ZMH mode is to make rfmail to
 * support ZMH, nothing else. If you need this, hack it and send diffs to me so
 * it can be merged with distribution. Thanks. I might do this myself, so check
 * out from me if later version does already include the code.
 *
 * You need to check out if calling system has mail.  This you can do by
 * picking up node information from firstblock structure, which should have
 * been collected by mail receiver, create the filename (sprintopacket) and see
 * if that file is there (access). Then use that filename and send it out
 * (state = SendMail).
 */
	 case AllowPickup:
		 state = SendMail;
		 break;
	

/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | S3  | WaitClear| 1 no input for 0.5 secs | send TSYNCH = AEH       | S4  |
 * |     |          | 2 over 60 seconds       | hang up, report garbage | exit|
 * |     |          |   and line not clear    |                         |     |
 * |-----+----------+-------------------------+-------------------------+-----|
 *
 * Modified to send TSYNCH or YOOHOO
 */
	 case WaitClear:
		 SetStart();
		 while (state == WaitClear)
			 if (Timeout(60)) {
				 log("Garbage on line");
				 state = Error;
				 break;
			 } else if (readline(config.waitclear*1000) < 0) {
				 if (try_yoohoo) {
					 debug(1, "Line is clear, send YOOHOO");
					 state = YOOHOO_Sender;
				 } else {
					 debug(1, "Line is clear, send TSYNCH");
					 sendline(TSYNCH);
					 state = TSyncChk;
				 }
			 }
		 break;

	 case YOOHOO_Sender:
		 switch (yoohoo_sender()) {
		 case -1:
			 log("YOOHOO handshake failed");
			 state = TSyncChk;
			 break;
		 case 1:
			 if (remote_capabilities & ZED_ZAPPER) {
				 log("WaZoo method: ZedZap");
				 state = ZedZap_Sender;
				 break;
			 }
		 default:
			 log("WaZoo method: DietIfna");
			 state = TSyncChk;
		 }
		 break;
	
/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | S4* | TSyncChk | 1 'C' or NAK (peeked at)| (XMODEM send packet XS1)| S5  |
 * |     |          | 2 over 2 seconds        | eat noise, resend TSYNCH| S4  |
 * |     |          | 3 over 30 seconds       | hang up report not Fido | exit|
 * |-----+----------+-------------------------+-------------------------+-----|
 */
	 case TSyncChk:
		 SetStart();
		 while (state == TSyncChk) {
			 c = readline(3*1000);
			 if (c == 'C' || c == NAK) {
				 putback(c);
				 state = SendMail;
			 } else if (Timeout(30)) {
				 log("Not Fidonet answer");
				 state = Error;
			 } else {
				 eatnoice();
				 sendline(TSYNCH);
			 }
		 }
		 break;

	 case SendMail:
		 outpacket = outgoing_mailpacket(remote_node);

		 ok = xtsend(outpacket, packetname, MAILTRANSFER);

		 /*
		  * Nonstandard: Try full handshake again if xmodem sender
		  * fails. Receiver might have missed our TSYNCH. This should
		  * be in xtsend though, now delay may be too long for receiver
		  * anyway.
		  */ 
		 if (!ok && receive_retrys--)
			 state = WaitClear;
		 else
			 state = CheckMail;
		 break;

/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | S5  | CheckMail| 1 XMODEM successful     | (Fido registers success)| S6  |
 * |     |          | 2 XMODEM fail or timeout| hang up, report mail bad| exit|
 * |-----+----------+-------------------------+-------------------------+-----|
 */
	 case CheckMail:
		 if (ok) {
			 log("Mail sent successfully");
			 savepacket(outpacket);
			 state = SendFiles;
		 } else {
			 log("Mail send failed");
			 state = Error;
		 }
		 break;

/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | S6* | SendFiles|                         | (BATCH send files BS0)  | S7  |
 * |-----+----------+-------------------------+-------------------------+-----|
 */
	 case SendFiles:
		 ok = sendfiles(0);
		 (void)sendreq(0);
		 state = CheckFile;
		 break;

/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | S7  | CheckFile| 1 BATCH send successful |                         | S8  |
 * |     |          | 2 BATCH send failed     | hang up, rept files fail| exit|
 * |-----+----------+-------------------------+-------------------------+-----|
 */
	 case CheckFile:
		 if (ok) {
			 log("Files sent successfully");
			 state = TryPickup;
		 } else {
			 log("Files not send ok");
			 state = Error;
		 }
		 break;

/*
 * |-----+----------+-------------------------+-------------------------+-----|
 * | S8  | TryPickup| 1 wish to pickup        | note send ok            | R2* |
 * |     |          | 2 no desire to pickup   | delay 5 secs            | exit|
 * |     |          |                         |   hang up, rept send ok |     |
 * `-----+----------+-------------------------+-------------------------+-----'
 */
	 case TryPickup:
		 log("Send successful");
		 if (fidonet_options.dopickup && !reverse_handshake) {
			 log("Starting mail pickup");
			 state = WaitTsync;
		 } else
			 state = Done;
		 break;

	 case ZedZap_Receiver:
		 if (zzreceiver())
			 state = Done;
		 else
			 state = Error;
		 break;

	 case ZedZap_Sender:
		 if (zzsender())
			 state = Done;
		 else
			 state = Error;
		 break;
		 
	 case Done:
	 case Error:
		 total_time = time(NULL) - start_time;
		 
		 if (state == Error) 
			 log("Conversation failed for %s",
			     			ascnode(remote_node));
		 else {
			 log("Conversation complete for %s",
			     			ascnode(remote_node));
			 if (call_node)
				 clear_call_status(*call_node);
		 }
		 
		 if (line >= 0) {
			 log("Conversation time %ld (not including dialup and termination)",
			     total_time);
			 log("Total data transmitted %ld, %ld bytes per second",
			     total_bytes,
			     total_time ? total_bytes/total_time : 0L);
			 if (reverse_handshake) {
				 /*
				  * We know there will be a hangup signal
				  * coming, thus ignore it so we can gracefully
				  * terminate. 
				  */
				 signal(SIGHUP, SIG_IGN);
				 
				 /* Drop the line. */
				 hangup(line);
				 carrier = FALSE;
				 
				 /*
				  * This delay is for directly connected
				  * fidonet system, binkleyterm doesn't notice
				  * too short loss of carrier, so help a bit.
				  */ 
				 sleep(3);
				 log("Hung up.");
			 }
		 }
	
		 state = Exit;
		 break;
	 }
        }
	 
	if (outpacket) {
		free(outpacket);
		outpacket = NULL;
	}

	/*
	 * Finish up our business with this line
	 */
	if (call_node && !reverse_handshake) /* JN */
		clear_node_lock(*call_node);
	if (line > 0) {
		if (line != -1) {
			new_undial(line);
			carrier = FALSE;
			line = -1;
		}
		return TRUE;
	}
	return FALSE;
}


/*
 * Do initializations for a news session
 */
static void
initsession()
{
	opacketseq = sequencer(config.opacketsequence);
	sprintf(packetname, "%08x.pkt", opacketseq); /* upper or lower case? */
	sprintf(ipacketname, "%08lx.in", sequencer(config.ipacketsequence));
}

/*
 * Try to setup communication channel to node "call_node"
 *
 * Return file descriptor for remote line, or
 * a negative error code (see dial.h)
 */
static int
dial_modem(call_node)
	Node call_node;
{
	Node *nodep;

	int retries;
	static char phonenumber[30];

	if (!(nodep = search_node(call_node, &remote_nodeentry)))
		fatal(EX_NOHOST, "Could not get remote node information for node %s", ascnode(call_node));
	remote_node = *nodep;
	remove_reqs();
	initsession();
  
	/*
	 * Setup speed to use for call.
	 */
	if (b_option_seen)
		speed = xmodem_options.speed;
	else {
		speed = remote_nodeentry.speed;
		if (speed > config.maxbaud)
			speed = config.maxbaud;
	}
	if (speed < config.minbaud) 
		return ILL_BD;
	
	baudrate = speed;

	/* Translate phone number from nodelist, if not set */
	if (!pflag) {
		dial_translation(phonenumber, remote_nodeentry.phone);
		telno = phonenumber;
	}
	sprintipacketname(ipacketname, remote_node);
	
	if (direct_line) {
		log("Using direct line %s", call_line);
		if ((line = open(*call_line == '/' ? call_line :
				 sprintfs("/dev/%s", call_line), O_RDWR, 0)) == -1)
			fatal(EX_OSFILE, "$Cannot open tty line given (%s)",
			      call_line);
		if (!get_terminal_state(line, &orgtblk))
			fatal(EX_OSFILE, "Cannot get terminal state");
		if (!set_terminal_state(line, &call_attr))
			fatal(EX_OSFILE, "Cannot set terminal state");
		calling = TRUE;
		carrier = TRUE;
		return line;
	} 

	/*
	 * Dial-up line.
	 * Obtain a line to dial out on, and dial.
	 */
	for (retries = 0; retries <= retry_count; retries++) {
		log("Dialing %s on %s", ascnode(call_node), telno);
		line = new_dial(telno, &call_attr, &remote_nodeentry);
		if (line > 0) {
			carrier = TRUE;
			break;
		}
		log_dialerr(line);
		switch (line) {
		case NO_ANS:	/* No answer */
		case NO_OCC:	/* Occupied */
			return line;

		case DV_NT_K:	/* requested device not known */
		case NO_BD_K:	/* no device known at requested baud */
		case DV_NT_A:	/* Device not available */
		case NO_BD_A:	/* No device at requested baud */
		case DIAL_BAD_SPEED:
		case DIAL_NO_CARRIER:
		case DIAL_RING:
		case DIAL_MODEM_ERROR:
		case DIAL_NO_DIALTONE:
		case L_PROB:
			if (wait_line) {
				log("No free lines, waiting %d seconds",
				    wait_line);
				sleep(wait_line);
				continue;
			}
			log("No free lines, connection attempt abandoned");
			return line;

		default:
			if (line < 0)
				fatal(EX_OSFILE, "Fatal error in dial.");
		}
		if (line > 0)
			break;
	}
	calling = TRUE;
	return line;
}


static void
usermessage(VOID)
{
	/* I guess we have correct bps rate here? */
	sendstring(sprintfs("rfmail %s at %s\r\n",
			    version, ascnode(config.mynode)));
	if (*config.login_path)
		sendstring("Send 'L' or ESC for login.\r\n");
	else
		sendstring("No login allowed, mail only.\r\n");
	
	sendstring("Fidonet Mail Receiver Ready..\r\n");
	
	debug(2, "Sent welcome, switching to WaitTsync");
	initsession();
}

static boolean
usersession(c)
	int c;
{
	int pid;
	char *tty;
	int fd;
	int status;

	debug(1, "Received login request '%s', exec'ing a login",
	      expand_char(c));
	
	if (!exit_after_session) {
		/* New process */
		pid = fork();
		if (pid == -1) {
			log("$Cannot fork for login");
			sendstring("Cannot fork for login, sorry\r\n");
			return FALSE;
		}
	} else
		pid = 0;

	if (pid) {
		/* Daddy */
		/* Don't care about signal returns, retry. Maybe a stupid
		   thing to do? */
		status = mywait(pid);
		
		/* We don't care about return values either. Child died,
		   R.I.P., whatever it did. */
	} else {

		/* hope your login is smart enough to ask for uid. */ 
		
		/* Presume current standard input & outputs are not on tty,
		   but on console. This should be the case when daemon is
		   invoked by cron, input/output is on console? */
		close(0);	/* Close ... */
		close(1);	/* ... all standard ... */ 
		close(2);	/* ... files, and open them to tty given */

		/* Standard input. */
		tty = (*call_line == '/'
		       ? call_line : sprintfs("/dev/%s", call_line));
		if (fd = open(tty, O_RDWR));
		if (fd != 0)
			fatal(EX_OSFILE, "$Cannot reopen standard input, got %d, expected 0",fd);

		/* Standard output. */
		if (open(tty, O_RDWR) != 1)
			fatal(EX_OSFILE, "$Cannot reopen standard output, got %d", fd);

		/* Standard error. */
		if (open(tty, O_RDWR) != 2)
			fatal(EX_OSFILE, "$Cannot reopen standard error, got %d", fd);
		  
		execlp(config.login_path, basename(config.login_path), 0);
		fatal(EX_OSERR, "$Exec failed");
	}
	return TRUE;
}


/*
 * Make a dummy packet in case we have no file to send
 */
int
build_header(packet)
	Uchar *packet;
{
	struct packet header;
	int count;
	struct tm *tm_s;
	time_t now = time(NULL);
	Uchar *pp = packet;

#define	PUTINT16(w)   *pp++ = (Uchar)(w); *pp++ = ((Uint)w) >> 8
	
	tm_s = localtime(&now);

	bzero((char *)&header, sizeof(header));	/* Just in case */
	
	/* create packet structure */
	header.orig.node = config.mynode.node;
	header.dest.node = remote_node.node;
	header.orig.net = config.mynode.net;
	header.dest.net = remote_node.net;
	
	/* save time for header (why all these fields?) */
	header.year = tm_s->tm_year + 1900;
	header.month = tm_s->tm_mon;
	header.day = tm_s->tm_mday;
	header.hour = tm_s->tm_hour + 1;
	header.minute = tm_s->tm_min;
	header.second = tm_s->tm_sec;
	
	header.rate = config.maxbaud;
	header.ver = HDRVER;
	header.prodcode = PRODUCTCODE;
	header.serialno = 0;
#ifdef FIDO_V11w
	for (count = 0; count < 16; count++)
		header.fill[count] = 0;
#else
	for (count = 0; count < 8; count++)
		header.passwd[count] = 0;
	header.orig.zone = config.mynode.zone;
	header.dest.zone = remote_node.zone;
#endif
	/* write header to file */
	PUTINT16(header.orig.node);
	PUTINT16(header.dest.node);
	PUTINT16(header.year);
	PUTINT16(header.month);
	PUTINT16(header.day);
	PUTINT16(header.hour);
	PUTINT16(header.minute);
	PUTINT16(header.second);
	PUTINT16(header.rate);
	PUTINT16(header.ver);
	PUTINT16(header.orig.net);
	PUTINT16(header.dest.net);
	*pp++ = header.prodcode;
	*pp++ = header.serialno;
	for (count = 0; count < 8; count++)
		*pp++ = header.passwd[count];
	PUTINT16(header.orig.zone);
	PUTINT16(header.dest.zone);
	for (count = 0; count < 16; count++)
		*pp++ = '\0';
	for (count = 0; count < 4; count++)
		*pp++ = '\0';
	return pp - packet;
}

/*
 * Save a bad file/packet into the badfiles directory.
 */
void
savebad(fname)
	char *fname;
{
	char badname[PATH_LEN];

	sprintf(badname, "%s/%s", config.badfiles, basename(fname));
	unique_name(badname);
	log("Saving bad file %s as %s", spoolname(fname), spoolname(badname));
	if (myrename(fname, badname)) {
		log("$Could not save bad file %s", spoolname(fname));
		if (unlink(fname))
			log("$Could not unlink file %s", spoolname(fname));
	}
}

/*
 * Dispose of a sent mail packet
 */
void
savepacket(fname)
	char *fname;
{
	char savename[PATH_LEN];

	if (fname && *fname) {
		if (config.save_sent_packets) {
			sprintf(savename, "%s/%s.%d", 
				nodepath(config.sentbundles, remote_node),
				basetype(fname), opacketseq);
			log("Moving mail packet %s to %s",
			    spoolname(fname), spoolname(savename));
			if (myrename(fname, savename)) {
				log("$Could not save mail packet %s",
				    spoolname(fname));
				if (unlink(fname))
					log("$Could not unlink packet %s",
					    spoolname(fname));
			}
		} else
			if (unlink(fname))
				log("$Could not unlink packet %s",
				    spoolname(fname));
	}
}

/*
 * Dispose of a sent file
 */
void
savefile(fname)
	char *fname;
{
	char savename[PATH_LEN];

	if (fname && *fname) {
		if (config.save_sent_files) {
			sprintf(savename, "%s/%s", config.sentfiles, basename(fname));
			unique_name(savename);
			log("Moving sent file %s to %s",
			    spoolname(fname), spoolname(savename));
			if (myrename(fname, savename)) {
				log("$Could not save sent file %s",
				    spoolname(fname));
				if (unlink(fname))
					log("$Could not unlink file %s",
					    spoolname(fname));
			}
		} else {
			if (unlink(fname))
				log("$Could not unlink file %s",
				    spoolname(fname));
		}
	}
}



/*
 * Create full path for an upload file
 * given the remote suggested filename.
 */
void
uploadpath(path, fname)
	char *path, *fname;
{
	if (is_mailpkt(fname) || is_req(fname))
		sprintf(path, "%s/%s",
			nodepath(config.indir, remote_node), fname);
	else
		sprintf(path, "%s/%s",
			nodepath(config.infiles, remote_node), fname);
}


/*
 * Get name of outgoing mail packet for a node
 * Returns NULL if no outgoing mail packet for node.
 * Return argument has to be freed by free()
 */
char *
outgoing_mailpacket(node)
	Node node;
{
	char path[PATH_LEN];
	char *ft;

	/*
	 * Try for file type .out, .cut, .dut and .hut
	 */
	sprintf(path, "%s.out", nodepath(config.outdir, node));
	ft = basetype(path);
	if (access(path, 4) != 0) {
		*ft = 'c';
		if (access(path, 4) != 0) {
			*ft = 'd';
			if (access(path, 4) != 0) {
				*ft = 'h';
				if (access(path, 4) != 0)
					return NULL;
			}
		}
	}
	return strsave(path);
}
