/*
 * $Header: /u1/src/rfmail/RCS/configs.h,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: configs.h,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.5  1991/09/07  10:37:46  pgd
 * not finished revision check-in
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

/*
 * Authors:
 *
 * Teemu Torma who wrote the original code (?)
 *
 * Heikki Suonsivu (hsu@hutcs.hut.fi) who made a lot of enhancements
 * 
 * Per Lindqvist (pgd@compuram.bbt.se) who continued to enhance rfmail.
 */

#define	CONFIG_VERSION	3

/*
 * File request modes
 */
#define	NONE_REQ	0	/* No file requests */
#define	PROT_REQ	1	/* Only from a password protected connection */
#define	KNOWN_REQ	2	/* Anyone known in nodelist can request */
#define	ANYONE_REQ	3	/* Anyone can request */

/*
 * Modem message types
 */
#define	MM_OK		1
#define	MM_NOCARRIER	2
#define	MM_ERROR	3
#define	MM_NODIALTONE	4
#define	MM_BUSY		5
#define	MM_NOANSWER	6
#define	MM_RING		7
#define	MM_RRING	8
#define	MM_CONNECT	9
#define	MM_JUNK		10

/*
 * Event options
 */
#define	EVENT_CM	1
#define	EVENT_NONCM	2
#define	EVENT_OBFREQ	4
#define	EVENT_IBFREQ	010
#define	EVENT_RECVONLY	020
#define	EVENT_DYNAMIC	040

#define	SUNDAY		0001
#define	MONDAY		0002
#define	TUESDAY		0004
#define	WEDNESDAY	0010
#define	THURSDAY	0020
#define	FRIDAY		0040
#define	SATURDAY       	0100

typedef enum {FTS0001, FSC0039, FSC0045, FSC0048 } Pkttype;
	
typedef struct {
  char echo[MAX_ECHOLEN];	/* Name of echo area */
  char ng[MAX_NGLEN];		/* Name of newsgroup */
  char distribution[MAX_DISTRIBUTION_LEN]; /* Distribution */
  boolean acceptprivate;	/* accept private messages */
  boolean trashprivate;		/* trash private messages */
  Node	my_address;		/* adress to be used as origin for */
				/* gated messages */ 
  char	nodes;			/* Number of distribution nodes */
  union {
	  char command[MAX_COMMAND_LEN]; /* command word */
	  Node node[MAX_NEWSGROUP_NODES];
  } u;
} Newsgroup;

struct routing_target {
	char tag;		/* Routine schedule tag */
	routing_type rtype;	/* type of routing (hash symbol) */
	char masks;		/* Number of masks */
	Node dest;		/* Destination node */
	char unixaddr[20];	/* unix routing target */
	Node mask[MAX_MASKS];
};

struct dest_info {
	Node masks[MAX_MASKS];	/* Nodes or mask for which info applies */
	int no_masks;		/* number of masks */
	Node my_address;	/* orig. address to be used for node */
	char passwd[PASSW_LEN]; /* packet password for dest */
	Pkttype pkttype;	/* packet type to be used for dest */
	int packer;		/* packer to be used (offset in packerinfo) */
};

struct pack_info {
	char name[NAME_LEN];	/* name used in rest of config for packer */
	char ext[EXT_LEN];	/* extension used by packer */
	int id_len;		/* lenght of packer identifier */
	int id_start;		/* offset in file for id */
	char id[ID_LEN];	/* identifier string */
	char extract_cmd[PATH_LEN];	/* extract command */
	char arc_cmd[PATH_LEN];	/* add command */
};	 	

/*
 * The configuration structure (file format)
 */
typedef struct {
  long version;			/* Version of configuration file */
  Node mynode;
  short myregion;
  Uint windows_at_2400;
  Uint max_send_ahead;
  boolean dobatch;
  boolean crdebug;
  int prewait;
  int waitclear;
  boolean save_arcmail;
  boolean save_bad_messages;
  boolean save_bad_packets;
  boolean save_unpacked_packets;
  boolean save_sent_packets;
  boolean save_sent_files;
  int max_send_retries;
  int maxbaud;
  int minbaud;
  int inbaud;
  int debuglevel;
  int max_linelen;
  char receive_path[RECEIVE_PATH_LEN];
  char fidonet_domain[DOMAIN_LEN];
  char spooldir[PATH_LEN];
  char unpacked[PATH_LEN];
  char sentbundles[PATH_LEN];
  char indir[PATH_LEN];
  char infiles[PATH_LEN];
  char outdir[PATH_LEN];
  char outfiles[PATH_LEN];
  char sentfiles[PATH_LEN];
  char msgdir[PATH_LEN];
  char libdir[PATH_LEN];
  char rnews[PATH_LEN];
  char logdir[PATH_LEN];	/* Directory where logfiles go */
  char orphans[PATH_LEN];
  char badfiles[PATH_LEN];
  char badarticles[PATH_LEN];
  char sequence[PATH_LEN];
  char idsequence[PATH_LEN];
  char ipacketsequence[PATH_LEN];
  char opacketsequence[PATH_LEN];
  char opackedmailsequence[PATH_LEN];
  char badsequence[PATH_LEN];
  int useruid;
  char alias[PATH_LEN];
  char rmail[PATH_LEN];
  boolean return_failed_mail;
  int dials;				/* Number of strings in dialtable */
  char dialtable[DIALS][DIALSTRING_LEN];
  int newsgroups;
  char origin[ORIGIN_LEN];
  Newsgroup ng[MAX_NEWSGROUPS];
  Node seenby[MAX_SEENBYS];
  int seenbys;
  Node aka[MAX_AKAS];			/* The akas */
  int akas;				/* Number of akas */
  char nodelist_name[PATH_LEN];		/* Name of the compiled nodelist */
  char nodelists;			/* Number of nodelists */
  char nodelist[MAX_NODELISTS][PATH_LEN]; /* Nodelist filenames */
  char systemlist[MAX_SYSTEMLISTS][PATH_LEN]; /* System lists */
  char systemlists;			/* Number of system lists */
  short country;		/* Country-code */
  Ushort include_zone[MAX_ZONES]; /* Zones to include in the nodelist */
  Ushort exclude_zone[MAX_ZONES]; /* Zones to exclude from the nodelist */
  struct {
	  Ushort zone;
	  Ushort net;
  } include_net[MAX_NETS], exclude_net[MAX_NETS];
  Uchar include_zones, exclude_zones;
  Uchar include_nets, exclude_nets;
  boolean use_internal_dial;
  int dial_modem_delay;
  int dial_retries;
  char dial_initstring[PATH_LEN];
  char dial_initreply[PATH_LEN];
  time_t dial_inittimeout;
  char dial_prefix[PATH_LEN];
  char dial_trailer[PATH_LEN];
  char dial_connect[PATH_LEN];
  time_t dial_timeout;
  char lockdir[PATH_LEN];	/* Directory to put lock files in */
  char locks[PATH_LEN];
  time_t lock_timeout;
  time_t lock_sleep;

  /* Routing information */
  int targets;			/* Number of targets */
  struct routing_target routing[MAX_TARGETS];
  int dests;			/* number of destinations */
  struct dest_info destinfo[MAX_TARGETS];
  int packers;			/* number of packers */
  struct pack_info packerinfo[MAX_PACKERS];
  boolean dopickup;
  boolean allowpickup;
  boolean sealink;
  boolean forcecrc;
  int checksum_fallback;
  time_t sleeptime;
  boolean quicknak;
  char admin[PATH_LEN];
  boolean transfer_ack_numbered;
  boolean quick_whack;
  boolean telinkmail;
  char init_script[SCRIPT_LEN];
  char dialers[PATH_LEN];
  char dial_script[SCRIPT_LEN];
  time_t script_timeout;
  char login_path[PATH_LEN];
  char system_name[SYSTEM_NAME_LEN];
  char sysop_name[SYSOP_NAME_LEN];
  char tmpdir[PATH_LEN];
  int file_request_mode;
  char file_request_dir[PATH_LEN];
  char file_request_files[PATH_LEN];
  char file_request_about[PATH_LEN];
  char file_request_list[PATH_LEN];
  char file_request_alias[PATH_LEN];
  int file_request_max_size;
  int file_request_max_files;
  char devices[PATH_LEN];
  char mailname[MAILNAME_LEN];
  char file_owner[8];		/* File creation user id */
  char file_group[8];		/* File creation group id */
  int file_mode;		/* File creation mode */
  int retry_max;
  int retry_interval;
  int retry_sleeptime;
  int retry_count;
  int retry_time;
  boolean internet_gateway;
  struct modem_struct {
	  char	name[14];		/* Name of modem */
	  Ushort interface_speed;	/* Interface speed or 0 for auto */
	  Ushort speeds;		/* Speeds, bsd bitmap format */
	  Ulong modemcap;		/* Modem capabilities bitmap */
	  Ushort dial_rate;		/* Rate for dialling */
	  char	init[40];		/* Modem init string */
	  char	dial_prefix[40];	/* Modem dial prefix */
	  char	dial_suffix[40];	/* Modem dial suffix */
	  struct {
		  Uint type:4; 	/* Message type */
		  Uint misc:12;
		  Uint flags:16;	/* Message flags */
		  char msg[32];
	  } message[MAX_MODEM_MESSAGES];
	  Uchar messages;		/* Number of modem messages */
  } modem[MAX_MODEMS];
  Uchar modems;			/* Number of modems in table */

  struct line_struct {
	  char	device[40];		/* Device */
	  Uchar modem;			/* Index into modem table */
  } line[MAX_LINES];
  Uchar lines;				/* Number of lines in table */

  Ulong modem_search_order[16];	/* Search-order for modems */

  char ungetty_path[PATH_LEN];		/* Path to ungetty program */

  char include[MAX_INCLUDES][PATH_LEN]; /* list of include files */
  Uchar includes;			/* Number of include files */

  struct event {
	  Uchar	tag;		/* schedule tag */
	  Uchar	days;		/* Days in week */
	  Ushort	start;		/* Start time */
	  Ushort	end;		/* End time */
	  Ushort	options;	/* Event options */
  } event[MAX_EVENTS];
  Uint events;

} config_t;

extern config_t config;
extern char *configfile;

