/*LINTLIBRARY*/
/* interpret configuration file */
/*
 * $Header: /u1/src/rfmail/RCS/config.c,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: config.c,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.5  1991/09/07  10:37:46  pgd
 * not finished revision check-in
 *
 * Fixed bug where schedule was set to random at initialization.
 *
 * Revision 0.4.1.3  1991/06/15  09:33:39  pgd
 * *** empty log message ***
 *
 * Made all references relative to LIBDIR SPOOLDIR
 *
 * Revision 0.4.1.2  1991/06/05  09:13:58  pgd
 * Various Bugfixes:
 *
 * localfgets has to check for NULL returned by fgets.
 *
 * Revision 0.4.1.1  1991/05/21  11:13:48  pgd
 * *** empty log message ***
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 *
 */


/*
 * Authors:
 *
 * Teemu Torma who wrote the original code (?)
 *
 * Heikki Suonsivu (hsu@hutcs.hut.fi) who made a lot of enhancements
 * 
 * Per Lindqvist (pgd@compuram.bbt.se) who continued to enhance rfmail.
 */

#include "fnet.h"

#ifdef FCNTL
#include <fcntl.h>
#endif

#include <sys/stat.h>

#include "nodelist.h"
#include "configs.h"
/* #include "dynamic.h" */
#include "config-hash.h"
#include "routing-hash.h"
#include "packet-hash.h"
#include "packer-hash.h"
#include "key-hash.h"

#define its(s) (!strcmp(p, s))

#ifdef XENIX
DECLARE(int, stat, (char *, struct stat *));
#endif

LDECLARE(Node, scannode, (void));
LDECLARE(int, scanlist, (char *, Node, Node *, boolean));
LDECLARE(void, process_routing, (void));
LDECLARE(void, process_key, (void));
LDECLARE(void, process_packer, (void));
LDECLARE(char *, getstring, (int));
LDECLARE(char *, getstring, (int));
LDECLARE(char *, getrestofline, (int));
LDECLARE(void, parse_newsgroups, (void));
LDECLARE(boolean, has_packer, (Node));
DECLARE(void, printusage, (FILE *));
DECLARE(void, configprintusage, (FILE *));

static int configline;
extern char newline_string[];
char *configfile = CONFIGFILE;		/* Name of configuration file */
static boolean gotnodelist;
boolean hasconfig = FALSE;
char *progname;				/* Program name. Handy to have */
boolean have_verbose;			/* Indicates that verbose is valid */
int verbose;				/* Verbosity level */
					/*  */
int inclno = 0;				/* Number of current include file */
FILE *configfp[MAX_INCLUDES+1];
extern boolean allow_address_wildcards;

config_t config;

static char *modemflags[] = {
	"bell300", "v21", "bell212", "v22", "v22b", "v23", "v29",
	"v32", "v32b", "v33",
	"v34", "v42", "v42b", "mnp",  "h96", "hst", "max", "pep",  "csp",
	0};
static Ulong modemflagvals[] = {
	BELL300, V21,   BELL212, V22,   V22b,   V23,   V29,
	V32,   V32b,   V33,
	V34,   V42,   V42b,   MNP,   H96,   HST,   MAX,    PEP,    CSP};
static char *modem_message_strings[] = {
	"ok", "nocarrier", "error", "nodialtone",
	"busy", "noanswer", "ring", "rring", "connect", "junk",
	"300", "600", "1200", "2400",
	"4800", "9600", "19200", "38400",
	"v21", "v22", "v22b", "v23",
	"v29", "v32", "v32b", "v33",
	"v34", "v42", "v42b", "mnp",
	"h96", "hst", "max", "pep", "csp",
	0};
static Ushort modem_message_type[] = {
	MM_OK, MM_NOCARRIER, MM_ERROR, MM_NODIALTONE,
	MM_BUSY, MM_NOANSWER, MM_RING, MM_RRING, MM_CONNECT, MM_JUNK,
	300, 600, 1200, 2400,
	4800, 9600, 19200, 38400,
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 0, 0};
static Ushort modem_message_flags[] = {
	0, 0, 0, 0,
	0, 0, 0, 0, 0,
	0, 0, 0, 0,
	0, 0, 0, 0,
	V21, V22, V22b, V23,
	V29, V32, V32b, V33,
	V34, V42, V42b, MNP,
	H96, HST, MAX, PEP, CSP};

static char *event_days[] = {
	"all",	"weekdays",	"weekend",
	"sun",	"mon",	"tue",	"wed",	"thu",	"fri",	"sat",	"sun", 0};
static Uchar event_dayvals[] = {
	MONDAY|TUESDAY|WEDNESDAY|THURSDAY|FRIDAY|SATURDAY|SUNDAY,
	MONDAY|TUESDAY|WEDNESDAY|THURSDAY|FRIDAY,
	SATURDAY|SUNDAY,
	MONDAY, TUESDAY, THURSDAY, WEDNESDAY, FRIDAY, SATURDAY, SUNDAY};

static char *event_flags[] = {
	"cm",     "noncm",     "obfreq",    "ibfreq",     "recvonly",
	"dynamic", 0};
static Uchar event_flagvals[] = {
	EVENT_CM, EVENT_NONCM, EVENT_OBFREQ, EVENT_IBFREQ, EVENT_RECVONLY,
	EVENT_DYNAMIC};

/*
 * Configuration error
 */
static void conferror(char *, ...);

#ifdef __STDC__
static void
conferror(char *fmt, ...)
#else
static void
conferror(fmt VA_ALIST)
	char *fmt;
	VA_DCL
#endif
{
	va_list args;

	VA_START(args, fmt);
	fprintf(stderr, "rfmail fatal configuration file, line %d:\n",
		configline);
	vfprintf(stderr, fmt, args);
	putc('\n', stderr);
	exit(EX_OSFILE);
	va_end(args);
}



/* Searches char * table for string */

int
listscan(list, search)
	register char **list;
	char *search;
{
	register int i;
  
	for (i = 0; list[i]; i++)
		if (strequ(list[i], search))
			return i;
	return -1;
}

/*
 * Return a pointer to next word
 */
static char *
getstring(len)
	int len;
{
	char *p;

	p = strtok(NULL, SEPARATORS);
	if (p == NULL)
		return NULL;
	if (len && strlen(p) > len - 1)
		conferror("String too long: %s", p);
	return p;
}


long
getlong()
{
	char *p;
	register char *cp;
  
	p = getstring(0);
	if (p == NULL)
		conferror("Illegal number");
	for (cp = p; *cp; cp++)
		if (!isdigit(*cp) && cp == p && *cp != '-')
			conferror("Illegal digit in statement");
	return atol(p);
}

int
getint()
{
	long longvalue;
  
	longvalue = getlong();
	if ((int) longvalue != longvalue)
		conferror("Reading integer: %ld too large to fit in an integer?", longvalue);
	return (int) longvalue;
}

/*
 * Convert hexadecimal asicii character to it's value
 */
static int
hexchartoval(c)
	register char c;
{
	switch(c)
	{
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
		return c - '0';
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
		return c - 'a' + 10;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
		return c - 'A' + 10;
	default:
		conferror("Ilegal character in hexadecimal number");
	}
}

/*
 * Check if a string is a legal numeric string
 * Give error if not.
 */
static void
checknumeric(s)
	register char *s;
{
	while (isspace(*s))
		s++;
	if (isdigit(*s)) {
		while (isdigit(*s))
			s++;
		while (isspace(*s))
			s++;
		if (*s == 0)
			return;
	}
	conferror("Illegal number: %s", s);
}


/*
 * Get an octal value
 */
int
getoct()
{
	char *s, *cp;
	int o, c;

	cp = s = getstring(10);
	if (s == NULL)
		conferror("Illegal number");
	o = 0;
	while (c = *cp++) {
		if (c < '0' || c > '7')
			conferror("Illegal octal number %s", s);
		o = o * 8 + c - '0';
	}
	return o;
}


#define TIME_SEPARATORS " ,;\015\012\011:"

time_t
gettime()
{
	register char *p;
	time_t total_time_value = 0;

	total_time_value = (time_t) getlong();
	
	p = getstring(0);
	if (p == NULL)
		conferror("Illegal time");
	/* Could be smarter with minute <-> minutes, but you loose. */
	if (its("minutes") || its("minute") || its("min") || its("m")) 
		return 60 * total_time_value;
	else if (its("hours") || its("hour") || its("h") || its("hr")) 
		return 60 * 60 * total_time_value;
	else if (its("days") || its("day") || its("d"))
		return 24 * 60 * 60 * total_time_value;
	else if (its("sec") || its("seconds") || its("second") || its("s")) 
		return total_time_value;
	else
		conferror("Bad time specifier '%s'", p);
}

/*
 * Convert ascii to time of day spec. (minutes since midnight)
 */
static Uint
cvttotime(s)
	char *s;
{
	register int n;
	register char *cp = s;

	n = 0;
	if (!isdigit(*cp))
		goto bad;
	while (isdigit(*cp))
		n = n * 10 + *cp++ - '0';
	if (*cp++ != ':')
		goto bad;
	if (!isdigit(*cp))
		goto bad;
	n *= 60;
	while (isdigit(*cp))
		n = n * 10 + *cp++ - '0';
	if (*cp == 0)
		return n;
 bad:
	conferror("Bad time specification: %s", s);
	
}

/*
 * Strip trailing slash from pathname
 */
static void
strip_trailing_slash(s)
	char *s;
{
	char *cp;

	if (strlen(s))
		if ( *(cp = s + (strlen(s) - 1)) == '/')
			*cp = 0;

}

/* Get an absolute path. Require initial '/'! */

char *
get_absolute_path(maxlen)
	int maxlen;
{
	char *p;

	p = getstring(maxlen);
	if (p == NULL)
		return "";
	if (*p != '/')
		conferror("Expect absolute path, got '%s'", p);
	strip_trailing_slash(p);
	return p;
}


/* Get a path, and cat default_directory_path if no path from root is given. */

char *default_directory_path;

char *
getpath()
{
	char *p, *add, *cp;
	int noslash;

	p = getstring(PATH_LEN);
	if (p == NULL)
		return "";
	
	if (*p != '/')
		add = default_directory_path;
	else
		add = "";
	if (strlen(p) + strlen(add) >= PATH_LEN - 1)
		conferror("Too long string in config (%s)", p);
	
	/* Move string 'up' to fit in default_directory_path */
	
	noslash = (add[strlen(add) - 1] != '/');
	nstrcpy(p + strlen(add) + noslash, p);

	/* Copy default_directory_path, excluding terminating nul */
	
	for (cp = p; *add; )
		*cp++ = *add++;
	if (noslash)
		*cp = '/';
	strip_trailing_slash(p);
	return p;
}

/*
 * Return a pointer to the rest of the line
 * Argument is max length of string (including the terminating null)
 * Trailing and leading blanks are stripped
 */
static char *
getrestofline(len)
	int len;
{
	register char *p, *cp;

	p = strtok(NULL, "");
	if (p == NULL)
		return "";
	while (isspace(*p) || *p == '\t')
		p++;
	if (len && strlen(p) > len - 1)
		conferror("String too long: -%s- (max: %d chars)", p, len);
	cp = strend(p);
	while (cp > p && isspace(cp[-1]))
		*--cp = 0;
	return p;
}

static boolean
gettruth()
{
	char *p;
	static char *trues[] = { "yes", "ok", "true", "1", "y", "on", 0 };
	static char *falses[] = { "no", "false", "0", "n", "none", "off", 0 };

	p = getstring(10);
	if (p == NULL)
		return TRUE;
	strlwr(p);
	if (listscan(trues, p) != -1)
		return TRUE;
	if (listscan(falses, p) != -1)
		return FALSE;
	conferror("Suspicious word of truth in config (%d): %s, returning true",
		  p, configline);
}

/* 
 * Like fgets, but no \n is returned 
 * Also un-nests include files.
 */
static char *
getline(buffer, size)
	char *buffer;
	int size;
{
	char *p, *p1;

	if (inclno < 0)
		return NULL;
	while ((p = fgets(buffer, size, configfp[inclno])) == NULL) {
		fclose(configfp[inclno]);
		if (--inclno < 0)
			return NULL;
	}
	p1 = strend(p);
	if (p1 > p && p1[-1] == '\n')
		*--p1 = 0;
	return p;
}

#ifdef NEEDED
/* Create a table of character strings. */
struct {
  char **table;
  int size, allocated_size;
} table;

do_table()
{
	register int count;
	register char *p;
  
	if (!table.table)
		initialize_array(table, 8, char **);
	clean_array(table);
  
	while (p = getstring(BUFSIZ)) {
		expand_array(table, count, char **);
		table.table[count] = p;
	}
}
#endif

static void
config_setdefaults()
{
	bzero((char *)&config, sizeof(config));

	configline = 0;

	default_directory_path = "";
  
	config.crdebug = FALSE;
	config.windows_at_2400 = 6;
	config.max_send_ahead = 800;
	config.dobatch = FALSE;
	config.prewait = 5;
	config.waitclear = 2;
	config.max_send_retries = 1;
	config.maxbaud = 1200;
	config.minbaud = 1200;
	config.inbaud = 9600;
	config.max_linelen = 78;
	*config.receive_path = 0;
	strcpy(config.fidonet_domain, ".fidonet");
	sprintf(config.spooldir,	"%s/",			SPOOLDIR);
	*config.unpacked = 0;
	*config.sentbundles = 0;
	*config.sentfiles = 0;
	*config.indir = 0;
	*config.infiles = 0;
	*config.outdir = 0;
	*config.outfiles = 0;
	*config.msgdir = 0;
	*config.logdir = 0;
	*config.badarticles = 0;
	*config.tmpdir = 0;
	*config.badfiles = 0;
	*config.file_request_dir = 0;
	config.save_arcmail = FALSE;
	config.save_unpacked_packets = FALSE;
	config.save_sent_packets = FALSE;
	config.save_sent_files = FALSE;

	strcpy(config.libdir, LIBDIR);
	*config.orphans = 0;
	*config.sequence = 0;
	*config.idsequence = 0;
	*config.ipacketsequence = 0;
	*config.opacketsequence = 0;
	*config.opackedmailsequence = 0;
	*config.badsequence = 0;
	*config.alias = 0;
	*config.nodelist[0] = 0;
	*config.nodelist_name = 0;

	*config.file_request_dir = 0;
	strcpy(config.rnews, 		"/usr/bin/rnews");
	config.save_bad_messages = TRUE;
	config.save_bad_packets = FALSE;
	config.useruid = 50;
	strcpy(config.rmail, "/bin/rmail");
	config.return_failed_mail = TRUE;
	config.dials = 0;
	config.newsgroups = 0;
	strcpy(config.origin, "");
	config.seenbys = 0;
	config.lock_timeout = 600;
	config.lock_sleep = 5;
	config.targets = 0;
	config.dests = 0;
	config.packers = 0;
	config.dopickup = TRUE;
	config.allowpickup = TRUE;
	config.sealink = TRUE;
	config.forcecrc = FALSE;
	config.quicknak = FALSE;
	*config.admin = 0;
	config.transfer_ack_numbered = FALSE;
	config.quick_whack = TRUE;
	config.telinkmail = TRUE;
	*config.init_script = '\0';
	*config.dial_script = '\0';
	*config.login_path = '\0';
	*config.sysop_name = '\0';
	*config.system_name = '\0';
	config.nodelists = 1;
	gotnodelist = FALSE;
	config.country = 0;
	config.include_zones = config.exclude_zones = 0;
	config.include_nets = config.exclude_nets = 0;

	config.systemlist[0][0] = 0;
	config.systemlists = 0;

	config.checksum_fallback = 6;
	config.use_internal_dial = TRUE;
	config.dial_modem_delay = 10;
	config.dial_retries = 2;
	strcpy(config.dialers, 		"/usr/lib/uucp/Dialers");
	strcpy(config.devices, 		"/usr/lib/uucp/Devices");
	config.script_timeout = 30;
	*config.lockdir = 0;
	*config.locks = 0;
	config.file_request_mode = NONE_REQ;
	*config.file_request_files = 0;
	*config.file_request_about = 0;
	*config.file_request_list = 0;
	*config.file_request_alias = 0;
	config.file_request_max_files = 0;
	config.file_request_max_size = 0;
	strcpy(config.file_owner, "uucp");
	strcpy(config.file_group, "uucp");
	config.file_mode = 0660;
	config.retry_max = 5;
	config.retry_interval = 15;
	config.retry_sleeptime = 300;
	config.retry_count = 2;
	config.retry_time = 30;
	config.internet_gateway = FALSE;

	config.modems = 0;
	config.lines = 0;
	/*
	 * Default modem search order
	 */
	config.modem_search_order[0] = PEP;
	config.modem_search_order[1] = V32b;
	config.modem_search_order[2] = MAX;
	config.modem_search_order[3] = CSP;
	config.modem_search_order[4] = HST;
	config.modem_search_order[5] = V32;
	config.modem_search_order[6] = V29;
	config.modem_search_order[7] = V23;
	config.modem_search_order[8] = V22b;
	config.modem_search_order[9] = V22;
	config.modem_search_order[10] = V21;
	config.modem_search_order[11] = 0;

	config.ungetty_path[0] = 0;
	config.dial_timeout = 60; 	/* Default timeout 60 seconds  */

	config.includes = 0;		/* No include files */
	config.events = 0;		/* No events initially */
}

static void
config_fixdefaults()
{
	if (*config.unpacked == 0)
		sprintf(config.unpacked,    "%s/unpacked", config.spooldir);
	if (*config.sentbundles == 0)
		sprintf(config.sentbundles, "%s/sentbundles", config.spooldir);
	if (*config.sentfiles == 0)
		sprintf(config.sentfiles,   "%s/sentfiles", config.spooldir);
	if (*config.indir == 0)
		sprintf(config.indir,       "%s/in", config.spooldir);
	if (*config.infiles == 0)
		sprintf(config.infiles,     "%s/infiles", config.spooldir);
	if (*config.outdir == 0)
		sprintf(config.outdir,      "%s/out", config.spooldir);
	if (*config.outfiles == 0)
		sprintf(config.outfiles,    "%s/outfiles", config.spooldir);
	if (*config.msgdir == 0)
		sprintf(config.msgdir,      "%s/msg", config.spooldir);
	if (*config.logdir == 0)
		sprintf(config.logdir,      "%s/log", config.spooldir);
	if (*config.badarticles == 0)
		sprintf(config.badarticles, "%s/bad", config.spooldir);
	if (*config.tmpdir == 0)
		sprintf(config.tmpdir,      "%s/tmp", config.spooldir);
	if (*config.badfiles == 0)
		sprintf(config.badfiles,    "%s/bad", config.spooldir);
	if (*config.file_request_dir == 0)
		sprintf(config.file_request_dir, "%s/files", config.spooldir);

	if (*config.orphans == 0)
		sprintf(config.orphans,     "%s/orphans", config.libdir);
	if (*config.sequence == 0)
		sprintf(config.sequence,    "%s/seq", config.libdir);
	if (*config.idsequence == 0)
		sprintf(config.idsequence,  "%s/idseq", config.libdir);
	if (*config.ipacketsequence == 0)
		sprintf(config.ipacketsequence, "%s/ipacketseq", config.libdir);
	if (*config.opacketsequence == 0)
		sprintf(config.opacketsequence, "%s/opacketseq", config.libdir);
	if (*config.opackedmailsequence == 0)
		sprintf(config.opackedmailsequence, "%s/opackedmailseq", config.libdir);
	if (*config.badsequence == 0)
		sprintf(config.badsequence, "%s/badseq", config.libdir);
	if (*config.alias == 0)
		sprintf(config.alias, "%s/Alias", config.libdir);
	if (*config.nodelist[0] == 0)
		sprintf(config.nodelist[0], "%s/nodelist.*", config.libdir);
	if (*config.nodelist_name == 0)
		sprintf(config.nodelist_name, "%s/nodelist.bin", config.libdir);

}


void
read_configuration()
{
  char buffer[BUFSIZ];
  char *p;
  register int hash;
  int n, i, j, msgno;
  Node tmpnode;
  struct modem_struct *mp;

  config_setdefaults();

  if ((configfp[inclno] = fopen(configfile, "r")) == NULL)
	  conferror("Cannot open config file %s", configfile);
      
  while (getline(buffer, BUFSIZ)) {
	  configline++;
	  
	  p = strtok(buffer, SEPARATORS);
	  
	  /* Empty lines are silently skipped  */
	  if (p == NULL)
		  continue;
	  
	  /* Skip comment lines */
	  if (*p == '#') continue;

	  hash = config_hash_function(p);

	  switch (hash) {
	  case CONFIG_DEBUGLEVEL:
		  config.debuglevel = getint();
		  if (!have_verbose)
			  verbose = config.debuglevel;
		  break;

	  case CONFIG_WINDOWS_AT_2400:
		  config.windows_at_2400 = getint();
		  break;

	  case CONFIG_MAX_SEND_AHEAD:
		  config.max_send_ahead = getint();
		  break;

	  case CONFIG_DOBATCH:
		  config.dobatch = gettruth();
		  break;

	  case CONFIG_CRDEBUG:
		  config.crdebug = gettruth();
		  break;

	  case CONFIG_SAVE_ARCMAIL:
		  config.save_arcmail = gettruth();
		  break;

	  case CONFIG_SAVE_BAD_PACKETS:
		  config.save_bad_packets = gettruth();
		  break;

	  case CONFIG_SAVE_BAD_MESSAGES: 
		  config.save_bad_messages = gettruth();
		  break;

	  case CONFIG_SAVE_UNPACKED_PACKETS:
		  config.save_unpacked_packets = gettruth();
		  break;

	  case CONFIG_SAVE_SENT_PACKETS:
		  config.save_sent_packets = gettruth();
		  break;

	  case CONFIG_SAVE_SENT_FILES:
		  config.save_sent_files = gettruth();
		  break;

	  case CONFIG_MYNODE:
		  if (!parsenode(p = getstring(BUFSIZ), &config.mynode, NULL, NULL))
			  conferror("Cannot parse my node address %s", p);
		  if (config.mynode.zone == NOZONE
		      || config.mynode.net == NONET
		      || config.mynode.node == NONODE)
			  conferror("Mynode must be fully specified: %s", p);
		  break;

	  case CONFIG_MYREGION:
		  config.myregion = getint();
		  break;

	  case CONFIG_PREWAIT:
		  config.prewait = getint();
		  break;

	  case CONFIG_WAITCLEAR:
		  config.waitclear = getint();
		  break;

	  case CONFIG_MAX_SEND_RETRIES:
		  config.max_send_retries = getint();
		  break;

	  case CONFIG_MAXBAUD:
		  n = getint();
		  if (n == 0 || baud_to_bsdbaud(n) == 0)
			  conferror("Illegal baudrate: %d", n);
		  config.maxbaud = n;
		  break;
		  
	  case CONFIG_MINBAUD:
		  n = getint();
		  if (n == 0 || baud_to_bsdbaud(n) == 0)
			  conferror("Illegal min baud: %d", n);
		  config.minbaud = n;
		  break;

	  case CONFIG_INBAUD:
		  n = getint();
		  if (n == 0 || baud_to_bsdbaud(n) == 0)
			  conferror("Illegal inbaud: %d", n);
		  config.inbaud = n;
		  break;

	  case CONFIG_MAX_LINE_LEN:
		  config.max_linelen = getint();
		  break;

	  case CONFIG_RECEIVE_PATH:
		  strcpy(config.receive_path, getrestofline(RECEIVE_PATH_LEN));
		  break;

	  case CONFIG_FIDONET_DOMAIN:
		  strcpy(config.fidonet_domain, getrestofline(0));
		  break;

	  case CONFIG_SPOOLDIR:
		  strcpy(config.spooldir, get_absolute_path(PATH_LEN));
		  default_directory_path = config.spooldir;
		  break;

	  case CONFIG_BADFILES:
		  strcpy(config.badfiles, getpath());
		  break;

	  case CONFIG_BADARTICLES:
		  strcpy(config.badarticles, getpath());
		  break;

	  case CONFIG_UNPACKED:
		  strcpy(config.unpacked, getpath());
		  break;

	  case CONFIG_SENTBUNDLES:
		  strcpy(config.sentbundles, getpath());
		  break;

	  case CONFIG_SENTFILES:
		  strcpy(config.sentfiles, getpath());
		  break;

	  case CONFIG_INDIR:
		  strcpy(config.indir, getpath());
		  break;

	  case CONFIG_INFILES:
		  strcpy(config.infiles, getpath());
		  break;

	  case CONFIG_OUTDIR:
		  strcpy(config.outdir, getpath());
		  break;

	  case CONFIG_MSGDIR:
		  strcpy(config.msgdir, getpath());
		  break;

	  case CONFIG_OUTFILES:
		  strcpy(config.outfiles, getpath());
		  break;

	  case CONFIG_LIBDIR:
		  strcpy(config.libdir, get_absolute_path(PATH_LEN));
		  default_directory_path = config.libdir;
		  break;

	  case CONFIG_LOGDIR:
		  strcpy(config.logdir, getpath());
		  break;

	  case CONFIG_NODELIST:
		  if (!gotnodelist) {
			  config.nodelists = 0;
			  gotnodelist = TRUE;
		  }
		  if (config.nodelists >= MAX_NODELISTS-1)
			  conferror("This version is configured for a maximum of %d nodelists,", MAX_NODELISTS);
		  strcpy(config.nodelist[config.nodelists++], getpath());
		  break;

	  case CONFIG_SYSTEMLIST:
		  if (config.systemlists >= MAX_SYSTEMLISTS-1)
			  conferror("This version is configured for a maximum of %d systemlists,", MAX_SYSTEMLISTS);
		  strcpy(config.systemlist[config.systemlists++], getpath());
		  break;

	  case CONFIG_NODELIST_NAME:
		  strcpy(config.nodelist_name, getpath());
		  break;
		  
	  case CONFIG_COUNTRY:
		  config.country = getint();
		  break;

	  case CONFIG_INCLUDE_ZONE:
		  config.include_zones = 0;
		  while (p = getstring(0)) {
			  checknumeric(p);
			  if (config.include_zones > MAX_ZONES)
				  conferror("This version is configured for a maximum of %d zones,", MAX_ZONES);
			  config.include_zone[config.include_zones++] = atoi(p);
		  }
		  break;

	  case CONFIG_EXCLUDE_ZONE:
		  config.exclude_zones = 0;
		  while (p = getstring(0)) {
			  checknumeric(p);
			  if (config.exclude_zones > MAX_ZONES)
				  conferror("This version is configured for a maximum of %d zones,", MAX_ZONES);
			  config.exclude_zone[config.exclude_zones++] = atoi(p);
		  }
		  break;


	  case CONFIG_INCLUDE_NET:
		  config.include_nets = 0;
		  while (p = getstring(0)) {
			  if (config.include_nets > MAX_NETS)
				  conferror("This version is configured for a maximum of %d nets,", MAX_NETS);
			  if (!parsenode(p, &tmpnode, NULL, NULL)
			      || tmpnode.node != NONODE
			      || tmpnode.point != NOPOINT
			      || tmpnode.zone == NOZONE
			      || tmpnode.net == NONET)
				  conferror("Illegal net address %s", p);
			  config.include_net[config.include_nets].zone
				  = tmpnode.zone;
			  config.include_net[config.include_nets].net
				 = tmpnode.net;
			  config.include_nets++;
		  }
		  break;

	  case CONFIG_EXCLUDE_NET:
		  config.exclude_nets = 0;
		  while (p = getstring(0)) {
			  if (config.exclude_nets > MAX_NETS)
				  conferror("This version is configured for a maximum of %d nets,", MAX_NETS);
			  if (!parsenode(p, &tmpnode, NULL, NULL)
			      || tmpnode.node != NOZONE
			      || tmpnode.point != NOPOINT
			      || tmpnode.zone == NOZONE
			      || tmpnode.net == NONET)
				  conferror("Illegal net address %s", p);
			  config.exclude_net[config.exclude_nets].zone
				  = tmpnode.zone;
			  config.exclude_net[config.exclude_nets].net
				 = tmpnode.net;
			  config.exclude_nets++;
		  }
		  break;

	  case CONFIG_SEQUENCE:
		  strcpy(config.sequence, getpath());
		  break;

	  case CONFIG_IDSEQUENCE:
		  strcpy(config.idsequence, getpath());
		  break;

	  case CONFIG_IPACKETSEQUENCE:
		  strcpy(config.ipacketsequence, getpath());
		  break;

	  case CONFIG_OPACKETSEQUENCE:
		  strcpy(config.opacketsequence, getpath());
		  break;

	  case CONFIG_OPACKEDMAILSEQUENCE:
		  strcpy(config.opackedmailsequence, getpath());
		  break;

	  case CONFIG_BADSEQUENCE:
		  strcpy(config.badsequence, getpath());
		  break;

	  case CONFIG_ALIAS:
		  strcpy(config.alias, getpath());
		  break;

	  case CONFIG_DIALERS:
		  strcpy(config.dialers, getpath());
		  break;

	  case CONFIG_DEVICES:
		  strcpy(config.devices, getpath());
		  break;

	  case CONFIG_RNEWS:
		  strcpy(config.rnews, get_absolute_path(PATH_LEN));
		  break;

	  case CONFIG_FIRSTUSERUID:
		  config.useruid = getint();
		  break;

	  case CONFIG_RMAIL:
		  strcpy(config.rmail, get_absolute_path(PATH_LEN));
		  break;

	  case CONFIG_RETURN_FAILED_MAIL:
		  config.return_failed_mail = gettruth();
		  break;

	  case CONFIG_DIAL:
		  for (p = strtok(NULL, WHITESPACE); p; p = strtok(NULL, WHITESPACE)) {
			  if (config.dials >= DIALS)
				  conferror("Dial table overflow, max %d translations", DIALS/2);
			  if (strequ(p, "\"\"")) *p = 0;
			  else if (strequ(p, "''")) *p = 0;
			  else if (strlen(p) >= DIALSTRING_LEN)
				  conferror("Too long dial string %s", p);
			  strcpy(config.dialtable[config.dials++], p);
		  }
		  
		  if (config.dials & 1)
			  conferror("Dial table must have pairs of strings, %d found",
				    config.dials);
		  break;
	      
	  case CONFIG_NEWSGROUPS:
		  parse_newsgroups();
		  break;
	      
	  case CONFIG_SEENBYS:
		  config.seenbys = 1;
		  if (!config.mynode.net)
			  conferror("Node must be set before seenbys");
		  config.seenby[0] = config.mynode;
		  while (getline(buffer, BUFSIZ)) {
			  configline++;
		  
			  /* '#' is a comment */
		  
			  if (*buffer == '#') continue;
			  
			  /* '*' means end of seenbys */
			  
			  if (*buffer == '*') break;
			  
			  if (!parsenode(buffer, &config.seenby[config.seenbys++], NULL, NULL))
				  conferror("Cannot parse fidonet address %s", buffer);
		  }
#ifdef USG
		  qsort((char *) config.seenby, (Uint) config.seenbys,
			sizeof(Node), cmpnode);
#endif
#ifdef BSD
		  qsort( (char *) config.seenby, config.seenbys,
			sizeof(Node), cmpnode);
#endif
		  break;

	  case CONFIG_AKAS:
		  config.akas = 0;
		  while (getline(buffer, BUFSIZ)) {
			  configline++;
			  
			  /* '#' is a comment */
			  if (*buffer == '#') continue;
			  
			  /* '*' means end of akas */
			  if (*buffer == '*') break;
			  
			  if (!parsenode(buffer, &config.aka[config.akas++], NULL, NULL))
				  conferror("Cannot parse fidonet address %s", buffer);
		  }
#ifdef USG
		  qsort( (char *) config.aka, (Uint) config.akas,
			sizeof(Node), cmpnode);
#endif
#ifdef BSD
		  qsort( (char *) config.aka, config.akas,
			sizeof(Node), cmpnode);
#endif
		  break;
	      
	  case CONFIG_ORIGIN:
		  strcpy(config.origin, getrestofline(0));
		  break;

	  case CONFIG_USE_INTERNAL_DIAL:
		  config.use_internal_dial = gettruth();
		  break;

	  case CONFIG_DIAL_MODEM_DELAY:
		  config.dial_modem_delay = getint();
		  break;

	  case CONFIG_DIAL_RETRIES:
		  config.dial_retries = getint();
		  break;

	  case CONFIG_DIAL_INITSTRING:
		  strcpy(config.dial_initstring, getrestofline(PATH_LEN));
		  break;

	  case CONFIG_DIAL_INITREPLY:
		  strcpy(config.dial_initreply, getrestofline(PATH_LEN));
		  break;

	  case CONFIG_DIAL_INITTIMEOUT:
		  config.dial_inittimeout = gettime();
		  break;

	  case CONFIG_DIAL_PREFIX:
		  strcpy(config.dial_prefix, getrestofline(PATH_LEN));
		  break;

	  case CONFIG_DIAL_TRAILER:
		  strcpy(config.dial_trailer, getrestofline(PATH_LEN));
		  break;

	  case CONFIG_DIAL_CONNECT:
		  strcpy(config.dial_connect, getrestofline(PATH_LEN));
		  break;

	  case CONFIG_DIAL_TIMEOUT:
		  config.dial_timeout = getint();
		  break;

	  case CONFIG_LOCKDIR:
		  strcpy(config.lockdir, get_absolute_path(PATH_LEN));
		  break;

	  case CONFIG_LOCKS:
		  strcpy(config.locks, getrestofline(PATH_LEN));
		  if (!*config.lockdir) {
			  if (strequ(config.locks, "bsd") ||
			      strequ(config.locks, "old")) 
				  strcpy(config.lockdir, "/usr/spool/uucp");
			  else if (strequ(config.locks, "hdb")) 
				  strcpy(config.lockdir, "/usr/spool/locks");
			  else if (strequ(config.locks, "svr4"))
				  strcpy(config.lockdir, "/var/spool/locks");
			  else 
				  conferror("Unknown lock type %s", config.locks);
		  }
		  break;

	  case CONFIG_LOCK_TIMEOUT:
		  config.lock_timeout = gettime();
		  break;

	  case CONFIG_LOCK_SLEEP:
		  config.lock_sleep = gettime();
		  break;


	  case CONFIG_ROUTING:
		  process_routing();
		  break;

	  case CONFIG_KEY:
		  process_key();
		  break;

	  case CONFIG_DOPICKUP:
		  config.dopickup = gettruth();
		  break;

	  case CONFIG_ALLOWPICKUP:
		  config.allowpickup = gettruth();
		  break;

	  case CONFIG_SEALINK:
		  config.sealink = gettruth();
		  break;

	  case CONFIG_FORCECRC:
		  config.forcecrc = gettruth();
		  break;

	  case CONFIG_QUICKNAK:
		  config.quicknak = gettruth();
		  break;

	  case CONFIG_CHECKSUM_FALLBACK:
		  config.checksum_fallback = getint();
		  break;

	  case CONFIG_ADMIN:
		  strcpy(config.admin, getrestofline(0));
		  break;

	  case CONFIG_TRANSFER_ACK_NUMBERED:
		  config.transfer_ack_numbered = gettruth();
		  break;

	  case CONFIG_QUICK_WHACK:
		  config.quick_whack = gettruth();
		  break;

	  case CONFIG_TELINKMAIL:
		  config.telinkmail = gettruth();
		  break;

	  case CONFIG_INIT_SCRIPT:
		  strcpy(config.init_script, getrestofline(SCRIPT_LEN));
		  break;

	  case CONFIG_DIAL_SCRIPT:
		  strcpy(config.dial_script, getrestofline(SCRIPT_LEN));
		  break;

	  case CONFIG_SCRIPT_TIMEOUT:
		  config.script_timeout = gettime();
		  break;

	  case CONFIG_LOGIN_PATH:
		  strcpy(config.login_path, get_absolute_path(PATH_LEN));
		  break;

	  case CONFIG_SYSTEM_NAME:
		  strcpy(config.system_name, getrestofline(SYSTEM_NAME_LEN));
		  break;

	  case CONFIG_SYSOP_NAME:
		  strcpy(config.sysop_name, getrestofline(SYSOP_NAME_LEN));
		  break;

	  case CONFIG_PACKER:
		  process_packer();
		  break;
		  
	  case CONFIG_TMPDIR:
		  strncopy(config.tmpdir, getpath(), PATH_LEN-1);
		  break;

	  case CONFIG_FILE_REQUEST_DIR:
		  strncopy(config.file_request_dir, getpath(), PATH_LEN-1);
		  break;

	  case CONFIG_FILE_REQUEST_ABOUT:
		  strncopy(config.file_request_about, getpath(), PATH_LEN-1);
		  break;

	  case CONFIG_FILE_REQUEST_FILES:
		  strncopy(config.file_request_files, getpath(), PATH_LEN-1);
		  break;

	  case CONFIG_FILE_REQUEST_MODE:
		  p = getstring(10);
		  if (p == NULL)
			  conferror("Illegal file-request-mode");
		  strlwr(p);
		  if (strequ(p, "anyone"))
			  config.file_request_mode = ANYONE_REQ;
		  else if (strequ(p, "none"))
			  config.file_request_mode = NONE_REQ;
		  else if (strequ(p, "known"))
			  config.file_request_mode = KNOWN_REQ;
		  else if (strequ(p, "prot"))
			  config.file_request_mode = PROT_REQ;
		  else
			  conferror("Unknown option to file-request-mode: %s", p);
		  break;
	  
	  case CONFIG_FILE_REQUEST_LIST:
		  strncopy(config.file_request_list, getpath(), PATH_LEN-1);
		  break;

	  case CONFIG_FILE_REQUEST_ALIAS:
		  strncopy(config.file_request_alias, getpath(), PATH_LEN-1);
		  break;

	  case CONFIG_FILE_REQUEST_MAX_FILES:
		  config.file_request_max_files = getint();
		  break;

	  case CONFIG_FILE_REQUEST_MAX_SIZE:
		  config.file_request_max_size = getint();
		  break;

	  case CONFIG_MAILNAME:
		  strcpy(config.mailname, getrestofline(MAILNAME_LEN));
		  break;

	  case CONFIG_FILE_OWNER:
		  strcpy(config.file_owner,
			 getrestofline(sizeof(config.file_owner)));
		  break;

	  case CONFIG_FILE_GROUP:
		  strcpy(config.file_group,
			 getrestofline(sizeof(config.file_group)));
		  break;

	  case CONFIG_FILE_MODE:
		  config.file_mode = getoct();
		  break;

	  case CONFIG_RETRY_MAX:
		  config.retry_max = getint();
		  break;

	  case CONFIG_RETRY_INTERVAL:
		  config.retry_interval = getint();
		  break;
		  
	  case CONFIG_RETRY_SLEEPTIME:
		  config.retry_sleeptime = getint();
		  break;

	  case CONFIG_RETRY_COUNT:
		  config.retry_count = getint();
		  break;
		  
	  case CONFIG_RETRY_TIME:
		  config.retry_time = getint();
		  break;
		  
	  case CONFIG_INTERNET_GATEWAY:
		  config.internet_gateway = gettruth();
		  break;

	  case CONFIG_MODEM:
		  if (config.modems+1 >= MAX_MODEMS)
			  conferror("Too many modem specifications");
		  config.modems++;
		  strcpy(config.modem[config.modems-1].name,
			  getrestofline(sizeof(config.modem[0].name)));
		  strlwr(config.modem[config.modems-1].name);
		  config.modem[config.modems-1].interface_speed = 0;
		  config.modem[config.modems-1].speeds = 0;
		  config.modem[config.modems-1].modemcap = 0;
		  config.modem[config.modems-1].dial_rate = 0;
		  config.modem[config.modems-1].init[0] = 0;
		  config.modem[config.modems-1].dial_prefix[0] = 0;
		  config.modem[config.modems-1].dial_suffix[0] = 0;
		  config.modem[config.modems-1].messages = 0;
		  break;
		  
	  case CONFIG_MODEM_INTERFACE_SPEED:
		  n = getint();
		  if (n == 0 || baud_to_bsdbaud(n) == 0)
			  conferror("Illegal modem interface speed: %s",
				    n);
		  config.modem[config.modems-1].interface_speed = n;
		  break;
				
	  case CONFIG_MODEM_SPEED:
		  config.modem[config.modems-1].speeds = 0;
		  while (p = getstring(0)) {
			  n = atoi(p);
			  if (n == 0 || (n = baud_to_bsdbaud(n)) == 0)
				  conferror("Illegal modem speed: %s", p);
			  config.modem[config.modems-1].speeds |= BIT(n-1);
		  }
		  break;

	  case CONFIG_MODEM_FLAGS:
		  config.modem[config.modems-1].modemcap = 0;
		  while (p = getstring(0)) {
			  strlwr(p);
			  i = listscan(modemflags, p);
			  if (i == -1)
				  conferror("Unknown modem flag: %s", p);
			  config.modem[config.modems-1].modemcap
				  |= modemflagvals[i];
		  }
		  break;
			
	  case CONFIG_MODEM_INIT:
		  strcpy(config.modem[config.modems-1].init,
			  getrestofline(sizeof(config.modem[0].init)));
		  break;
		  
	  case CONFIG_MODEM_DIAL_PREFIX:
		  strcpy(config.modem[config.modems-1].dial_prefix,
			  getrestofline(sizeof(config.modem[0].dial_prefix)));
		  break;
		  
	  case CONFIG_MODEM_DIAL_SUFFIX:
		  strcpy(config.modem[config.modems-1].dial_suffix,
			  getrestofline(sizeof(config.modem[0].dial_suffix)));
		  break;

	  case CONFIG_MODEM_DIAL_RATE:
		  config.modem[config.modems-1].dial_rate = getint();
		  break;
		  
	  case CONFIG_MODEM_MESSAGE:
		  if (config.modem[config.modems-1].messages+1
		      >= MAX_MODEM_MESSAGES)
			  conferror("Too many message strings for modem %s",
				    config.modem[config.modems-1].name);
		  mp = &config.modem[config.modems-1];
		  msgno = mp->messages++;
		  mp->message[msgno].type = 0;
		  mp->message[msgno].misc = 0;
		  mp->message[msgno].flags = 0;
		  mp->message[msgno].msg[0] = 0;
		  while (p = strtok(NULL, " \t\r\n")) {
			  j = strlen(p);
			  if (j > 0 && p[j-1] == ',')
				  p[j-1] = 0;
			  else
				  j = 0;
			  strlwr(p);
			  i = listscan(modem_message_strings, p);
			  if (i == -1)
				  conferror("Unknown modem message flag: %s", p);
			  if (modem_message_type[i]) {
				  if (modem_message_type[i] > 99) {
					  if (mp->message[msgno].misc)
						  conferror("Multiple definitions of speed");
					  else
						  mp->message[msgno].misc = baud_to_bsdbaud(modem_message_type[i]);
				  } else if (mp->message[msgno].type)
					  conferror("Multiple definition of modem message type: %s", p);
				  else
					  mp->message[msgno].type
						  = modem_message_type[i];
			  } else
				  mp->message[msgno].flags
					  |= modem_message_flags[i];
			  if (j)
				  break;
		  }
		  if (j == 0)
			  conferror("Missing ',' delimiter in modem message");
		  strcpy(mp->message[msgno].msg,
			 getrestofline(sizeof(mp->message[j].msg)));
		  break;

	  case CONFIG_MODEM_LINE:
		  if (config.lines+1 >= MAX_LINES)
			  conferror("Too many line specifications");
		  p = getstring(sizeof(config.line[0].device));
		  if (p == NULL)
			  conferror("Missing device in statement");
		  strcpy(config.line[config.lines].device, p);
		  p = getrestofline(0);
		  strlwr(p);
		  for (i = 0; i < config.modems; i++)
			  if (strequ(config.modem[i].name, p))
				  break;
		  if (i == config.modems)
			  conferror("Unknown modem in line specification: %s",
				    p);
		  config.line[config.lines].modem = i;
		  config.lines++;
		  break;

	  case CONFIG_MODEM_SEARCH_ORDER:
		  config.modem_search_order[0] = 0;
		  j = 0;
		  while (p = getstring(0)) {
			  strlwr(p);
			  i = listscan(modemflags, p);
			  if (i == -1)
				  conferror("Unknown modem flag: %s", p);
			  if (j+1 == sizeof(config.modem_search_order))
				  conferror("Too many entries to modem-search-order");
			  config.modem_search_order[j++] = modemflagvals[i];
		  }
		  break;

	  case CONFIG_UNGETTY_PATH:
		  strcpy(config.ungetty_path, get_absolute_path(PATH_LEN));
		  break;

	  case CONFIG_INCLUDE:		/* configuration include file */
		  if (config.includes == MAX_INCLUDES)
			  conferror("Too many include files");
		  strcpy(config.include[config.includes++],
			 get_absolute_path(PATH_LEN));
		  if ((configfp[inclno+1]
		       = fopen(config.include[config.includes-1], "r")) == NULL)
			  conferror("Cannot open file %s",
				  config.include[config.includes-1]);
		  inclno++;
		  break;

	  case CONFIG_EVENT:
		  if (config.events == MAX_EVENTS)
			  conferror("Too many events defined");
		  config.event[config.events].days = 0;
		  config.event[config.events].options = 0;
		  p = getstring(0);
		  if (p[0] == 0 || p[1])
			  conferror("Illegal event schedule tag: %s", p);
		  config.event[config.events].tag = p[0];
		  while ((p = getstring(0)) && !isdigit(*p)) {
			  i = listscan(event_days, p);
			  if (i == -1)
				  conferror("Illegal day of week: %s", p);
			  config.event[config.events].days
				  |= event_dayvals[i];
		  }
		  config.event[config.events].start = cvttotime(p);
		  config.event[config.events].end = cvttotime(getstring(0));
		  while (p = getstring(0)) {
			  i = listscan(event_flags, p);
			  if (i == -1)
				  conferror("Illegal event option: %s", p);
			  config.event[config.events].options
				  |= event_flagvals[i];
		  }
		  config.events++;
		  break;

	  default:
		  conferror("Unknown config parameter %s (hash %d)", p, hash);
	  } /* End switch configuration file command */
  }
  config_fixdefaults();
}

/* Create and remove lock file. */


/*
 * Do initial parsing of command parameters. 
 * Read configuration, recompile if neccessary.
 */
void
get_configuration(argc, argv, options)
	int *argc;
	char **argv;
	char *options;
{
	struct stat binstat, configstat;
	char configname[BUFSIZ];
	boolean recompile = FALSE;
	FILE *fp;
	int i, j, opt, noptions;
	char *opp;
	long srctime;

	/*
	 * Careful, before reading the configuration file,
	 * we have no configuration data, like log-file names, etc.
	 *
	 * Process some options common to all rfmail modules.
	 * We also make a simple syntax check of the options,
	 * and abort early if illegal options are given.
	 *
	 * Switches processed at this point are:
	 *	-X <configfile>		Alternative configuration file
	 *	-O <logfile>		Alternative output log file
	 *	-h			Help with options
	 *	-?			Help with options
	 *	-v <level>		Verbosity level
	 */
	progname = argv[0];
	for (i = 1; i < *argc; ) {
		if (argv[i][0] == '-') {
			opt = argv[i][1]; noptions = 0;
			switch (opt) {

			case 'X': /* Load alternative configuration file. */
				if (argv[i][2] == 0) {
					configfile = strdup(argv[i+1]);
					noptions = 2;
				} else {
					configfile = strdup(&argv[i][2]);
					noptions = 1;
				}
				break;


			case 'O': 	/* Alternative log output file */
				if (argv[i][2] == 0) {
					opp = argv[i+1];
					noptions = 2;
				} else {
					opp = &argv[i][2];
					noptions = 1;
				}
				if ((errorfp = myfopen(opp, "a+")) == NULL)
					exit(EX_USAGE);
				break;


			case 'h':	/* Options help */

			case '?':
				printusage(stdout); /* Print usage message */
				exit(EX_OK); 	/* And exit */
				break;


			case 'v':	/* Set log verbosity level */
				if (argv[i][2] == 0) {
					opp = argv[i+1];
					noptions = 2;
				} else {
					opp = &argv[i][2];
					noptions = 1;
				}
				verbose = atoi(opp);
				have_verbose = TRUE;
				break;

			default:
				if (opp = strchr(options, opt)) {
					if (opp[1] == ':' && argv[i][2] == 0)
						i++;
				} else {
					fatal(EX_USAGE, "Illegal option '%c', type %s -h for help",
					      opt, progname);
				}
			}
		}

		switch (noptions) {
		default:
			i++;
			break;


		case 2:		/* remove two options */
			for (j = i+1; j < *argc; j++)
				argv[j-1] = argv[j];
			(*argc)--;

		case 1:		/* remove one option */
			for (j = i+1; j < *argc; j++)
				argv[j-1] = argv[j];
			(*argc)--;
		}
	}
			

	/*
	 * Options appear to be allright, proceed with
	 * loading of configuration file.
	 */
	strcpy(configname, configfile);
	strcat(configname, ".bin");
  
	/*
	 * Stat the config file and all include files, and check if
	 * any of them is more recent than the binary configuration file.
	 */
	if (stat(configfile, &configstat) == -1)
		fatal(EX_OSFILE, "$Could not get config file status");
	srctime = configstat.st_mtime;
	for (i = 0; i < config.includes; i++) {
		if (stat(config.include[i], &configstat) == -1)
			fatal(EX_OSFILE, "$Could not stat %s",
			      config.include[i]);
		if (configstat.st_mtime > srctime)
			srctime = configstat.st_mtime;
	}
		    
	if (stat(configname, &binstat) == -1) {
		if (errno != ENOENT)
			fatal(EX_OSFILE,
			      "$Could not get binary config file status");
		else 
			recompile = TRUE;
	} else if (binstat.st_mtime <= srctime
		   || binstat.st_size != sizeof(config))
		recompile = TRUE;

	if (!createlock(SUPERLOCK, SUPERLOCK_TIMEOUT))
		fatal(0, "Could not create superlock file: %s", SUPERLOCK);
	if (!recompile) {
		/*
		 * Read compiled, binary, configuration file
		 */
		if ((fp = fopen(configname, "r")) == NULL)
			fatal(EX_OSFILE, "$Cannot open configuration file");
		if (fread((char *)&config, 1, sizeof(config), fp) != sizeof(config))
			fatal(EX_OSFILE, "$Error reading configuration file");
		fclose(fp);
		if (config.version != CONFIG_VERSION)
			recompile = TRUE;
		else
			get_ownerdata();
	}
	if (recompile) {
		/* Get configuration information into config structure */
      
		read_configuration();
		get_ownerdata();

		/* Write it to binary configuration file */
		config.version = CONFIG_VERSION;
		write_file( (char *) &config, configname, sizeof(config));
	}

	removelock(SUPERLOCK);

	if (!have_verbose)
		verbose = config.debuglevel;

	if (config.crdebug)
		strcpy(newline_string, "\r\n");
	else
		strcpy(newline_string, "\n");
	hasconfig = TRUE;
}


/*
 * Process routing information
 */
static void
process_routing()
{
	int hash = 0;
	struct routing_target *rp;
	char *p;
	char buffer[128], scratch[128];
	boolean arc_mail = FALSE;
	char sched = 0;
	int i;

	config.targets = 0;
	sched = 0;
	while (getline(buffer, BUFSIZ)) {
		configline++;
		/* '#' is a comment */
		if (*buffer == '#' || *buffer == 0)
			continue;
		/* '*' means end of routing */
		if (*buffer == '*')
			break;
		strcpy(scratch, buffer);
		p = strtok(scratch, SEPARATORS);
		if (p == NULL)
			continue;
		rp = &config.routing[config.targets++];
		arc_mail = FALSE;
		hash = routing_hash_function(p);
		if (hash == ROUTING_SCHED) {
			p = getstring(0);
			if (p == NULL)
				conferror("Missing routing schedule");
			if (strlen(p) != 1 || !isalnum(p[0])) {
				conferror("routing schedule must be a single letter (%s)\nLine: %s", p, buffer);
				continue;
			}
			sched = *p;
		continue;
		}
		if (config.targets >= MAX_TARGETS)
			conferror("Routing: Too many targets (max %d)",
			    MAX_TARGETS);
		rp->rtype = (routing_type) hash;
/*		rp->sched = sched; */
		rp->masks = 0;
		*rp->unixaddr = 0;

		switch (hash) {

		case ROUTING_ARC_CRASH:

		case ROUTING_ARC_HOLD:

		case ROUTING_ARC_TO:

			arc_mail = TRUE;

		case ROUTING_CRASH:

		case ROUTING_HOLD:

		case ROUTING_ROUTE_TO:
			/*
			 * cmd node {node-mask-list}
			 */
			rp->dest = scannode();
			if (!has_packer(rp->dest))
				conferror("No packer defined for node %s", ascnode(rp->dest));
			rp->masks = scanlist(p, rp->dest, rp->mask, TRUE);
			if (rp->masks == 0)
				rp->mask[rp->masks++] = rp->dest;
			break;
			

		case ROUTING_POLL:
			/*
			 * cmd node {node-list}
			 */
			rp->dest = scannode();
			rp->masks = scanlist(p, rp->dest, rp->mask, FALSE);
			if (rp->masks == 0)
				rp->mask[rp->masks++] = rp->dest;
			break;


		case ROUTING_ARC_DIRECT:

			arc_mail = TRUE;

		case ROUTING_DIRECT:

		case ROUTING_UNHOLD:

		case ROUTING_LEAVE:

		case ROUTING_SEND:

		case ROUTING_UNCRASH:
			/*
			 * cmd node
			 */
			rp->masks = scanlist(p, config.mynode, rp->mask, TRUE);
			if (arc_mail)
				for (i = 0; i < rp->masks; i++)
					if(!has_packer(rp->mask[i]))
						conferror("No packer defined for %s", ascnode(rp->mask[i]));
			break;


		case ROUTING_UNIXMAIL:
			/*
			 * cmd string {nodemasklist}
			 */
			p = getstring(0);
			if (p == NULL)
				conferror("Missing unix mail address: %s",
					  buffer);
			strcpy(rp->unixaddr, p);
			rp->masks = scanlist(p, config.mynode, rp->mask, TRUE);
			if (rp->masks == 0)
				conferror("Illegal routing line: %s",
					  buffer);
			break;
			

		case ROUTING_DOCRASH:
			/*
			 * cmd
			 */
			break;

		default:
			conferror("Unknown config routing parameter %s\n%s (hash %d)", p, hash, buffer);
		}
	}
}

/*
 * Process key information
 */
static void
process_key()
{
	int dest;	
	char *p;
	int hash = 0;
	int i;
	char buffer[128], scratch[128];
	boolean got_alias = FALSE; 
	boolean got_passwd = FALSE; 
	boolean got_pkttype = FALSE;
	boolean got_packer = FALSE;
	
	dest = config.dests++;

	if (config.dests >= MAX_KEYS)
		conferror("Too many key statements (max %d)", MAX_KEYS);
	

	/* set default values */

	config.destinfo[dest].pkttype = FTS0001;
	config.destinfo[dest].my_address = config.mynode;
	config.destinfo[dest].passwd[0] = '\0';
	config.destinfo[dest].packer = -1;

	/* parse address masks for destination */

	config.destinfo[dest].no_masks = scanlist(scratch, config.mynode, config.destinfo[dest].masks, TRUE);

	while (getline(buffer, BUFSIZ)) {
		configline++;

		/* '#' is a comment */

		if (*buffer == '#' || *buffer == 0)
			continue;

		/* '*' means end of key info */

		if (*buffer == '*')
			break;

		strcpy(scratch, buffer);
		p = strtok(scratch, SEPARATORS);
		if (p == NULL)
			continue;

		hash = key_hash_function(scratch);

		switch (hash)
		{
		case KEY_PACKETTYPE:
			if (got_pkttype)
				conferror("You may specify only one packettype");	
			p = getstring(0);	
	 		hash = packet_hash_function(p);
			switch (hash) 
			{
			case PACKETTYPE_FSC_0039:
				config.destinfo[dest].pkttype = FSC0039;
				break;
		
			case PACKETTYPE_FSC_0045:
				config.destinfo[dest].pkttype = FSC0045;
				break;
			case PACKETTYPE_FSC_0048:
				config.destinfo[dest].pkttype = FSC0048;
				break;
				
			case PACKETTYPE_FTS_0001:
				config.destinfo[dest].pkttype = FTS0001;
				break;
			default:
				conferror("Unknown packettype: %s", p);
			}
			got_pkttype = TRUE;

			break;	
	
		case KEY_ALIAS:
			if (got_alias)
				conferror("You may specify only one alias");	
			p = getstring(0);	
			if (!parsenode(p, &config.destinfo[dest].my_address, NULL, &config.mynode))
				conferror("illegal fidonet address %s", p);
			got_alias = TRUE;
			break;
		case KEY_PASSWORD:
			if (got_passwd)
				conferror("You may specify only one password");	
			p = getstring(0);	
	
			if (strlen(p) > (PASSW_LEN - 1))
				conferror("Too long password %s (max. %d characters)", p, PASSW_LEN - 1);
			strupr(p);
			strcpy(config.destinfo[dest].passwd, p);
			got_passwd = TRUE;
			break;
		case KEY_PACKER:
			if (got_packer)
				conferror("You may specify only one packer");

			p = getstring(0);
			for (i = 0; i < config.packers; i++)
				{
				if (strcmp (config.packerinfo[i].name, p) == 0)
					{
					if (strlen(config.packerinfo[i].arc_cmd) == 0)
						conferror("No add command specified for packer %s", p);
					else	{
						config.destinfo[dest].packer = i;
						got_packer = TRUE;
						break;
						}
					}
				}
			if (!got_packer)
				conferror("Unknow packer %s", p);
			break;					

		default:
			conferror("Unknown option %s", p);
		}
	} 
	
	if ((!got_alias) && (!got_passwd) && (!got_pkttype) && (!got_packer))
		conferror("No options specified for node %s", p);
}

static void
process_packer()
	{
	int packer;
	char *p;
	int i;
	char buffer[128], scratch[128];
	int hash = 0;
	boolean got_ident = FALSE;
	boolean got_offset = FALSE;
	boolean got_arc_cmd = FALSE;
	boolean got_extract_cmd = FALSE;
	boolean got_extension = FALSE; 

	packer = config.packers++;

	if (config.packers >= MAX_PACKERS)
		conferror("Too many packers (max %d)", MAX_PACKERS);
	
	strcpy(config.packerinfo[packer].name, getrestofline(NAME_LEN));	
	
	/* set defaults */

	config.packerinfo[packer].ext[0] = '\0';
	config.packerinfo[packer].id_start = 0;
	config.packerinfo[packer].id_len = 0;
	config.packerinfo[packer].extract_cmd[0] = '\0';
	config.packerinfo[packer].arc_cmd[0] = '\0';


	while (getline(buffer, BUFSIZ)) {
		configline++;

		/* '#' is a comment */

		if (*buffer == '#' || *buffer == 0)
			continue;

		/* '*' means end of packer info */

		if (*buffer == '*')
			{
			if (got_extract_cmd && !got_ident)
				conferror("Packer %s: extract comand without ident string", config.packerinfo[packer].name);
			if (got_arc_cmd && !got_extension)
				conferror("Packer %s: add comand without extension string", config.packerinfo[packer].name);
			if (got_ident && !got_offset)
				conferror("Packer %s: ident string without offset", config.packerinfo[packer].name);
			break;
			}

		strcpy(scratch, buffer);
		p = strtok(scratch, SEPARATORS);
		if (p == NULL)
			continue;
		hash = packer_hash_function(scratch);

		switch (hash)
		{
		case PACKER_OFFSET:
			if(got_offset)
				conferror("Second offset command for packer %s", config.packerinfo[packer].name);
			got_offset = TRUE;
			config.packerinfo[packer].id_start = getint();
			break;		
			
		case PACKER_IDENT:
			if(got_ident)
				conferror("Second ident command for packer %s", config.packerinfo[packer].name);
			got_ident = TRUE;
			
			if(!got_offset)
				conferror("Must define offset before you can define an ident string");	
			strcpy(scratch, getrestofline(0));

			i = 0;
			while (scratch[i] != '\0')
				{
				while (scratch[i] == ' '|| scratch[i] == '\t')
					i++;
				config.packerinfo[packer].id[config.packerinfo[packer].id_len++] = 
					hexchartoval(scratch[i++]) * 16 + 
					hexchartoval(scratch[i++]);
				}				
			break;									
	
		case PACKER_EXTENSION:
			if(got_extension)
				conferror("Second extension command for packer %s", config.packerinfo[packer].name);	
			got_extension = TRUE;	
			strcpy(config.packerinfo[packer].ext, getrestofline(EXT_LEN));
			break;

		case PACKER_ADD:
			if(got_arc_cmd)
				conferror("Second add command for packer %s", config.packerinfo[packer].name);	
			got_arc_cmd = TRUE;	
			strcpy(config.packerinfo[packer].arc_cmd, getrestofline(PATH_LEN));
			break;

		case PACKER_EXTRACT:
			if(got_extract_cmd)
				conferror("Second extract command for packer %s", config.packerinfo[packer].name);	
			got_extract_cmd = TRUE;	
			strcpy(config.packerinfo[packer].extract_cmd, getrestofline(PATH_LEN));
			break;
		default:	
			conferror("Illegal packer option");
		}
	}	
}
	
static int
scanlist(p, defnode, mp, wild)
	char *p;
	Node defnode, *mp;
	boolean wild;
{
	int masks;
	Node masknode, stickynode;

	masks = 0;
	allow_address_wildcards = wild;
	stickynode = defnode;
	
	while (p = getstring(0)) {
		if (masks >= MAX_MASKS)
			conferror("Routing: Too many masks (max %d)",
			    MAX_MASKS);
		if (!parsenode(p, &masknode, NULL, &stickynode))
			conferror("Illegal fidonet address %s", p);
		mp[masks++] = masknode;
		stickynode = masknode;
	}
	allow_address_wildcards = FALSE;
	return masks;
}

static Node
scannode()
{
	Node node;
	char *p;

	p = getstring(0);
	if (p == NULL)
		conferror("Missing fidonet address");
	if (!parsenode(p, &node, NULL, &config.mynode))
		conferror("Illegal fidonet node address: %s", p);
	return node;
}

static boolean
has_packer(node)
	Node node;
{
	int i, j;
	
	for (i = 0; i < config.dests; i++)
		for (j = 0; j < config.destinfo[i].no_masks; j++)
			if (node_match(config.destinfo[i].masks[j], node))
				{
				if (config.destinfo[i].packer != -1)
					return TRUE;
				else
					return FALSE;
				}
	return FALSE;
}

static void
parse_newsgroups()
{
	int c;
	char buffer[BUFSIZ];
	char *p;
	Node tmpnode;

	config.newsgroups = 0;
	while (getline(buffer, BUFSIZ)) {
		configline++;
		/*
		 * Collect continuation lines
		 */
		while ((c = getc(configfp[inclno])) && (c == ' ' || c == '\t'))
			getline(strend(buffer), BUFSIZ-strlen(buffer));
		ungetc(c, configfp[inclno]);
		
		if (config.newsgroups >= MAX_NEWSGROUPS)
		       conferror("Too many newsgroups, %d max",MAX_NEWSGROUPS);
		  
		/* '#' is a comment */
		if (*buffer == '#') continue;
		  
		/* '*' means end of groups */
		if (*buffer == '*') break;
		  
		/* Get echo name */
		if ((p = strtok(buffer, SEPARATORS)) == NULL)
			conferror("No echo name at config line %d",
				  configline);
		if (strlen(p) >= MAX_ECHOLEN)
			conferror("Too long echo name: %s", p);
		strcpy(config.ng[config.newsgroups].echo, p);
		      
		/* Get newsgroup name */
		if ((p = getstring(0)) == NULL)
			conferror("No newsgroup name for %s at config line %d",
				  config.ng[config.newsgroups].echo,
				  configline);
		if (strlen(p) >= MAX_NGLEN)
			conferror("Too long newsgroup name: %s", p);
		strcpy(config.ng[config.newsgroups].ng, p);

		/* Get primary address for newsgroup, if any */

		if ((p = getstring(0)) != NULL)			  
			if (p[0] == '#')
				{
				p++;
				if (!parsenode(p, &config.ng[config.newsgroups].my_address, NULL, &config.mynode))
					conferror("Ilegal fidonet address: %s", p);
		
				/* printf("Newsgroup %s, address %d:%d/%d.%d\n", config.ng[config.newsgroups].ng,
					config.ng[config.newsgroups].my_address.zone,
					config.ng[config.newsgroups].my_address.net,
					config.ng[config.newsgroups].my_address.node,
					config.ng[config.newsgroups].my_address.point); */
				p = getstring(0);
				}
			else 
				config.ng[config.newsgroups].my_address = config.mynode;

		/* Get distribution */

		if (p == NULL)
			conferror("No distribution for %s at config line %d",
				  config.ng[config.newsgroups].ng, configline);
		if (strlen(p) >= MAX_DISTRIBUTION_LEN)
			conferror("Too long distribution %s", p);
		strcpy(config.ng[config.newsgroups].distribution, p);
			      
		/* Get flags and parse them */
		config.ng[config.newsgroups].acceptprivate =
			config.ng[config.newsgroups].trashprivate = FALSE;
		config.ng[config.newsgroups].nodes = 0;
		tmpnode = config.mynode;
		while (p = getstring(0)) {
			if (its("accept-private"))
				config.ng[config.newsgroups].acceptprivate
					= TRUE;
			else if (its("command")) {
				if ((p = getrestofline(0)) == NULL)
					conferror("No command at config line %d ?", configline);
				if (strlen(p) >= MAX_COMMAND_LEN)
					conferror("Too long command, %s %d",
						  "config line", p,
						  configline);
				if (config.ng[config.newsgroups].nodes)
					conferror("Cannot have both command and node(s) for newsgroup\nLine: %s", configline);
				strcpy(config.ng[config.newsgroups].u.command, p);
			} else if (its("trash-private"))
				config.ng[config.newsgroups].trashprivate =
					TRUE;
			else if (isdigit(*p) || *p == '.') {
				Node node;
				/*
				 * A distribution node
				 */
				if (!parsenode(p, &node, NULL, &tmpnode))
					conferror("Cannot parse newsgroup distribution node address: %s", p);
				if (config.ng[config.newsgroups].nodes >= MAX_NEWSGROUP_NODES)
					conferror("Too many distirbution nodes for newsgroup %s",
						  config.ng[config.newsgroups].ng);
				config.ng[config.newsgroups].u.node[config.ng[config.newsgroups].nodes++] = node;
				tmpnode = node;
			} else
			      conferror("Bad flag '%s', line %d",p,configline);
		}
		config.newsgroups++;
	}
}

void
configprintusage(fp)
	FILE *fp;
{
	fprintf(fp, "-h          Display this help message.\n");
	fprintf(fp, "-v nn       Sets verbosity to nn.\n");
	fprintf(fp, "-O debuglog Sends debugging output to specified file.\n");
	fprintf(fp, "-X <filename> Use this configuration file instead of %s\n", CONFIGFILE);
}


