#!/bin/sh
# Revision 0.4  1991/05/08  04:36:28  pgd
# Initial Beta-release
#
case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
	echo "Using config.sh from above..."
    fi
    . ./config.sh
    ;;
esac
echo "Extracting conf.h (with variable substitutions)"
sed <<!GROK!THIS! >conf.h -e 's!^#undef!/\*#undef!'
/* conf.h
 * This file was produced by running the conf.h.SH script, which
 * gets its values from config.sh, which is generally produced by
 * running Configure.
 *
 * Feel free to modify any of this as the need arises.  Note, however,
 * that running conf.h.SH again will wipe out any changes you've made.
 * For a more permanent change edit config.sh and rerun conf.h.SH.
 */

/* BINKLEY:
 * 	This symbol will make Rfmail produce Binkley style flow files
 *	instead of relying on Rfmail's own mailer. 
 */

#$d_binkley	BINKLEY		/**/

/* FIDONET_ORDER
 *	This symbol will change the way Rfmail interprets a mail
 *	sent to user@1.2.3.4.fidonet[.org] and it's variations.
 *	If the symbol is not defined, Rfmail will follow the Internet
 * 	order of adresses, so the address mentioned above will be
 *	translated to: user at node 4:3/2.1
 *	If the symbol is defined the adress will be translated to:
 *	user at 1:2/3.4
 *	Parsing of user@f1.n2.z4.fidonet[.org] style of adresses is
 *	NOT affected.
 */

#$d_fidonet_order	FIDONET_ORDER	/**/

/* CPPSTDIN:
 *	This symbol contains the first part of the string which will invoke
 *	the C preprocessor on the standard input and produce to standard
 *	output.	 Typical value of "cc -E" or "/lib/cpp".
 */
/* CPPMINUS:
 *	This symbol contains the second part of the string which will invoke
 *	the C preprocessor on the standard input and produce to standard
 *	output.  This symbol will have the value "-" if CPPSTDIN needs a minus
 *	to specify standard input, otherwise the value is "".
 */
#define CPPSTDIN "$cppstdin"
#define CPPMINUS "$cppminus"

/* FCNTL:
 *	This symbol, if defined, indicates to the C program that it should
 *	include fcntl.h.
 */
#$d_fcntl	FCNTL		/**/

/* FTIMER:
 *	This symbol, if defined, indicates that the ftime() routine exists.
 */
#$d_ftime	FTIMER		/**/

/* PORTABLE:
 *	This symbol, if defined, indicates to the C program that it should
 *	not assume that it is running on the machine it was compiled on.
 *	The program should be prepared to look up the host name, translate
 *	generic filenames, use PATH, etc.
 */
#$d_portable	PORTABLE	/**/

/* TERMIO:
 *	This symbol, if defined, indicates that the program should include
 *	termio.h rather than sgtty.h.  There are also differences in the
 *	ioctl() calls that depend on the value of this symbol.
 */
#$d_termio	TERMIO		/**/

/* TMINSYS:
 *	This symbol is defined if this system declares "struct tm" in
 *	in <sys/time.h> rather than <time.h>.  We can't just say
 *	-I/usr/include/sys because some systems have both time files, and
 *	the -I trick gets the wrong one.
 */
#$d_tminsys	TMINSYS 	/**/

/* VOIDSIG:
 *	This symbol is defined if this system declares "void (*signal())()" in
 *	signal.h.  The old way was to declare it as "int (*signal())()".  It
 *	is up to the package author to declare things correctly based on the
 *	symbol.
 */
#$d_voidsig	VOIDSIG 	/**/

/* WHOAMI:
 *	This symbol, if defined, indicates that the program may include
 *	whoami.h.
 */
#$d_whoami	WHOAMI		/**/

/* GIDTYPE:
 *	This symbol has a value like gid_t, int, ushort, or whatever type is
 *	used to declare group ids in the kernel.
 */
#define GIDTYPE $gidtype		/**/

/* XENIX:
 *	This symbol, if defined, indicates that the program is running under
 *	the XENIX operating system.
 */
/* BSD:
/* USG
 *	There are two major dialects of unix. The BSD symbol indicates that
 *	we are running under the BSD 4.3 (4.2) version. The other alternative
 *	is USG, which stands for a system V derivative.
 */
#$d_xenix	XENIX		/**/
#$d_bsd		BSD		/**/
#$d_usg		USG		/**/

/* HAVE_BCOPY:
 *	This symbol, if defined, indicates that the bcopy routine is available
 *	to copy blocks of memory.  Otherwise you should probably use memset().
 */
#$d_bcopy	HAVE_BCOPY		/**/

/* HAVE_BSEARCH:
 *	This symbol, if defined, indicates that the bsearch routine is available.
 */
#$d_bsearch	HAVE_BSEARCH		/**/

/* HAVE_BZERO:
 *	This symbol, if defined, indicates that the bzero routine is available
 *	to copy blocks of memory.  Otherwise you should probably use memset().
 */
#$d_bzero	HAVE_BZERO		/**/

/* GETHOSTNAME:
 *	This symbol, if defined, indicates that the C program may use the
 *	gethostname() routine to derive the host name.  See also DOUNAME
 *	and PHOSTNAME.
 */
/* DOUNAME:
 *	This symbol, if defined, indicates that the C program may use the
 *	uname() routine to derive the host name.  See also GETHOSTNAME and
 *	PHOSTNAME.
 */
/* PHOSTNAME:
 *	This symbol, if defined, indicates that the C program may use the
 *	contents of PHOSTNAME as a command to feed to the popen() routine
 *	to derive the host name.  See also GETHOSTNAME and DOUNAME.
 */
#$d_gethname	GETHOSTNAME	/**/
#$d_douname	DOUNAME		/**/
#$d_phostname	PHOSTNAME "$phostname"	/**/
#$d_whoami	USE_WHOAMI	/**/

/* HAVE_GETTIMEOFDAY:
 *	This symbol, if defined, indicates that the gettimeofday routine is available
 */
#$d_gettime	HAVE_GETTIMEOFDAY		/**/

/* HAVE_LOCKF:
 *	This symbol, if defined, indicates that the lockf routine is available.
 */
#$d_lockf	HAVE_LOCKF		/**/

/* HAVE_LOCKING:
 *	This symbol, if defined, indicates that the locking routine is available.
 */
#$d_locking	HAVE_LOCKING		/**/

/* MKDIR:
 *	This symbol, if defined, indicates that the mkdir routine is available
 *	to create directories.  Otherwise you should fork off a new process to
 *	exec /bin/mkdir.
 */
#$d_mkdir	HAVE_MKDIR		/**/

/* HAVE_NAP:
 *	This symbol, if defined, indicates that the nap routine is available
 *	for sub-second sleeps.
 */
#$d_nap	HAVE_NAP		/**/

/* HAVE_RDCHK:
 *	This symbol, if defined, indicates that the rdchk routine is available
 *	to find out if there is input pending on an IO channel.  Generally
 *	the routine is used only if FIONREAD and O_NDELAY aren't available.
 */
#$d_rdchk	HAVE_RDCHK		/**/

/* RENAME:
 *	This symbol, if defined, indicates that the rename routine is available
 *	to rename files.  Otherwise you should do the unlink(), link(), unlink()
 *	trick.
 */
#$d_rename	HAVE_RENAME		/**/

/* HAVE_SELECT:
 *	This symbol, if defined, indicates that the select routine is available.
 */
#$d_select	HAVE_SELECT		/**/

/* strchr:
 *	This preprocessor symbol is defined, along with strrchr, if the system
 *	uses the index and rindex routines instead.
 */
/* strrchr:
 *	This preprocessor symbol is defined, along with strchr, if the system
 *	uses the index and rindex routines instead.
 */
#$d_strchr	strchr index	/* cultural */
#$d_strchr	strrchr rindex	/*  differences? */

/* HAVE_STRLWR:
 *	This symbol, if defined, indicates that the strlwr routine is available
 *	lowercase a character string. Otherwise you have to use the supplied.
 */
#$d_strlwr	HAVE_STRLWR		/**/

/* HAVE_STRUPR:
 *	This symbol, if defined, indicates that the strupr routine is available
 *	uppercase a character string. Otherwise you have to use the supplied.
 */
#$d_strlwr	HAVE_STRUPR		/**/

/* HAVE_STRSTR:
 *	This symbol, if defined, indicates that the strstr routine is available.
 */
#$d_strstr	HAVE_STRSTR		/**/

/* HAVE_TIMES:
 *	This symbol, if defined, indicates that the times routine is available
 */
#$d_times	HAVE_TIMES		/**/

/* HAVE_DIRENT:
 *	This symbol, if defined, indicates that the program should
 *	use the system "dirent" package instead of ndir.
 */
#$d_dirent	HAVE_DIRENT	/**/
/* USENDIR:
 *	This symbol, if defined, indicates that the program should compile
 *	the ndir.c code provided with the package.
 */
#$d_usendir	USENDIR		/**/
/* LIBNDIR:
 *	This symbol, if defined, indicates that the program should include the
 *	system's version of ndir.h, rather than the one with this package.
 */
#$d_libndir	LIBNDIR		/**/

/* HAVE_USLEEP:
 *	This symbol, if defined, indicates that the usleep routine is available
 *	for short sleeps.
 */
#$d_usleep	HAVE_USLEEP		/**/

/* HAVE_VFPRINTF:
 *	This symbol, if defined, indicates that the vfprintf routine is available.
 */
#$d_vfprintf	HAVE_VFPRINTF		/**/

/* HAVE_VSPRINTF:
 *	This symbol, if defined, indicates that the vsprintf routine is available.
 */
#$d_vsprintf	HAVE_VSPRINTF		/**/

/* HOSTNAME:
 *	This symbol contains name of the host the program is going to run on.
 *	The domain is not kept with hostname, but must be gotten from MYDOMAIN.
 *	The dot comes with MYDOMAIN, and need not be supplied by the program.
 *	If gethostname() or uname() exist, HOSTNAME may be ignored.
 */
/* MYDOMAIN:
 *	This symbol contains the domain of the host the program is going to
 *	run on.  The domain must be appended to HOSTNAME to form a complete
 *	host name.  The dot comes with MYDOMAIN, and need not be supplied by
 *	the program.  If the host name is derived from PHOSTNAME, the domain
 *	may or may not already be there, and the program should check.
 */
#define HOSTNAME "$hostname"		/**/
#define MYDOMAIN "$mydomain"		/**/

/* HAVE_STDARG_H:
 *	This symbol, if defined, indicates that the <stdarg_h.h> include file
 *	is available. Otherwise we assume that we have the <varargs.h>
 *	include file.
 */
#$stdarg_h	HAVE_STDARG_H		/**/

/* HAVE_STRING_H:
 *	This symbol, if defined, indicates that the <string_h.h> include file
 *	is available. Otherwise we assume that we have the <strings.h>
 *	include file.
 */
#$string_h	HAVE_STRING_H		/**/

/* HAVE_SYSEXITS:
 *	This symbol, if defined, indicates that the <sysexits.h> include file
 *	is available.
 */
#$sysexits	HAVE_SYSEXITS		/**/

/* HAVE_TIMEB_H:
 *	This symbol, if defined, indicates that the <timeb.h> include file
 *	is available. Otherwise we assume that we will use the
 *	supplied timeb.h include file.
 */
#$timeb_h	HAVE_TIMEB_H		/**/

/* UIDTYPE:
 *	This symbol has a value like uid_t, int, ushort, or whatever type is
 *	used to declare user ids in the kernel.
 */
#define UIDTYPE $uidtype		/**/

/* HAVE_UNISTD:
 *	This symbol, if defined, indicates that the <unistd.h> include file
 *	is available.
 */
#$unistd	HAVE_UNISTD		/**/

/* HAVE_UTIME_H:
 *	This symbol, if defined, indicates that the <utime.h> include file
 *	is available.
 */
#$utime	HAVE_UTIME_H		/**/

/* HAVE_VALUES_H:
 *	This symbol, if defined, indicates that the <values.h> include file
 *	is available.
 */
#$values	HAVE_VALUES_H		/**/

/* HAVE_WAIT_H:
 *	This symbol, if defined, indicates that the <sys/wait.h> include file
 *	is available.
 */
#$wait	HAVE_WAIT_H		/**/

!GROK!THIS!
