/*
 * $Header: /u1/src/rfmail/RCS/cleanf.c,v 0.5 1992/05/18 04:27:24 pgd Exp pgd $
 *
 * $Log: cleanf.c,v $
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

#include "fnet.h"
#include "nodelist.h"
#include "configs.h"
#include "shuffle.h"

/* Convert dos filename to more reasonable format. Uppercase to lowercase,
   does basename on string (both msdos and unix filename separators known,
   if result is '..', returns sequenced created filename and gives warning.
   Uses badsequence. */


char *
clean_filename(filename)
	char *filename;
{
	char *d, *s;
	int count;
	boolean dotseen = FALSE;
	FILE *fp;
	static char buffer[BUFSIZ];

	s = filename;
  
	for (d = buffer, count = 0; *s; s++, count++) {
		/* Add ms-dos dot which isn't sent */
		if (count == 8 && !dotseen) {
			*d++ = '.';
			dotseen = TRUE;
		}
		
		/* Strip some unwanted characters */
		switch (*s) {
		case ' ':
		case '<':
		case '>':
		case '\r':
		case '\n':
			break;
			
		case '.':
			dotseen = TRUE;
			/* Fall thru */
			
		default:
			*d++ = tolower(*s); /* ! */
		}
	}
	*d = 0;
	
	d = s = buffer;
	while (*s) {
		if (*s == '/' || *s == '\\')
			d = s;
		s++;
	}
	
	nstrcpy(buffer, d);
  
	if (strequ(buffer, "..")) {
		log("Filename <%s> became <..> in clean_filename", filename);
		sprintf(buffer, "illegal%ld", sequencer(config.badsequence));
	}

	/* Check out if the file already exists.
	   If so, concatenate a number to make it unique. */

	while ((fp = fopen(sprintfs("%s/%s", config.infiles, buffer), "r")) != NULL
	       || errno != ENOENT) {
		char number[20];
		
		debug(1, "File <%s> already exists, serialize", buffer);
		sprintf(number, "%ld", sequencer(config.ipacketsequence));
		
#if !defined(BSD) && !defined(LONG_FILENAMES)
		/* Poor system V doesn't support more than 14 characters
		   per file name.
		   All this hassle to serialize it.
		   In theory, this could loop forever. Though, he will
		   probably run out of inodes or nerves, or the famous AT&T
		   inode bug hits, so its only a theoretical question. */
		
		if (strlen(number) > 13) {
			log("Internal: too large sequence (%s), replacing 'panic'",
			    buffer);
			strcpy(buffer, "panic");
			break;
		} else {
			if (strlen(buffer) + strlen(number) <= 13) {
				if (buffer[strlen(buffer) - 1] != '.')
					strcat(buffer, ".");
				strcat(buffer, number);
			} else {
				strcpy(buffer + 14 - strlen(number), number);
				if (buffer[13 - strlen(number)] != '.')
					buffer[13 - strlen(number)] = '.';
			}
		}
#endif	
	}
	if (fp)
		fclose(fp);
  
	/* Files need to be put into certain directory, to avoid filename
	   to being same with the mail packet we just received, or nasty
	   practical jokes. */

/*  	strcpy(buffer, sprintfs("%s/%s", config.infiles, buffer)); */
  
	debug(1, "Filename <%s> became <%s> after conversion",
	      filename, buffer);
	return buffer;
}

