/*
 * $Header: /u1/src/rfmail/RCS/chars.c,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: chars.c,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

/* Character conversions and general string operations. */

/*
 * String functions missing in some implementations.
 * Moved here from separate files, by pgd@compuram.bbt.se
 * File "chars.c" and "string.c" merged
 */

/*
 * Authors:
 *
 * Teemu Torma who wrote the original code (?)
 *
 * Heikki Suonsivu (hsu@hutcs.hut.fi) who made a lot of enhancements
 * 
 * Per Lindqvist (pgd@compuram.bbt.se) who continued to enhance rfmail.
 */

#include "fnet.h"
#include "shuffle.h"

/* Converts control characters to ascii and tries to do something intelligent
   to ibm pc graphics characters. */

int ctable[256] = {
  -1, /* 000 nul */
  -1, /* 001 soh */
  -1, /* 002 stx */
  -1, /* 003 etx */
  -1, /* 004 eot */
  -1, /* 005 enq */
  -1, /* 006 ack */
  -1, /* 007 bel */
  -1, /* 010 bs  */
  '\011', /* 011 ht not expanded, may be useful! */
  -1, /* 012 nl  */
  -1, /* 013 vt  */
  -1, /* 014 np  */
  -1, /* 015 cr  */
  -1, /* 016 so  */
  -1, /* 017 si  */
  -1, /* 020 dle */
  -1, /* 021 dc1 */
  -1, /* 022 dc2 */
  -1, /* 023 dc3 */
  -1, /* 024 dc4 */
  -1, /* 025 nak */
  -1, /* 026 syn */
  -1, /* 027 etb */
  -1, /* 030 can */
  -1, /* 031 em  */
  -1, /* 032 sub */
  -1, /* 033 esc */
  -1, /* 034 fs  */
  -1, /* 035 gs  */
  -1, /* 036 rs  */
  -1, /* 037 us  */
  ' ', /* 040 sp  */
  '!', /* 041  !  */
  '"', /* 042  "  */
  '#', /* 043  #  */
  '$', /* 044  $  */
  '%', /* 045  %  */
  '&', /* 046  &  */
  '\'', /* 047  '  */
  '(', /* 050  (  */
  ')', /* 051  )  */
  '*', /* 052  *  */
  '+', /* 053  +  */
  ',', /* 054  ,  */
  '-', /* 055  -  */
  '.', /* 056  .  */
  '/', /* 057  /  */
  '0', /* 060  0  */
  '1', /* 061  1  */
  '2', /* 062  2  */
  '3', /* 063  3  */
  '4', /* 064  4  */
  '5', /* 065  5  */
  '6', /* 066  6  */
  '7', /* 067  7  */
  '8', /* 070  8  */
  '9', /* 071  9  */
  ':', /* 072  :  */
  ';', /* 073  ;  */
  '<', /* 074  <  */
  '=', /* 075  =  */
  '>', /* 076  >  */
  '?', /* 077  ?  */
  '@', /* 100  @  */
  'A', /* 101  A  */
  'B', /* 102  B  */
  'C', /* 103  C  */
  'D', /* 104  D  */
  'E', /* 105  E  */
  'F', /* 106  F  */
  'G', /* 107  G  */
  'H', /* 110  H  */
  'I', /* 111  I  */
  'J', /* 112  J  */
  'K', /* 113  K  */
  'L', /* 114  L  */
  'M', /* 115  M  */
  'N', /* 116  N  */
  'O', /* 117  O  */
  'P', /* 120  P  */
  'Q', /* 121  Q  */
  'R', /* 122  R  */
  'S', /* 123  S  */
  'T', /* 124  T  */
  'U', /* 125  U  */
  'V', /* 126  V  */
  'W', /* 127  W  */
  'X', /* 130  X  */
  'Y', /* 131  Y  */
  'Z', /* 132  Z  */
  '[', /* 133  [  */
  '\\', /* 134  \  */
  ']', /* 135  ]  */
  '^', /* 136  ^  */
  '_', /* 137  _  */
  '`', /* 140  `  */
  'a', /* 141  a  */
  'b', /* 142  b  */
  'c', /* 143  c  */
  'd', /* 144  d  */
  'e', /* 145  e  */
  'f', /* 146  f  */
  'g', /* 147  g  */
  'h', /* 150  h  */
  'i', /* 151  i  */
  'j', /* 152  j  */
  'k', /* 153  k  */
  'l', /* 154  l  */
  'm', /* 155  m  */
  'n', /* 156  n  */
  'o', /* 157  o  */
  'p', /* 160  p  */
  'q', /* 161  q  */
  'r', /* 162  r  */
  's', /* 163  s  */
  't', /* 164  t  */
  'u', /* 165  u  */
  'v', /* 166  v  */
  'w', /* 167  w  */
  'x', /* 170  x  */
  'y', /* 171  y  */
  'z', /* 172  z  */
  '{', /* 173  {  */
  '|', /* 174  |  */
  '}', /* 175  }  */
  '~', /* 176  ~  */
  -2,  /* 177 del   Translated to ^? */
  'C', /* 80 nul */
  'u', /* 81 soh */
  'e', /* 82 stx */
  'a', /* 83 etx */
  'a', /* 84 eot  scandinavian a with dots */
  'a', /* 85 enq */
  'a', /* 86 ack  scandinavian a with dot */
  'c', /* 87 bel */
  'e', /* 88 bs  */
  'e', /* 89 ht  */
  'e', /* 8a nl  */
  'i', /* 8b vt  */
  'i', /* 8c np  */
  'i', /* 8d cr  */
  'A', /* 8e so   scandinavian A with dots */
  'A', /* 8f si   scandinavian A with dot */
  'E', /* 90 dle */
  'a', /* 91 dc1  scandinavian a with dots */
  'A', /* 92 dc2 */
  'o', /* 93 dc3 */
  'o', /* 94 dc4  scandinavian o with dots */
  'o', /* 95 nak */
  'u', /* 96 syn */
  'u', /* 97 etb */
  'y', /* 98 can */
  'O', /* 99 em   scandinavian O with dots */
  'U', /* 9a sub */
  'c', /* 9b esc */
  '$', /* 9c fs   pound */
  'Y', /* 9d gs  */
  'P', /* 9e rs  */
  'f', /* 9f us  */
  'a', /* a0 sp  */
  'i', /* a1  !  */
  'o', /* a2  "  */
  'u', /* a3  #  */
  'n', /* a4  $  */
  'N', /* a5  %  */
  'a', /* a6  &  */
  'o', /* a7  '  */
  '?', /* a8  (  */
  '-', /* a9  )  */
  '-', /* aa  *  */
  '/', /* ab  +  */
  '/', /* ac  ,  */
  '!', /* ad  -  */
  '<', /* ae  .  */
  '>', /* af  /  */
  '.', /* b0  0   Colouring chars from light to ... */
  '*', /* b1  1  */
  '#', /* b2  2   ... dark */
  '|', /* b3  3  */
  '+', /* b4  4  */
  '+', /* b5  5  */
  '+', /* b6  6  */
  '+', /* b7  7  */
  '+', /* b8  8  */
  '+', /* b9  9  */
  '|', /* ba  :  */
  '+', /* bb  ;  */
  '+', /* bc  <  */
  '+', /* bd  =  */
  '+', /* be  >  */
  '+', /* bf  ?  */
  '+', /* c0  @  */
  '+', /* c1  A  */
  '+', /* c2  B  */
  '+', /* c3  C  */
  '-', /* c4  D  */
  '+', /* c5  E  */
  '+', /* c6  F  */
  '+', /* c7  G  */
  '+', /* c8  H  */
  '+', /* c9  I  */
  '+', /* ca  J  */
  '+', /* cb  K  */
  '+', /* cc  L  */
  '-', /* cd  M  */
  '+', /* ce  N  */
  '+', /* cf  O  */
  '+', /* d0  P  */
  '+', /* d1  Q  */
  '+', /* d2  R  */
  '+', /* d3  S  */
  '+', /* d4  T  */
  '+', /* d5  U  */
  '+', /* d6  V  */
  '+', /* d7  W  */
  '+', /* d8  X  */
  '+', /* d9  Y  */
  '+', /* da  Z  */
  '#', /* db  [  */
  '_', /* dc  \  */
  '|', /* dd  ]  */
  '|', /* de  ^  */
  '-', /* df  _  */
  'a', /* e0  `  */
  'b', /* e1  a  */
  'T', /* e2  b  */
  'p', /* e3  c  */
  'E', /* e4  d  */
  'o', /* e5  e  */
  'u', /* e6  f  */
  't', /* e7  g  */
  'O', /* e8  h  */
  'O', /* e9  i  */
  'O', /* ea  j  */
  'o', /* eb  k  */
  '~', /* ec  l  */
  'O', /* ed  m  */
  'E', /* ee  n  */
  'A', /* ef  o  */
  '=', /* f0  p  */
  '+', /* f1  q  */
  '>', /* f2  r  */
  '<', /* f3  s  */
  '|', /* f4  t  */
  '|', /* f5  u  */
  '=', /* f6  v  */
  '~', /* f7  w  */
  'o', /* f8  x  */
  '.', /* f9  y  */
  '.', /* fa  z  */
  'V', /* fb  {  */
  'n', /* fc  |  */
  '2', /* fd  }  */
  '*', /* fe  ~  */
  ' '  /* ff del */
};

/* Expand character, possibly ibm pc character set, to something more
   sensible. Control characters are also expanded. Returns one static buffer,
   which is overwritten every call. Result can be of any size, though this
   implementation returns only 1- or 2-character strings. */

#define safeputc(c) { if (strlen(s) < size) *new++ = c; }

char *expand_char(c)
     int c;
{
  static char s[3], *new;
  int size, code;

  size = 3;
  new = s;
  *new = 0;

  if (c < 0 || c > 255) c = c & 255;
  
  switch (code = ctable[c])
    {
     case -1:
      safeputc('^');
      c = c + '@'; /* This really works only for control-chars! */
      safeputc(c);
      break;
      
      /* DEL is converted to ^? */
      
     case -2:
      safeputc('^');
      safeputc('?');
      break;
      
      /* Other chars as translated */
      
     default:
      safeputc(code);
    }

  safeputc(0);
  
  return s;
}

/* Cleans up string from non-ascii characters and expands control characters.
   If string would not fit in size, trailer will be ignored. */

char *
asciify(s, size)
	char *s;
	int size;
{
	char *p, *new;
	int c, code;

	SHUFFLEBUFFERS;

	new = sbuffer;
	*new = 0;
  
	for (p = s; *p; p++) {
		switch (code = ctable[ *(Uchar *) p]) {
		case -1:
			safeputc('^');
			c = *p + '@'; /* This really works only for control-chars! */
			safeputc(c);
			break;

			/* DEL is converted to ^? */

		case -2:
			safeputc('^');
			safeputc('?');
			break;

			/* Other chars as translated */
			
		default:
			safeputc(code);
		}
	}
	safeputc(0);
	
	if (strlen(sbuffer) >= size) {
		log("Asciify: string '%s' becomes '%s'", s, sbuffer);
		log("loses %d characters due to %d character space limit",
		    strlen(sbuffer) - size, size);
	}

	if (strlen(sbuffer)) {
		strncpy(s, sbuffer, size - 1);
		s[size - 1] = 0;
	}
	
	return s;
}

#undef safeputc


/* Strip bad chars from names, ie chars not which may be dangerous in
   different networks. Currectly removes all non-alphanumeric chars,
   but leaves whitespace alone. Strips 8bit chars also. */

void
stripbad(name)
     char *name;
{
	char *s, *string;

	mallocname("stripbad tmp");
	string = s = strsave(name);
	for (; *s; s++) if (isalpha(*s) || isspace(*s) || strchr("-._%!", *s))
		*name++ = *s;
	*name = 0; /* Terminating null, result can be shorter */
	free(string);
}


/* Compare two strings, considering '_' and ' ', and converting
   {|}[\] to aoaAOA instead, and ignoring case.

   stripbad_name(string) does conversion.
   */

char *stripbad_name(s)
	char *s;
{
	char *p;

	p = s;
	while (*s) {
		switch (*s) {
		case '_':
		case '.':
			*s = ' ';
			break;
		case '{':
		case '}':
		case '[':
		case ']':
			*s = 'a';
			break;
		case '|':
		case '\\':
			*s = 'o';
			break;
		default:
			*s = tolower(*s);
		}
		s++;
	}
	return p;
}

#ifdef NEED_STRIP_NEWLINE
char *
strip_newline(s)
	char *s;
{
	char *p;

	if (p = index(s, '\n'))
		*p = '\0';
	return s;
}
#endif

int
stricmp(d, s)
     char *d, *s;
{
	register char *ds, *ss;
	register int result;

	ds = strsave(d);
	ss = strsave(s);
  
	result = strcmp(stripbad_name(ds), stripbad_name(ss));
	free(ds);
	free(ss);
	return result;
}


int
strnicmp(d, s, n)
     char *d, *s;
     int n;
{
	register char *td, *ts;
	register int result;

	td = strsave(d);
	ts = strsave(s);
	result = strncmp(stripbad_name(td), stripbad_name(ts), n);
	free(ts);
	free(td);
	return result;
}

/* Copy string, like strcpy but guarantees overlapping copies to work. */
void
nstrcpy(d, s)
     register char *d, *s;
{
	register int len = strlen(s);
  
	if (d > s)
		for (d += len, s += len, len++; len-- >= 0; *d-- = *s--)
			;
	else
		for (; *d++ = *s++;)
			;
}


#ifndef HAVE_VFPRINTF
  
int
vfprintf(fp, fmt VA_ALIST)
	FILE *fp;
	char *fmt;
	VA_DCL
{
	va_list ap;
	char buffer[BUFSIZ];

	VA_START(ap, fmt);
	vsprintf(buffer, fmt, ap);
	fputs(buffer, fp);
	va_end(ap);
	return 0;
}
#endif

#ifndef HAVE_VSPRINTF
/*
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


int
vsprintf(str, fmt VA_ALIST)
	char *str, *fmt;
	VA_DCL
{
	va_list ap;
	FILE f;
	int len;

	VA_START(ap, fmt);
	f._flag = _IOWRT+_IOSTRG;
	f._ptr = str;
	f._cnt = 32767;
	len = _doprnt(fmt, ap, &f);
	*f._ptr = 0;
	va_end(ap);
	return (len);
}
#endif

#ifndef HAVE_STRSTR

/*
 * strstr - find first occurrence of wanted in s
 */
char *				/* found string, or NULL if none */
strstr(s, wanted)
	const char *s;
	const char *wanted;
{
	register char *scan;
	register int len;
	register char firstc;

	/*
	 * The odd placement of the two tests is so "" is findable.
	 * Also, we inline the first char for speed.
	 * The ++ on scan has been moved down for optimization.
	 */
	firstc = *wanted;
	len = strlen(wanted);
	for (scan = s; *scan != firstc || strncmp(scan, wanted, len) != 0; )
		if (*scan++ == '\0')
			return(NULL);
	return(scan);
}

#endif

#ifndef	HAVE_STRUPR
void
strupr(s)
	register char *s;
{
	for (; *s; s++)
		*s = toupper(*s);
}
#endif
#ifndef	HAVE_STRLWR
void
strlwr(s)
	register char *s;
{
	for (; *s; s++)
		*s = tolower(*s);
}
#endif



#ifdef NEED_STREMPTY
/* Check if string just consists of space (or is null). Return TRUE if so */

boolean
strempty(s)
     char *s;
{
	while (*s) {
		if (!isspace(*s))
			return FALSE;
		else
			s++;
	}
	return TRUE;
}
#endif

/* Clean up space from start and end */

char *
strclean(s)
     char *s;
{
	char *d = s, *p = s;

	/* Find first non-space char */
	for (; *p; p++)
		if (!isspace(*p))
			break;

	/* Copy until end */
	if (d != p)
		while (*d++ = *p++)
			;

	/* Strip space from end */
	while (strlen(s) && isspace(s[strlen(s) - 1]))
		s[strlen(s) - 1] = 0;
	return s;
}

#ifdef NEED_STRSCLEAN
/* Clean up whitespace from start */
char *
strsclean(s)
	char *s;
{
	char *d = s, *p = s;

	/* Find first non-space char */
	for (; *p; p++)
		if (!isspace(*p))
			break;

	/* Copy until end */
	if (d != p)
		while (*d++ = *p++)
			;

	return s;
}
#endif


#ifdef NEED_SSTRCAT
/* Strcat creating its own buffer */

char *
sstrcat(d, s)
	char *d, *s;
{
	SHUFFLEBUFFERS;

	strncpy(tcharp, d, MAX_SHUFFLE_BUFFERSIZE);
	tcharp[MAX_SHUFFLE_BUFFERSIZE - 1] = '\0';
	strncat(tcharp, s, MAX_SHUFFLE_BUFFERSIZE);
	return tcharp;
}
#endif

/* strdup creating its own buffer */
char *
sstrdup(s)
	char *s;
{
	SHUFFLEBUFFERS;

	strncpy(tcharp, s, MAX_SHUFFLE_BUFFERSIZE);
	tcharp[MAX_SHUFFLE_BUFFERSIZE - 1] = '\0';
	return tcharp;
}



/* 
 * Sprintf with own buffer
 */
char *
sprintfs(fmt VA_ALIST)
	char *fmt;
	VA_DCL
{
	va_list pvar;

	VA_START(pvar, fmt);
	SHUFFLEBUFFERS;
	vsprintf(tcharp, fmt, pvar);
	va_end(pvar);
	return tcharp;
}

/*
 * Compare two strings for equality disregarding case
 */
int
struequ(s1, s2)
	register char *s1, *s2;
{
	while (*s1 && tolower(*s1) == tolower(*s2))
		s1++, s2++;
	return tolower(*s1) == tolower(*s2);
}

char *
strnsave(s, n)
	char *s;
	int n;
{
	register char *p;
	
	p = strncpy(mymalloc((Uint) ((n) + 1)), (s), (n));
	p[n] = 0;
	return p;
}


/*
 * strncpy that puts in the final null.
 * Note that the null will be in first the position after the
 * string
 */
void
strncopy(d, s, l)
	char *d, *s;
	int l;
{
	strncpy(d, s, l);
	d[l] = 0;
}
