/*
 * $Header: /u1/src/rfmail/RCS/bsearch.c,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
 *
 * $Log: bsearch.c,v $
 * Revision 0.5.0.1  1992/06/15  06:11:25  pgd
 * Minor compilation bug fixes.
 * Change of all types with u_ prefix to U prefix
 * Change of name of routine msleep() to mssleep()
 *
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 */

#include "fnet.h"

/*

  for (start = table, end = table + items; start < end;) {
    register i;

    item = start + ((end - start) >> 1);
    if ((i = *key - *item->key) == 0 &&
        (i = (*cmpfunction)(key, item->key)) == 0) return item;
    if (i < 0) {
      end = item;
    } else {
      start = item + 1;
    }
  }
  return NULL;
}

*/

#ifndef HAVE_BSEARCH

/* BSD doesn't seem to have bsearch? Weird, but hope this works */
  
char *
bsearch(item, items, nitems, itemsize, cmpfunction)
	char *item, *items;
	Uint nitems;
	Uint itemsize;
	int (*cmpfunction)();
{
	Uint position, step;
	int cmp, lastcmp;
  
	if (items <= 0)
		return NULL;
  
	step = (nitems - 1) / 2;
	position = step;
	if (step < 1) step = 1;
	lastcmp = -2;
  
	while (cmp = (*cmpfunction)(item, items + position * itemsize)) {
		cmp = REDUCE(cmp); /* This maybe isn't necessary ? */
		step = step / 2;
		if (!step) {
			step = 1;
			if (lastcmp != cmp) 
				/* Seems that we are stepping around same point, its not there */
				return NULL;
		}
		if (cmp > 0)
			if (position + step >= nitems) {
				if (step == 1)
					return NULL; /* Fell of the edge */
				else 
					position = nitems - 1;
			} else
				position += step;
		else {
			if (position < step) 
				if (step == 1) 
					return NULL; /* Fell off the edge */
				else
					position = 0;
			else
				position -= step;
		}
		lastcmp = cmp;
	}
	return items + position * itemsize;
}

#endif /* BSD */


#if 0
/* Bfind is like bsearch but returns always something, unless
   zero items searched for. If it cannot find the item, it returns
   the place where the item should be. */

char *bfind(item, items, nitems, itemsize, cmpfunction)
	char *item, *items;
	Uint nitems;
	Uint itemsize;
	int (*cmpfunction)();
{
  Uint position, step;
  int cmp, lastcmp;
  
  if (!items) return NULL;
  
  step = (nitems - 1) / 2;
  position = step;
  if (step < 1) step = 1;
  lastcmp = -2;
  
  while (cmp = (*cmpfunction)(item, items + position * itemsize))
    {
      cmp = REDUCE(cmp); /* This maybe isn't necessary ? */
      step = step / 2;
      if (!step)
	{
	  step = 1;
	  if (lastcmp != cmp) 
	    /* Seems that we are stepping around same point, its not there */
	    while (position &&
		   (*cmpfunction)(item, items + position * itemsize) >= 0) 
	      position--;
	  
	  position++;
	  return (position >= nitems) ?
	    items + (nitems - 1) * itemsize :
	      items + position * itemsize;
	  
	}
      
      if (cmp > 0)
	{
	  if (position + step >= nitems)
	    {
	      if (step == 1) 
		return items + (nitems - 1) * itemsize;
	      else 
		position = nitems - 1;
	    }
	  else 
	    position += step;
	}
      else
	{
	  if (position < step)
	    {
	      if (step == 1) 
		return items;
	      else 
		position = 0;
	    }
	  else 
	    position -= step;
	}
      
      lastcmp = cmp;
    }
  
  return items + position * itemsize; /* Match */
}
#else
/*
 * Perform a binary search.
 *
 * The code below is a bit sneaky.  After a comparison fails, we
 * divide the work in half by moving either left or right. If lim
 * is odd, moving left simply involves halving lim: e.g., when lim
 * is 5 we look at item 2, so we change lim to 2 so that we will
 * look at items 0 & 1.  If lim is even, the same applies.  If lim
 * is odd, moving right again involes halving lim, this time moving
 * the base up one item past p: e.g., when lim is 5 we change base
 * to item 3 and make lim 2 so that we will look at items 3 and 4.
 * If lim is even, however, we have to shrink it by one before
 * halving: e.g., when lim is 4, we still looked at item 2, so we
 * have to make lim 3, then halve, obtaining 1, so that we will only
 * look at item 3.
 */
char *
bfind(key, base0, nmemb, size, compar)
	char *key;
	char *base0;
	size_t nmemb;
	size_t size;
	int (*compar)();
{
	char *base = base0;
	register int lim, cmp;
	register char *p;

	for (lim = nmemb; lim != 0; lim >>= 1) {
		p = base + (lim >> 1) * size;
		cmp = (*compar)(key, p);
		if (cmp == 0)
			return (p);
		if (cmp > 0) {	/* key > p: move right */
			base = (char *)p + size;
			lim--;
		} /* else move left */
	}
	return base;
}

#endif      
