/*
 * Binkley specific stuff
 */

#include "fnet.h"
#include "nodelist.h"
#include "binkley.h"
#include "configs.h"
#include "routing-hash.h"


LDECLARE( void, unlock_node, (Node));
LDECLARE( void, unlock_node, (Node));
LDECLARE( void, arc_packet, (Node, char *, boolean, char *));
LDECLARE( int, get_current_arcmail_name, (char *, char *));

void 
lock_node(node)
	Node node;
{	
}

void
unlock_node(node)
	Node node;
{
}

void
arc_mail(dest, flavour, packetname)
	Node dest;
	char flavour;
	char *packetname;
{
	char outdir[PATH_LEN];
	char flowfile_name[PATH_LEN];
	char arcmail_name[PATH_LEN];
	boolean existing_archive;
	int archive_no;
	boolean do_arc_mail;
	FILE *flowfile;

	/* determine outbound directory name */	

	if (dest.zone != config.mynode.zone)	
		sprintf(outdir, "%s.%03x", config.outdir, dest.zone);
	else 
		sprintf(outdir, "%s", config.outdir); 

	/* determine name of flow file */

	sprintf(flowfile_name, "%s/%04x%04x.", outdir, dest.net, dest.node);
	switch (flavour)
	{
	case ROUTING_ARC_CRASH:
	case ROUTING_CRASH:
	case ROUTING_DOCRASH:
		strcat(flowfile_name, "CLO");
		break;
	case ROUTING_ARC_HOLD:
	case ROUTING_HOLD:
		strcat(flowfile_name, "HLO");
		break;
	default:
		strcat(flowfile_name, "FLO");
	}

	/* lock the destination node, so we avoid interference with Binkley */

	lock_node(dest);

	/* arc mail? */

	switch(flavour)
	{
	case ROUTING_ARC_CRASH:
	case ROUTING_ARC_DIRECT:
	case ROUTING_ARC_HOLD:
	case ROUTING_ARC_TO:
		do_arc_mail = TRUE;
		break;
	default:
		do_arc_mail = FALSE;
	}

	if (do_arc_mail)
		{
		if (!(existing_archive = get_current_arcmail_name(flowfile_name, arcmail_name)))
			{
			/* no arcmail file exists, create a name */

			archive_no = sequencer(config.opackedmailsequence);  		
			sprintf(arcmail_name,"%s/%08d.MO0", outdir, archive_no); 

			log("Create new mail bundle %s for node %s", spoolname(arcmail_name),
						ascnode(dest));

			/* append name to the flowfile */
			
			if (( flowfile = myfopen(flowfile_name, "a")) == NULL)
				{
				log("Can not open flowfile %s for writing",
					flowfile_name);
				return;
				}
			fprintf(flowfile, "\n^%s", arcmail_name);
			fclose(flowfile); 
			}
		else
			log("Append mail for node %s to %s", ascnode(dest), arcmail_name);
		arc_packet(dest, arcmail_name, existing_archive, packetname);
		}
	else
		{
		/* send packet directly */

		if (( flowfile = myfopen(flowfile_name, "a")) == NULL)
			{
			log("Can not open flowfile %s for writing",
				flowfile_name);
			return;
			}
		if (strlen(packetname) != 0)
			fprintf(flowfile, "\n^%s", packetname);
		fclose(flowfile); 
		}
	unlock_node(dest);
}


void 
arc_packet(dest, arcmail_name, existing_arcmail, packetname)
	Node dest;
	char *arcmail_name;
	boolean existing_arcmail;
	char *packetname;
{
	char scratch[128];
	char arcfile[PATH_LEN];
	char cmd_line[3 * PATH_LEN];
	char *p;
	struct dest_info di;

	log("Arcing arcmail to node %s (%s into %s)",
	    ascnode(dest), spoolname(packetname),spoolname(arcmail_name));
	
	di = get_destinfo(dest);
	if (strlen(config.packerinfo[di.packer].arc_cmd) == 0)
		{
		log("Impossible error in arc_mail: no arc command for %s", ascnode(dest));
		return;
		}

	/*
	 * Move to work directory
	 */
	strcpy(scratch, arcmail_name);
	p = strrchr(scratch, '/');
	if (p == NULL)
		log("Impossible error in arc_mail (strrchr(%s))", scratch); 
	else 
		{
		*p = '\0';	

		if (chdir(scratch) == -1)
		log("Impossible error in arc_packet (chdir to %s)",
			scratch);
		}
	
	/* determine temporary archive name */

	strcpy(arcfile, arcmail_name);
	p = strrchr(arcfile, '.') + 1;
	strcpy(p, config.packerinfo[di.packer].ext);

	if ((existing_arcmail) &&
            myrename( arcmail_name, arcfile))
		log("Could not rename %s to %s", spoolname(arcmail_name), spoolname(arcfile));

	/* pack mail */

	strcpy (cmd_line, config.packerinfo[di.packer].arc_cmd);

	log ("Packer command: %s %s %s", cmd_line, arcfile, packetname);

	if (exec_command(cmd_line, arcfile, packetname, NULL)) { 
		log("Can not execute %s", config.packerinfo[di.packer].arc_cmd);
		return; 
	}
	else 
		debug(1, "Arcing successfully completed");

	if (myrename(arcfile, arcmail_name))
		log("Could not rename %s to %s", spoolname(arcfile), spoolname(arcmail_name));
	
	if (unlink(packetname))
		log("$Could not unlink %s", spoolname(packetname));
	return;
}

int
get_current_arcmail_name(flowfile, arcmailname)
	char * flowfile;
	char * arcmailname;
{
	FILE *flowf;
	char line[PATH_LEN];

	if ((flowf = fopen(flowfile, "r")) == NULL)
		if (errno != ENOENT)
			{
			log("Cannot open flowfile %s", spoolname(flowfile));
			return FALSE;
			}
		else
			return FALSE;

	while  (fgets(line, PATH_LEN, flowf) != NULL)
		{
		if (line[strlen(line) -1] == '\n')
			line[strlen(line) - 1] = '\0';

		if ((line[0] = '^') && is_arcmail(line))
			{
			strcpy(arcmailname, line + 1);
			fclose(flowf);
			return TRUE; 
			}
		}
	fclose(flowf);
	return FALSE;
}	
