/*
 * $Header: /u1/src/rfmail/RCS/address.c,v 0.5 1992/05/18 04:27:24 pgd Exp pgd $
 *
 * $Log: address.c,v $
 * Revision 0.5  1992/05/18  04:27:24  pgd
 * New distribution
 *
 * Revision 0.4.1.6  1992/03/15  07:58:52  pgd
 * Untested version
 *
 * Revision 0.4.1.5  1991/09/07  10:37:46  pgd
 * not finished revision check-in
 *
 * Revision 0.4.1.3  1991/06/15  09:33:39  pgd
 * *** empty log message ***
 *
 * disallowed multihop addressing towards fidonet
 * fixed bug with domain!name parsing
 *
 * Revision 0.4  1991/05/08  04:23:43  pgd
 * Initial Beta-release
 *
 *
 */

/* Routines to handle fidonet addresses. Currently addres format in outside
   fidonet is <name>@<node>.<net>.fidonet. This will propablty change when
   zones are coming. Those standards are ready, but I haven't seen them
   yet.

   Mon Oct  3 02:43:49 1988
   zones-format will be <name>@<point>.<node>.<net>.<zone>.fidonet.
   Fidonet-like format maybe would be easier to get used to but
   parsing it with sendmails etc would be more difficult. Notice that there
   certainly will be problems if different number of numbers than 4
   is specified. I will use following solution:

   case 4: assume point.node.net.zone
   case 3: assume node.net.zone (point 0)
   case 2: assume node.net (in current zone, point 0)
   case 1: assume node (in current net, zone, point 0)

   Other way would be to force users to use zones and/or try to check
   other possibilities by checking if its on the nodelist. I don't
   really like points, they make life difficult, they could just be local
   nodes off the nodelist, and no special support would be needed!

   Mon Apr 10 23:00:42 1989
   Added support for address format user.name@p0.f1.n504.z2.fidonet.
   user.name is kinda strange to my eyes so it won't be default, though
   mix like user_name@p0.f1.n504.z2.fidonet might be a good idea?

   Thu Nov 23 00:53:36 1989
   Changed default format to be in p0.f1.n504.z2.domain format. Fidonet domain
   can now be specified in configuration file.
   
   Thu Dec  7 00:28:32 1989
   Fixed internet style addresses.
   
   @(#)Copyright (c) 1987 by Teemu Torma

   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/*
 * Authors:
 *
 * Teemu Torma who wrote the original code (?)
 *
 * Heikki Suonsivu (hsu@hutcs.hut.fi) who made a lot of enhancements
 * 
 * Per Lindqvist (pgd@compuram.bbt.se) who continued to enhance rfmail.
 */

/* LINTLIBRARY */

#include "fnet.h"

#include "nodelist.h"
#include "shuffle.h"
#include "configs.h"
     


/* Allow address wildcard '*' in fidonet addresses. This allows one to use */

boolean allow_address_wildcards = FALSE;

/* 
 * Parse fidonet address to name, net and node. Address contains address,
 * and name, net and node will be returned. Return NULL is it was valid
 * fidonet address, otherwise string to error message.
 */
char *
parse_address(address, name, node)
	char *address, *name;
	Node *node;
{
	static char error[64];
	register char *cp;
	register int cnt;

	for (cp = address, cnt=0; *cp; cp++) if ((*cp=='!')||(*cp=='@'))
		cnt++;
	if(cnt>1) {
		debug(1, "Invalid address: %s: no hops allowed (too many !@)",
		      address);
		sprintf(error, "No hops allowd - Too many @!\n\n\t%s", address);
		return error;
	}
	
	/* make address to lowercase */
	strlwr(address);

	/* Get name. We assume that name has space at least 36 characters 
	   (maximum length of name in fido).
	   First check whether format is name@domain
	   or domain!name format. */
	if ((cp = strchr(address, '!')) != NULL) {
		debug(2, "Fidonet address domain!name");
		*cp = 0;
		for (cp++, cnt = 0; *cp && cnt < 35; cnt++, cp++)
			name[cnt] = *cp;
		name[cnt] = 0;
		cp = address;
		debug(3, "Name %s", name);
	} else {
		debug(2, "Fidonet address name@domain");
		for (cp = address, cnt = 0; *cp && cnt < 35 && *cp != '@'; cp++, cnt++)
			name[cnt] = *cp;
		name[cnt] = 0;
		debug(3, "Name %s", name);

		if (*cp != '@') {
			/* name is too long or address is invalid */
			while (*cp && *cp != '@')
				cp++;
			if (*cp == 0) {
				debug(1, "Invalid address: %s: missing @",
				      address);
				sprintf(error, "No @ in address %s", address);
				return error;
			}
		}
		cp++;
	}

	debug(2, "Address %s, up to '!' or end", cp);
	
	if (!parseinternode(cp, node)) {
		sprintf(error, "Bad address %s", cp);
		return error;
	}
	
	/* we're done */
	return NULL;
}

int
returnbad(errtype, s, node)
     char *errtype, *s;
     Node *node;
{
  debug(2, "Bad address %s : %s, returning my node", s, errtype);
  *node = config.mynode;
  return -1;
}

/* Motorola Unix defines howmany in sys/types.h */
#ifdef howmany
#undef howmany
#endif


/*
 * Parse internet format fidonet address
 *
 * Returns TRUE if success, FALSE if illegal address.
 */
boolean
parseinternode(address, fnode)
	char *address;
	Node *fnode;
{
	int numbers[4], count;
	char *p, *cp;
	int zone, net, node, point;
	boolean gotzone, gotnet, gotnode, gotpoint;
	char scratch[128];
	int l;
	Node *np;
  
	strcpy(scratch, address);

	/* 
	 * Strip off domain part out of address
	 * This assumes that routing domains have been stripped
	 * away already.
	 */
	cp = strend(scratch);
	if (cp >= &scratch[l = strlen(config.fidonet_domain)]
	    && strequ(config.fidonet_domain, cp-l))
		cp[-l] = 0;
	else if (cp >= &scratch[12] && strequ(".fidonet.org", cp-12))
		cp[-12] = 0;
	else if (cp >= &scratch[8] && strequ(".fidonet", cp-8))
		cp[-8] = 0;
	else
		return FALSE;

	if (isdigit(scratch[0])) {
		/*
		 * Numeric format.
		 */
		count = 0;
		for (p = strtok(scratch, "."); p; p = strtok(NULL, ".")) {
			if (!check_atoi(p, &numbers[count++]))
				goto error;
			if (count > 4)
				goto error;
		}
      
		switch (count) {
#ifdef FIDONET_ORDER
		case 4:
			fnode->zone = numbers[0];
			fnode->net = numbers[1];
			fnode->node = numbers[2];
			fnode->point = numbers[3];
			break;
      
		case 3:
			fnode->zone = numbers[0];
			fnode->net = numbers[1];
			fnode->node = numbers[2];
			fnode->point = 0;
			break;
      
		case 2:
			fnode->zone = config.mynode.zone;
			fnode->net = numbers[0];
			fnode->node = numbers[1];
			fnode->point = 0;
			break;
      
		case 1:
			fnode->zone = config.mynode.zone;
			fnode->net = config.mynode.net;
			fnode->node = numbers[0];
			fnode->point = 0;
			break;
#else
		case 4:
			fnode->zone = numbers[3];
			fnode->net = numbers[2];
			fnode->node = numbers[1];
			fnode->point = numbers[0];
			break;
      
		case 3:
			fnode->zone = numbers[2];
			fnode->net = numbers[1];
			fnode->node = numbers[0];
			fnode->point = 0;
			break;
      
		case 2:
			fnode->zone = config.mynode.zone;
			fnode->net = numbers[1];
			fnode->node = numbers[0];
			fnode->point = 0;
			break;
      
		case 1:
			fnode->zone = config.mynode.zone;
			fnode->net = config.mynode.net;
			fnode->node = numbers[0];
			fnode->point = 0;
			break;
#endif
		default:
			return FALSE;
		}
	} else if (np = search_name(scratch, NULL)) {
		/*
		 * rfmail name addressing.
		 */
		*fnode = *np;
	} else {
		/*
		 * Alphanumeric format.
		 * p<point>.f<node>.n<net>.z<zone>
		 */
		gotzone = gotnet = gotnode = gotpoint = FALSE;
		for (p = strtok(scratch, "."); p; p = strtok(NULL, ".")) {
			switch (*p) {
			case 'p':
				if (gotpoint || !check_atoi(p+1, &point))
					goto error;
				gotpoint = TRUE;
				break;

			case 'f':
				if (gotnode || !check_atoi(p+1, &node))
					goto error;
				gotnode = TRUE;
				break;

			case 'n':
				if (gotnet || !check_atoi(p+1, &net))
					goto error;
				gotnet = TRUE;
				break;

			case 'z':
				if (gotzone || !check_atoi(p+1, &zone))
					goto error;
				gotzone = TRUE;
				break;
				
			default:
			error:
				return FALSE;
			}
		}
		if (!gotnode)
			return FALSE;
		fnode->point = gotpoint ? point : 0;
		fnode->node = gotnode ? node : config.mynode.node;
		fnode->net = gotnet ? net : config.mynode.net;
		fnode->zone = gotzone ? zone : config.mynode.zone;
	} 
	return TRUE;
}
       
/* It would have been more sensible if
   fidonet addresses were down to up, it would be easier to parse.

   Fri Oct  7 12:09:21 1988
   Removes non-numeric chars at start, Opus puts 'Opus ' there
   */



/* Return address in string format */

char *
ascnode(node)
     Node node;
{
	SHUFFLEBUFFERS;

	if (node.point)
		sprintf(tcharp, "%d:%d/%d.%d",
			node.zone, node.net, node.node, node.point);
	else
		sprintf(tcharp, "%d:%d/%d",
			node.zone, node.net, node.node);
	return tcharp;
}

char *
ascnode_nozone(node)
     Node node;
{
	SHUFFLEBUFFERS;

	if (node.point)
		sprintf(tcharp, "%d/%d.%d",
			node.net, node.node, node.point);
	else
		sprintf(tcharp, "%d/%d", node.net, node.node);
	return tcharp;
}

char *
ascnode_nopoint(node)
	Node node;
{
	SHUFFLEBUFFERS;

	sprintf(tcharp, "%d:%d/%d", node.zone, node.net, node.node);
	return tcharp;
}

char *
netnode(node)
	Node node;
{
	SHUFFLEBUFFERS;

	sprintf(tcharp, "%d/%d", node.net, node.node);
	return tcharp;
}

/* 
 * Uucp bang path
 */
char *
bangnode(node)
	Node node;
{
	SHUFFLEBUFFERS;

	if (node.point)
		sprintf(tcharp, "z%d!n%d!f%d!p%d", node.zone, node.net,
			node.node, node.point);
	else
		sprintf(tcharp, "z%d!n%d!f%d", node.zone, node.net, node.node);
	return tcharp;
}

/* 
 * Internet format
 */
char *
internode(node)
	Node node;
{
	SHUFFLEBUFFERS;

	if (node.point)
		sprintf(tcharp, "p%d.f%d.n%d.z%d%s",
			node.point, node.node, node.net, node.zone,
			config.fidonet_domain);
	else
		sprintf(tcharp, "f%d.n%d.z%d%s", node.node, node.net, node.zone,
			config.fidonet_domain);
	
	return tcharp;
}

/*
 * Parse a fidonet node specification.
 *
 * Missing parts are flagged with "-1" as number, watch out
 * for this when using the routine.
 *
 * "delimiters" is a string of legal characters that end the
 * node number.
 *
 * Routine returns a pointer to after the found delimiter, or
 * NULL if illegal node address.
 */
char *
parsenode(info, node, delimiters, deflt)
	char *info;
	Node *node, *deflt;
	char *delimiters;
{
	boolean gotzone, gotnet, gotnode, gotdigit, gotpoint;
	register char *cp;
	int c, n = 0;
	Node tmpnode;
	enum {LOOKING_FOR_ZONE, LOOKING_FOR_NET, LOOKING_FOR_NODE, LOOKING_FOR_POINT} state;

	gotzone = gotnet = gotnode = gotpoint = gotdigit = FALSE;
	cp = info;
	while (isspace(*cp)) cp++;

	state = LOOKING_FOR_ZONE;
	for (;;) {
		if (*cp == 0) break;
		if (isdigit(*cp)) {
			n = 0;
			do {
				n = n * 10 + *cp++ - '0';
			} while (isdigit(*cp));
			gotdigit = TRUE;
		} else if (allow_address_wildcards && *cp == '*') {
			n = NODE_WILDCARD;
			gotdigit = TRUE;
			cp++;
		} else
			gotdigit = FALSE;
		c = *cp;
		switch (state) {
		case LOOKING_FOR_ZONE:
			if (c == ':') {
				if (!gotdigit) goto fini;
				tmpnode.zone = n;
				gotzone = TRUE;
				state = LOOKING_FOR_NET;
				break;
			}
		case LOOKING_FOR_NET:
			if (c == '/') {
				if (!gotdigit) goto fini;
				tmpnode.net = n;
				gotnet = TRUE;
				state = LOOKING_FOR_NODE;
				break;
			}
		case LOOKING_FOR_NODE:
			if (gotdigit) {
				tmpnode.node = n;
				gotnode = TRUE;
			}
			if (*cp == '.' && isdigit(cp[1])) {
				state = LOOKING_FOR_POINT;
				break;
			}
			goto fini;
		case LOOKING_FOR_POINT:
			if (!gotdigit) goto fini;
			tmpnode.point = n;
			gotpoint = TRUE;
			goto fini;
		}
		cp++;
	}
fini:					
	if (*cp && (delimiters == NULL || strchr(delimiters, *cp) == NULL))
		return NULL;

	if (!gotzone && !gotnet && !gotnode && !gotpoint)
		return NULL;

	if (deflt) {
		if (!gotzone) tmpnode.zone = deflt->zone;
		if (!gotnet) tmpnode.net = deflt->net;
		if (!gotnode) tmpnode.node = deflt->node;

		/* If point is not specified it is more sensible to use 0 as default */

		if (!gotpoint) tmpnode.point = 0;
	} else {
		if (!gotzone) tmpnode.zone = -1;
		if (!gotnet) tmpnode.net = -1;
		if (!gotnode) tmpnode.node = -1;
		if (!gotpoint) tmpnode.point = 0;
	}
			
	*node = tmpnode;
	return cp;
}


boolean
check_atoi(s, ip)
	char *s;
	int *ip;
{
	register char *cp;

	while (isspace(*s))
		s++;
	for (cp = s; isdigit(*cp); cp++);
	while (isspace(*cp))
		cp++;
	if (*cp)
		return FALSE;
	*ip = atoi(s);
	return TRUE;
}

