#!/bin/sh
case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . config.sh
    ;;
esac
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting Makefile (with variable substitutions)"
: This section of the file will have variable substitutions done on it.
: Move anything that needs config subs from !NO!SUBS! section to !GROK!THIS!.
: Protect any dollar signs and backticks that you do not want interpreted
: by putting a backslash in front.  You may delete these comments.
$spitshell >Makefile <<!GROK!THIS!
#
#	Generic Makefile for rfmail package
#
#	$Header: /u1/src/rfmail/RCS/Makefile.SH,v 0.5.0.1 1992/06/15 06:11:25 pgd Exp pgd $
#
#	$Log: Makefile.SH,v $
# Revision 0.5.0.1  1992/06/15  06:11:25  pgd
# Minor compilation bug fixes.
# Change of all types with u_ prefix to U prefix
# Change of name of routine msleep() to mssleep()
#
# Revision 0.5  1992/05/18  04:24:33  pgd
# New distribution
#
# Revision 0.4.1.6  1992/03/15  07:58:52  pgd
# Untested version
#
# Revision 0.4.1.2  1991/06/05  09:10:16  pgd
# *** empty log message ***
#
# Revision 0.4  1991/05/08  04:23:43  pgd
# Initial Beta-release
#
#
#	@(#)Copyright (C) Teemu Torma 1987
#
#	pgd@compuram.bbt.se
#
# NOTE: This file is automatically genereated by Makefile.SH, all
# changes you do here, will go away when re-configuring rfmail.
#

###########################################################################
#
# The following definitions are automatically generated by 
# the Configure program
# 
CONFIG_LIBS = $ndirlib $libx
EXTRA_OBJS = $gethostname_o
EXTRA_SRCS = $gethostname_c
CAT = $spitshell
SED = $sed
ECHO = $echo
MKDIR = $mkdir
CP = $cp
RM = $rm
GCC = $gcc
Ccflags = $ccflags
Ldflags = $ldflags
Huge = $huge
Large = $large
Split = $split

#
# End of automatically generated definitions
#
###########################################################################

!GROK!THIS!

: In the following dollars and backticks do not need the extra backslash.
$spitshell >>Makefile <<'!NO!SUBS!'
#
# Define the following file to the latest ftscprod.??? file
#
FTSCPROD = ftscprod.048

INCLUDE	=	/usr/include
INSTALLER	=	$(CP)

#
# Use -g for debugging, -O for optimizer
#
# The following flags for gcc:
CCFLAGS	= -W -Wreturn-type -Wunused -Wshadow -Wcast-qual -Wimplicit -Wpointer-arith # -pedantic
# The following flags for SCO and microsoft compiler
#CCFLAGS = -O -Zi -g
#-DMALLOC_DEBUGGER
#CCFLAGS = -W1
#CCFLAGS = -g
MKDEP = gcc -MM

CFLAGS = $(CCFLAGS) $(Ccflags)

LDFLAGS = $(CFLAGS) $(Ldflags) $(Split) $(Huge) $(Large)

#
# C compiler.
#CC	=	cc
CC	=	gcc
# CC	=	gcc -pipe
# CC	=	mcc gcc -pipe

#
# Lint flags. Usually like CFLAGS.
#
LNFLAGS	= -c -u -h

#
# Add -lbsd or ndir or whatever to include posix-compatible scandir
# Add -lPW on sysv
# (-lmalldeb)
# LIBS	=	-lPW -ldial
LIBS	= ${CONFIG_LIBS}

# Owner and group for rfmail programs
OWNER	=	uucp
# GROUP	=	mail
GROUP 	=	uucp

# These should be those in "config.h", helps in installing the stuff
# (jari@krkct)

LIBDIR	=	/usr/lib/fnet
SPOOLDIR=	/usr/spool/fnet
DIRS	=	$(LIBDIR) $(SPOOLDIR) $(SPOOLDIR)/unpacked \
		$(SPOOLDIR)/sentbundles $(SPOOLDIR)/bad

# This should be where real rmail is (see "rmail.h")
RMAIL_LIB = 	/usr/lib

TAGS = etags

# ------------------------------------------------------------------------
# There shouldn't be any need to change following (?)
# ------------------------------------------------------------------------

COMMON_OBJECTS	=	shuffle.o config.o funcs.o chars.o \
			config-hash.o key-hash.o packet-hash.o \
			packer-hash.o nodelist.o address.o \
			locks.o bsearch.o routing-hash.o 

COMMON_CFILES	=	shuffle.c config.c funcs.c chars.c \
			config-hash.c key-hash.c packet-hash.c \
			packer-hash.c nodelist.c address.c \
			locks.c bsearch.c routing-hash.c \
			rfc822.c getdate.c 

NDIFF	=	ndiff.o
LNDIFF	=	ndiff.c

RMAIL	=	rmail.o $(COMMON_OBJECTS)
LRMAIL	=	rmail.c lintlib.c $(COMMON_CFILES)

RFMAIL	=	rfmail.o $(EXTRA_OBJS) getdate.o packet.o \
		funpack.o fpack.o crc.o $(GETHOSTNAME_O) rfc822.o \
		binkley.o $(COMMON_OBJECTS)
LRFMAIL	=	rfmail.c $(EXTRA_SRCS) lintlib.c packet.c \
		funpack.c fpack.c $(GETHOSTNAME_C) \
		$(COMMON_CFILES)

FCALL	=	fcall.o fio.o xtsend.o xtrec.o crc.o dial.o cleanf.o \
		freq.o sched.o zm.o zr.o zs.o yoohoo.o $(COMMON_OBJECTS)
LFCALL	=	fcall.c fio.c xtsend.c xtrec.c crc.c dial.c cleanf.c \
		freq.c sched.c zm.c zr.c zs.c yoohoo.c lintlib.c $(COMMON_CFILES)

RFCONFIG =	rfconfig.o $(COMMON_OBJECTS)
LRFCONFIG =	rfconfig.c $(COMMON_CFILES)

RFSTATUS =	rfstatus.o getmessage.o packet.o getdate.o \
			$(COMMON_OBJECTS)
LRFSTATUS =	rfstatus.c getmessage.c packet.c \
			$(COMMON_CFILES)

RFSEND	=	rfsend.o $(COMMON_OBJECTS)
LRFSEND	=	rfsend.c $(COMMON_CFILES)

FIDO	=	fido.o
LFIDO	=	fido.c


NODECOMP =	nodecomp.o funcs.o nodelist.o chars.o bsearch.o config.o address.o \
		routing-hash.o key-hash.o packet-hash.o packer-hash.o \
		shuffle.o config-hash.o locks.o ndcomp-hash.o

ADDRESS	=	addres.o lex.yy.o shuffle.o funcs.o

HASHGEN	=	hashgen.o

LHASHGEN =	hashgen.c

CFILES	=	rfmail.c funcs.c rmail.c fpack.c funpack.c fcall.c \
                fio.c xtsend.c xtrec.c nodelist.c \
                address.c crc.c lintlib.c config.c rfconfig.c \
		bsearch.c \
		dial.c locks.c shuffle.c \
		cleanf.c hashgen.c \
		getmessage.c rfstatus.c packet.c \
		fido.c rfsend.c chars.c freq.c zm.c zr.c zs.c yoohoo.c \
		fidoquery.c gethostnam.c ndiff.c sched.c nodecomp.c \
		rfc822.c getdate.c

HFILES	=	fnet.h packet.h rmail.h crc.h shuffle.h \
		nodelist.h fnews.h longnames.h unistd.h fcall.h \
		directory.h configs.h declare.h \
		xmodem.h \
		zmodem.h config.h rfmail.h timeb.h

OTHERFILES =	README HISTORY INSTALL LICENCE \
		TODO THANKS MANIFEST Alias fcaller zmh \
		getdate.y packer fnetdemn.day \
	        rfmail.cf \
		config.h.bsd config.h.usg ChangeLog \
		Makefile.SH \
		config.hash routing.hash ndcomp.hash \
		lint-sed ftscprod.awk $(FTSCPROD) \
		Configure conf.h.SH rfc822.y

ALLFILES =	$(OTHERFILES) $(HFILES) $(CFILES)

# Add rmail to build rmail
ALL	=	fido rfsend hashgen rfstatus ndiff \
		fcall rfmail rmail rfconfig nodecomp
ALL_LN	=	fpack funpack rfnews

# You could add Alias rfmail.cf but it may be confusing, it would be better
# to compare new configuration file against previous version, typically
# most values have reasonable defaults.

OTHERS	= 	packer fcaller zmh fnetdemn.day

all:		${ALL} ${ALL_LN}
	touch all

bsd43:
	@if [ -f rfmail.cf ] \
	then \
		$(ECHO) rfmail.cf already exists, please make sure all new \
		$(ECHO) additions in this version will be added to your \
		$(ECHO) rfmail.cf \
	fi
	@if [ -f config.h ] \
	then \
		$(ECHO) config.h already exists, please compare it with \
		$(ECHO) config.h.bsd43 to make sure all new additions \
		$(ECHO) will be added. \
	else \
		ln config.h.bsd43 config.h \
	fi \
	$(ECHO) edit config.h and rfmail.cf for your system,
	$(ECHO) type make depend; make all

svr3:
	@if [ -f rfmail.cf ] ; \
	then \
		$(ECHO) "'rfmail.cf' already exists, please make sure all new";\
		$(ECHO) "additions in this version will be added to your 'rfmail.cf'"; \
	fi
	@if [ -f config.h ] ; \
	then \
		$(ECHO) "'config.h' already exists, please compare it with"; \
		$(ECHO) "'config.h.svr3' to make sure all new additions will be added."; \
	else \
		ln config.h.svr3 config.h ; \
	fi 
	@$(ECHO) edit config.h and rfmail.cf for your system,
	@$(ECHO) then make depend; make all

hashgen.o : hashgen.c config.h conf.h

hashgen:	$(HASHGEN)
	$(CC) $(LDFLAGS) $(HASHGEN) -o hashgen

config-hash.h config-hash.c: config.hash hashgen
	./hashgen -dc -i config.hash -o config-hash -s config_hash -z CONFIG_

routing-hash.h routing-hash.c: routing.hash hashgen
	./hashgen -dc -i routing.hash -o routing-hash -s routing_hash -z ROUTING_

ndcomp-hash.h ndcomp-hash.c: ndcomp.hash hashgen
	./hashgen -dc -i ndcomp.hash -o ndcomp-hash -s nodecomp_hash -z NODEFLAG_

key-hash.h key-hash.c: key.hash hashgen
	./hashgen -dc -i key.hash -o key-hash -s key_hash -z KEY_

packer-hash.h packer-hash.c: packer.hash hashgen
	./hashgen -dc -i packer.hash -o packer-hash -s packer_hash -z PACKER_

packet-hash.h packet-hash.c: packet.hash hashgen
	./hashgen -dc -i packet.hash -o packet-hash -s packet_hash -z PACKETTYPE_


getdate.c: 	getdate.y
	@$(ECHO) "expect 8 shift/reduce conflicts"
	bison getdate.y
	mv getdate.tab.c getdate.c

rfc822.c:	rfc822.y
	bison rfc822.y
	mv rfc822.tab.c rfc822.c

rfmail:		${RFMAIL}
	-$(RM) -f $@
	$(CC) $(LDFLAGS) -o $@ $(RFMAIL) ${LIBS}

funpack rfnews fpack: rfmail
	-$(RM) -f $@
	rm -f $@
	ln rfmail $@

fcall:		${FCALL}
	-$(RM) -f $@
	$(CC) ${LDFLAGS} -o $@ $(FCALL) ${LIBS}

rmail:		${RMAIL}
	-$(RM) -f $@
	$(CC) ${LDFLAGS} -o $@ $(RMAIL) ${LIBS}

rfconfig:	$(RFCONFIG)
	-$(RM) -f $@
	$(CC) $(LDFLAGS) -o $@ $(RFCONFIG) $(LIBS)

rfstatus:	$(RFSTATUS)
	-$(RM) -f $@
	$(CC) $(LDFLAGS) -o $@ $(RFSTATUS) $(LIBS)

address:	$(ADDRESS)
	-$(RM) -f $@
	$(CC) $(LDFLAGS) -o $@ $(ADDRESS) $(LIBS)

fido:		$(FIDO)
	-$(RM) -f $@
	$(CC) $(LDFLAGS) -o $@ $(FIDO) $(LIBS)

rfsend:		$(RFSEND)
	-$(RM) -f $@
	$(CC) $(LDFLAGS) -o $@ $(RFSEND) $(LIBS)

ndiff:		$(NDIFF)
	-$(RM) -f $@
	$(CC) $(LDFLAGS) -o $@ $(NDIFF) $(LIBS)

nodecomp:	$(NODECOMP)
	-$(RM) -f $@
	$(CC) $(LDFLAGS) -o $@ $(NODECOMP) $(LIBS)


# The following is more shell independent with older dumb make preprocessors
# jari@krkct

install:	all
	@for i in $(DIRS); \
	do \
		if [ ! -d $$i ] ; then $(ECHO) "Creating directory $$i ... \c"; \
			$(MKDIR) $$i; \
			chmod 750 $$i; \
			chown ${OWNER} $$i; \
			chgrp ${GROUP} $$i; \
			$(ECHO) "done."; \
		fi; \
	done
	@$(ECHO) "Moving ${ALL} into ${LIBDIR}"
	-$(INSTALLER) ${ALL} ${LIBDIR} 
	rm -f ${LIBDIR}/funpack ${LIBDIR}/fpack ${LIBDIR}/rfnews
	ln ${LIBDIR}/rfmail ${LIBDIR}/funpack
	ln ${LIBDIR}/rfmail ${LIBDIR}/fpack
	ln ${LIBDIR}/rfmail ${LIBDIR}/rfnews
	@$(ECHO) "Moving ${OTHERS} into ${LIBDIR}"
	-$(INSTALLER) ${OTHERS} ${LIBDIR}
	@$(ECHO) "Changing ownerships and modes"
	@cd ${LIBDIR} ; chmod 6755 ${ALL} ${ALL_LN}
	@cd ${LIBDIR} ; chgrp ${GROUP} ${OTHERS}
	@cd ${LIBDIR} ; chown ${OWNER} ${ALL} ${ALL_LN} ${OTHERS}
	@$(ECHO) "\nDONE."


# Use this if you don't have a proper mailer (see rmail.c)

rmail-install:	rmail
	@if [ ! -f $(RMAIL_LIB)/rmail ]; then \
		$(ECHO) "Changing /bin/rmail ... \c"; \
		ln /bin/rmail $(RMAIL_LIB)/rmail; \
		$(RM) /bin/rmail; \
		$(CP) rmail /bin; \
		chmod 2755 /bin/rmail; \
		chown bin /bin/rmail; chgrp mail /bin/rmail; \
		$(ECHO) "done."; \
	else $(ECHO) "$(RMAIL_LIB)/rmail exists, updating /bin/rmail ... \c"; \
		$(CP) rmail /bin; \
		chmod 2755 /bin/rmail; \
		chown bin /bin/rmail; chgrp mail /bin/rmail; \
		$(ECHO) "done."; \
	fi


lrmail:
	lint $(LNFLAGS) $(LRMAIL) $(LIBS)

lrfmail:
	lint $(LNFLAGS) $(LRFMAIL) $(LIBS)

lfcall:
	lint $(LNFLAGS) $(LFCALL) $(LIBS)

lrfconfig:
	lint $(LNFLAGS) $(LRFCONFIG) $(LIBS)

lfido:
	lint $(LNFLAGS) $(LFIDO) $(LIBS)

lrfsend:
	lint $(LNFLAGS) $(LRFSEND) $(LIBS)

lndiff:
	lint $(LNFLAGS) $(LNDIFF) $(LIBS)

lint:	lfcall lrfmail lrfconfig lrmail lfido \
	lrfsend lndiff

tar:
	tar cf - $(ALLFILES) | compress > rfmail050.t.Z

zip:
	zip -9 rfmail050 $(ALLFILES)

backup:
	tar cv $(ALLFILES)

wc:
	wc $(ALLFILES)

edit:
	co -l $(ALLFILES)

look:
	co $(ALLFILES)

rcs:
	ci $(ALLFILES)
#	co Makefile.SH

Makefile: Makefile.SH
	sh Makefile.SH
	make depend
	
shar:
	shar -vc -l50 -orfmail.050 $(ALLFILES)

# change previous version number here
diff:
#	diff -c $(OTHERFILES) $(CFILES) $(HFILES) fnetdist/0.3.3
	diff -c $(OTHERFILES) $(CFILES) $(HFILES) rfmail-0350

clean:
	-$(RM) -f ${ALL}
	-$(RM) -f *.o .make .unpack .lint log loki .depend *~
	-$(RM) -f *.idx config-hash.h config-hash.c ndcomp-hash.c 
	-$(RM) -f routing-hash.h routing-hash.c
	-$(RM) -f packer-hash.h packer-hash.c
	-$(RM) -f packet-hash.h packet-hash.c
	-$(RM) -f key-hash.h key-hash.c

depend: Makefile config-hash.h routing-hash.h ndcomp-hash.h key-hash.h packer-hash.h packet-hash.h
	${MKDEP} $(CFILES) >.depend
	( ${SED} -e '/^# DO NOT DELETE THIS LINE/,$$d' <Makefile  ; \
	  ${ECHO} "# DO NOT DELETE THIS LINE -- make depend DEPENDS ON IT" ; \
	  ${CAT} <.depend ; \
	  ${ECHO} "# *** Do not add anything here - It will go away. ***" ) \
		> Makefile.new
	mv Makefile.new Makefile

#
# RCS
#

METACONFIG = metaconfig U/*

co:
	co -l $(OTHERFILES) $(CFILES) $(HFILES)

ci:
	ci -l0.5 $(OTHERFILES) $(CFILES) $(HFILES) $(METACONFIG)

rcsdiff:
	rcsdiff -c -r0.4.1.4 -r0.4.1.5 $(OTHERFILES) $(CFILES) $(HFILES) $(METACONFIG)

tags:
	$(TAGS) $(CFILES) $(HFILES)
	
#
# Convert ftscprod.??? file to prodcode.h
#
prodcode.h : $(FTSCPROD) ftscprod.awk
	awk -f ftscprod.awk <$(FTSCPROD) >prodcode.h

# DO NOT DELETE THIS LINE -- make depend DEPENDS ON IT
rfmail.o : rfmail.c fnet.h conf.h declare.h config.h nodelist.h configs.h packet.h \
  rfmail.h routing-hash.h 
funcs.o : funcs.c fnet.h conf.h declare.h config.h nodelist.h shuffle.h configs.h \
  directory.h packet.h prodcode.h routing-hash.h 
rmail.o : rmail.c fnet.h conf.h declare.h config.h rmail.h nodelist.h configs.h 
fpack.o : fpack.c fnet.h conf.h declare.h config.h nodelist.h configs.h packet.h \
  routing-hash.h rfmail.h 
funpack.o : funpack.c fnet.h conf.h declare.h config.h nodelist.h configs.h \
  fnews.h packet.h routing-hash.h rfmail.h 
fcall.o : fcall.c fnet.h conf.h declare.h config.h nodelist.h fcall.h configs.h \
  packet.h xmodem.h zmodem.h directory.h 
fio.o : fio.c fnet.h conf.h declare.h config.h fcall.h 
xtsend.o : xtsend.c fnet.h conf.h declare.h config.h fcall.h crc.h xmodem.h 
xtrec.o : xtrec.c fnet.h conf.h declare.h config.h fcall.h crc.h xmodem.h 
nodelist.o : nodelist.c fnet.h conf.h declare.h config.h nodelist.h configs.h \
  shuffle.h 
address.o : address.c fnet.h conf.h declare.h config.h nodelist.h shuffle.h \
  configs.h 
crc.o : crc.c fnet.h conf.h declare.h config.h 
lintlib.o : lintlib.c config.h unistd.h 
config.o : config.c fnet.h conf.h declare.h config.h nodelist.h configs.h config-hash.h \
  routing-hash.h 
rfconfig.o : rfconfig.c fnet.h conf.h declare.h config.h nodelist.h configs.h 
bsearch.o : bsearch.c fnet.h conf.h declare.h config.h 
dial.o : dial.c fnet.h conf.h declare.h config.h nodelist.h configs.h fcall.h 
locks.o : locks.c fnet.h conf.h declare.h config.h nodelist.h configs.h 
shuffle.o : shuffle.c fnet.h conf.h declare.h config.h shuffle.h 
cleanf.o : cleanf.c fnet.h conf.h declare.h config.h nodelist.h configs.h shuffle.h 
hashgen.o : hashgen.c conf.h config.h 
getmessage.o : getmessage.c fnet.h conf.h declare.h config.h nodelist.h configs.h \
  packet.h 
rfstatus.o : rfstatus.c fnet.h conf.h declare.h config.h nodelist.h configs.h \
  packet.h 
packet.o : packet.c fnet.h conf.h declare.h config.h nodelist.h configs.h packet.h \
  rfmail.h 
fido.o : fido.c fnet.h conf.h declare.h config.h nodelist.h configs.h 
rfsend.o : rfsend.c fnet.h conf.h declare.h config.h nodelist.h configs.h 
chars.o : chars.c fnet.h conf.h declare.h config.h shuffle.h 
freq.o : freq.c fnet.h conf.h declare.h config.h fcall.h nodelist.h configs.h \
  xmodem.h zmodem.h directory.h packet.h 
zm.o : zm.c fnet.h conf.h declare.h config.h fcall.h zmodem.h crc.h 
zr.o : zr.c fnet.h conf.h declare.h config.h zmodem.h nodelist.h configs.h crc.h \
  fcall.h 
zs.o : zs.c fnet.h conf.h declare.h config.h zmodem.h crc.h fcall.h 
yoohoo.o : yoohoo.c fnet.h conf.h declare.h config.h fcall.h nodelist.h configs.h \
  packet.h crc.h zmodem.h 
fidoquery.o : fidoquery.c 
gethostnam.o : gethostnam.c fnet.h conf.h declare.h config.h 
ndiff.o : ndiff.c fnet.h conf.h declare.h config.h 
sched.o : sched.c fnet.h conf.h declare.h config.h fcall.h nodelist.h configs.h \
  xmodem.h zmodem.h directory.h packet.h routing-hash.h 
nodecomp.o : nodecomp.c fnet.h conf.h declare.h config.h nodelist.h configs.h \
  shuffle.h ndcomp-hash.h 
rfc822.o : rfc822.c 
getdate.o : getdate.c fnet.h conf.h declare.h config.h 
# *** Do not add anything here - It will go away. ***
!NO!SUBS!
chmod 755 Makefile
$eunicefix Makefile
