/*
 * Window file
 * Pink House Systems, October 1993
 */

#include <stdio.h>
#include "tty.h"
#include "window.h"


window::window(int _startx, int _starty, int _rows, int _columns)
{
    startx  = _startx;
    starty  = _starty;
    rows    = _rows;
    columns = _columns;
    cursorx = cursory = 0;    
}


int window::write(char *str, int length)
{
    return tty_write(str, length);
}


int window::putch(char c)
{
    return tty_write(&c, 1);
}


void window::cursormove(int y, int x)
{
    tty_cursormove(y + starty, x + startx);
}
