/*
 * Linux tty interface header file
 * Pink House Systems, October 1993
 */

#ifndef __TTY_H
#define __TTY_H


#define OFF			0
#define ON			1

#define BLACK			0
#define RED			1
#define GREEN			2
#define YELLOW			3
#define BLUE			4
#define MAGENTA			5
#define CYAN			6
#define WHITE			7


#define KEY_NOKEY		0000		// No key (error)

#define KEY_CTRLA		0001		// ^A
#define KEY_CTRLB		0002		// ^B
#define KEY_CTRLC		0003		// ^C
#define KEY_CTRLD		0004		// ^D
#define KEY_CTRLE		0005		// ^E
#define KEY_CTRLF		0006		// ^F
#define KEY_CTRLG		0007		// ^G
#define KEY_CTRLH		0010		// ^H
#define KEY_CTRLI		0011		// ^I	(Tab)
#define KEY_CTRLJ		0012		// ^J
#define KEY_CTRLK		0013		// ^K
#define KEY_CTRLL		0014		// ^L
#define KEY_CTRLM		0015		// ^M	(Enter)
#define KEY_CTRLN		0016		// ^N
#define KEY_CTRLO		0017		// ^O
#define KEY_CTRLP		0020		// ^P
#define KEY_CTRLQ		0021		// ^Q
#define KEY_CTRLR		0022		// ^R
#define KEY_CTRLS		0023		// ^S
#define KEY_CTRLT		0024		// ^T
#define KEY_CTRLU		0025		// ^U
#define KEY_CTRLV		0026		// ^V
#define KEY_CTRLW		0027		// ^W
#define KEY_CTRLX		0030		// ^X
#define KEY_CTRLY		0031		// ^Y
#define KEY_CTRLZ		0032		// ^Z

#define KEY_TAB        		0011           	// Tab
#define KEY_ENTER       	0015           	// Enter
#define KEY_ESC			0033		// Esc
#define KEY_ALTENTER		0037		// Left alt + enter
#define KEY_SPACE		0040		// Space
#define KEY_BACKSPACE   	0177           	// Backspace

#define KEY_END			0401		// End
#define KEY_DOWN        	0402		// Up
#define KEY_UP          	0403		// Down
#define KEY_LEFT        	0404		// Right
#define KEY_RIGHT       	0405           	// Left
#define KEY_HOME        	0406           	// Home key 

#define KEY_F1			0411		// Function keys
#define KEY_F2			0412
#define KEY_F3			0413
#define KEY_F4			0414
#define KEY_F5			0415	
#define KEY_F6			0416
#define KEY_F7			0417
#define KEY_F8			0420
#define KEY_F9			0421
#define KEY_F10			0422
#define KEY_F11			0423
#define KEY_F12			0424

#define KEY_SHIFTF1		KEY_F11		// Shift & function keys
#define KEY_SHIFTF2		KEY_F12	
#define KEY_SHIFTF3		0432	
#define KEY_SHIFTF4		0433	
#define KEY_SHIFTF5		0434
#define KEY_SHIFTF6		0435
#define KEY_SHIFTF7		0436	
#define KEY_SHIFTF8		0437	
#define KEY_SHIFTF9		0440	
#define KEY_SHIFTF10		0441	
#define KEY_SHIFTF11		KEY_F11
#define KEY_SHIFTF12		KEY_F12	

#define KEY_DEL         	0512           // Delete
#define KEY_INS         	0513           // Insert
#define KEY_NPAGE       	0522           // PageDown
#define KEY_PPAGE       	0523           // PageUp

#define KEY_ALT0		0600
#define KEY_ALT1		0601
#define KEY_ALT2		0602
#define KEY_ALT3		0603
#define KEY_ALT4		0604
#define KEY_ALT5		0605
#define KEY_ALT6		0606
#define KEY_ALT7		0607
#define KEY_ALT8		0610
#define KEY_ALT9		0611

#define KEY_ALTA		0700
#define KEY_ALTB		0701
#define KEY_ALTC		0702
#define KEY_ALTD		0703
#define KEY_ALTE		0704
#define KEY_ALTF		0705
#define KEY_ALTG		0706
#define KEY_ALTH		0707
#define KEY_ALTI		0710
#define KEY_ALTJ		0711
#define KEY_ALTK		0712
#define KEY_ALTL		0713
#define KEY_ALTM		0714
#define KEY_ALTN		0715
#define KEY_ALTO		0716
#define KEY_ALTP		0717
#define KEY_ALTQ		0720
#define KEY_ALTR		0721
#define KEY_ALTS		0722
#define KEY_ALTT		0723
#define KEY_ALTU		0724
#define KEY_ALTV		0725
#define KEY_ALTW		0726
#define KEY_ALTX		0727
#define KEY_ALTY		0730
#define KEY_ALTZ		0731

#define KEY_ALTa		0740
#define KEY_ALTb		0741
#define KEY_ALTc		0742
#define KEY_ALTd		0743
#define KEY_ALTe		0744
#define KEY_ALTf		0745
#define KEY_ALTg		0746
#define KEY_ALTh		0747
#define KEY_ALTi		0750
#define KEY_ALTj		0751
#define KEY_ALTk		0752
#define KEY_ALTl		0753
#define KEY_ALTm		0754
#define KEY_ALTn		0755
#define KEY_ALTo		0756
#define KEY_ALTp		0757
#define KEY_ALTq		0760
#define KEY_ALTr		0761
#define KEY_ALTs		0762
#define KEY_ALTt		0763
#define KEY_ALTu		0764
#define KEY_ALTv		0765
#define KEY_ALTw		0766
#define KEY_ALTx		0767
#define KEY_ALTy		0770
#define KEY_ALTz		0771



typedef struct 
{
    int fg_color, bg_color;
    int br_status, rv_status, bl_status;
} tty_colors;


void tty_init(void);
void tty_end(void);
void tty_clrscr(void);
void tty_cursormove(int y, int x);
void tty_foreground(int color);
void tty_background(int color);
void tty_bright(int status);
void tty_reverse(int status);
void tty_blink(int status);
void tty_beep(void);
void tty_defaults(void);
void tty_getcolors(tty_colors *col);
void tty_setcolors(tty_colors *col);
int  tty_write(char *buf, int length);
int  tty_read(char *buf, int length);
int  tty_getch(void);
void tty_putch(int c);
int  tty_getkey(void);
void tty_getsize(int *columns, int *rows);
void tty_getscreen(char *buf);
void tty_putscreen(char *buf);
int  tty_getcolorindex(char *colorname);


#endif
