/*
 * Status line file
 * Pink House Systems, October 1993
 */

#include <curses.h>
#include <string.h>
#include "tty.h"
#include "window.h"
#include "status.h"


static window *status_win;
static char stemp[256];
static int columns;
static int line;
static char *default_msg;
static char dummy[] = "";


#define STATUSBAR_FIELDS	9

static char StatusBarFields[STATUSBAR_FIELDS][40] = 
{
    "StatusBarForeground",
    "StatusBarBackground",
    "StatusBarBrightness",
    "StatusBarWarningForeground",
    "StatusBarWarningBackground",
    "StatusBarWarningBrightness",
    "StatusBarErrorForeground",
    "StatusBarErrorBackground",
    "StatusBarErrorBrightness"
};

static int StatusBarColors[STATUSBAR_FIELDS] = 
{
    BLACK, CYAN, ON, BLACK, WHITE, OFF, WHITE, RED, ON
};

static int& StatusBarForeground 	= StatusBarColors[0];
static int& StatusBarBackground 	= StatusBarColors[1];
static int& StatusBarBrightness 	= StatusBarColors[2];
static int& StatusBarWarningForeground 	= StatusBarColors[3];
static int& StatusBarWarningBackground 	= StatusBarColors[4];
static int& StatusBarWarningBrightness 	= StatusBarColors[5];
static int& StatusBarErrorForeground 	= StatusBarColors[6];
static int& StatusBarErrorBackground 	= StatusBarColors[7];
static int& StatusBarErrorBrightness 	= StatusBarColors[8];


void status_init(int _columns, int _begin_y, 
                 char *def_msg, configuration *config)
{
    char *data;
    int sectionptr, index;
    
    columns = _columns;
    line    = _begin_y;
    default_msg = def_msg;
    status_win = new window(0, _begin_y, 1, _columns);

    if (config->getstatus() == STATUS_OK)
    {
        if ((sectionptr = config->getsectionptr("[Colors]")) != -1)
            for (int i = 0; i < STATUSBAR_FIELDS; i++)
            {
                config->getfielddata(sectionptr, StatusBarFields[i], &data, 1);
                if (!data || (index = tty_getcolorindex(data)) == -1)
                    printf("Invalid %s (%s).\n", StatusBarFields[i], data);
	        else
                    StatusBarColors[i] = index;
            }
    }
} 


void status_end(void)
{
    delete status_win;
}


int status(char *msg_name, int wait, int sound, int restore, int msg_type)
{
    tty_colors c;
    int key = 0, len;
    

    tty_getcolors(&c);
    
    memset(stemp, ' ', columns);
    if (msg_name == NULL) msg_name = dummy;
    len = strlen(msg_name);
    if (len < columns)    
        memcpy(stemp + ((columns - len) >> 1), msg_name, len);
    else
        memcpy(stemp, msg_name, columns);

    for (int i = 0; i < columns; i++)
        if (stemp[i] == '\r' || stemp[i] == '\n' || stemp[i] == '\t')
            stemp[i] = ' ';

    if (sound) tty_beep();
    switch (msg_type)
    {
        case MSG_WARNING:
             tty_bright(StatusBarWarningBrightness);
             tty_foreground(StatusBarWarningForeground);
             tty_background(StatusBarWarningBackground);
             break;
             
        case MSG_ERROR:
             tty_bright(StatusBarErrorBrightness);
             tty_foreground(StatusBarErrorForeground);
             tty_background(StatusBarErrorBackground);
             break;
             
        default:
             tty_bright(StatusBarBrightness);
             tty_foreground(StatusBarForeground);
             tty_background(StatusBarBackground);
             break;
    }
    status_win->cursormove(0, 0);
    status_win->write(stemp, columns);

    if (wait)
        while ((key = tty_getkey()) == 0)
            status_win->cursormove(line, columns);
    
    if (restore)
    {
        memset(stemp, ' ', columns);
        len = strlen(default_msg);
        if (len < columns)    
            memcpy(stemp + ((columns - len) >> 1), default_msg, len);
        else
            memcpy(stemp, default_msg, columns);
        tty_bright(StatusBarBrightness);
        tty_foreground(StatusBarForeground);
        tty_background(StatusBarBackground);
        status_win->cursormove(0, 0);
        status_win->write(stemp, columns);
    }
    
    tty_setcolors(&c);
    return key;
}
