/*
 * Panel header file
 * Pink House Systems, October 1993
 */

#ifndef __PANEL_H
#define __PANEL_H


#include <dirent.h>
#include <sys/param.h>
#include "edit.h"
#include "config.h"

#define MAX_ENTRIES	0x400


enum 
{
    act_NOACTION,
    act_ENTER,
    act_COPY,
    act_DELETE,
    act_SELECT,
    act_SELECTALL,
    act_UNSELECTALL,
    act_TOGGLE,
    act_MODE,
    act_MKDIR,
    act_MOVE,
    act_UP,
    act_DOWN,
    act_PGUP,
    act_PGDOWN,
    act_HOME,
    act_END,
    act_CHDIR,    
    act_REFRESH,
    act_SWITCH
};


enum 
{
    DIR_ENTRY,
    FILE_ENTRY,
    SYMLINK_ENTRY
};


typedef struct
{
    char *name;
    unsigned char selected   : 1,
    		  type       : 2,
    		  executable : 1;
    int  size, mode, uid, gid;
    char owner[8];
    char group[8];
    char date[15];
} _dir_entry;


class panel
{
    window *win;
    DIR *dir;
    int on_screen;
    int current_entry;
    int first_on_screen;
    int last_index, found_selection, end;
    int lines, columns, begin_x, begin_y;
    int normal_color, insert_color;
    int mode, chkdest;
    char path[MAXPATHLEN];
    void (*panic)(char *);
    int entries, focus, size, selected_files;
    unsigned int maxname;
    _dir_entry dir_entry[MAX_ENTRIES];
    edit *edt;
    
    void recover(void);
    void update(void);  
    void update_frame(void);
    void update_info(void);
    void update_path(void);
    void update_size(void);
    void update_entry(int entry);
    void trunc_fname(char *fname, char *dest, int len);
    int  _move(char *from, char *to);
    int  _copy(char *src, char *dest, int mode);
    int  verify_name(char *file_name);
    int  getnext(void);
    int  getindex(char *str);
    int  getdirinfo(char *directory, int verify = 1);
                
   public:
    
    panel(int lines, int columns, int begin_x, int begin_y, char *path, 
          edit *edt, void (*_panic)(char *), 
          int *UserHeartAttack, configuration *config);
    ~panel(void);
    void setfocus(int status, panel *link = NULL);
    void nooptimizations(void) { on_screen = MAX_ENTRIES; };
    int  action(int action, panel *link, void *aux_info = NULL);
    char *getpath(char *temppath, unsigned len = MAXPATHLEN);
    char *getcurrentfilename(char *dest) { return strcpy(dest, dir_entry[current_entry].name); }
    int  getcurrentfileuid(void) { return dir_entry[current_entry].uid; }
    int  getcurrentfilegid(void) { return dir_entry[current_entry].gid; }
    int  getcurrentfilemode(void) { return dir_entry[current_entry].mode; }
    int  getcurrentfiletype(void) { return dir_entry[current_entry].type; }
};


#endif
