/*
 * Edit line header file
 * Pink House Systems, October 1993
 */

#ifndef __EDIT_H
#define __EDIT_H


#include "config.h"


#define EDIT_BUFLEN	0xFF
#define EDIT_HISTBUFLEN	0x2000
#define EDIT_RECLEN	0x100
#define EDIT_HISTRECS   (EDIT_HISTBUFLEN / EDIT_RECLEN)
#define EDIT_RECORD	0
#define EDIT_PREVIOUS	1
#define EDIT_NEXT	2


class edit
{
    window *win;
    unsigned index, columns;
    unsigned static_size, records, current_record;
    char *buf, *history_buf;

   public:
   
    edit(int columns, int begin_y, configuration *config);
    ~edit(void) { delete buf; delete history_buf; delete win; }
    void putch(int key);
    void puts(char *str);
    char *gets(char *static_text, char *dest, char *default_str = NULL);
    char *gettext(char *dest) { return strcpy(dest, buf + static_size); }
    void reset(void) { buf[index = static_size = 0] = 0; }
    void del(void);
    void setcursor(void);
    void update(void);
    void eos(void) { static_size = index; }
    void history(int action);
};


#endif
