/*
 * Configuration file
 * Pink House Systems, October 1993
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "config.h"



configuration::configuration(char *filename, void (*_panic)(char *))
{
    file = fopen(filename, "r");
    panic = _panic;
    status = file != NULL;
}


configuration::~configuration(void)
{
    fclose(file);
}


int configuration::getline(void)
{
    int len;
    char *comment;

    if (fgets(line, MAXLINE - 1, file) == NULL)
	return 0;
    if ((len = strlen(line)) == MAXLINE - 1)
	panic("line too long");
    if (comment = strchr(line, '#')) *comment = 0;
    else line[len - 1] = 0;
    return 1;
}


int configuration::getsectionptr(char *section_name)
{
    char buf[MAXLINE];

    fseek(file, 0, SEEK_SET);
    while (getline())
    {
	sscanf(line, "%s", buf);
	if (strcmp(section_name, buf) == 0)
	    return ftell(file);
    }
    return -1;
}


void configuration::getfielddata(int sectionptr, char *field_name,
				  char **dest, int fields, int seek)
{
    int fld;
    char buf[MAXLINE], *ptr, *tmp;

//  Assuming the section fields are read in the correct order is a lot faster.

    if (seek) fseek(file, sectionptr, SEEK_SET);

    memset(dest, 0, fields * sizeof(char *));

    while (getline() && *line)
    {
	*buf = 0;
	sscanf(line, "%s", buf);
	if (!isalpha(*buf)) return;
	if (strcmp(field_name, buf) == 0)
	{
	    if ((ptr = strchr(line, '=')) && *++ptr)
	    {
		for (dest[0] = ptr, fld = 1; *ptr && fld < fields; ptr++)
		    if (*ptr == ';')
		    {
			*ptr = 0;
			if (*(ptr + 1) && *(ptr + 1) != ';')
			    dest[fld] = ptr + 1;
			fld++;
		    }
		if (ptr = strchr(ptr, ';')) *ptr = 0;
	    }
	    for (fld = 0; fld < fields; fld++)
		if (dest[fld])
		{
		    while (isblank(*dest[fld])) dest[fld]++;
		    tmp = dest[fld] + strlen(dest[fld]) - 1;
		    while (isblank(*tmp) && tmp >= dest[fld]) tmp--;
		    *(tmp + 1) = 0;
		    if (dest[fld][0] == 0) dest[fld] = NULL;
		}
	    return;
	}
    }
}
