# Copyright (C) 1993 John W. Eaton
# 
# This file is part of Octave.
# 
# Octave is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
# 
# Octave is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Octave; see the file COPYING.  If not, write to the Free
# Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

function retval = vander (c)

# usage: vander (c)
#
# Return the Vandermonde matrix whose next to last column is c.
#
# See also: hankel, hadamard, hilb, invhilb, toeplitz

  if (nargin != 1)
    error ("usage: vander (c)");
  endif

  nr = rows (c);
  nc = columns (c);
  if (nr == 1 && nc == 1)
    retval = 1;
  elseif (nr == 1 || nc == 1)
    n = length (c);
    if (n > 0)
      retval = zeros (n, n);
      for i = 1:n
        tmp = c(i);
        for j = 1:n
          retval (i, j) = tmp ^ (n - j);
        endfor
      endfor
    endif
  else
    error ("vander: argument must be a vector");
  endif

endfunction
