/* 
   mstbirc.c
   Main file for MstbIRC - the offline do-it-yourself IRC
   Copyright (c) 1996 by Gerald Friedland. Distribute following the GNU GPL2.
   A gag-project.
   Version: 0.8 Revision: 1 Date: 06/01/1996
   ------------------------------------------------------
   This version was tested and compiled with WATCOM C++32 10.0 for DOS
   on a 386SX/16 with 3MB RAM.
   Linux support is a bit unstable...
   Compiled with gcc 2.7.2 and Linux-conio 1.01 by Gerald Friedland on
   a Pentium 120 16MB RAM
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __DOS__
	#include <conio.h>
        #include <dos.h>
	#include <graph.h>
	#define BLACK _BLACK
	#define WHITE _WHITE
	#define SHELL "command.com"
   	#define VERSION "1.0D"
#endif

#ifdef __linux__
   	#include <curses.h>
   	#include "conio.h" /* This program uses the Linux-conio.h by Fractor/MXP */
   	#define stricmp strcasecmp
   	#define SHELL "/bin/sh"
   	#define VERSION "0.8l"
#endif

#define DATAFILE "mstbirc.dat"
#define BANFILE "mstbirc.ban"


typedef struct {
    char answer[256];
    long hits;
} hitrec;

 
FILE *datfile;
hitrec **answerstore;
unsigned long answercount;
char answer[256];
char debugmode=0;

double _random(range)
unsigned int range;
{
 double i;
 i=(rand()*range)/RAND_MAX;
 return(i); 
}

void _gotoxy(short x, short y)
{
    #ifdef __DOS__
    _settextposition(y,x);
    #endif
    #ifdef __linux__
    gotoxy(x,y);
    #endif
}

void _clrscr()
{
    #ifdef __DOS__
    _clearscreen(0);
    #endif
    #ifdef __linux__
    clrscr();
    #endif
}

void _textcolor(short color)
{
    #ifdef __DOS__
    _settextcolor(color);
    #endif
    #ifdef __linux__
    textcolor(color);
    #endif
}

void _textbackground(short color)
{
    #ifdef __DOS__
    _setbkcolor(color);
    #endif
    #ifdef __linux__
    textbackground(color);
    #endif
}

void _writeln(char *string)
{
    #ifdef __DOS__
    _outtext(string);
    #endif
    #ifdef __linux__
    cprintf("%s",string);
    #endif
    #ifndef __DOS__
    #ifndef __linux__
    printf("%s",string);
    #endif
    #endif
}

void _window(short x1, short y1, short x2, short y2)
{
     #ifdef __DOS__
     _settextwindow(y1,x1,y2,x2);
     #endif
     #ifdef __linux__
     window(x1,y1,x2,y2); 
     #endif 
}

void _readln(char *str)
{
 char temp[257];
 #ifndef __linux__
 fgets(str,254,stdin);
 #endif
 #ifdef __linux__
 temp[0]=254;
 cgets(temp);
 strcpy(str,&temp[2]);
 strcat(str,"\n");
 #endif
}

void createdesign()
{
    #ifdef __DOS__
    _setvideomode(_TEXTC80);
    #endif
    _clrscr();
    _gotoxy(1,23);
    _textcolor(BLACK);
    _textbackground(WHITE);
    _writeln("MstbIRC v");
    _writeln(VERSION);
    _writeln("   *private*  #do-it-yourself                                      ");
    _textcolor(WHITE);
    _textbackground(BLACK);
    _window(1,1,80,25);
    _gotoxy(1,24);
}

void showbanner(void)
{
    FILE *banfile;
    char lin[81];
    _window(1,1,80,22);
    banfile=fopen(BANFILE,"r");
    if (banfile!=NULL) {
	fseek(datfile,0,SEEK_SET);
	do {
	    fgets(lin,sizeof(lin),banfile);
	    if (!feof(banfile)) {
		_writeln(lin);
	    }
	} while (!feof(banfile));
	fclose(banfile);
    }
    _window(1,1,80,25);
    _gotoxy(1,24);
}

void initialize()
{
   #ifdef __linux__
    initconio();
   #endif;
    _clrscr();
    _window(23,6,60,19);
    _writeln("MstbIRC version ");
    _writeln(VERSION);
    _writeln("\n");
    _writeln("The do-it-yourself-offline IRC\n");
    _writeln("\n\n\n");
    _writeln("Copyright (c) 1996 by Fractor/MXP \n(Distribute it following GNU GPL)\n");
    _writeln("\n\n\n\n");
    _writeln("Press any key...\n");
    while (!kbhit()) {
	_random(10);
    }
    #ifndef __linux__
    getch();
    #endif
    datfile=fopen(DATAFILE,"a+");
    if (datfile==NULL) {
	printf("Could not open '%s' .Aborting \n",DATAFILE);
	exit(1);
    }
    createdesign();
    showbanner();
}

void shutdown(void)
{
    free(answerstore);
    fclose(datfile);
    _window(1,1,80,25);
    _gotoxy(1,25);
    _writeln("\n");
    #ifdef __linux__
    doneconio();
    #endif
    exit(0);
}

char *getparam(char *line,unsigned int no)
{
   unsigned int i=0;
   char *p;
   char *buffer;
   char *delims = { " \n,-!?;:'`" };
   buffer=strdup(line);
   p=strtok(buffer,delims);
   while (i<no) {
      p = strtok(NULL,delims);
      i++;
   }
   return(p);                                                      
}

unsigned short countparams(char *line)
{
   unsigned short i=0;
   while (getparam(line,i)!=NULL) i++;
   return(i);
}

void createansw()
{
    char keys[256],answ[256];
    _writeln(">> MstbIRC. Add keywords and answer to datafile.\n");
    _writeln(">> Enter keywords: ");
    _readln(keys);
    _writeln("\n");
    if (strcmp(keys,"\n")==0) {
	_writeln(">> Canceled.\n");
	return;
    }
    _writeln(">> Enter answer: ");
    _readln(answ);
    _writeln("\n");
    if (strcmp(answ,"\n")==0) {
	_writeln(">> Canceled.\n");
	return;
    }
    fseek(datfile,0,SEEK_END);
    keys[strlen(keys)-1]=0;
    answ[strlen(answ)-1]=0;     
    fprintf(datfile,"%s|%s\n",answ,keys);
    _writeln(">> OK.\n");
}

void addanswer(char *answ)
{
    hitrec *tmprec;
    unsigned long i;
    char doesexist=0;
    if (answercount>0) {
	for (i=1;i<answercount+1;i++) {
	    if (strcmp(answ,answerstore[i]->answer)==0) {
		answerstore[i]->hits++;
		doesexist=1;
	    }
	}
    }
    if (doesexist==0) {
	answercount++;
	answerstore=realloc(answerstore,sizeof(tmprec)*answercount+1);
	tmprec=malloc(sizeof(hitrec));
	if (tmprec==NULL) {
		printf(">> Oops, no memory... \n");
		shutdown();
	}
	strcpy(tmprec->answer,answ);
	tmprec->hits=1;
	answerstore[answercount]=tmprec;
    }
}

char *searchkey(char *key)
{
    char temp[256],keyl[256],lin[512];
    long c,i;
    fseek(datfile,0,SEEK_SET);
    do {
	fgets(lin,sizeof(lin),datfile);
	if (!feof(datfile)) {
		lin[strlen(lin)-1]=0;
		strcpy(temp,strchr(lin,'|'));
		strncpy(keyl,&temp[1],strlen(&temp[1]));
		keyl[strlen(&temp[1])]=0;
		c=countparams(keyl);
		for (i=0;i<c;i++) {
		    if (stricmp(getparam(keyl,i),key)==0) {
			strncpy(temp,lin,strlen(lin)-strlen(strchr(lin,'|')));
			temp[strlen(lin)-strlen(strchr(lin,'|'))]=0;
			addanswer(temp);
		    }
		}
	}
    } while (!feof(datfile));
    return(0);
}

unsigned long getmaximum(void)
{
    unsigned long i,maxi;
    maxi=0;
    if (answercount<1) return(maxi);
    for (i=1;i<answercount+1;i++) {
	if (answerstore[i]->hits>maxi) maxi=answerstore[i]->hits;
    }
    return(maxi);
}

void selectanswer(void)
{
    unsigned long i,maxi,cnt;
    char **answers,*tmpptr;
    cnt=0;
    if (debugmode==1) {
	tmpptr=(char *) malloc(1024);
	sprintf(tmpptr,">> Keyword(s) match(es) %d answer(s): (hits) \n",answercount);
	_writeln(tmpptr);
	for (i=1;i<answercount+1;i++) {
	    sprintf(tmpptr,">> %d: '%s' (%d)\n",i,answerstore[i]->answer,answerstore[i]->hits);
	    _writeln(tmpptr);
	}
	free(tmpptr);
	_writeln(">> (Answer selected is:)\n");
    }
    if (answercount==1) {
	strcpy(answer,answerstore[1]->answer);
	return;
    }
    maxi=getmaximum();
    answers=malloc(sizeof(*answers));
    if (answers==NULL) {
	printf(">> What's that? No memory left.\n");
	shutdown();
    }
    for (i=1;i<answercount+1;i++) {
	if (answerstore[i]->hits==maxi) {
	    cnt++;
	    answers=realloc(answers,sizeof(tmpptr)*cnt+1);
	    tmpptr=strdup(answerstore[i]->answer);
	    answers[cnt]=tmpptr;
	}
    }
    if (cnt>1) i=(long) _random(cnt)+1; else i=1;
    if (cnt==0) answer[0]=0; else strcpy(answer,answers[i]);
    for (i=1;i<cnt+1;i++) free(answers[i]);
    free(answers);
}
    
	
    
unsigned char searchanswer(char *line)
{
    unsigned long c,i;
    answercount=0;
    answerstore=malloc(sizeof(*answerstore));
    if (answerstore==NULL) {
	printf(">> Oops, incredible low memory ! \n");
	fclose(datfile);
	exit(1);
    }
    line[strlen(line)-1]=0;
    c=countparams(line);
    for (i=0;i<c;i++) {
	searchkey(getparam(line,i));
    }
    selectanswer();
    if (answer[0]!=0) {
	c=1;
	_writeln(answer);
    } else {
	c=0;
    }
    for (i=1;i<answercount+1;i++) free(answerstore[i]);
    free(answerstore);
    return(c);
}


void parse(char *line)
{
    unsigned short pc;
    char *command;
    unsigned char exc=0;
    FILE *tmpfile;
    pc=countparams(line);
    if (pc==0) return;
    command=strdup(getparam(line,0));
    _writeln("\n");
    if (strlen(line)>80) _writeln("\n");
    if (command[0]=='/') {
	if (strcmp(command,"/debug")==0) {
	    if (debugmode==0) {
		_writeln(">> Debug mode is now: ON\n");
		debugmode=1;
	    } else {
		_writeln(">> Debug mode is now: OFF\n");
		debugmode=0;
	    }
	    exc=1;
	}
	if (strcmp(command,"/quit")==0) shutdown();
	if ((strcmp(command,"/join")==0) || (strcmp(command,"/msg")==0)) {
	    exc=1;
	    _writeln(">> These commands are not very useful in this program.\n");
	}
	if (strcmp(command,"/help")==0) {
	    exc=1;
	    _writeln(">>\n");
	    _writeln(">> Avaliable commands:\n");
	    _writeln(">> ~~~~~~~~~~~~~~~~~~~\n");
	    _writeln(">> /quit              Quits MstbIRC\n");
	    _writeln(">> /new               Add new keywords to the datafile\n");
	    _writeln(">> /debug             Toggle debug mode\n");
	    _writeln(">> /system            Temporarily exit to shell\n");
	    _writeln(">> /file <filename>   Open/create a new datafile\n");
	    _writeln(">> /clear             Clear screen\n");
	    _writeln(">> /help              Show this help screen\n");
	    _writeln(">>\n");
	}
	if (strcmp(command,"/file")==0) {
	    exc=1;
	    if (pc==2) {
		tmpfile=fopen(getparam(line,1),"a+");
		if (tmpfile==NULL) {
		    _writeln(">> Could not open/create '");
		    _writeln(getparam(line,1));
		    _writeln("'. Using old datafile. \n");
		    } else {
			fclose(datfile);
			datfile=tmpfile;
			_writeln(">> Now accessing '");
			_writeln(getparam(line,1));
			_writeln("'.\n");
		    }
	    } else {
		_writeln(">> Wrong number of arguments.\n");
		_writeln(">> Usage is: /file <filename>\n");
	    }
	}
	if (strcmp(command,"/new")==0) {
	    exc=1;
	    createansw();
	}
	if (strcmp(command,"/clear")==0) {
	    exc=1;
	    createdesign();
	}
	if (strcmp(command,"/system")==0) {
	    _window(1,1,80,25);
	    _gotoxy(1,25);
	    _writeln("\n");
	    printf(">> Type exit to return...\n");
	    exc=system(SHELL);
	    createdesign();
	    if (exc!=0) {
		_writeln(">> Errorcode!=0. ");
		_writeln(SHELL);
		_writeln("  not in path ? \n");
	    }
	    exc=1;
	}
	if (exc==0) {
	    _writeln(">> Sorry, but this command is not defined.\n");
	    exc=1;
	}
    }
    if (exc==0) {
	_writeln(">");
	_writeln(line);
	exc=searchanswer(line);
    }
    if (exc==0) {
	_writeln("Could you repeat this in other words... I don't understand it!\n");
    }
    exc=0;
    free(command);
}

void main()
{
    char inputln[255];
    initialize();
    do {
	_window(1,1,80,25);
	_gotoxy(1,24);
	_window(1,24,80,25);
	_writeln(">");
        _readln(inputln);
	_writeln("\n\n\n");
	_window(1,1,80,22);
	_gotoxy(1,22);
        parse(inputln);
    } while(1!=0);
}
