/* K3 for Linux - based on (my) DOS version
 * (c) 1993 Russell Marks for improbabledesigns
 *
 * This program may be freely used and distributed, but only in an
 *  unmodified form.
 *
 * K3 is just a prettifier for /proc/meminfo.
 *
 * And if you don't have /proc/meminfo?
 *  1. You're weird
 *  2. It won't work
 */

#include <stdio.h>

/* these are VT100 #define's for the graphics used.
 * replace with '#include "ascii.h"' to use normal ascii characters.
 */
#include "vt100.h"

main()
{
int mf,mt,mb,ms,sf,st;

readmeminfo(&mf,&mt,&mb,&ms,&sf,&st);
showbar("Real memory:",mf+mb,mt);
if(st>0)
  showbar("\nSwap space:",sf,st);
showfooter();
exit(0);
}

showfooter()
{
printf("                   "
       "Above, '%s%c%s' is used space, '%s%c%s' is unused.\n",
	GRAFIXON,USEDCHAR,GRAFIXOFF,GRAFIXON,FREECHAR,GRAFIXOFF);
}

showbar(title,avail,total)
char *title;
int avail,total;
{
int availk,totalk,limit,count;

availk=avail>>10;
totalk=total>>10;
printf("%s\n"
       "                          %4dK free - %3d%% of %4dK\n",
	title,availk,(availk*100)/totalk,totalk);
limit=76-((availk*76)/totalk);
printf(GRAFIXON);                                     /* VT100 graphics on */
printf(TOPBAR);
for(count=0;count<76;count++)
  putchar((count<limit)?USEDCHAR:FREECHAR);
printf(CELLARBAR);
printf(GRAFIXOFF);                                   /* VT100 graphics off */
}

readmeminfo(pmf,pmt,pmb,pms,psf,pst)
int *pmf,*pmt,*pmb,*pms,*psf,*pst;
{
FILE *in;
char waste[128];
int waste2;

if((in=fopen("/proc/meminfo","r"))==NULL)
  {
  printf("Couldn't read /proc/meminfo\n");
  exit(1);
  }
else
  {
  fgets(waste,sizeof(waste),in);
  fscanf(in,"%s %d%d%d%d%d",waste,pmt,&waste2,pmf,pms,pmb);
  fscanf(in,"%s %d%d%d",waste,pst,&waste2,psf);
  fclose(in);
  }
}
