#ifndef GOT_DRIVER_H

#define GOT_DRIVER_H
#define GOT_TERM_DRIVER /* I started using this name for some reason */

#include "plot.h"
#include "bitmap.h"
#include "setshow.h"

/* functions provided by in term.c */

void do_point __P((unsigned int x, unsigned int y, int number));
void line_and_point __P((unsigned int x, unsigned int y, int number));
void do_arrow __P((unsigned int sx, unsigned int sy, unsigned int ex, unsigned int ey, int head));
int null_text_angle __P((int ang));
int null_justify_text __P((enum JUSTIFY just));
int null_scale __P((double x, double y));
int do_scale __P((double x, double y));
void options_null __P((void));
void UNKNOWN_null __P((void));
int set_font_null __P((char *s));
void null_set_pointsize __P((double size));

extern FILE *outfile;
extern struct termentry *term;
extern float xsize, ysize;

/* for use by all drivers */
#define sign(x) ((x) >= 0 ? 1 : -1)
#ifndef abs                            /* SAS/C has abs, but shouldn't */
#define abs(x) ((x) >= 0 ? (x) : -(x))
#endif

#ifndef max	/* GCC uses inline functions */
#define max(a,b) ((a) > (b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a) < (b) ? (a) : (b))
#endif

#define NICE_LINE		0
#define POINT_TYPES		6

#endif
