/*
 * $Id: stdfn.h,v 1.13 1995/12/07 21:41:11 drd Exp $
 *
 */

/* get prototypes or declarations for string and stdlib functions and deal
   with missing functions like strchr. */

/* we will assume the ANSI/Posix/whatever situation as default.
   the header file is called string.h and the index functions are called
   strchr, strrchr. Exceptions have to be listed explicitly */

#ifndef STDFN_H
#define STDFN_H

#include <stdio.h>
#include <setjmp.h>

#ifdef sequent
#define NO_STRCHR
#endif

#ifndef NO_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#ifdef NO_STRCHR
#ifdef strchr
#undef strchr
#endif
#define strchr index
#ifdef strrchr
#undef strrchr
#endif
#define strrchr rindex
#endif

#ifdef NO_STDLIB_H
char *malloc();
char *realloc();
char *getenv();
int system();
double atof();
int atoi();
long atol();
double strtod();
#else
#include <stdlib.h>
#endif

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#else
#ifdef HAVE_LIBC_H /* NeXT uses libc instead of unistd */
#include <libc.h>
#endif
#endif

#ifndef NO_ERRNO_H
#include <errno.h>
#endif
#ifdef EXTERN_ERRNO
extern int errno;
#endif

#ifndef NO_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifndef NO_LIMITS_H
#include <limits.h>
#else
#ifdef HAVE_VALUES_H
#include <values.h>
#endif
#endif

#if defined(DJGPP)||defined(sun386)
#define time_t unsigned long
#endif

#include <time.h> /* ctime etc, should also define time_t and struct tm */

#if defined(PIPES) && (defined(VMS) || (defined(OSK) && defined(_ANSI_EXT))) || defined(PIPES) && defined(AMIGA_SC_6_1)
FILE *popen(char *cmd, char *mode);
int pclose(FILE *pipe);
#endif

#ifdef HAVE_LOCALE
#include <locale.h>
#endif

#endif /* STDFN_H */
