/*
 * $Id: setshow.h,v 1.28 1995/12/10 18:33:49 drd Exp $
 *
 */

/* GNUPLOT - setshow.h */
/*
 * Copyright (C) 1986 - 1993   Thomas Williams, Colin Kelley
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear 
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the modified code.  Modifications are to be distributed 
 * as patches to released version.
 *  
 * This software is provided "as is" without express or implied warranty.
 * 
 *
 * AUTHORS
 * 
 *   Original Software:
 *     Thomas Williams,  Colin Kelley.
 * 
 *   Gnuplot 2.0 additions:
 *       Russell Lang, Dave Kotz, John Campbell.
 *
 *   Gnuplot 3.0 additions:
 *       Gershon Elber and many others.
 *
 * There is a mailing list for gnuplot users. Note, however, that the
 * newsgroup 
 *	comp.graphics.gnuplot 
 * is identical to the mailing list (they
 * both carry the same set of messages). We prefer that you read the
 * messages through that newsgroup, to subscribing to the mailing list.
 * (If you can read that newsgroup, and are already on the mailing list,
 * please send a message info-gnuplot-request@dartmouth.edu, asking to be
 * removed from the mailing list.)
 *
 * The address for mailing to list members is
 *	   info-gnuplot@dartmouth.edu
 * and for mailing administrative requests is 
 *	   info-gnuplot-request@dartmouth.edu
 * The mailing list for bug reports is 
 *	   bug-gnuplot@dartmouth.edu
 * The list of those interested in beta-test versions is
 *	   info-gnuplot-beta@dartmouth.edu
 */


#ifndef DEFAULT_TIMESTAMP_FORMAT
#define DEFAULT_TIMESTAMP_FORMAT "%a %b %d %H:%M:%S %Y" /* asctime() format */
#endif
 
/*
 * global variables to hold status of 'set' options
 *
 */

typedef struct {
	char text[MAX_LINE_LEN+1];
	double xoffset, yoffset;
	char font[MAX_LINE_LEN+1];
} label_struct;


extern TBOOLEAN                 multiplot;

extern TBOOLEAN			autoscale_r;
extern TBOOLEAN			autoscale_t;
extern TBOOLEAN			autoscale_u;
extern TBOOLEAN			autoscale_v;
extern TBOOLEAN			autoscale_x;
extern TBOOLEAN			autoscale_y;
extern TBOOLEAN			autoscale_z;
extern TBOOLEAN			autoscale_x2;
extern TBOOLEAN			autoscale_y2;
extern TBOOLEAN			autoscale_lt;
extern TBOOLEAN			autoscale_lu;
extern TBOOLEAN			autoscale_lv;
extern TBOOLEAN			autoscale_lx;
extern TBOOLEAN			autoscale_ly;
extern TBOOLEAN			autoscale_lz;
extern double			boxwidth;
extern TBOOLEAN			clip_points;
extern TBOOLEAN			clip_lines1;
extern TBOOLEAN			clip_lines2;
extern int			draw_border;
#define SOUTH			1 /* 0th bit */
#define WEST			2 /* 1th bit */
#define NORTH			4 /* 2th bit */
#define EAST			8 /* 3th bit */
#define border_east		(draw_border & EAST)
#define border_west		(draw_border & WEST)
#define border_south		(draw_border & SOUTH)
#define border_north		(draw_border & NORTH)
extern TBOOLEAN			draw_surface;
extern char			dummy_var[MAX_NUM_VAR][MAX_ID_LEN+1];
extern char			default_font[]; /* Entry font added by DJL */
extern char			xformat[];
extern char			yformat[];
extern char			zformat[];
extern char			x2format[];
extern char			y2format[];
/* do these formats look like printf or time ? */
extern int format_is_numeric[];

extern char			key_title[];
extern enum PLOT_STYLE data_style, func_style;
extern double bar_size;
extern int			grid, grid_linetype, mgrid_linetype;
extern double     polar_grid_angle; /* angle step in polar grid in radians */
extern int			key;
extern struct position key_user_pos; /* user specified position for key */
extern int 			key_vpos, key_hpos, key_just;
extern TBOOLEAN			key_reverse;  /* key back to front */
extern int			key_box;  /* linetype round box < -2 = none */
extern TBOOLEAN			is_log_x, is_log_y, is_log_z;
extern double			base_log_x, base_log_y, base_log_z;
				/* base, for computing pow(base,x) */
extern double			log_base_log_x, log_base_log_y, log_base_log_z;
				/* log of base, for computing logbase(base,x) */
extern TBOOLEAN			is_log_x2, is_log_y2;
extern double			base_log_x2, base_log_y2;
				/* base, for computing pow(base,x) */
extern double			log_base_log_x2, log_base_log_y2;
				/* log of base, for computing logbase(base,x) */
extern FILE*			outfile;
extern char			outstr[];
extern TBOOLEAN			parametric;
extern double			pointsize;
extern TBOOLEAN			polar;
extern TBOOLEAN			hidden3d;
extern int			angles_format;
extern double			ang2rad; /* 1 or pi/180 */
extern int			mapping3d;
extern int			samples;
extern int			samples_1;
extern int			samples_2;
extern int			iso_samples_1;
extern int			iso_samples_2;
extern float			xsize; /* scale factor for size */
extern float                    xoffset;
extern float                    yoffset;
extern float			ysize; /* scale factor for size */
extern float			zsize; /* scale factor for size */
extern TBOOLEAN      square;
extern float			surface_rot_z;
extern float			surface_rot_x;
extern float			surface_scale;
extern float			surface_zscale;
extern char			term_options[];

extern label_struct title, timelabel;
extern label_struct xlabel, ylabel, zlabel;
extern label_struct x2label, y2label;

extern char			timefmt[];
extern int 			datatype[];
extern int			range_flags[];
extern double			rmin, rmax;
extern double			tmin, tmax, umin, umax, vmin, vmax;
extern double			xmin, xmax, ymin, ymax, zmin, zmax;
extern double			x2min, x2max, y2min, y2max;
extern double			loff, roff, toff, boff;
extern int			draw_contour;
extern TBOOLEAN      label_contours;
extern char			contour_format[];
extern int			contour_pts;
extern int			contour_kind;
extern int			contour_order;
extern int			contour_levels;
extern double			zero; /* zero threshold, not 0! */
extern int			levels_kind;
extern double		levels_list[MAX_DISCRETE_LEVELS];

extern int			dgrid3d_row_fineness;
extern int			dgrid3d_col_fineness;
extern int			dgrid3d_norm_value;
extern TBOOLEAN			dgrid3d;

#define ENCODING_DEFAULT	0
#define ENCODING_ISO_8859_1	1
#define ENCODING_CP_437		2
#define ENCODING_CP_850		3   /* JFi */

extern int			encoding;
extern char			*encoding_names[];

/* -3 for no axis, or linetype */
extern int xzeroaxis;
extern int yzeroaxis;
extern int x2zeroaxis;
extern int y2zeroaxis;

extern int xtics;
extern int ytics;
extern int ztics;
extern int mxtics;
extern int mytics;
extern int mztics;
extern int x2tics;
extern int y2tics;
extern int mx2tics;
extern int my2tics;
extern double mxtfreq;
extern double mytfreq;
extern double mztfreq;
extern double mx2tfreq;
extern double my2tfreq;

extern float ticslevel;
extern double ticscale; /* scale factor for tic marks (was (0..1])*/
extern double miniticscale; /* and for minitics */

extern struct ticdef xticdef;
extern struct ticdef yticdef;
extern struct ticdef zticdef;
extern struct ticdef x2ticdef;
extern struct ticdef y2ticdef;

extern TBOOLEAN			tic_in;

extern struct text_label *first_label;
extern struct arrow_def *first_arrow;

extern int lmargin, bmargin,rmargin,tmargin; /* plot border in characters */

extern char cur_locale[MAX_ID_LEN+1];

extern char full_month_names[12][32];
extern char abbrev_month_names[12][8];

extern char full_day_names[7][32];
extern char abbrev_day_names[7][8];

/* The set and show commands, in setshow.c */
void set_command __P((void));
void reset_command __P((void));
void show_command __P((void));
/* and some accessible support functions */
enum PLOT_STYLE get_style __P((void));
TBOOLEAN load_range __P((int axis, double *a, double *b, int autosc));
void show_version __P((void));
char * conv_text __P((char *s, char *t));

/* string representing missing values, ascii datafiles */
extern char *missing_val;
