/*
 * $Id: protos.h,v 1.36 1995/12/02 22:04:37 drd Exp $
 *
 */

#include "ansichek.h"

/* note that this before this file, some headers that define stuff like FILE,
   time_t and GPFAR must be already be included */

/* Prototypes from file "command.c" */

void extend_input_line __P((void));
void extend_token_table __P((void));
void init_memory __P((void));
int com_line __P((void));
int do_line __P((void));
void done __P((int status));
void define __P((void));

/* Prototypes from file "contour.c" */
typedef double tri_diag[3];         /* Used to allocate the tri-diag matrix. */

struct gnuplot_contours *contour __P((int num_isolines, struct iso_curve *iso_lines, int ZLevels, int approx_pts, int int_kind, int order1, int levels_kind, double *levels_list));
int solve_tri_diag __P((tri_diag m[], double r[], double x[], int n));

/* Prototypes from file "datafile.c" */
int df_open __P((int max_using));
int df_readline __P((double v[], int max));
void df_close __P((void));
int df_2dbinary __P((struct curve_points *this_plot));
int df_3dbinary __P((struct surface_points *this_plot));

/* Prototypes from file "eval.c" */

struct udvt_entry * add_udv __P((int t_num));
struct udft_entry * add_udf __P((int t_num));
int standard __P((int t_num));
void execute_at __P((struct at_type *at_ptr));


/* Prototypes from file "fit.c" */

void    do_fit __P((void));


/* Prototypes from file "graphics.c" */

void graph_error __P((char *text));
void timetic_format __P((int axis, double amin, double amax));
void do_plot __P((struct curve_points *plots, int pcount));
double time_tic_just __P((int level, double ticplace));
double make_ltic __P((int tlevel, double incr));
int label_width __P((char *str, int *lines));
void setup_tics __P((int axis, struct ticdef *def, char *format, int max));
/* is this valid use of __P ? */
typedef void (*tic_callback) __P((int axis, double place, char *text, int grid));
void gen_tics __P((int axis, struct ticdef *def, int grid, int minitic, double minifreq, tic_callback callback));
void write_multiline __P((unsigned int x, unsigned int y, char *text_will_be_mangled, int hor, int vert, int angle, char *font));

/* Prototypes from file "graph3d.c" */

void map3d_xy __P((double x, double y, double z, unsigned int *xt, unsigned int *yt));
int map3d_z __P((double x, double y, double z));
void do_3dplot __P((struct surface_points *plots, int pcount));

/* Prototypes from file "hidden3d.c" */

#ifndef LITE
void init_hidden_line_removal __P((void));
void reset_hidden_line_removal __P((void));
void term_hidden_line_removal __P((void));
void plot3d_hidden __P((struct surface_points *plots, int pcount));
#endif

/* Prototypes from file "internal.c" */

#ifdef MINEXP
double gp_exp __P((double x));
#else
#define gp_exp(x) exp(x)
#endif

/* int matherr __P((void)); */
void reset_stack __P((void));
void check_stack __P((void));
struct value *pop __P((struct value *x));
void push __P((struct value *x));

/* Prototypes from file "interpol.c" */

void gen_interp __P((struct curve_points *plot));
void sort_points __P((struct curve_points *plot));
void cp_implode __P((struct curve_points *cp));

/* Prototypes from file "misc.c" */

struct curve_points * cp_alloc __P((int num));
void cp_extend __P((struct curve_points *cp, int num));
void cp_free __P((struct curve_points *cp));
struct iso_curve * iso_alloc __P((int num));
void iso_extend __P((struct iso_curve *ip, int num));
void iso_free __P((struct iso_curve *ip));
struct surface_points * sp_alloc __P((int num_samp_1, int num_iso_1, int num_samp_2, int num_iso_2));
void sp_replace __P((struct surface_points *sp, int num_samp_1, int num_iso_1, int num_samp_2, int num_iso_2));
void sp_free __P((struct surface_points *sp));
void save_functions __P((FILE *fp));
void save_variables __P((FILE *fp));
void save_all __P((FILE *fp));
void save_set __P((FILE *fp));
void save_set_all __P((FILE *fp));
void load_file __P((FILE *fp, char *name, TBOOLEAN subst_args));
FILE *lf_top __P((void));
void load_file_error __P((void));
int instring __P((char *str, char c));
void show_functions __P((void));
void show_at __P((void));
void disp_at __P((struct at_type *curr_at, int level));
int find_maxl_keys __P((struct curve_points *plots, int count, int *kcnt));
int find_maxl_keys3d __P((struct surface_points *plots, int count, int *kcnt));
TBOOLEAN valid_format __P((const char *format));

/* Prototypes from file "parse.c" */

/* void fpe __P((void)); */
void evaluate_at __P((struct at_type *at_ptr, struct value *val_ptr));
struct value * const_express __P((struct value *valptr));
struct at_type * temp_at __P((void));
struct at_type * perm_at __P((void));

/* Prototypes from file "plot.c" */

void interrupt_setup __P((void));

/* prototypes from plot2d.c */

void plotrequest __P((void));

/* prototypes from plot3d.c */

void plot3drequest __P((void));


/* Prototypes from file "readline.c" */

char * readline __P((char *prompt));
void add_history __P((char *line));

/* Prototypes from file "scanner.c" */

int scanner __P((char expression[]));

/* Prototypes from file "term.c" */

void list_terms __P((void));
struct termentry *set_term __P((int c_token));
struct termentry *change_term __P((char *name, int length));
void init_terminal __P((void));
void test_term __P((void));
void UP_redirect __P((int called));
#ifdef LINUX
void LINUX_setup __P((void));
#endif
#ifdef VMS
void vms_reset();
#endif

/* Prototypes from file "util.c" */

int chr_in_str __P((int t_num, char c));
int equals __P((int t_num, char *str));
int almost_equals __P((int t_num, char *str));
int isstring __P((int t_num));
int isanumber __P((int t_num));
int isletter __P((int t_num));
int is_definition __P((int t_num));
void copy_str __P((char str[], int t_num, int max));
int token_len __P((int t_num));
void quote_str __P((char str[], int t_num, int max));
void capture __P((char str[], int start, int end, int max));
void m_capture __P((char **str, int start, int end));
void m_quote_capture __P((char **str, int start, int end));
void convert __P((struct value *val_ptr, int t_num));
void disp_value __P((FILE *fp, struct value *val));
double real __P((struct value *val));
double imag __P((struct value *val));
double magnitude __P((struct value *val));
double angle __P((struct value *val));
struct value * Gcomplex __P((struct value *a, double realpart, double imagpart));
struct value * Ginteger __P((struct value *a, int i));
void os_error __P((char str[], int t_num));
void int_error __P((char str[], int t_num));
void int_warn __P((char str[], int t_num));
void lower_case __P((char *s));
void squash_spaces __P((char *s));
char * gstrptime __P((char *s, char *fmt, struct tm *tm));
int gstrftime __P((char *buf, int bufsz, char *fmt, double clock));
int xstrftime __P((char *buf, int bufsz, char *fmt, struct tm *tm));
double gtimegm __P((struct tm *tm));
int ggmtime __P((struct tm *tm, double clock));

/* Prototypes from file "util3d.c" */

void draw_clip_line __P((unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2));
void clip_move __P((unsigned int x, unsigned int y));
void clip_vector __P((unsigned int x, unsigned int y));
void edge3d_intersect __P((struct coordinate GPHUGE *points, int i, double *ex, double *ey, double *ez));
TBOOLEAN two_edge3d_intersect __P((struct coordinate GPHUGE *points, int i, double *lx, double *ly, double *lz));
void mat_unit __P((double mat[4][4]));
void mat_trans __P((double tx, double ty, double tz, double mat[4][4]));
void mat_scale __P((double sx, double sy, double sz, double mat[4][4]));
void mat_rot_x __P((double teta, double mat[4][4]));
void mat_rot_y __P((double teta, double mat[4][4]));
void mat_rot_z __P((double teta, double mat[4][4]));
void mat_mult __P((double mat_res[4][4], double mat1[4][4], double mat2[4][4]));
int clip_point __P((unsigned int x, unsigned int y));
void clip_put_text __P((unsigned int x, unsigned int y, char *str));
void clip_put_text_just __P((unsigned int x, unsigned int y, char *str, int just));

#include "alloc.h"

