/* $Id: matrix.h,v 1.2 1994/03/17 00:54:09 alex Exp $ */

/*
 *	Header file: public functions in matrix.c
 *
 *
 *	Copyright of this module:   Carsten Grammes, 1993
 *      Experimental Physics, University of Saarbruecken, Germany
 *
 *	Internet address: cagr@rz.uni-sb.de
 *
 *	Permission to use, copy, and distribute this software and its
 *	documentation for any purpose with or without fee is hereby granted,
 *	provided that the above copyright notice appear in all copies and
 *	that both that copyright notice and this permission notice appear
 *	in supporting documentation.
 *
 *      This software is provided "as is" without express or implied warranty.
 */


#ifndef MATRIX_H
#define MATRIX_H

#ifndef ANSI_CHECK
#include "ansichek.h"
#endif

#ifdef EXT
#undef EXT
#endif

#ifdef MATRIX_MAIN
#define EXT
#else
#define EXT extern
#endif


/******* public functions ******/

EXT double  *vec __P((int n));
EXT int     *ivec __P((int n));
EXT double  **matr __P((int r, int c));
EXT void    free_matr __P((double **m, int r));
EXT void    redim_vec __P((double **v, int n));
EXT void    redim_ivec __P((int **v, int n));
EXT void    solve __P((double **a, int n, double **b, int m));
EXT void    inverse __P((double **src, double **dst, int n));

#endif
