/* this file is included into all the doc2* convertors
 * it provides a replacement for fgets() which inserts all the
 * help from the terminal drivers line by line at the < in the
 * gnuplot.doc file. This way, doc2* dont need to know what's going
 * on, and think it's all coming from one place
 */
#ifdef TEST
#include <stdio.h>
#endif

#include <ctype.h>


/* may need to something more clever for 64k machines ? */

#define GOT_DRIVER_H   /* a complete lie, but they dont need it ! */
#define TERM_HELP
#define START_HELP(x) /* nothing */
#define END_HELP(x)   ,
char *termtext[] = {
#include "term.h"
NULL
};


char *get_line(char *buffer, int max, FILE *fp)
{
	static int line=-1;  /* not going yet */
	static int level=0; /* terminals are at level 0 - we add this */

	if (line == -1) {
		if (!fgets(buffer, max, fp))
			return NULL; /* EOF */

		if (buffer[0] != '<')
			return buffer; /* the simple case */

		/* prepare to return text from the terminal drivers */
		level=buffer[1]-'0';
		line=0;
	}

	/* we're sending lines from terminal help */
	/* more efficient to return pointer, but we need to modify it */
	strncpy(buffer, termtext[line], max);
	strncat(buffer, "\n", max);
	if (isdigit(buffer[0]))
		buffer[0] += level;
	if (!termtext[++line])
		line=(-1); /* we've done the last line, so get next line from file */
	return buffer;
}


#ifdef TEST
int main()
{
	char line[256];
	while(get_line(line, 256, stdin))
		fputs(line, stdout);
	return 0;
}
#endif

#define fgets(a,b,c) get_line(a,b,c)

