

(defun deriv-aux(a) (list '/ (deriv a) a))

(defun deriv (a)
 (cond
  ((atom a)
   (cond ((eq a 'x) 1) (t 0)))
  ((eq (car a) '+)
   (cons '+ (mapcar #'deriv (cdr a))))
  ((eq (car a) '-)
   (cons '- (mapcar #'deriv (cdr a))))
  ((eq (car a) '*)
   (list '*
         a
         (cons '+ (mapcar #'deriv-aux (cdr a)))))
  ((eq (car a) '/)
   (list '-
         (list '/
               (deriv (car(cdr a)))
               (car(cdr(cdr a))))
         (list '/
               (car(cdr a))
               (list '*
                     (car(cdr(cdr a)))
                     (car(cdr(cdr a)))
                     (deriv (car(cdr(cdr a))))))))
  (t 'error)))


(defun run (&optional (times 1000)) 
 ;(declare (i fixnum))   NON IMPLEMENTATO
 (do ( (i 0 (1+ i)) )
     ( (= i times) )
  (deriv '(+ (* 3 x x) (* a x x) (* b x) 5))
  (deriv '(+ (* 3 x x) (* a x x) (* b x) 5))
  (deriv '(+ (* 3 x x) (* a x x) (* b x) 5))
  (deriv '(+ (* 3 x x) (* a x x) (* b x) 5))
  (deriv '(+ (* 3 x x) (* a x x) (* b x) 5))
 )
)

(defun test-derive(&optional (n 100) &aux (tm (get-time)))
  (run n)
    (print
	 " DERIVE  stato eseguito " n " volte"
	 "\nTempo trascorso (in millisecondi) <" (- (get-time) tm) ">\n"
	)
	'ok
)
(print "DERIVE test\n")
(print "Si calcola molte volte la derivata della funzione\n")
(print "F(X)=3*X^2+A*X^2+B*X+5\n")
(print "Uso: (Test-Derive <Numero>)\n")
(print "  dove <Numero> specifica quante volte si ripete \n")
(print "  il calcolo di 5 derivate (solitamente 1000 volte cioe' 5000 derivate).\n")
(print "Si puo' inoltre calcolare la derivata di una qualunque\n")
(print "funzione prefissa usando (deriv <funzione>)\n")
(print "ad esempio : (deriv '(+ 2 (* x x]"]
(print "calcola la derivata di 2x^2\n")

