
(let (( rnd .1234567890123))
  (defun random (&aux seed)        ; 0 - 1
    (when seed (setf rnd seed))
    (setf rnd  (sqrt (rem (* 1000 rnd))))
    (rem (* 1000  rnd))
 )
)


(defun  rnd ( n ) ; 0 - n-1
 (round (* n (random) ))  
)


(defun rndlist ( n )
 (if (=0 n) nil
  (cons 
    (rnd *scrnx*)
    (cons
      (rnd *scrny*)
      (rndlist (1- n))
    )
  )
 )
)

(defun rndstr ( n)
 (if (=0 n) ""
  (strcat
    (strnum (+ 32 (rnd (- 256 32))))
    (rndstr (1- n))
  )
 )
)



(defun gfillpolylist ( n l)
  (eval (append (list  'gfillpoly n ) l) )
)
   
(setf *scrnx* (gmode 1))
(setf *scrny* (car(cdr *scrnx*)))
(setf *scrnx* (car *scrnx*))

(let (n)
 (dotimes ( i 50 )
  (gpentick (1+ (rnd 10)))
  (gpencolor (rnd (* 256 256 256)))
  (gbrushcolor (rnd (* 256 256 256)))
  (gbrushtype (rnd 8))
  (setf n (+ 3 (rnd 10)))
  (gfillpolylist n (rndlist n)) 
 )
)
(readchar)
(gclear)


(dotimes ( i 500 )
  (gpentick (1+ (rnd 10)))
  (gpencolor (rnd (* 256 256 256)))
  (gmoveto (rnd *scrnx*) (rnd *scrny*)) 
  (glineto (rnd *scrnx*) (rnd *scrny*)) 
)
(readchar)
(gclear)

(dotimes ( i 500 )
  (gpentick (1+ (rnd 10)))
  (gpencolor (rnd (* 256 256 256)))
  (gbrushcolor (rnd (* 256 256 256)))
  (gbrushtype (rnd 8))
  (gfillellipse (rnd *scrnx*) (rnd *scrny*) (rnd 30) (rnd 30)) 
)
(readchar)
(gclear)

(dotimes ( i 500 )
  (gpentick (1+ (rnd 10)))
  (gpencolor (rnd (* 256 256 256)))
  (gbrushcolor (rnd (* 256 256 256)))
  (gbrushtype (rnd 8))
  (gfillsector (rnd *scrnx*) (rnd *scrny*) (rnd 360) (rnd 360) (rnd 30) (rnd 30)) 
)
(readchar)
(gclear)


(dotimes ( i 300 )
  (gputpixel (rnd *scrnx*) (rnd *scrny*) (rnd (* 256 256 256)))
)
(readchar)
(gclear)



(dotimes ( i 1000 )
  (gpencolor (rnd (* 256 256 256))) 
  (gouttext (-(rnd *scrnx*) 20) (-(rnd *scrny*)20) (strcat "GOutText" (rndstr 5)))
)
(readchar)
(gmode 0)



