; Graphic Lisp
; By Zoia Andrea
(load "graphadd.lsp")
(load "fft.inc")


(defun atan2 (r i)
  (if (= 0 r) (asin 1) (atan (/ i r)))
)

(defun calc-phase (real img &aux p)
  (do*
    (
      (r real (cdr r))
      (i img  (cdr i))
    )
    ( (null r) p)
    (setf p (append p (list (atan2 (car i) (car r)))))
  )
)

(defun calc-mod (real img &aux p)
  (do*
    (
      (r real (cdr r))
      (i img  (cdr i))
    )
    ( (null (cdr r)) p)
    (setf p (append p (list (sqrt (* (car r)(car r))
			          (* (car i)(car i))
			    ))))
  )
)

(defun search-absmax (l &aux (max 0))
  (dolist (i l)
     (when (> (abs i) max) (setf max (abs i)))
  )
  max
)


(defun read-file (name &aux f l n)
  (setf f (fopen name "r"))
  (if (not f) nil
   (progn
    (loop
     (setf n (fscanf f 1))
     (when (feof f) (return))
     (setf l (append l (list n)))
    )
    (fclose f)
    l
   )    
  ) 
)





(defun print-grid()
  (gpencolor (rgb 255 0 0))

  (gmoveto 0 0)
  (glineto (1- *scrnx*) 0)
  (glineto (1- *scrnx*) (1- *scrny*))
  (glineto 0 (1- *scrny*))
  (glineto 0 0)

  (gpencolor (rgb 0 0 255))

  (gmoveto 0           *scrny/3* )
  (glineto *scrnx*     *scrny/3* )
  
  (gmoveto 0           *scrny/3*2* )
  (glineto *scrnx*     *scrny/3*2* )

  (gmoveto *scrnx/5*4* 0       )
  (glineto *scrnx/5*4* *scrny* )

  (gpencolor (rgb 0 255 255))
  (gpentype *pen-dash*)

  (gmoveto 0           (rround (/ *scrny/3* 2)))
  (glineto *scrnx/5*4* (rround (/ *scrny/3* 2)))

  (gmoveto 0           (rround (- *scrny* (/ *scrny/3* 2))))
  (glineto *scrnx/5*4* (rround (- *scrny* (/ *scrny/3* 2))))

  (gpentype *pen-solid*)
)



(defun print-func (func name &aux max min zfact xfact x)
  (gpencolor (rgb 255 255 255))
  (setf max (search-absmax func))
  (setf zfact (float (/ *scrny/3* max 2)))
  (setf xfact (float (/ *scrnx/5*4* (1- (array-dimension func 0)))))
  
  (setf x 0)
  (gmoveto (rround x) (rround (- (/ *scrny/3* 2) (* (car func) zfact) )))
  (dolist (y (cdr func))
    (setf x (+ x xfact))
    (glineto (rround x) (rround (- (/ *scrny/3* 2) (* y zfact) )))
  )
  (gouttext (+ 2 *scrnx/5*4*) 2                (strprintf "+%lf" max))
  (gouttext (+ 2 *scrnx/5*4*) (- *scrny/3* 16) (strprintf "-%lf" max))
  (gouttext (+ 2 *scrnx/5*4*) (rround (/ *scrny/3* 2))   name)
)  


(defun print-mod (func &aux max min zfact xfact x)
  (gpencolor (rgb 255 255 255))
  (setf max (search-absmax func))
  (setf zfact (float (/ *scrny/3* max )))
  (setf xfact (float (/ *scrnx/5*4* (1- (array-dimension func 0)))))
  
  (setf x 0)
  (dolist (y func)
    (gmoveto (rround x) (* 2 *scrny/3*))
    (glineto (rround x) (rround (- (* *scrny/3* 2) (* y zfact) )))
    (setf x (+ x xfact))
  )
  (gouttext (+ 2 *scrnx/5*4*) (+ 2 *scrny/3* ) (strprintf "%lf" max))
  (gouttext (+ 2 *scrnx/5*4*) (- (* 2 *scrny/3*) 16) (strprintf "%lf" 0.0))
)  

(defun print-phase (func &aux max min zfact xfact x)
  (gpencolor (rgb 255 255 255))
  (setf xfact (float (/ *scrnx/5*4* (1- (array-dimension func 0)))))
  (setf yf    (- *scrny* (/ *scrny/3* 2)))
  (setf x 0)
  (dolist (y func)
    (gmoveto (rround x) (rround (- *scrny* (/ *scrny/3* 2))) )
    (glineto (rround x) (rround (- 
    				*scrny* 
    				(/ *scrny/3* 2) 
    				(* (/ *scrny/3* 2) (/ y (/ 3.1415926 2)) )
    				)
    		        )
    )		         
    (setf x (+ x xfact))
  )
  (gouttext (+ 2 *scrnx/5*4*) (+ 2 (* 2 *scrny/3* ) ) "+PI")
  (gouttext (+ 2 *scrnx/5*4*) (- *scrny* 16) "-PI")
)  

(defun gfft (filename)

  (setf *scrny*  (gmode 2))
  (setf *scrnx*  (car *scrny*))
  (setf *scrny*  (car (cdr *scrny*)))
  (setf *scrnx/5*4* (rround (* 4 (/ *scrnx* 5))))
  (setf *scrny/3*   (rround (/ *scrny* 3)))
  (setf *scrny/3*2* (rround (* 2 (/ *scrny* 3))))


  (print-grid)
  (setf re (append (read-file filename) '(0)))
  (setf im (make-array (lenght re) :initial-element 0.0))

  (print-func re filename)
 
  (fft re im)
  (print-mod  (calc-mod   re im))
  (print-phase(calc-phase re im))
  (readchar)
  (gmode 0)
)

(defun input-filename (&aux f name)
 (cls)
 (curpos 1 15)
 (print "         Fast Fourier Transform  \n")
 (print "  Immettere il nome del file ad.es 'my_ox.usr' \n")
 (print "  Il file deve contenere 2^n numeri che rappresentano i campioni del segnale")
 (loop
  (curpos 1 10)
  (print "File ('exit' per uscire)->              ")
  (curpos 27 10)
  (setf name (read-line 12))
  (when (string= name "exit") (return nil))
  (setf f (fopen name "r"))
  (when f (fclose f) (return name))
 )
)

(defun graph-fft (&aux name)
  (loop
    (setf name (input-filename))
    (unless name (return))
    (gfft name)
  )
  (cls)
  (print "Per ripartire digita (graph-fft)\n")
  T
)
;(graph-fft)
(print "Per partire digita (graph-fft)\n")



