
;;; From Performance and evaluation of Lisp Systems
;;;	R.P.Gabriel  MIT Press

(load "array.lsp")
(load "addon.lsp")


(defun fft (areal aimag)
 ;;; fast fourier transform
 ;;; areal = real part
 ;;; aimag = imaginary part
 (prog
  (ar ai i j k m n le le1 ip nv2 nm1 ur ui wr wi tr ti)
  ;;; initialize
  (setq ar areal
        ai aimag	n (array-dimension ar 0)
	n (1- n)	nv2 (floor n 2)
	;;; compute m = log(n)
	nm1 (1- n) m 0
	i 1)

;  (print "n=" n " nv2=" nv2 " nm1=" nm1 " m=" m " i=" i "\n")
;  (readchar)

l1 (cond ((< i n) (setq m (1+ m) i (+ i i)) (go l1)))

;   (print "n=" n " nv2=" nv2 " nm1=" nm1 " m=" m " i=" i "\n")
;   (readchar)

   (cond ((not (equal n (expt 2 m)))
	  (print "error ... array size not a power of two.")
	  (input) (return nil)))

   ;;; interchange elements in bit-reverse order
   (setq j 1 i 1)
l3 (cond ((< i j)
          (setq tr (aref ar j) ti (aref ai j))
	  (setf (aref ar j) (aref ar i))
          (setf (aref ai j) (aref ai i))
          (setf (aref ar i) tr)
          (setf (aref ai i) ti)))    
   (setq k nv2)
l6 (cond ((< k j)
          (setq j (- j k) k (/ k 2))
          (go l6)))    
   (setq j (+ j k)
         i (1+ i))
   (cond ((< i n)
          (go l3)))

;   (print "Pass 1 \n")
;   (print re "\n")
;   (print im "\n")
;   (readchar) 	


   ;;; loop thru stages
   (do ((l 1 (1+ l)))
       ((> l m))
       (setq le (expt 2 l)
             le1 (floor le 2) ur 1.0
	     ui 0.0 	      wr (cos (/ pi (float le1)))	
             wi (sin (/ pi (float le1))))
        ;;; loop thru butterflies
       (do ((j 1 (1+ j)))
	   ((> j le1))
           ;;; do a butterfly
           (do ((i j (+ i le)))
               ((> i n))
               (setq ip (+ i le1)
                     tr (- (* (aref ar ip) ur)
                           (* (aref ai ip) ui))
                     ti (+ (* (aref ar ip) ui)
                           (* (aref ai ip) ur))) 
;               (print tr " " ti " " wr " " wi "\n")
               (setf (aref ar ip) (- (aref ar i) tr))
               (setf (aref ai ip) (- (aref ai i) ti))
               (setf (aref ar i) (+ (aref ar i) tr))
               (setf (aref ai i) (+ (aref ai i) ti))) ; 

       (setq tr (- (* ur wr) (* ui wi))
             ti (+ (* ur wi) (* ui wr))
             ur tr ui ti))
)       
   (return t)))        
		



