/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file clos_tc1.c */
/* codice non ansi per turboc 2.0 , turboc++ 1.0 e borlandc 2.0 */

#include "clos.h"

#include <dos.h>
#include <conio.h>
#include <process.h>
#include <sys\timeb.h>
#include <graphics.h>
#include <signal.h>


int input_string(int x,int y,unsigned char *s,int maxlen);

int ctrl_brk_handler(void);
void c_stack_overflow(void);

extern unsigned _stklen=0xffef;

int ctrl_brk_handler(void)
{
 longjmp(critical_jmp,LONGJMP_CONTROLC);
 return 0;
}

void c_stack_overflow(void)
{
 longjmp(critical_jmp,LONGJMP_STACK);
}

void into(int,int,int* reglist);
void into(int a,int b,int *c)
{
 signal(SIGFPE,into);
 error(E_OVERFLOW,ERR_MERROR|ERR_PVOID|ERR_TBLVL,NULL);
}

int clos_non_ansi_init()
{
 char *ptr;
 if(!(ptr=(char*)malloc(4096))){
   fprintf(stderr,"Should not be enough memory to manage files \n");
     fprintf(stderr,
	"Retry allocating few nodes or few strings or few hash entries\n");
   return ERROR;
 }
 free((void*)ptr);
 registerbgidriver(EGAVGA_driver);
 registerbgidriver(IBM8514_driver);
 ctrlbrk(ctrl_brk_handler);

 setcbrk(1);
 /* int 0 div by zero */
 /* int 4 mult overflow */
 signal(SIGFPE,into);

 printf("\n\n\n");
 printf(
" ------------------>   Common Lisp Object System   V%s <------------------ \n",CLOS_VERSION);
						/*   05  */
 printf(
"----------------> (c) 1991--1994 By Andrea Michele Zoia <----------------------\n");

 printf(
"------------------------------>  For MsDos  <----------------------------------\n");
 printf(
" -------------------->Date %s Time %s <------------------------ \n",__DATE__,__TIME__);
		/*          11      08  */
 return OK;
}

void clos_non_ansi_exit()
{
 exit(0);
}

int cl_beep(int freq)
{
 freq?sound(freq):nosound();
 return OK;
}

int cl_getch(void)
{
 return getch();
}

long na_millitime(void)
{
 /* ritorna il timer in millisecondi */
 struct timeb t;
 long tmp;

 ftime(&t);

 tmp=t.time;
 tmp*=1000;
 tmp+=(long)t.millitm;
 return tmp;
}

char *matherr_names[6]={
	"DOMAIN",
	"SINGgularity",
	"OVERFLOW",
	"UNDERFLOW",
	"Total LOSS of precision",
	"Partial LOSS of precision" /* non usato da turboc */
};

int matherr(struct exception *e)
{
 char buffer[200];
 sprintf(buffer,
	"type<%s>,function name<%s>,argument1<%f>,argument2(zero if nonexistent)<%f>",
	matherr_names[e->type-1],e->name,e->arg1,e->arg2
 );
 error(E_MATH,ERR_MERROR|ERR_PSTRING|ERR_TBLVL,buffer);
 return 1;
}


void stack_backtrace(void)
{

 /*
 ADDRESSES   STACK              BYTES
	 | ecc... 		 |
  low    | 0x12345678 magic	4|    eval stack-frame
	 | node func            4|
	 | node remalloc        4|
	 |  bp			2|
	 | return address 	4|
	 | nin			4|    eval parameters
	 | nout			4|
	 | genv			4|
	 | lenv			4|
  high	 | flags		2|

*/


 char far *s;
 char far *p;
 node nin;
 /* node_p *nout; */
 node genv;
 node lenv;
 /* unsigned fl; */
 int printed=FALSE;

 s=MK_FP(_SS,_SP);
 for(;;){
   while(*(unsigned long *)s!=0x12345678L){
     s++;
     if(FP_OFF(s)>_stklen){
       if(printed)lisp_print_string("***End Of Stack***\n",stderr);
       return;
     }
   }
   p=s;
   /* p++;p++;p++;p++;
   p++;p++;p++;p++;*/
   p++;p++;p++;p++;
   p++;p++;
   p++;p++;p++;p++;
   nin=*(node *)p;
   p++;p++;p++;p++;
   /* nout=*(node_p **)p; */
   p++;p++;p++;p++;
   genv=*(node *)p;
   p++;p++;p++;p++;
   lenv=*(node *)p;
   /* p++;p++;p++;p++; */
   /* fl=*(unsigned*)p; */

   if(IS_CONS(nin)){
     printed=TRUE;
     lisp_print_string(  "Function ",stderr);
     fprint_func(CONSLEFT(nin),stderr);
     lisp_print_string("\nParList  ",stderr);
      fprint_func(CONSRIGHT(nin),stderr);
     lisp_print_string("\nL-Env    ",stderr);
     fprint_func(lenv,stderr);
     lisp_print_string("\nG-Env    ",stderr);
     fprint_func(genv,stderr);
     lisp_print_string("\nMore?\n",stderr);
     if(getch()=='n') return;
   }
   s++;
 }

}

/*****************   EMULAZIONE TERMINALE ************************/
/* put_char, put_string, get_char, get_string, curpos, charcolor */
/*****************************************************************/


int lisp_curpos(x,y)
int x;
int y;
{
 if(x>=1 && x<=80 && y>=1 && y<=25)
   printf("%c[%u;%uf",27,26-y,x);
}


int lisp_charcolor(fore,back,attrib)
n_int fore;
n_int back;
n_int attrib;
{
 if(attrib>=1 && attrib <=9)
   printf("%c[%um",27,(int)(attrib-1));
 if(back>=1 && back <=8)
   printf("%c[%um",27,(int)(39+back));
 if(fore>=1 && fore <=8)
   printf("%c[%um",27,(int)(29+fore));
}

int lisp_cls(void)
{
 printf("%c[2J",27);
 printf("%c[%u;%uf",27,24,0);
}

int lisp_getcurpos(x,y)
int x;int y;
{x=y=0;}


/* usare queste funzioni per stampare qualcosa su di un file di I/O utente*/
/* stampa la stessa stringa anche sul dribble file */
/* se il file di I/O non e' NULL */
/* tramite queste funzioni si possono intercettare tutte le chiamate */
/* allo stream e ridirigerle altrove ad.es. su di una finestra di windows */

int lisp_put_char(int c,FILE *f)
{
 /* ritorna c oppure EOF se c'e' qualche errore */
 if(f==stdout || f==stderr){
   fputc(c,f);
   if(dribble_file)fputc(c,dribble_file);
   return c;
 }
 return f?fputc(c,f):EOF;
}

int lisp_print_string(char *s,FILE *f)
{
 /* ritorna l'ultimo carattere della stringa oppure EOF se c'e' un errore */
 int ret;
 while(*s)ret=lisp_put_char(*s++,f);
 return ret;
}


int lisp_get_string(char *c,int len,FILE *f)
{
 /* len e' la lunghezza massima della stringa senza lo zero finale */
 /* ritorna una stringa senza il newline finale */

 if(!f)return EOF;
 if(f==stdin){
   input_string(wherex(),wherey(),c,len);
   if(dribble_file)
     fputs(c,dribble_file);
   return len;
 }
 if(!fgets(c,len+1,f))return EOF;
 while(*c)c++;
 if(*--c=='\n')*c=0;
 return len;
}


int lisp_get_char(f)
FILE *f;
{
 static unsigned char buffer[MAX_ID_LENGHT];
 static int  counter=0;

 if(f==stdin){
   if(counter==0){
     buffer[0]=0;
     input_string(wherex(),wherey(),buffer,MAX_ID_LENGHT);
     if(dribble_file)
       fputs(buffer,dribble_file);
     lisp_put_char('\n',stdout);
   }
   return buffer[counter]?buffer[counter++]:(counter=0,'\n');
 }
 return f?getc(f):EOF;
}



#define UP	72
#define DOWN	80
#define RIGHT	77
#define LEFT	75
#define PGUP	73
#define PGDOWN	81
#define HOME	71
#define END	79
#define INS	82
#define DEL	83
#define ESC	27
#define BACKSP	8
#define TAB	9
#define ENTER	13
#define SPACE	32

#define CHAR_PER_LINE 80
#define ROWS_PER_SCREEN 25
int input_string(int x,int y,unsigned char *s,int maxlen)
{
 /* maxlen non tiene conto dello 0 finale */
 int delete_flag=1;
 int curpos=0;
 int len=strlen(s);
 int insert_flag=1;
 int i;
 int c;

 x--;
 s[maxlen]=0;
 gotoxy(x+1,y);
 /*puts(s)*/;
 gotoxy(x+1,y);
 do{
   c=getch();
   if(!c){
     switch(getch()){
       case UP:
	 curpos-=CHAR_PER_LINE;
	 if(curpos<0)curpos+=CHAR_PER_LINE;
	 gotoxy((x+curpos)%CHAR_PER_LINE+1,y+(x+curpos)/CHAR_PER_LINE);
	 delete_flag=0;
	 break;
       case DOWN:
	 curpos+=CHAR_PER_LINE;
	 if(curpos>len)curpos-=CHAR_PER_LINE;
	 gotoxy((x+curpos)%CHAR_PER_LINE+1,y+(x+curpos)/CHAR_PER_LINE);
	 delete_flag=0;
	 break;
       case RIGHT:
	 curpos++;
	 if(curpos>len)curpos=len;
	 gotoxy((x+curpos)%CHAR_PER_LINE+1,y+(x+curpos)/CHAR_PER_LINE);
	 delete_flag=0;
	 break;
       case LEFT:
	 curpos--;
	 if(curpos<0)curpos=0;
	 gotoxy((x+curpos)%CHAR_PER_LINE+1,y+(x+curpos)/CHAR_PER_LINE);
	 delete_flag=0;
	 break;
       case END:
	 curpos=len;
	 gotoxy((x+curpos)%CHAR_PER_LINE+1,y+(x+curpos)/CHAR_PER_LINE);
	 delete_flag=0;
	 break;
       case HOME:
	 curpos=0;
	 gotoxy(x+1,y);
	 delete_flag=0;
	 break;
       case DEL:
	 if(curpos<len){
	   for(i=curpos;i<len;i++){
	     s[i]=s[i+1];
	     putchar(s[i]?s[i]:' ');
	   }
	   gotoxy((x+curpos)%CHAR_PER_LINE+1,y+(x+curpos)/CHAR_PER_LINE);
	   len--;
	 }
	 delete_flag=0;
	 break;
       case INS:
	 insert_flag^=1;
	 delete_flag=0;
	 break;
     }
   }
   if(c==BACKSP){
     if(curpos>0){
       gotoxy((x+curpos-1)%CHAR_PER_LINE+1,y+(x+curpos-1)/CHAR_PER_LINE);
       for(i=curpos;i<=len;i++){
	 s[i-1]=s[i];
	 putchar(s[i]?s[i]:' ');
       }
       curpos--;
       len--;
       gotoxy((x+curpos)%CHAR_PER_LINE+1,y+(x+curpos)/CHAR_PER_LINE);
       delete_flag=0;
     }
   }
   if(c>=32){/* && c<=127){*/
     if(delete_flag){
       s[0]=0;
       curpos=0;
       len=0;
       gotoxy(x+1,y);
       for(i=0;i<len;i++)
	 putchar(' ');
       gotoxy(x+1,y);
       delete_flag=0;
     }
     if(insert_flag){
       if(len<maxlen){
	 for(i=len;i>=curpos;i--){
	   s[i+1]=s[i];
	 }
	 for(i=curpos;i<=len;i++){
	   putchar(s[i]);
	   if(y+(x+i+1)/CHAR_PER_LINE>ROWS_PER_SCREEN){
	     y--;
	   }
	 }
	 len++;
	 s[curpos]=c;
	 gotoxy((x+curpos)%CHAR_PER_LINE+1,y+(x+curpos)/CHAR_PER_LINE);
	 putchar(c);
	 curpos++;
       }
     }
     else{ /* overwrite */
       if(curpos<len){
	 s[curpos++]=c;
	 putchar(c);
       }
       else{ /* curpos==len */
	 if(len<maxlen){
	   s[curpos++]=c;
	   putchar(c);
	   s[curpos]=0;
	   len++;
	   if(y+(len-1)/CHAR_PER_LINE>ROWS_PER_SCREEN){
	     y--;
	   }
	 }
       }
     }
   }
 }while(c!=ENTER);/* && c!=ESC);*/
 gotoxy((x+len+1)%CHAR_PER_LINE,y+(x+len+1)/CHAR_PER_LINE);
 return c;
}




