%{
/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file closlex.l */
#define CLOSLEX_L
#include "clos.h"
#include "closyacc.h"

#ifndef FLEX_SCANNER
#undef  input
#define input() \
(\
    (\
	( yytchar=yysptr>yysbuf\
	      ?U(*--yysptr)\
	      :lisp_get_char(yacc_filein)\
	)==10\
	    ?(yylineno++,yytchar)\
	    :yytchar\
    )==EOF\
	?0\
	:yytchar\
)

#else
#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = lisp_get_char(yacc_filein)) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yacc_filein ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif



int		sq_b_fl=FALSE;
int		parcount=0;
extern FILE	*yacc_filein;

%}
integer		[+-]?[0-9]+
real1		[+-]?[0-9]*"."[0-9]+
real2		[+-]?[0-9]*"."[0-9]+[Ee][+-]?[0-9]+
real3		[+-]?[0-9]+[Ee][+-]?[0-9]+
real		{real1}|{real2}|{real3}
identifier	[^ \n\t\"\;\.\,\'\#\&\:\~\]\(\)]+
rem		";"[^\n]*\n
string		\"("\\\""|[^\"\n])*[\"\n]
nl		\n
legalchar	"."|","|"'"|"#"|":"|"&"|"~"
openpar		(
closepar	)
squarepar	]
nothing		[ \t]+

%%
 {
  if(sq_b_fl){
   if(parcount){
      parcount--;
      return ')';
   }
   sq_b_fl=FALSE;
  }
 }
{nothing}	;
{legalchar}	{return yytext[0];}
{nl}|{rem}	{return '\n';}
"("		{parcount++;return '(';}
")"		{parcount--;return ')';}
"]"		{
			if(!parcount){
				return BAD_SQB_YY;
			}
			else{
				sq_b_fl=TRUE;
				parcount--;
				return ')';
			}
		}
{integer}	{
			sscanf(yytext,"%ld",&yylval.integer);
			return	INTEGER_YY;
		}
{real}		{
			sscanf(yytext,"%lf",&yylval.real);
			return REAL_YY;
		}
{identifier}	{
			yylval.ident=yytext;
			if(!config.case_sensitive)
			{  /* converte le lettere in upper-case */
			   /* es 'anDRea23*ee'-->'ANDREA23*EE' */
			    while(*yylval.ident){
				if(*yylval.ident>='a' && *yylval.ident<='z')
				    *yylval.ident=*yylval.ident-('a'-'A');
				yylval.ident++;
			    }
			    yylval.ident=yytext;
			}
			if(strlen(yytext)>config.max_id_lenght){
			    yytext[config.max_id_lenght]=0;
			    error(E_IDLONG,ERR_MWARN|ERR_TNORM|ERR_PSTRING,
				yytext);
			}
			return	IDENTIFIER_YY;
		}
{string}	{
			if(yytext[strlen(yytext)-1]!='"')
				return BAD_STRING_YY;
			if(strlen(yytext)>config.max_string_lenght+2){
			    yytext[config.max_string_lenght+1]=0;
			    error(E_STRLONG,ERR_MWARN|ERR_TNORM|ERR_PSTRING,
			       &yytext[1]);
			}else{
			    yytext[strlen(yytext)-1]=0;
			}
			yylval.ident=&yytext[1];
			return	STRING_YY;
		}
.		{
		    if(config.bad_char_error){
			yylval.integer=(n_int)yytext[0];
			return BAD_CHAR_YY;
		    }
		    else{
			sprintf(buf1,"Char '%c' ascii %i",yytext[0],yytext[0]);
			error(E_BADCH,ERR_MWARN|ERR_PSTRING|ERR_TNORM,buf1);
		    }
		}
%%

