/* $Id: truncate.c,v 1.1 1996/02/12 23:58:15 oh Exp $
 *  Very Simple Program That Truncate File(s). 
 *
 *  There are many shell or perl scripts that do 'truncate'.
 *  If you already have it, use that.
 *  Just in case you don't have truncate,
 *  I included this to truncate the log file fetchpop creates with -l flag
 *
 *    Copyright (C) 1996        Seung-Hong Oh
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>

#define whoami (getpwuid(getuid())->pw_name)

int main(int argc, char **argv)
{
    struct stat statbuf;
    int count = 1;
    int length = 0;

    if ( argc < 2 ) {    /* When there are no arguments, display usage info */
	fprintf(stderr,"Usages: %s [-l bytes] FILE...\nTruncate FILE(s).\n",argv[0]);
	return 1;
    }
    for ( ; count < argc; count ++) {
	if (!strcmp(argv[count],"-l")) { 
	    if ((length = atoi(argv[++count])) < 0 )
		length = 0;
	    ++count;
	}
	if (stat(argv[count], &statbuf) < 0) {
	    fprintf(stderr,"%s: %s: No such file.\n",argv[0],argv[count]);
	    return 1;
	} else {
	    if ((getuid() != 0) && (statbuf.st_uid != getuid())) /* checking ownership of the file */
		fprintf(stderr,"%s: %s: Not owned by %s.\n",argv[0],argv[count],whoami);
	    else if (S_ISLNK(statbuf.st_mode) /* is it really a regular file? */
		     || S_ISDIR(statbuf.st_mode) 
		     || S_ISBLK(statbuf.st_mode) 
		     || !S_ISREG(statbuf.st_mode))
		fprintf(stderr,"%s: %s: Not a regular file.\n",argv[0], argv[count]);
	    else 
		if (truncate(argv[count], length) < 0) {
		    perror("truncate");
		    return 1;
		}
	}
    }
    return 0;
}
