/*
 * $Id: socket.c,v 1.9 1996/06/26 01:27:29 oh Exp $
 *
 *  Copyright (C) 1996	Seung-Hong Oh
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <time.h>
#include <unistd.h>
#include <stdarg.h>
#include "socket.h"


int get_connect(char *serv_name, unsigned short  port_num)
{
    struct hostent *hp;
    struct sockaddr_in sa;
    int sockfd;

#ifdef SOCKDEBUG
    printf("FUNC get_connect: getting IP address of server %s\n", serv_name);
#endif
    if ((hp = gethostbyname( serv_name )) == NULL)
    {
#ifdef SOCKDEBUG
	printf("FUNC get_connect: Server does not exist: %s\n", serv_name);
#endif
	return SOCK_NOEXIST;
    }
#ifdef SOCKDEBUG
    printf("FUNC get_connect: initializing the socket address of server.\n");
#endif
    bzero(&sa, sizeof(sa));
    bcopy(hp->h_addr, (char *) &(sa.sin_addr), hp->h_length);
    sa.sin_family = AF_INET; 
    sa.sin_port = htons(port_num);

    if (( sockfd = socket(AF_INET, SOCK_STREAM, 0 )) < 0) {
#ifdef SOCKDEBUG
	perror(" FUNC: get_connect: socket cannot be opened\n");
#endif	
	return SOCK_ERROR;
    }
    if (connect(sockfd, (struct sockaddr *) &sa, sizeof(sa)) < 0 ) {
#ifdef SOCKDEBUG
	printf("FUNC: get_connect: can't connect to server: %s\n",serv_name );
#endif
	close(sockfd);
	return SOCK_NORESPOND;
    }
#ifdef SOCKDEBUG
    printf("FUNC get_connect: Successfully connected to server %s\n", serv_name);
    printf("FUNC get_connect: Socket number is %d\n", sockfd);
#endif
    return sockfd;
}

int writesock(int sockfd, char* buff, int bufflen)
{
#ifdef SOCKDEBUG
    printf("FUNC writesock: the buffer is %s\n", buff);
    printf("FUNC writesock: the bufferlen is %d\n", bufflen);
    printf("FUNC writesock: the sockfd is %d\n", sockfd);
#endif
    if ((send(sockfd, buff, bufflen, 0)) < 0) {
	printf("FUNC writesock: ERROR in writing line to socket.\n");
	return SOCK_ERROR;
    }
    return 0;
}


int readsock( int sockfd, char* buff, int bufflen)
{
    int count, len_of_line = 1;

    if (recv(sockfd, buff, bufflen, MSG_PEEK) < 1) {
#ifdef SOCKDEBUG
      printf( "FUNC readsock: Error in reading line from socket.\n");
#endif
      return SOCK_ERROR;
    }
    for ( count = 0; ( buff[count] != '\n' ) && ( count < ( bufflen -2 ) ) ; count++, len_of_line++)
      ;
    
    recv( sockfd, buff, len_of_line, 0 );
    buff[len_of_line] = '\0' ;
    
    return 0;
}

int writeln( int sockfd, char* buf)
{
  
  if ( (writesock(sockfd, buf, strlen(buf))) == 0 )
    return 0;
  else
    return SOCK_ERROR;
}

int sockprintf(int socket,char* format, ...)
{
  va_list ap;
  char buf[8192];
  
  va_start(ap, format);
  vsprintf(buf, format, ap);
  va_end(ap);
  return writesock(socket, buf, strlen(buf));
}

int sockgetline(int socket, char *buf, int len)
{
  while (--len)
    {
      if (read(socket, buf, 1) != 1)
	return -1;
      if (*buf == '\n')
	break;
      if (*buf != '\r') 
	buf++;
    }
  *buf = 0;
  return 0;
}
