/*
 * $Id: retrieve.c,v 1.9 1996/06/26 01:27:22 oh Exp $
 *
 *  Copyright (C) 1996	Seung-Hong Oh
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <pwd.h>
#include <sys/types.h>

#include "fetchpop.h"
#include "socket.h"
#include "pop.h"
#include "config.h"
#include "retrieve.h"
#include "ctype.h"

static void reply_hack(char *after, const char *before, const char *host); 

int fetchmail(struct optrep *options, int sockfd, int howmany, int lastread, FILE *logfd)
{
  int rpy, index; 
  int start = lastread+1;
  char buf[POPBUFLEN];
  unsigned long int howlong;
#ifdef LogOnlyNew
  time_t now;
#endif

  if ( options->check == 2 ) 
    start = 1;
  for ( index = start ; index <= howmany ; index ++ ) {
    if ( options->toplines )
      rpy = pop_top(sockfd,index,options->toplines);
    else
      rpy = pop_retr(sockfd,index);
    if ( rpy != 0 ) {
      sprintf(buf,"[-Error-] RETR/TOP command. Your mail remains in %s.\nDisconnecting from the pop server.\n",options->host);
      printmsg(buf,options->logging,options->daemon,logfd,1, options->whichdeliver==4);
      pop_quit(sockfd);
      close(sockfd);
      return 1;
    }
    rpy=pop_delivermsg(options,sockfd, logfd, &howlong,index);
    if ( rpy < 0 ) {
      if ( rpy == SHIT )
	printmsg("[-Error-] Shit happened while sending mail with MDA. You will get a bogus message. Just disregard it. Disconnecting from the pop server\n",options->logging,options->daemon, logfd, 1, options->whichdeliver==4);
      else
	printmsg("[-Error-] Retrieving mail. Resetting mail status. Disconnecting from the pop server\n",options->logging,options->daemon, logfd, 1, options->whichdeliver==4);
      rpy =pop_rset(sockfd);
      pop_quit(sockfd);
      close(sockfd);
      return 1;
    }

#ifndef LogOnlyNew
    sprintf(buf,"[Message #%2d] fetched (%d lines %lu characters).\n",index,rpy,howlong);
    printmsg(buf,options->logging, options->daemon, logfd, 0, options->whichdeliver == 4);
#else
    now = time(NULL);
    sprintf(buf,"[Message #%2d] fetched (%d lines %lu characters). %s",index,rpy,howlong,ctime(&now));
    printmsg(buf,options->logging, options->daemon, logfd, 0, options->whichdeliver == 4);
#endif

    if ( options->remove==1 ) {
      if ((rpy = pop_dele(sockfd, index)) ) {
	printmsg("[-Error-] Deleting mail on the remote server.\n",options->logging, options->daemon, logfd, 1, options->whichdeliver==4);
	pop_quit(sockfd);
	close(sockfd);
	return 1;
      } else {
	sprintf(buf,"[Remove #%2d] Message #%d was removed on the remote server.\n",index,index);
	printmsg(buf,options->logging,options->daemon,logfd,0, options->whichdeliver == 4);
      }
    }
  }
  
#ifndef NODETAILLOG
  if ( options->whichdeliver == 2 ) {
    sprintf(buf,"%s was used to deliver mail.\n",DefaultMDA);
    printmsg(buf,options->logging, options->daemon, logfd, 0, options->whichdeliver == 4);
  } else if ( options->whichdeliver == 3 )
    printmsg("procmail/formail was used to deliver mail.\n",options->logging, options->daemon, logfd,0, options->whichdeliver == 4);
  else {
    sprintf(buf,"Mail was appended to mailbox folder %s.\n",options->output);
    printmsg(buf,options->logging, options->daemon, logfd,0, options->whichdeliver == 4);
  }
#endif
  
  return 0;
}

/* This function reply_hack was written by Eric S. Raymond. Also He fixed 
   my Enlish in the man page.
   He made patches to popclient3.0b4 to add fetchpop's features and behavior.
   Now, he is a new maintainer of popclinet. So don't get suprised when you
   see fetchpop and upcomming popclient are similar in terms of
   behavior and features.
*/
static void reply_hack(char *after, const char *before, const char *host)
/* hack local mail IDs -- code by Eric S. Raymond 20 Jun 1996 */
{
  const char *from;
  int state = 0;

  for (from = before; *from; from++)
  {
    switch (state)
      {
      case 0:   /* before header colon */
        if (*from == ':')
          state = 1;
        break;

      case 1:   /* we've seen the colon, we're looking for addresses */
        if (*from == '"')
          state = 2;
        else if (*from == '(')
          state = 3;    
        else if (*from == '<' || isalnum(*from))
          state = 4;
        break;

      case 2:   /* we're in a quoted human name, copy and ignore */
        if (*from == '"')
          state = 1;
        break;

      case 3:   /* we're in a parenthesized human name, copy and ignore */
        if (*from == ')')
          state = 1;
        break;

      case 4:   /* the real work gets done here */
        /*
         * We're in something that might be an address part,
         * either a bare unquoted/unparenthesized text or text
         * enclosed in <> as per RFC822.
         */
        /* if the address part contains an @, don't mess with it */
        if (*from == '@')
          state = 5;

        /* If the address token is not properly terminated, ignore it. */
        else if (*from == ' ' || *from == '\t')
          state = 1;

        /*
         * On proper termination with no @, insert hostname.
         * Case '>' catches <>-enclosed mail IDs.  Case ',' catches
         * comma-separated bare IDs.  Cases \r and \n catch the case
         * of a single ID alone on the line.
         */
        else if (strchr(">,\r\n", *from))
        {
          strcpy(after, "@");
          strcat(after, host);
          after += strlen(after);
          state = 1;
        }

        /* everything else, including alphanumerics, just passes through */
        break;

      case 5:   /* we're in a remote mail ID, no need to append hostname */
        if (*from == '>' || *from == ',' || isspace(*from))
          state = 1;
        break;
      }

    /* all characters from the old buffer get copied to the new one */
    *after++ = *from;
  }
  *after++ = '\0';
}

int pop_delivermsg(struct optrep *options, int sockfd, FILE *logfd, unsigned long int *howlong, int index)
{
  char msgbuf[MSGBUFLEN];
  int lines = 0;
  time_t now;
  FILE *fp =NULL;
  int mfd=1;
  char deliverycommand[80];
  int length;
  int inheaders = 1;
  char msg[POPBUFLEN];

  (*howlong) = 0ul;
  signal(SIGINT,SIG_IGN);

  if ( ( options->whichdeliver == 0 ) || (options->whichdeliver == 1) || (options->whichdeliver==4)) {
    if ( (mfd=openmbox(options->whichdeliver,options->output)) < 0 ) {
      printmsg("[-Error-] opening mailbox folder.\n",options->logging, options->daemon, logfd, 0, options->whichdeliver==4);
      return -2;
    }
  } else { 
    if ( options->whichdeliver == 2 ) {
#ifdef HAVEMDA
      strcpy(deliverycommand, DefaultMDA);
      strcat(deliverycommand," ");
      strcat(deliverycommand, whoami);
#endif    
    }
    if ( options->whichdeliver == 3 ) {
#ifdef HAVEPROCMAIL
      strcpy(deliverycommand, FORMAIL);
      strcat(deliverycommand, " -s procmail");
#endif
    }
    
    if ((fp = popen(deliverycommand, "w")) == NULL ) {
      printmsg("[-Error-] Opening pipe to MDA.\n",options->logging, options->daemon, logfd, 0, options->whichdeliver==4);
      return -1;
    }
  }

  while (1) {
    if (sockgetline(sockfd,msgbuf,MSGBUFLEN) < 0) {
      return -10;
    }
    
    if (inheaders && msgbuf[0] == '\0')
      inheaders = 0;

    if (msgbuf[0] == '.') 
      if (msgbuf[1] == 0)
	break; 
    
    strcat(msgbuf,"\n");
    if (options->hack_addresses && inheaders) {
      if (!strncmp("From: ", msgbuf, 6)
	  || !strncmp("To: ", msgbuf, 4)
	  || !strncmp("Reply-", msgbuf, 6)
	  || !strncmp("Cc: ", msgbuf, 4)
	  || !strncmp("Bcc: ", msgbuf, 5)) {
	sprintf(msg, "[Message #%2d] Hacking header: %s", index,msgbuf);
#ifdef LogShowfrom
	printmsg(msg, options->logging, options->daemon, logfd, 0, options->whichdeliver==4);
#endif
	reply_hack(msg, msgbuf, options->host);
	(void) strcpy(msgbuf, msg);
      }
    }

    length = strlen(msgbuf);
    if ((options->whichdeliver==2) || (options->whichdeliver == 3)) { 
      if (fwrite(msgbuf,length,1,fp) != 1) {
	/* need to prevent sending bogus mails here. flush*/
	pclose(fp);
	return(SHIT);
      }
    } else {
      if ( ( lines==0 ) && (strncmp(msgbuf,"From ",5)) != 0 ) {
	now = time(NULL);
	sprintf(msg,"From fetchpop %s",ctime(&now));
	if (write(mfd, msg, strlen(msg)) < 0) {
	  return -1;
	}
      }
      
      if (write(mfd,msgbuf,length) < 0 ) {
	printmsg("[-Error-] Can not write to mail folder.\n",options->logging, options->daemon, logfd, 0, options->whichdeliver==4);
	return SHIT;
      }
    }
#ifdef LogShowfrom
    if ( inheaders && 
	 (!strncmp(msgbuf,"Subject: ",9) || ((!options->hack_addresses) && !strncmp(msgbuf,"From: ",6))) ) {
      sprintf(msg,"[Message #%2d] %s",index,msgbuf);
      printmsg(msg,options->logging, options->daemon, logfd, 0, options->whichdeliver==4);
    }
#endif
    
    lines++;
    (*howlong) += length;
  }
  
  if ((options->whichdeliver == 2) || (options->whichdeliver ==3))
    pclose(fp);
  else {
    if (write(mfd,"\n",1) < 0 ) { 
      printmsg("[-Error-] Can not write to mail folder.\n",options->logging, options->daemon, logfd, 0, options->whichdeliver==4);
      lines = -1;
    }
    closembox(mfd);
  }
  
  signal(SIGINT,SIG_DFL);  
  return lines;
}
