/*
 * fdfcomm.h
 *
 * common functions for find duplicates.
 *
 * Roy Bixler
 * March 23, 1991
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef MSDOS
#include <dir.h>
#include <dos.h>
#else
#include <dirent.h>
#endif
#include <sys/types.h>	/* must be included before stat.h */
#include <sys/stat.h>

#define ADD_TO_PATH		"*.*"
#define MAX_STR			80
#define N_INTERACTIVE	20	/* maximum number of interactive delete menu */
							/* entries */
#define MAX_SORT_CRITERIA 4     /* maximum simultaneous sort criteria */


/*
 * file matching criteria
 */
#define CONTENTS_MATCH	0x1
#define TIMES_MATCH		0x2
#define SIZES_MATCH		0x4
#define NAMES_MATCH		0x8
#define ALL_MATCH		(CONTENTS_MATCH|TIMES_MATCH|SIZES_MATCH|NAMES_MATCH)

/*
 * file sorting criteria
 */
#define DATE_SORT		0x1
#define NAME_SORT		0x2
#define SIZE_SORT		0x4
#define TIME_SORT		0x8

/*
 * file sort order
 */
#define ASCENDING		0x0
#define DESCENDING		0x1



#ifdef MSDOS
typedef struct file_list {
    struct ffblk dta;
    char *path;
    char added;
    char printed;
    struct file_list *next;
} FILE_LIST;
#else
struct ffblk {
    char *name;
    struct stat st_buf;
};

typedef struct file_list {
    DIR *dirp;
    struct ffblk dta;
    char *name;
    char *path;
    char added;
    char printed;
    struct file_list *next;
} FILE_LIST;
#endif
typedef int (*CMP_FLIST)(FILE_LIST *fd, char *path, struct ffblk *dta,
			 int sort_order);



extern CMP_FLIST Sort_criteria[MAX_SORT_CRITERIA];
extern int Sort_order[MAX_SORT_CRITERIA];
extern FILE_LIST *F_list;
extern char Match_criteria;
extern char i_flag;	/* interactive delete mode */
extern char l_flag;	/* long listing? */
extern char v_flag;	/* verbose? */



/* fdfcomm.c */
void ins_sort_criteria(CMP_FLIST cmp_func);
void ins_sort_order(int sort_order);
int has_sort_crit(CMP_FLIST cmp_flist_func);
void print_fdate(struct ffblk *dta);
void print_ftime(struct ffblk *dta);
void print_fdatetime(struct ffblk *dta);
void print_fpath(char *path, char *f_name);
void long_listing(char *path, struct ffblk *dta);
void print_match_header(FILE_LIST *start);
void print_next_match(FILE_LIST *next, int menu_num);
void print_id_menu(FILE_LIST **menu, int num_items);
int cmp_flist_date(FILE_LIST *fd, char *path, struct ffblk *dta, int sort_order);
int cmp_flist_name(FILE_LIST *fd, char *path, struct ffblk *dta, int sort_order);
int cmp_flist_size(FILE_LIST *fd, char *path, struct ffblk *dta, int sort_order);
int cmp_flist_time(FILE_LIST *fd, char *path, struct ffblk *dta, int sort_order);
int cmpflist(FILE_LIST *fd, char *path, struct ffblk *dta);
int cmpflist_eq(FILE_LIST *fd1, FILE_LIST *fd2);
int files_match(FILE_LIST *file1, FILE_LIST *file2);
void gen_list(FILE_LIST **f_list, char *path, char dirs);
void gen_list_of_dir(FILE_LIST **f_list, char *path, char *subdir, char dirs);
void add_file_to_list(FILE_LIST **f_list, char *path, struct ffblk *dta);
void list_files(FILE_LIST **f_list, char *prog_name, char *path, char dirs,
                char sorted);
void free_file_list(FILE_LIST *f_list);
void print_flist(FILE_LIST *flist);
int compare_path_name_files(char *path1, char *name1, char *path2, char *name2);
int delete_path_name_file(char *path, char *f_name, char force);
#ifdef MSDOS
void get_cur_path(char *new, char *target_dir);
void change_disk(char *dir, char *cur_dir);
int just_disk(char *dir);
#endif
