#ifdef MSDOS
#include <dir.h>

/*
 * cmpdate
 *
 * given two files, return positive if the first has a more recent modification
 * date/time, zero if the files have the same modification date/time or
 * negative if the second is more recent.
 */
int cmpdate(const struct ffblk *a, const struct ffblk *b)
{
   return (a->ff_fdate-b->ff_fdate);
}

/*
 * cmptime
 *
 * given two files, return positive if the first has a more recent modification
 * date/time, zero if the files have the same modification date/time or
 * negative if the second is more recent.
 */
long cmptime(const struct ffblk *a, const struct ffblk *b)
{
   return (((unsigned long)a->ff_fdate) << 16 | (unsigned long)a->ff_ftime) -
          (((unsigned long)b->ff_fdate) << 16 | (unsigned long)b->ff_ftime);
}
#else
#include <memory.h>
#include <time.h>

/*
 * cmpdate
 *
 * given two files, return positive if the first has a more recent modification
 * date/time, zero if the files have the same modification date/time or
 * negative if the second is more recent.
 */
int cmpdate(const time_t a, const time_t b)
{
    struct tm a_tm, b_tm;

    memcpy(&a_tm, localtime(&a), sizeof(struct tm));
    memcpy(&b_tm, localtime(&b), sizeof(struct tm));
    a_tm.tm_sec = a_tm.tm_min = a_tm.tm_hour = 0;
    b_tm.tm_sec = b_tm.tm_min = b_tm.tm_hour = 0;

#ifdef sun
    return (timelocal(&a_tm)-timelocal(&b_tm));
#else
    return (mktime(&a_tm)-mktime(&b_tm));
#endif
}

/*
 * cmptime
 *
 * given two files, return positive if the first has a more recent modification
 * date/time, zero if the files have the same modification date/time or
 * negative if the second is more recent.
 */
long cmptime(const time_t a, const time_t b)
{
    return (a-b);
}
#endif
