#ifdef MSDOS
#include <io.h>

/*
 *	copy_file_dates()
 *
 *	Input:
 *		src_handle - handle of source file
 *		dst_handle - handle of destination file
 *	Comments:
 *		copies the date and time from one file to another
 */

void copy_file_dates(int src_handle, int dst_handle)
{
	struct ftime ftime_buf;

	getftime(src_handle, &ftime_buf);
	setftime(dst_handle, &ftime_buf);
}
#else
#include <sys/stat.h>
#include <utime.h>

/*
 *	copy_file_dates()
 *
 *	Input:
 *		src_handle - handle of source file
 *		dst_path - path of destination file
 *	Comments:
 *		copies the date and time from one file to another
 */

void copy_file_dates(int src_handle, char *dst_path)
{
    struct stat stat_buf;
    struct utimbuf utime_buf;

    if (fstat(src_handle, &stat_buf) == 0) {
	utime_buf.actime = stat_buf.st_atime;
	utime_buf.modtime = stat_buf.st_mtime;
	utime(dst_path, &utime_buf);
    }
}
#endif
