/*
 * elib.h
 *
 * header file for Monk C library functions - Atari ST version
 *
 * Roy Bixler
 * Monk Software
 * March 31, 1991
 * Modified for unix: Jan. 10, 1995
 */



#define HASH_TAB_SIZE 211
#ifdef unix
#include <time.h>
#include <sys/param.h>
#define MAXPATH MAXPATHLEN
#define PATH_SEPARATOR "/"
#else /* MSDOS */
#include <dir.h>
#define PATH_SEPARATOR "\\"
#endif

/* askuser.c */
int ask_user(char *buf);

/* delete.c */
int delete_file(char *file, char force);

/* dirs.c */
int is_special(char *d_name);
char *append_dir_to_path(char *path, char *dir);
void format_dir(char *dir, char app_slash, char *formatted_dir);

/* getopt.c */
int getopt(int argc, char * const *argv, const char *opts);

/* hashpjw.c */
int hashpjw(char *s);

#ifdef MSDOS
/* fdates.c */
void copy_file_dates(int src_handle, int dst_handle);

/* ftimes.c */
int cmpdate(const struct ffblk *a, const struct ffblk *b);
long cmptime(const struct ffblk *a, const struct ffblk *b);
#else
/* fdates.c */
void copy_file_dates(int src_handle, char *dst_path);

/* ftimes.c */
int cmpdate(const time_t a, const time_t b);
long cmptime(const time_t a, const time_t b);
#endif

/* input.c */
char *skip_whitespace(char *str);
void zap_trailing_nl(char *str, int max_ch, FILE *stream);

/* marks.c */
int mark_list(char *num_list, char *mark_list, int max_num);
