
/***************************************************************************

                  D I R E C T O R Y - C O M M A N D E R

		
		  Holger Staeudte
		    IH Mittweida  1991
		
		  Rene Roellig  1993
		    Hochschule fuer Technik und Wirtschaft
		    Mittweida

***************************************************************************/


#include "dc.h"

extern di *buffer1, *buffer2;
extern int seite, line[2], count[2];
extern char path1[PATHLEN], path2[PATHLEN], pathl[PATHLEN];
extern struct dirent *direc;
extern struct stat stbuf;
extern struct tm *tmptr;
extern DIR *zz;
extern int fanz1, fanz2;

extern WINDOW *wptr[8][2];

extern int colors;

/**************************** Funktion sort() ******************************/

int  sort(dir1, dir2)
  char dir1[14], dir2[14];

{
    return (strcmp(dir1, dir2));
}

/**************************** Funktion get_direc() ************************/

di  *get_direc(buf, path, anz)
  di  *buf;
  char *path;
  int *anz;

{
    int  i = 0, temp = 0;
    int  (*comp) ();
    char *tempbuf, *tempptr, *dirptr;

    comp = sort;
    i = 0;
    zz = opendir(path);
    while ((direc = readdir(zz)) != NULL) {
	i++;
	stat(direc->d_name, &stbuf);
    }
    closedir(zz);

    tempbuf = calloc(i, DIRSIZE);
    tempptr = tempbuf;

    zz = opendir(path);
    while ((direc = readdir(zz)) != NULL) {
	stat(direc->d_name, &stbuf);
	if (S_ISDIR(stbuf.st_mode)) {
	    strcpy(tempptr, " ");
	    strcat(tempptr, direc->d_name);
	}
	else
	    strcpy(tempptr, direc->d_name);
	tempptr += DIRSIZE;
    }
    closedir(zz);
    temp = i;
    i = 0;
    dirptr = tempbuf;
    qsort(dirptr, temp, DIRSIZE, comp);

    if (buf != NULL)
	free(buf);

    tempptr = tempbuf;
    buf = calloc(temp, sizeof(di));

    do {
	if (*tempptr == ' ')
	    strcpy((buf + i)->name, (tempptr + 1));
	else
	    strcpy((buf + i)->name, tempptr);
	stat((buf + i)->name, &stbuf);
	if (S_ISDIR(stbuf.st_mode))
	    (buf + i)->mode = 1;
	(buf + i)->datsize = stbuf.st_size;
	tmptr = localtime(&stbuf.st_mtime);
	(buf + i)->own = stbuf.st_mode;
	(buf + i)->min = tmptr->tm_min;
	(buf + i)->hour = tmptr->tm_hour;
	(buf + i)->day = tmptr->tm_mday;
	(buf + i)->mon = tmptr->tm_mon + 1;
	i++;
	tempptr += DIRSIZE;
    }
    while (i < temp);
    *anz = temp;
    free(tempbuf);
    return (buf);
}


/************************** Funktion dirprint() ***************************/

void dirprint(seite, buffer, anz)
  int  seite;
  di  *buffer;
{
    int  i = 0;

    for (i = 0; i < 12; i++)
	balk(seite, i, count[seite] - line[seite] + i, 0, buffer, anz);

}


/*************************** Funktion balk() *****************************/

void balk(seite, i, count, mode, bufptr, maxfiles)
  int  seite, i, mode, count, maxfiles;
  di  *bufptr;

  /* i = Zeile im Fenster; count = Start der Ausg. bei Datei-Nr */

{

    char outname[15] =
    {0};
    int  c = 0;


    if ((count < maxfiles) & (bufptr != NULL)) {
	bufptr += count;
	strncpy(outname, bufptr->name, 14);
	if (colors)
	    wattrset(wptr[2][seite], COLOR_PAIR(1));
	if (mode) {
	    if (colors)
		wattrset(wptr[2][seite], COLOR_PAIR(2) | A_REVERSE);
	    else
		wattrset(wptr[2][seite], A_REVERSE);
	}
	else if (bufptr->set) {
	    if (colors)
		wattrset(wptr[2][seite], COLOR_PAIR(3) | A_BOLD);
	    else
		wattrset(wptr[2][seite], A_BOLD);
	}
	if (bufptr->mode) {
	    wmove(wptr[2][seite], i + 3, 1);
	    wprintw(wptr[2][seite], "%-14s   -DIR-   %2d.%2d  %02d:%02d",
		    outname,
		    bufptr->day, bufptr->mon,
		    bufptr->hour, bufptr->min);
	    wrefresh(wptr[2][seite]);
	}
	else {
	    wmove(wptr[2][seite], i + 3, 1);
	    wprintw(wptr[2][seite], "%-14s %8d  %2d.%2d  %02d:%02d",
		    outname,
		    bufptr->datsize,
		    bufptr->day, bufptr->mon,
		    bufptr->hour, bufptr->min);
	}
    }
    else {
	if (colors)
	    wattrset(wptr[2][seite], COLOR_PAIR(1));
	else
	    wattrset(wptr[2][seite], A_NORMAL);
	wmove(wptr[2][seite], i + 3, 1);
	wprintw(wptr[2][seite], "                                     ");
    }
    if (!colors)
	wattrset(wptr[2][seite], A_NORMAL);
    wmove(wptr[2][seite], i + 3, 15);
    waddch(wptr[2][seite], ACS_VLINE);
    wmove(wptr[2][seite], i + 3, 24);
    waddch(wptr[2][seite], ACS_VLINE);
    wmove(wptr[2][seite], i + 3, 31);
    waddch(wptr[2][seite], ACS_VLINE);
    wrefresh(wptr[2][seite]);
}

/*************************** Funktion balk_move() **************************/

void balk_move(seite, mode)
  int  seite, mode;

{
    if (seite)
	if (count[seite] < fanz2 - 1 || mode)
	    balk(seite, line[seite], count[seite], 0, buffer2, fanz2);
	else
	    return;
    else if (count[seite] < fanz1 - 1 || mode)
	balk(seite, line[seite], count[seite], 0, buffer1, fanz1);
    else
	return;
    if (mode) {
	line[seite]--;
	count[seite]--;
    }
    else {
	line[seite]++;
	count[seite]++;
    }
    if (seite)
	balk(seite, line[seite], count[seite], 1, buffer2, fanz2);
    else
	balk(seite, line[seite], count[seite], 1, buffer1, fanz1);
}

/************************** Funktion balk_left() **************************/

void balk_left(mode, reread)
  int  mode, reread;

{
    strcpy(pathl, path1);
    chdir(pathl);
    getcwd(path1, PATHLEN);
    if (reread)
	buffer1 = get_direc(buffer1, path1, &fanz1);
    balk(seite, line[seite], count[seite], 0, buffer2, fanz2);
    seite = 0;
    dirprint(seite, buffer1, fanz1);
    print_sel(seite, buffer1, fanz1);
    if (mode) {
	balk(seite, line[seite], count[seite], 1, buffer1, fanz1);
	wmove(wptr[1][0], 1, 1);
	wprintw(wptr[1][0], " Path:%s/>", path1);
	wrefresh(wptr[1][0]);
    }
}

/************************* Funktion balk_right() **************************/

void balk_right(mode, reread)
  int  mode, reread;

{
    strcpy(pathl, path2);
    chdir(pathl);
    getcwd(path2, PATHLEN);
    if (reread)
	buffer2 = get_direc(buffer2, path2, &fanz2);
    balk(seite, line[seite], count[seite], 0, buffer1, fanz1);
    seite = 1;
    dirprint(seite, buffer2, fanz2);
    print_sel(seite, buffer2, fanz2);
    if (mode) {
	balk(seite, line[seite], count[seite], 1, buffer2, fanz2);
	wmove(wptr[1][0], 1, 1);
	wprintw(wptr[1][0], " Path:%s/>", path2);
	wrefresh(wptr[1][0]);
    }
}

/*************************** Funktion pathprint()**************************/

void pathprint(path1, path2)
  char *path1, *path2;
{
    int  y1, y2;
    char tpath1[PATHLEN], tpath2[PATHLEN];

    move(5, 1);
    clrtoeol();
    if ((y1 = pathlength(path1)) > 36) {
	while ((y1 = pathlength(path1)) > 36)
	    path1++;
	strcpy(tpath1, "..");
	strcat(tpath1, path1);
    }
    else
	strcpy(tpath1, path1);

    if ((y2 = pathlength(path2)) > 36) {
	while ((y2 = pathlength(path2)) > 36)
	    path2++;
	strcpy(tpath2, "..");
	strcat(tpath2, path2);
    }
    else
	strcpy(tpath2, path2);

    if (!seite) {
	if (colors)
	    attrset(COLOR_PAIR(2) | A_REVERSE);
	else
	    attron(A_REVERSE);
	move(5, 24 - y1 / 2);
	printw(" %s ", tpath1);
	if (colors)
	    attrset(COLOR_PAIR(4));
	else
	    attroff(A_REVERSE);
	move(5, 64 - y2 / 2);
	printw(" %s ", tpath2);
    }
    else {
	if (colors)
	    attrset(COLOR_PAIR(2) | A_REVERSE);
	else
	    attron(A_REVERSE);
	move(5, 64 - y2 / 2);
	printw(" %s ", tpath2);
	if (colors)
	    attrset(COLOR_PAIR(4));
	else
	    attroff(A_REVERSE);
	move(5, 24 - y1 / 2);
	printw(" %s ", tpath1);
    }
    refresh();
}

/************************* Funktion pathlength() **************************/

int  pathlength(path)
  char path[];
{
    int  y = 0;

    while (path[y++] != '\0');
    return (y += 8);
}

/***************************** Funktion scr_up() *************************/

void scr_up(seite)
  int  seite;
{
    int  temp;

    if (!seite) {
	if (count[seite] < fanz1 - 1) {
	    balk(0, 11, count[seite], 0, buffer1, fanz1);
	    count[seite]++;
	    dirprint(0, buffer1, fanz1);
	    balk(0, 11, count[seite], 1, buffer1, fanz1);
	}
    }
    else {
	if (count[seite] < fanz2 - 1) {
	    balk(1, 11, count[seite], 0, buffer2, fanz2);
	    count[seite]++;
	    dirprint(1, buffer2, fanz2);
	    balk(1, 11, count[seite], 1, buffer2, fanz2);
	}
    }
}

/***************************** Funktion scr_down() ************************/

void scr_down(seite)
  int  seite;
{
    if (!seite) {
	if (count[seite]) {
	    balk(0, 0, count[seite], 0, buffer1, fanz1);
	    count[seite]--;
	    dirprint(0, buffer1, fanz1);
	    balk(0, 0, count[seite], 1, buffer1, fanz1);
	}
    }
    else {
	if (count[seite]) {
	    balk(1, 0, count[seite], 0, buffer2, fanz2);
	    count[seite]--;
	    dirprint(1, buffer2, fanz2);
	    balk(1, 0, count[seite], 1, buffer2, fanz2);
	}
    }
}



/****************************** Funktion mark() ****************************/

void mark(seite)
  int  seite;
{
    di  *buf1, *buf2;

    buf1 = buffer1 + count[0];
    buf2 = buffer2 + count[1];
    if ((seite && !buf2->mode) || (!seite && !buf1->mode)) {
	if ((seite && !buf2->set) || (!seite && !buf1->set))
	    wattrset(wptr[2][seite], A_REVERSE);
	if (seite)
	    buf2->set = !buf2->set;
	else
	    buf1->set = !buf1->set;
	if (line[seite] < 11)
	    balk_move(seite, 0);
	else
	    scr_up(seite);
    }
    else {
	if (line[seite] < 11)
	    balk_move(seite, 0);
	else
	    scr_up(seite);
    }
    wattrset(wptr[2][seite], A_NORMAL);
}


/*************************** Funktion page_down() *************************/

void page_down(seite)
  int  seite;
{
    int  zeile = 0;

    if (seite) {
	while (count[seite] + zeile < fanz2 && zeile < 11)
	    zeile++;
	if (zeile) {
	    zeile--;
	    count[seite] += zeile;
	    line[seite] = 0;
	    dirprint(seite, buffer2, fanz2);
	    balk(1, 0, count[seite], 1, buffer2, fanz2);
	}
    }
    else {
	while (count[seite] + zeile < fanz1 && zeile < 11)
	    zeile++;
	if (zeile) {
	    zeile--;
	    count[seite] += zeile;
	    line[seite] = 0;
	    dirprint(seite, buffer1, fanz1);
	    balk(0, 0, count[seite], 1, buffer1, fanz1);
	}
    }
}

/************************* Funktion page_up() *****************************/

void page_up(seite)
  int  seite;
{
    int  zeile = 0;

    if (seite) {
	while (count[seite] - zeile >= 0 && zeile < 11)
	    zeile++;
	if (zeile) {
	    zeile--;
	    count[seite] -= zeile;
	    line[seite] = 0;
	    dirprint(seite, buffer2, fanz2);
	    balk(1, 0, count[seite], 1, buffer2, fanz2);
	}
    }
    else {
	while (count[seite] - zeile >= 0 && zeile < 11)
	    zeile++;
	if (zeile) {
	    zeile--;
	    count[seite] -= zeile;
	    line[seite] = 0;
	    dirprint(seite, buffer1, fanz1);
	    balk(0, 0, count[seite], 1, buffer1, fanz1);
	}
    }
}


/************************* Funktion print_sel() ***************************/

void print_sel(seite, buffer, maxfiles)
  int  seite, maxfiles;
  di  *buffer;

{
    int  i = 0, sel_anz = 0, size = 0;

    while (i < maxfiles) {
	if ((buffer + i)->set) {
	    size += (buffer + i)->datsize;
	    sel_anz++;
	}
	i++;
    }
    if (sel_anz) {
	if (colors)
	    attrset(COLOR_PAIR(5) | A_BOLD);
	else
	    attron(A_BOLD);
	move(23, 3 + seite * 40);
	printw("%d Byte in %d Files selected ", size, sel_anz);
	refresh();
	if (colors)
	    attrset(COLOR_PAIR(4));
	else
	    attroff(A_BOLD);
    }
    else {
	move(23, 3 + seite * 40);
	printw("                                      ");
	refresh();
    }
}
