
/***************************************************************************

                  D I R E C T O R Y - C O M M A N D E R

		
		  Holger Staeudte
		    IH Mittweida  1991
		
		  Rene Roellig  1993
		    Hochschule fuer Technik und Wirtschaft
		    Mittweida

***************************************************************************/


#include "dc.h"

extern WINDOW *wptr[8][2];
extern int sel_anz, count[2], line[2], seite;
extern char selmask[DIRSIZE];
extern int fanz1, fanz2;
extern di *buffer1, *buffer2;
extern path1[PATHLEN], path2[PATHLEN];

/*************************** Funktion itoa() ******************************/

char *itoa(int z, int base)
  /* fuer Basis 2..10 */
{
    char zz, zzstr[6];
    static char zei[6] = "\0\0\0\0\0";

    zei[0] = 0;
    zei[1] = 0;
    if (z < 0) {
	z = -z;
	zei[0] = '-';
    }
    while (z > 0) {
	zz = (z % base) | 0x30;
	zzstr[0] = zz;
	zzstr[1] = 0;
	z = z / base;
	strcat(zzstr, zei);
	strcpy(zei, zzstr);
    }
    return (&zei[0]);
}


/*************************** Funktion rebuild_scr() ***********************/

void rebuild_scr()
{
    clear();
    refresh();
    maske1(wptr[1][0], W_REP);
    maske2(wptr[2][0], W_REP, 1);
    maske2(wptr[2][1], W_REP, 41);
    maske3(wptr[3][0], W_REP, 0);
    wnoutrefresh(wptr[1][0]);
    wnoutrefresh(wptr[2][0]);
    wnoutrefresh(wptr[2][1]);
    wnoutrefresh(wptr[3][0]);
    pathprint(path1, path2);
    if (seite)
	print_sel(seite, buffer2, fanz2);
    else
	print_sel(seite, buffer1, fanz1);
    doupdate();
}

/*************************** Funktion func_ein() ***************************/

int  func_ein(win, anf, x, length, mask, sel)
  int  anf, x, length, sel;
  char mask[];
  WINDOW *win;

{
    char *befehl, *befehlfirst, *befehllast, hp[10], *bftemp;
    int  i = 0, y, bfmax = 0;
    unsigned int c = 0;

    befehl = &mask[0];
    befehlfirst = befehl;
    wmove(win, x, anf);
    wrefresh(win);
    y = anf;
    while ((c = getch()) != 10) {
	bfmax = strlen(mask) + anf;
	befehllast = befehlfirst;
	while (*befehllast++ != '\0');
	switch (c) {
	case KEY_BACKSPACE:
	    if (y > anf) {
		*befehl--;
		y--;
		bftemp = befehl;
		while (*bftemp != '\0') {
		    *(bftemp) = *(bftemp + 1);
		    *bftemp++;
		}
		*(bftemp) = '\0';
		wmove(win, x, anf);
		wprintw(win, "%s ", befehlfirst);
	    }
	    wmove(win, x, y);
	    wrefresh(win);
	    break;

	case KEY_DC:
	    if (*befehl != '\0') {	/* Delete */
		bftemp = befehl;
		while (*bftemp != '\0') {
		    *bftemp = *(bftemp + 1);
		    *bftemp++;
		}
		*(bftemp - 1) = '\0';
		wprintw(win, "%s  ", befehl);
	    }
	    wmove(win, x, y);
	    wrefresh(win);
	    break;

	case KEY_F(12):
	    return;

	case KEY_HOME:
	    wmove(win, x, anf);
	    befehl = befehlfirst;
	    y = anf;
	    wrefresh(win);
	    break;

	case KEY_END:
	    wmove(win, x, bfmax);
	    befehl = befehllast - 1;
	    y = bfmax;
	    wrefresh(win);
	    break;

	case KEY_UP:		/* Up and Down Arrow */
	case KEY_DOWN:
	    break;
	case KEY_RIGHT:
	    if (y < bfmax) {
		y++;
		*befehl++;
	    }
	    wmove(win, x, y);
	    wrefresh(win);
	    break;
	case KEY_LEFT:
	    if (y > anf) {
		y--;
		*befehl--;
	    }
	    wmove(win, x, y);
	    wrefresh(win);
	    break;

	case KEY_F(1):
	    help(sel);
	    return;
	default:
	    waddch(win, c);
	    if (bfmax < anf + length && y < anf + length) {
		if (c > 31 && c < 127) {
		    if (befehl < befehllast) {
			bftemp = befehllast;
			while (bftemp >= befehl) {
			    *(bftemp + 1) = *bftemp;
			    *bftemp--;
			}
			wmove(win, x, y);
			wprintw(win, "%s", befehl);
			wrefresh(win);
		    }
		    *befehl++ = c;
		    wmove(win, x, y);
		    wprintw(win, "%c", c);
		    wrefresh(win);
		    y++;
		}
	    }
	    break;
	}
    }
    return (c);
}

/*************************** Funktion Select() *****************************/

void Select(seite, buffer, mode, maxfiles)
  int  seite, mode;
  di  *buffer;
  int  maxfiles;
{
    char befehl[80];
    int  code;
    FILE *dirfile;
    dlist *wurzel, *akt;
    int  fnr;

    wptr[4][0] = maske4(NULL, W_NEW);
    sel_anz = 0;
    if (mode) {
	wmove(wptr[4][0], 1, 7);
	wprintw(wptr[4][0], "Select");
    }
    else {
	wmove(wptr[4][0], 1, 6);
	wprintw(wptr[4][0], "Unselect");
    }
    wattron(wptr[4][0], A_REVERSE);
    wmove(wptr[4][0], 3, 2);
    wprintw(wptr[4][0], ">               <");
    wmove(wptr[4][0], 3, 3);
    wprintw(wptr[4][0], "%s", selmask);
    wrefresh(wptr[4][0]);
    code = func_ein(wptr[4][0], 3, 3, 14, selmask, 0);
    wattroff(wptr[4][0], A_REVERSE);
    if (code == 10) {
	strcpy(befehl, "ls -1 >.temp ");
	strcat(befehl, selmask);
	system(befehl);
	if ((dirfile = fopen(".temp", "r")) != NULL) {
	    wurzel = malloc(sizeof(dlist));
	    akt = wurzel;
	    akt->next = NULL;
	    while (fgets(akt->name, DIRSIZE, dirfile) != NULL) {
		akt->next = malloc(sizeof(dlist));
		akt = akt->next;
		akt->next = NULL;
	    }
	    fclose(dirfile);
	    system("rm .temp");
	    akt = wurzel;
	    while (akt->next != NULL) {
		akt->name[strlen(akt->name) - 1] = 0;
		fnr = 0;
		while (fnr < maxfiles) {
		    if (strcmp((buffer + fnr)->name, akt->name) == 0)
			if (!(buffer + fnr)->mode)
			    (buffer + fnr)->set = mode;
		    fnr++;
		}
		wurzel = akt;
		akt = akt->next;
		free(wurzel);
	    }
	}
    }
    if (code != 4)
	rebuild_scr();
    dirprint(seite, buffer, maxfiles);
    balk(seite, line[seite], count[seite], 1, buffer, maxfiles);
    print_sel(seite, buffer, maxfiles);
    wptr[4][0] = maske4(wptr[4][0], W_DEL);
}

/*************************** Funktion Config() *****************************/

void Config()
{
    FILE *inp;


    chdir(getenv("HOME"));
    if ((inp = fopen(".dc_func.sh", "r")) == NULL) {
	printf("\n\n\nShellscript \".dc_func.sh\" for configuring function keys F2..F4 not found !\n");
	printf("A default shellscript (configured for LINUX) is written in your HOME directory.\n");
	printf("You can change the following functions with this script :\n\n");
	printf("         F2 : Status - any commands for getting the status of your system ...\n\n");
	printf("         F3 : View - your pager (like 'more' or 'less')\n\n");
	printf("         F4 : Edit - your editor ('vi' ...)\n\n\n");
	printf("< Press any key >\n");
	getchar();
	inp = fopen(".dc_func.sh", "w");
	fprintf(inp, "             EDITOR=vi\n");
	fprintf(inp, "             PAGER=more\n");
	fprintf(inp, "\n");
	fprintf(inp, "\n");
	fprintf(inp, "\n");
	fprintf(inp, "                 if [ \"$1\" = \"edit\" ]; then\n");
	fprintf(inp, "                   $EDITOR $2;\n");
	fprintf(inp, "                 fi\n");
	fprintf(inp, "                 if [ \"$1\" = \"view\" ]; then\n");
	fprintf(inp, "                   $PAGER $2;\n");
	fprintf(inp, "                 fi\n");
	fprintf(inp, "\n");
	fprintf(inp, "                 if [ \"$1\" = \"status\" ]; then\n");
	fprintf(inp, "                   free 2>&1 >> tempfile \n");
	fprintf(inp, "                   echo 2>&1 >> tempfile \n");
	fprintf(inp, "                   echo 2>&1 >> tempfile \n");
	fprintf(inp, "                   df   2>&1 >> tempfile \n");
	fprintf(inp, "                   echo 2>&1 >> tempfile \n");
	fprintf(inp, "                   echo 2>&1 >> tempfile \n");
	fprintf(inp, "                   ps   2>&1 >> tempfile \n");
	fprintf(inp, "                   echo 2>&1 >> tempfile \n");
	fprintf(inp, "                   more tempfile\n");
	fprintf(inp, "                   rm   tempfile\n");
	fprintf(inp, "                 fi \n");
	fclose(inp);
	system("chmod 700 .dc_func.sh");
    }
    else
	fclose(inp);
}
