
/***************************************************************************

                  D I R E C T O R Y - C O M M A N D E R

		
		  Holger Staeudte
		    IH Mittweida  1991
		
		  Rene Roellig  1993
		    Hochschule fuer Technik und Wirtschaft
		    Mittweida

***************************************************************************/

#include "dc.h"

extern WINDOW *wptr[8][2];

extern int colors;

/****************************** Funktion help() ***************************/

void help_menu()
{
    unsigned int c = 0, sel = 0;
    char befehl[15];

    if (colors)
	wattrset(wptr[3][0], COLOR_PAIR(4) | A_REVERSE);
    else
	wattron(wptr[3][0], A_REVERSE);
    maske3(wptr[3][0], W_REP, 1);
    if (colors)
	wattrset(wptr[3][0], COLOR_PAIR(1));
    else
	wattroff(wptr[3][0], A_REVERSE);
    helpprint(0);
    while (c = getch()) {
	if (colors)
	    wattrset(wptr[3][0], COLOR_PAIR(4) | A_REVERSE);
	else
	    wattron(wptr[3][0], A_REVERSE);
	helpprint(sel);
	if (colors)
	    wattrset(wptr[3][0], COLOR_PAIR(1));
	else
	    wattroff(wptr[3][0], A_REVERSE);
	switch (c) {
	case 10:
	    wptr[6][0] = maske6(NULL, W_NEW);	/* ENTER */
	    help_text(wptr[6][0], sel);
	    wrefresh(wptr[6][0]);
	    while (getch() != KEY_F(12));
	    wptr[6][0] = maske6(wptr[6][0], W_DEL);
	    rebuild_scr();
	    if (!colors)
		wattron(wptr[3][0], A_REVERSE);
	    maske3(wptr[3][0], W_REP, 1);
	    if (!colors)
		wattroff(wptr[3][0], A_REVERSE);
	    break;

	case KEY_RIGHT:
	    if (sel < 11)
		sel++;		/* --> */
	    else
		sel = 0;
	    break;
	case KEY_LEFT:
	    if (sel)
		sel--;		/* <-- */
	    else
		sel = 11;
	    break;
	case KEY_F(12):	/* F 12 */
	    maske3(wptr[3][0], W_REP, 0);
	    wrefresh(wptr[3][0]);
	    return;
	}
	if (colors)
	    wattrset(wptr[3][0], COLOR_PAIR(1));
	else
	    wattroff(wptr[3][0], A_REVERSE);
	helpprint(sel);
    }
}

void help(sel)
  int  sel;
{
    wptr[6][0] = maske6(NULL, W_NEW);	/* ENTER */
    help_text(wptr[6][0], sel);
    wrefresh(wptr[6][0]);
    while (getch() != KEY_F(12));
    wptr[6][0] = maske6(wptr[6][0], W_DEL);
    rebuild_scr();
}


/***************************** Funktion helpprint() ***********************/

void helpprint(sel)
  int  sel;
{
    switch (sel) {
    case 0:
	mvwaddstr(wptr[3][0], 0, 1, "Help");
	break;
    case 1:
	mvwaddstr(wptr[3][0], 0, 7, "State");
	break;
    case 2:
	mvwaddstr(wptr[3][0], 0, 14, "View");
	break;
    case 3:
	mvwaddstr(wptr[3][0], 0, 20, "Edit");
	break;
    case 4:
	mvwaddstr(wptr[3][0], 0, 26, "Copy");
	break;
    case 5:
	mvwaddstr(wptr[3][0], 0, 32, "Move");
	break;
    case 6:
	mvwaddstr(wptr[3][0], 0, 38, "MkDir");
	break;
    case 7:
	mvwaddstr(wptr[3][0], 0, 45, "Erase");
	break;
    case 8:
	mvwaddstr(wptr[3][0], 0, 52, "Chmod");
	break;
    case 9:
	mvwaddstr(wptr[3][0], 0, 60, "Find");
	break;
    case 10:
	mvwaddstr(wptr[3][0], 0, 67, "Comp");
	break;
    case 11:
	mvwaddstr(wptr[3][0], 0, 75, "Quit");
	break;
    }
    move(0, 0);
    wrefresh(wptr[3][0]);
}


/***************************** Funktion help() ****************************/

void help_text(win, hnum)
  int  hnum;
  WINDOW *win;

{
    switch (hnum) {
    case 0:
	wmove(win, 2, 2);
	wprintw(win, "G E N E R A L   I N F O R M A T I O N :");
	wmove(win, 3, 2);
	wprintw(win, "The Directory-Commander you can control with the follow-");
	wmove(win, 4, 2);
	wprintw(win, "ing keys :");
	wmove(win, 5, 2);
	wprintw(win, "   Arrow up/down    :    to move highlighted bar up/down");
	wmove(win, 6, 2);
	wprintw(win, "   Arrow left/right : to move the cursor on the cmd line");
	wmove(win, 7, 2);
	wprintw(win, "   TAB              :  to change between the two windows");
	wmove(win, 8, 2);
	wprintw(win, "   INS        :     to (un)select the file below the bar");
	wmove(win, 9, 2);
	wprintw(win, "   SHIFT F3   :   to multiple select files with filemask");
	wmove(win, 10, 2);
	wprintw(win, "   SHIFT F4   : to multiple unselect files with filemask");
	wmove(win, 11, 2);
	wprintw(win, "   Page up/down     :     to scroll bar 10 files up/down");
	wmove(win, 12, 2);
	wprintw(win, "   F1..F12  : to execute functions of the lower menu-bar");
	wmove(win, 14, 2);
	wprintw(win, "Additional help about the function keys F2..F12 you will");
	wmove(win, 15, 2);
	wprintw(win, "get by selecting one of the fields of the bottom-line");
	wmove(win, 16, 2);
	wprintw(win, "with the horizontal cursor keys.");
	break;

    case 1:
	wmove(win, 3, 2);
	wprintw(win, "S T A T U S:");
	wmove(win, 5, 2);
	wprintw(win, "The 'Status'-function will inform you about the state");
	wmove(win, 6, 2);
	wprintw(win, "of the operating system.");
	wmove(win, 7, 2);
	wprintw(win, "That you can run 'DIRECTORY COMMANDER' on different");
	wmove(win, 8, 2);
	wprintw(win, "platforms you are able to configure this function by");
	wmove(win, 9, 2);
	wprintw(win, "yourself. When this program is started the first time,");
	wmove(win, 10, 2);
	wprintw(win, "a file named '.dc_func.sh' is created in your HOME-dir.");
	wmove(win, 11, 2);
	wprintw(win, "It is a simple shell-script. Please change it, that you");
	wmove(win, 12, 2);
	wprintw(win, "will get the information **you** want to see there !");
	break;

    case 2:
	wmove(win, 3, 2);
	wprintw(win, "V I E W:");
	wmove(win, 5, 2);
	wprintw(win, "With the 'View'-function you can watch the content of");
	wmove(win, 6, 2);
	wprintw(win, "the (ASCII)file wich is selected by the highlighted bar.");
	wmove(win, 7, 2);
	wprintw(win, "To realize this function the shell-script 'dc_func.sh'");
	wmove(win, 8, 2);
	wprintw(win, "in your HOME-directory is launched with the parameter");
	wmove(win, 9, 2);
	wprintw(win, "'view'. By changing the PAGER entry in this shell-script");
	wmove(win, 10, 2);
	wprintw(win, "it is possible to use any other pager-program.");
	wmove(win, 11, 2);
	wprintw(win, "By default there is used the pager 'more'.");
	break;

    case 3:
	wmove(win, 3, 2);
	wprintw(win, "E D I T:");
	wmove(win, 4, 2);
	wprintw(win, "The usage of the 'Edit'-function allows to edit the");
	wmove(win, 5, 2);
	wprintw(win, "file selected by the bar.");
	wmove(win, 6, 2);
	wprintw(win, "To realize this function the shell-script 'dc_func.sh'");
	wmove(win, 7, 2);
	wprintw(win, "in your HOME-directory is launched with the parameter");
	wmove(win, 8, 2);
	wprintw(win, "'edit'. By changing the EDITOR entry in this script-file");
	wmove(win, 9, 2);
	wprintw(win, "it is possible to use any other editor-program.");
	wmove(win, 10, 2);
	wprintw(win, "By default there is used the editor 'vi'.");
	break;


    case 4:
	wmove(win, 2, 2);
	wprintw(win, "C O P Y:");
	wmove(win, 4, 2);
	wprintw(win, "The 'Copy'-function allows you to copy files from the");
	wmove(win, 5, 2);
	wprintw(win, "current directory to a destination-directory.");
	wmove(win, 6, 2);
	wprintw(win, "The current directory is represented by the window");
	wmove(win, 7, 2);
	wprintw(win, "which contains the sel. bar and the dest.-directory");
	wmove(win, 8, 2);
	wprintw(win, "accordingly is the other window. All selected files are");
	wmove(win, 9, 2);
	wprintw(win, "copied. Otherwise the file below the bar is copied.");
	wmove(win, 10, 2);
	wprintw(win, "To copy directories you have to specify a new dest.-");
	wmove(win, 11, 2);
	wprintw(win, "directory in the input-box.");
	wmove(win, 12, 2);
	wprintw(win, "If there exist the same files in both directories you");
	wmove(win, 13, 2);
	wprintw(win, "will receive a warning. There are three possibilities");
	wmove(win, 14, 2);
	wprintw(win, "to handle that : you can overwrite this file by typing");
	wmove(win, 15, 2);
	wprintw(win, "<CR>, you can keep the file (<S>kip) or you can");
	wmove(win, 16, 2);
	wprintw(win, "suppress further warnings (<A>ll).");
	wmove(win, 17, 2);
	break;

    case 5:
	wmove(win, 3, 2);
	wprintw(win, "M O V E:");
	wmove(win, 5, 2);
	wprintw(win, "The 'Move'-function allows you to move files from the");
	wmove(win, 6, 2);
	wprintw(win, "current directory to a destination-directory.");
	wmove(win, 7, 2);
	wprintw(win, "The current directory is represented by the window");
	wmove(win, 8, 2);
	wprintw(win, "which contains the sel. bar and the dest.-directory");
	wmove(win, 9, 2);
	wprintw(win, "accordingly is the other window. All selected files are");
	wmove(win, 10, 2);
	wprintw(win, "moved. Otherwise the file below the bar is moved.");
	wmove(win, 11, 2);
	wprintw(win, "If there exist the same files in both directories you");
	wmove(win, 12, 2);
	wprintw(win, "will receive a warning. There are three possibilities");
	wmove(win, 13, 2);
	wprintw(win, "to handle that : you can overwrite this file by typing");
	wmove(win, 14, 2);
	wprintw(win, "<CR>, you can keep the file (<S>kip) or you can");
	wmove(win, 15, 2);
	wprintw(win, "suppress further warnings (<A>ll).");
	wmove(win, 16, 2);
	break;

    case 6:
	wmove(win, 3, 2);
	wprintw(win, "M A K E  D I R E C T O R Y:");
	wmove(win, 5, 2);
	wprintw(win, "The function 'MkDir' creates a new directory which");
	wmove(win, 6, 2);
	wprintw(win, "is inserted as a subdirectory into the current dir-");
	wmove(win, 7, 2);
	wprintw(win, "ectory. The name of it is equal to the string which");
	wmove(win, 8, 2);
	wprintw(win, "you have to specify in the input box.");
	break;

    case 7:
	wmove(win, 3, 2);
	wprintw(win, "E R A S E:");
	wmove(win, 5, 2);
	wprintw(win, "The 'Erase'-function is useful to delete files you");
	wmove(win, 6, 2);
	wprintw(win, "do not need any longer. Either all selected files are");
	wmove(win, 7, 2);
	wprintw(win, "deleted or the one below the highlighted bar.");
	wmove(win, 8, 2);
	wprintw(win, "Further it is possible to remove a whole directory");
	wmove(win, 9, 2);
	wprintw(win, "including all the files in it. In this case an add-");
	wmove(win, 10, 2);
	wprintw(win, "itional warning appears.");
	wmove(win, 12, 2);
	wprintw(win, "Lock out before removing directories !!!");
	break;

    case 8:
	wmove(win, 3, 2);
	wprintw(win, "C H A N G E  M O D E:");
	wmove(win, 5, 2);
	wprintw(win, "To change the permissions of files the 'ChMod'-");
	wmove(win, 6, 2);
	wprintw(win, "function is a very useful tool. In the input-window");
	wmove(win, 7, 2);
	wprintw(win, "the several permissions for the groups <usr>, <group>");
	wmove(win, 8, 2);
	wprintw(win, "and <other> with their settings for read (r), write");
	wmove(win, 9, 2);
	wprintw(win, "(w) and execute (x) are displayed. The highlighted");
	wmove(win, 10, 2);
	wprintw(win, "elements are considered to be active. By using the");
	wmove(win, 11, 2);
	wprintw(win, "<INS> key you can change these settings.");
	wmove(win, 12, 2);
	wprintw(win, "With the cursor-keys (left/right) it is possible to");
	wmove(win, 13, 2);
	wprintw(win, "change the currently selected field.");
	break;

    case 9:
	wmove(win, 3, 2);
	wprintw(win, "F I N D  F I L E:");
	wmove(win, 5, 2);
	wprintw(win, "With the 'Find'-function you can search for files");
	wmove(win, 6, 2);
	wprintw(win, "in the filesystem. The search of the specified file");
	wmove(win, 7, 2);
	wprintw(win, "is caused downward from the CURRENT directory.");
	wmove(win, 8, 2);
	wprintw(win, "To find files the 'find'-command is used. Please ");
	wmove(win, 9, 2);
	wprintw(win, "do a 'man find' to watch for the syntax of the");
	wmove(win, 10, 2);
	wprintw(win, "expression to find !");
	break;

    case 10:

	wmove(win, 3, 2);
	wprintw(win, "C O M P A R E  D I R E C T O R Y:");
	wmove(win, 5, 2);
	wprintw(win, "The function 'Comp' compares the directories which are");
	wmove(win, 6, 2);
	wprintw(win, "currently displayed in both windows.");
	wmove(win, 7, 2);
	wprintw(win, "The files which exist only in the current window are");
	wmove(win, 8, 2);
	wprintw(win, "selected.");
	break;

    case 11:
	wmove(win, 3, 2);
	wprintw(win, "Q U I T:");
	wmove(win, 4, 2);
	wprintw(win, "The function 'Quit' terminates the current");
	wmove(win, 5, 2);
	wprintw(win, "function (like copy, move, mkdir ...). If there is no");
	wmove(win, 6, 2);
	wprintw(win, "function on execution you can finish the program");
	wmove(win, 7, 2);
	wprintw(win, "'DIRECTORY COMMANDER'.");
	break;

    }

}
