
/***************************************************************************

                  D I R E C T O R Y - C O M M A N D E R

		
		  Holger Staeudte
		    IH Mittweida  1991
		
		  Rene Roellig  1993
		    Hochschule fuer Technik und Wirtschaft
		    Mittweida

***************************************************************************/


#include <malloc.h>
#include <ncurses.h>
#include <signal.h>
#include <termio.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <dirent.h>
#include <time.h>
#include <sys/stat.h>

#define W_NEW 1
#define W_DEL 2
#define W_REP 3

#define PATHLEN 128 
#define DIRSIZE 256


typedef struct directory {
    char name[DIRSIZE];
    char time[30];
/*	unsigned long datsize; */
    off_t datsize;
    int  mode;
    int  min;
    int  hour;
    int  day;
    int  mon;
    int  set;
    int  own;
}

di;

typedef struct dir_list {
    char name[DIRSIZE];
    struct dir_list *next;
} dlist;


WINDOW *maske1(WINDOW *, int);       /* Maske fuer Kommandozeile */
WINDOW *maske2(WINDOW *, int, int);  /* Maske fuer Datei - Fenster - Ausgabe */

WINDOW *maske3(WINDOW *, int, int);  /* Maske fuer Funktionstasten */
WINDOW *maske4(WINDOW *, int);       /* Maske fuer Eingabe - Fenster klein */
WINDOW *maske5(WINDOW *, int);       /* Maske fuer Eingabe - Fenster gross */
WINDOW *maske6(WINDOW *, int);       /* Maske fuer Hilfe - Fenster */

/* sucht nach Shellscript bzw. erstellt es */
void Config();         

/* Find File */
void fgt();              

/* Auswaehlen aus einem Verzeichnis */
void Select();          

/* Eingabe innerhalb von Funktionen */
int  func_ein();        

/* Ausgabe von Status - Informationen */
void status();          

/* Aufruf von Editor + Datei */
void edit();             

/* Kopieren und Bewegen von Dateien */
void copy();            

/* Erstellen eines Verzeichnisses */
void mkdirec();       

/* Entfernen von Dateien und Verzeichnissen */
void delete();          

/* Zugriffs - Bits setzen */
void setmode();       

/* Vergleich zweier Verzeichnisse */
void comp();          

/* Konvertierung */
char *itoa();          

/* Ausgeben einer Datei auf dem Bildschirm */
void view(int);        

/* Bildschirm wiederaufbauen */
void rebuild_scr();    


/* Hauptschleife */
void main_loop();      

/* Einlesen eines Verzeichnisses */
di  *get_direc();      

/* Sortieren des Verzeichnisses */
int  sort();           

/* Ausgeben des Verzeichnisses */
void dirprint();       

/* Ausgeben des Fenster - Balkens */
void balk();           

/* Bewegen des Balkens */
void balk_move();      

/* Wechsel des aktuellen Fensters */
void balk_left();      

/* Wechsel des aktuellen Fensters */
void balk_right();     

/* Laenge eines Pfadnamens */
int  pathlength();     

/* Rollen des Fensters nach oben */
void scr_up();         

/* Rollen des Fensters nach unten */
void scr_down();       

/* Rollen des Fensters um 1 Seite */
void page_up();        
void page_down();

/* Markieren von Dateien */
void mark();           

/* Initialisierung des Programmes */
void win_init();       

/* Programm - Ende */
void quit();           

/* Hilfe - Steuerung */
void help();
void help_menu();      
void helpprint();
void help_text();

/* Ausgeben der Pfadnamen */
void pathprint();      
void print_str(char *);
void print_sel();
