
/***************************************************************************

                  D I R E C T O R Y - C O M M A N D E R

		
		  Holger Staeudte
		    IH Mittweida  1991
		
		  Rene Roellig  1993
		    Hochschule fuer Technik und Wirtschaft
		    Mittweida

                           -  Main Modul  -

***************************************************************************/

#include "dc.h"


						/* Zeiger auf DIR - Struktur */
DIR *zz;			
di  *buffer1 = NULL, *buffer2 = NULL;

						/* Zaehler fuer Fenster   */
int  seite = 0, 
     count[2] =	{0, 0}, 
     line[2] ={0, 0};

int  fa, sel_anz = 0, menu1 = 0, tmset = 0;

						/* File-Anzahl im Fenster */
int  fanz1 = 0,			
     fanz2 = 0;

						/* Puffer fuer Pfade         */
char bf[PATHLEN],		
     pathl[PATHLEN], path1[PATHLEN], path2[PATHLEN];

						/* Puffer fuer Bezeichner    */
char datei[DIRSIZE],		
     dir[PATHLEN], selmask[DIRSIZE], *fm[7];

						/* Directory - Struktur */

struct dirent *direc;		

						/* File      - Struktur */
struct stat stbuf;	

						/* Time      - Struktur */
struct tm *tmptr;		

						/* Puffer fuer interpretierte Codes */
char codebuf[1024];		

						/*Pointerfeld fuer Windowstrukturen */
WINDOW *wptr[8][2];

						/* Flag fuer Farbdarstellung */
int  mono = 0, colors = 0;	

/*************************** Main - Funktion ******************************/

void main(int argc, char *argv[])
{

    if (argc > 1)
	if (!strcmp(argv[1], "-mono"))
	    mono = 1;

    Config();
    savetty();
    initscr();
    cbreak();
    noecho();
    keypad(stdscr, TRUE);
    if (has_colors) {
	start_color();
	init_pair(1, COLOR_WHITE, COLOR_BLUE);
	init_pair(2, COLOR_CYAN, COLOR_BLACK);
	init_pair(3, COLOR_YELLOW, COLOR_BLUE);
	init_pair(4, COLOR_WHITE, COLOR_BLACK);
	init_pair(5, COLOR_YELLOW, COLOR_BLACK);
	init_pair(6, COLOR_WHITE, COLOR_CYAN);
	init_pair(7, COLOR_YELLOW, COLOR_WHITE);
	init_pair(8, COLOR_MAGENTA, COLOR_WHITE);
	init_pair(9, COLOR_WHITE, COLOR_RED);
	if (!mono)
	    colors = 1;
    }
    win_init();
    main_loop();
    clear();
    refresh();
    endwin();
    exit(0);
}


/*************************** Funktion win_init() **************************/

void win_init()
{
    refresh();
    wptr[5][0] = maske5(NULL, W_NEW);
    mvwaddstr(wptr[5][0], 1, 9, "D I R E C T O R Y     C O M M A N D E R");
    mvwaddstr(wptr[5][0], 3, 8, "Holger Staeudte 1991,   Rene Roellig 1993");
    wrefresh(wptr[5][0]);
    wgetch(wptr[5][0]);
    clear();
    refresh();
    wptr[5][0] = maske5(wptr[5][0], W_DEL);
    refresh();

    wptr[1][0] = maske1(NULL, W_NEW);
    wnoutrefresh(wptr[1][0]);
    wptr[2][0] = maske2(NULL, W_NEW, 1);
    wnoutrefresh(wptr[2][0]);
    wptr[2][1] = maske2(NULL, W_NEW, 41);
    wnoutrefresh(wptr[2][1]);
    wptr[3][0] = maske3(NULL, W_NEW, 0);
    wnoutrefresh(wptr[3][0]);
    doupdate();
}

/************************** Funktion main_loop() **************************/

void main_loop()
{
    char *befehl, *befehlfirst, *befehllast, *bftemp;
    char ende[5], temppath[PATHLEN], *pathptr;
    unsigned int c = 0, i = 0, x = 0, y = 0;
    int  state, bfmax = 0, pathmax = 0, sys = 1;
    char c1c;

    getcwd(pathl, 50);
    strcpy(path2, pathl);
    strcpy(ende, "quit");
    strcpy(selmask, "*");
    while (strcmp(ende, bf) != '\0') {	/* Hauptschleife */

	while (i < PATHLEN) {
	    bf[i] = pathl[i] = 0;
	    i++;
	}
	i = 0;

	befehl = &bf[0];
	pathptr = &bf[0];
	befehlfirst = befehl;

	getcwd(pathl, PATHLEN);
	y = 0;
	if (sys) {
	    if (seite) {
		strcpy(path2, pathl);
		balk_left(0, 1);
		balk_right(1, 1);
	    }
	    else {
		strcpy(path1, pathl);
		balk_right(0, 1);
		balk_left(1, 1);
	    }
	}
	else {
	    if (seite) {
		strcpy(path2, pathl);
		balk_right(1, 1);
		wrefresh(wptr[2][seite]);
	    }
	    else {
		strcpy(path1, pathl);
		balk_left(1, 1);
		wrefresh(wptr[2][seite]);
	    }
	}
	sys = 0;
	pathmax = y = pathlength(pathl);

	wmove(wptr[1][0], 1, y);
	wclrtoeol(wptr[1][0]);
	pathprint(path1, path2);
	if (seite)
	    print_sel(seite, buffer2, fanz2);
	else
	    print_sel(seite, buffer1, fanz1);
	wmove(wptr[1][0], 1, y);
	wrefresh(wptr[2][seite]);
	wrefresh(wptr[1][0]);

	while ((c = getch()) != 10) {	/* Befehls - Schleife  */
	    bfmax = strlen(bf) + pathmax;
	    befehllast = befehlfirst + bfmax - pathmax;

	    switch (c) {
	    case KEY_BACKSPACE:/* Backspace */
		if (y > pathmax) {
		    *befehl--;
		    y--;
		    bftemp = befehl;
		    while (*bftemp != '\0') {
			*(bftemp) = *(bftemp + 1);
			*bftemp++;
		    }
		    *(bftemp) = '\0';
		    wmove(wptr[1][0], 1, pathmax);
		    wprintw(wptr[1][0], "%s ", befehlfirst);
		}
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case 9:		/* Fenster wechseln */
		if (seite)
		    balk_left(1, 0);
		else
		    balk_right(1, 0);
		y = pathmax = pathlength(pathl);
		pathprint(path1, path2);
		wmove(wptr[1][0], 1, y);
		wclrtoeol(wptr[1][0]);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_HOME:
		wmove(wptr[1][0], 1, pathmax);
		wrefresh(wptr[1][0]);
		befehl = befehlfirst;
		y = pathmax;;
		break;

	    case KEY_F(1):
		help_menu();
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_F(2):
		status();
		wmove(wptr[1][0], 1, y);
		break;
	    case KEY_F(3):
		view(seite);
		wmove(wptr[1][0], 1, y);
		sys = 1;
		break;
	    case KEY_F(4):
		edit(seite);
		wmove(wptr[1][0], 1, y);
		break;
	    case KEY_F(5):
		if (seite)
		    copy(seite, path1, buffer2, 4, fanz2);
		else
		    copy(seite, path2, buffer1, 4, fanz1);
		wmove(wptr[1][0], 1, y);
		break;

	    case KEY_F(6):
		if (seite)
		    copy(seite, path1, buffer2, 5, fanz2);
		else
		    copy(seite, path2, buffer1, 5, fanz1);
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_F(7):
		mkdirec(seite);
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_F(8):
		if (seite)
		    delete(seite, buffer2, fanz2);
		else
		    delete(seite, buffer1, fanz1);
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_F(9):
		if (seite)
		    setmode(buffer2);
		else
		    setmode(buffer1);
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_F(10):
		fgt();
		wmove(wptr[1][0], 1, y);
		break;

	    case KEY_F(11):
		if (seite)
		    comp(buffer2, buffer1, fanz2, fanz1);
		else
		    comp(buffer1, buffer2, fanz1, fanz2);
		if (seite)
		    print_sel(seite, buffer2, fanz2);
		else
		    print_sel(seite, buffer1, fanz1);
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_F(12):
		quit();
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_DC:	/* Del */
		if (*befehl != '\0') {
		    bftemp = befehl;
		    while (*bftemp != '\0') {
			*bftemp = *(bftemp + 1);
			*bftemp++;
		    }
		    *(bftemp - 1) = '\0';
		    wmove(wptr[1][0], 1, pathmax);
		    wprintw(wptr[1][0], "%s  \n", befehlfirst);
		}
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_PPAGE:	/* PgUp */
		page_up(seite);
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_NPAGE:	/* PgDn */
		page_down(seite);
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_UP:	/* Up Arrow */
		if (line[seite] > 0)
		    balk_move(seite, 1);
		else
		    scr_down(seite);
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_DOWN:	/* Down Arrow */
		if (line[seite] < 11)
		    balk_move(seite, 0);
		else
		    scr_up(seite);
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_RIGHT:	/* Right Arrow */
		if (y < bfmax) {
		    y++;
		    *befehl++;
		}
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;
	    case KEY_LEFT:	/* Left Arrow */
		if (y > pathmax) {
		    y--;
		    *befehl--;
		}
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_IC:	/* Insert */
		if (seite)
		    mark(1);
		else
		    mark(0);
		if (seite)
		    print_sel(seite, buffer2, fanz2);
		else
		    print_sel(seite, buffer1, fanz1);
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_END:
		wmove(wptr[1][0], 1, bfmax);
		wrefresh(wptr[1][0]);
		befehl = befehllast;
		y = bfmax;
		break;

	    case KEY_F(13):
		if (seite)
		    Select(1, buffer2, 1, fanz2);
		else
		    Select(0, buffer1, 1, fanz1);
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    case KEY_F(14):
		if (seite)
		    Select(seite, buffer2, 0, fanz2);
		else
		    Select(seite, buffer1, 0, fanz1);
		wmove(wptr[1][0], 1, y);
		wrefresh(wptr[1][0]);
		break;

	    default:
		waddch(wptr[1][0], c);
		if (bfmax < 78 && y < 78) {
		    if (c > 31 && c < 127) {
			if (befehl < befehllast) {
			    bftemp = befehllast;
			    while (bftemp >= befehl) {
				*(bftemp + 1) = *bftemp;
				*bftemp--;
			    }
			    wmove(wptr[1][0], 1, y);
			    wprintw(wptr[1][0], "%s", befehl);
			    wrefresh(wptr[1][0]);
			}
			*befehl++ = c;
			wmove(wptr[1][0], 1, y);
			wprintw(wptr[1][0], "%c", c);
			wrefresh(wptr[1][0]);
			y++;
		    }
		}
		break;
	    }
	}

	if (bf[0] == '\0') {
	    if (seite) {
		strcpy(bf, (buffer2 + count[seite])->name);
		if ((buffer2 + count[seite])->mode) {
		    strcpy(bf, "cd ");
		    strcat(bf, (buffer2 + count[seite])->name);
		}
	    }
	    else {
		strcpy(bf, (buffer1 + count[seite])->name);
		if ((buffer1 + count[seite])->mode) {
		    strcpy(bf, "cd ");
		    strcat(bf, (buffer1 + count[seite])->name);
		}
	    }
	}
	if (bf[0] == 'c' && bf[1] == 'd') {
	    strcpy(temppath, pathptr + 3);
	    chdir(temppath);
	    line[seite] = count[seite] = 0;
	}
	else if (strcmp(ende, bf) != '\0') {
	    clear();
	    move(0, 0);
	    refresh();
	    resetty();
	    system(bf);
	    fixterm();
	    move(24, 65);
	    printw(">  Press <CR>  <");
	    refresh();
	    getch();
	    rebuild_scr();
	    sys = 1;
	}
    }
}
