;*---------------------------------------------------------------------*/
;*    Copyright (c) 1993 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.2/Llib/strings.scm ...      */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jul  4 16:03:22 1992                          */
;*    Last change :  Wed Apr 28 11:15:43 1993  (serrano)               */
;*                                                                     */
;*    6.7. Strings (page 25, r4)                                       */
;*---------------------------------------------------------------------*/
   
;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_strings_6_7
   (foreign (define bool c-string?       (obj)                "STRINGP")
	    (obj         c-make-string   (bint bchar)         "make_string")
	    (define int  c-string-length (bstring)            "STRING_LENGTH")
	    (define char c-string-ref  (bstring bint)         "STRING_REF")
	    (define obj  c-string-set! (bstring bint bchar)   "STRING_SET")
	    (define bool c-string=?  (bstring bstring)        "STRING_EGP")
	    (define bool strcicmp    (string string)          "strcicmp")
	    (define bool string_lt   (string string)          "string_lt")
	    (define bool string_le   (string string)          "string_le")
	    (define bool string_gt   (string string)          "string_gt")
	    (define bool string_ge   (string string)          "string_ge")
	    (define bool string_cilt (string string)          "string_cilt")
	    (define bool string_cile (string string)          "string_cile")
	    (define bool string_cigt (string string)          "string_cigt")
	    (define bool string_cige (string string)          "string_cige")
	    (define bstring c-string-copy (string)            "STRING_COPY")
	    (bstring        c-substring (bstring bint bint)   "c_substring")
	    (bstring        c-string-append (bstring bstring) "string_append")
	    (string         c-escape-string (string)          "escape_string")
	    (bstring        c-constant-string-to-string (string)
		     "c_constant_string_to_string"))
   (export  (inline string? obj)
	    (inline make-string k . char)
	    (inline string . chars)
	    (inline string-length string)
	    (string-ref string k)
	    (string-set! string k char)
	    (inline string-ref-ur string k)
	    (inline string-set-ur! string k char)
	    (inline string=? string1 string2)
	    (inline string-ci=? string1 string2)
	    (inline string<? string1 string2)
	    (inline string>? string1 string2)
	    (inline string<=? string1 string2)
	    (inline string>=? string1 string2)
	    (inline string-ci<? string1 string2)
	    (inline string-ci>? string1 string2)
	    (inline string-ci<=? string1 string2)
	    (inline string-ci>=? string1 string2)
	    (inline substring string start end)
	    (string-append . strings)
	    (string->list string)
	    (list->string chars)
	    (inline string-copy string)
	    (string-fill! string char)
	    (string-upcase string)
	    (string-downcase string)
	    (inline escape-string string)))

;*---------------------------------------------------------------------*/
;*    string? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (string? obj)
   (c-string? obj))

;*---------------------------------------------------------------------*/
;*    make-string ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline  (make-string k . char)
   (if (null? char)
       (c-make-string k #\space)
       (c-make-string k (car char))))

;*---------------------------------------------------------------------*/
;*    string ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (string . chars)
   (list->string chars))

;*---------------------------------------------------------------------*/
;*    string-length ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (string-length string)
   (c-string-length string))

;*---------------------------------------------------------------------*/
;*    string-ref ...                                                   */
;*---------------------------------------------------------------------*/
(define (string-ref string k)
   (if (and (>=fx k 0) (<fx k (string-length string)))
       (c-string-ref string k)
       (error "string-ref" "index out of range" k)))
 
;*---------------------------------------------------------------------*/
;*    string-set! ...                                                  */
;*---------------------------------------------------------------------*/
(define (string-set! string k char)
   (if (and (>=fx k 0) (<fx k (string-length string)))
       (c-string-set! string k char)
       (error "string-set!" "index out of range" k)))

;*---------------------------------------------------------------------*/
;*    string-ref-ur ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (string-ref-ur string k)
   (c-string-ref string k))
 
;*---------------------------------------------------------------------*/
;*    string-set-ur! ...                                               */
;*---------------------------------------------------------------------*/
(define-inline (string-set-ur! string k char)
   (c-string-set! string k char))

;*---------------------------------------------------------------------*/
;*    string=? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (string=? string1 string2)
   (c-string=? string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci=? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (string-ci=? string1 string2)
   (strcicmp string1 string2))

;*---------------------------------------------------------------------*/
;*    string<? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (string<? string1 string2)
   (string_lt string1 string2))

;*---------------------------------------------------------------------*/
;*    string>? ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (string>? string1 string2)
   (string_gt string1 string2))

;*---------------------------------------------------------------------*/
;*    string<=? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (string<=? string1 string2)
   (string_le string1 string2))

;*---------------------------------------------------------------------*/
;*    string>=? ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (string>=? string1 string2)
   (string_ge string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci<? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (string-ci<? string1 string2)
   (string_cilt string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci>? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (string-ci>? string1 string2)
   (string_cigt string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci<=? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (string-ci<=? string1 string2)
   (string_cile string1 string2))

;*---------------------------------------------------------------------*/
;*    string-ci>=? ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (string-ci>=? string1 string2)
   (string_cige string1 string2))

;*---------------------------------------------------------------------*/
;*    sustring ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (substring string start end)
   (c-substring string start end))

;*---------------------------------------------------------------------*/
;*    string-append ...                                                */
;*---------------------------------------------------------------------*/
(define (string-append . list)
   (if (null? list)
       ""
       (let loop ((list list))
	  (if (null? (cdr list))
	      (car list)
	      (c-string-append (car list) (loop (cdr list)))))))

;*---------------------------------------------------------------------*/
;*    list->string ...                                                 */
;*---------------------------------------------------------------------*/
(define (list->string list)
   (let* ((len    (length list))
	  (string (make-string len)))
      (let loop ((i 0)
		 (l list))
	 (if (=fx i len)
	     string
	     (begin
		(string-set! string i (car l))
		(loop (+fx i 1) (cdr l)))))))

;*---------------------------------------------------------------------*/
;*    string->list ...                                                 */
;*---------------------------------------------------------------------*/
(define (string->list string)
   (let ((len (string-length string)))
      (let loop ((i   0)
		 (acc '()))
	 (if (=fx i len)
	     (reverse! acc)
	     (loop (+fx i 1)
		   (cons (string-ref string i)
			 acc))))))

;*---------------------------------------------------------------------*/
;*    string-copy ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (string-copy string)
   (c-string-copy string))

;*---------------------------------------------------------------------*/
;*    string-fill! ...                                                 */
;*---------------------------------------------------------------------*/
(define (string-fill! string char)
   (let ((len (string-length string)))
      (let loop ((i 0))
	 (if (=fx i len)
	     string
	     (begin
		(string-set! string i char)
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    string-upcase ...                                                */
;*---------------------------------------------------------------------*/
(define (string-upcase string)
   (let* ((len (string-length string))
	  (res (make-string len)))
      (let loop ((i 0))
	 (if (=fx i len)
	     res
	     (begin
		(string-set! res i (char-upcase (string-ref string i)))
		(loop (+fx i 1)))))))

;*---------------------------------------------------------------------*/
;*    string-downcase ...                                              */
;*---------------------------------------------------------------------*/
(define (string-downcase string)
   (let* ((len (string-length string))
	  (res (make-string len)))
      (let loop ((i 0))
	 (if (=fx i len)
	     res
	     (begin
		(string-set! res i (char-downcase (string-ref string i)))
		(loop (+fx i 1)))))))
		 
;*---------------------------------------------------------------------*/
;*    escape-string ...                                                */
;*---------------------------------------------------------------------*/
(define-inline (escape-string string)
   (c-escape-string string))
